#include "ISHStepCounter.h"
#include "Log.h"

// LUID: 0230000000000000

struct stepcounter_raw {
        int64_t timestamp;
        int64_t timestamp0;
        unsigned char reset_flag;
        int32_t walk_step_count;
        int32_t walk_step_duration;
        int32_t run_step_count;
        int32_t run_step_duration;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct stepcounter_aware {
        int64_t timestamp;
        unsigned char reset_flag;
        int32_t walk_step_count;
        int32_t walk_step_duration;
        int32_t run_step_count;
        int32_t run_step_duration;
} __attribute__ ((packed));

ISHStepCounter::ISHStepCounter(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHAwareSensor(device, information, data)
{
        initialize();
}

ISHStepCounter::ISHStepCounter(const Sensor * refSensor, const uint32_t serial_number)
        :ISHAwareSensor(refSensor, serial_number)
{
        initialize();
}

ISHStepCounter::~ISHStepCounter()
{

}

void ISHStepCounter::initialize()
{
}

size_t ISHStepCounter::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct stepcounter_raw);

        if (bufSize % sizeof(struct stepcounter_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct stepcounter_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct stepcounter_aware));

        const struct stepcounter_raw *step_counter = reinterpret_cast<const struct stepcounter_raw *>(buf);
        struct stepcounter_aware *aware = reinterpret_cast<struct stepcounter_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = step_counter[i].timestamp * US_TO_NS;
                aware[i].reset_flag = step_counter[i].reset_flag;
                aware[i].walk_step_count = step_counter[i].walk_step_count;
                aware[i].walk_step_duration = step_counter[i].walk_step_duration;
                aware[i].run_step_count = step_counter[i].run_step_count;
                aware[i].run_step_duration = step_counter[i].run_step_duration;
        }

        return count * sizeof(struct stepcounter_aware);
}

size_t ISHStepCounter::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct stepcounter_raw);

        if (bufSize % sizeof(struct stepcounter_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct stepcounter_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct stepcounter_raw *step_counter = reinterpret_cast<const struct stepcounter_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = step_counter[i].timestamp * US_TO_NS;
                mEvents[i].u64.step_counter = step_counter[i].walk_step_count + step_counter[i].run_step_count;
        }
        return count;
}
