#include "ISHPickUpGesture.h"
#include "Log.h"

// LUID: 0215000000000000

struct pickup_raw {
        int64_t timestamp;
        int64_t timestamp0;
        unsigned char pickup;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct pickup_aware {
        int64_t timestamp;
        unsigned char pickup;
} __attribute__ ((packed));

ISHPickUpGesture::ISHPickUpGesture(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHPickUpGesture::ISHPickUpGesture(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHPickUpGesture::~ISHPickUpGesture()
{

}

void ISHPickUpGesture::initialize()
{
        this->device.flags |= SENSOR_FLAG_WAKE_UP;
}

size_t ISHPickUpGesture::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct pickup_raw);

        if (bufSize % sizeof(struct pickup_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct pickup_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct pickup_aware));

        const struct pickup_raw *pickup = reinterpret_cast<const struct pickup_raw *>(buf);
        struct pickup_aware *aware = reinterpret_cast<struct pickup_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = pickup[i].timestamp * US_TO_NS;
                aware[i].pickup = pickup[i].pickup;
        }

        return count * sizeof(struct pickup_aware);
}

size_t ISHPickUpGesture::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct pickup_raw);

        if (bufSize % sizeof(struct pickup_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct pickup_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct pickup_raw *pickup = reinterpret_cast<const struct pickup_raw *>(buf);
        for (size_t i = 0; i < count; i++) {
                mEvents[i].timestamp = pickup[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = pickup[i].pickup;
        }
        return count;
}
