#include "ISHPDR.h"
#include "Log.h"

struct pdr_raw {
        int64_t timestamp;
        int64_t timestamp0;
        int x;
        int y;
        char floor;
        int heading;
        unsigned int step;
        unsigned int distance;
        unsigned int speed;
        unsigned int pos_error;
        unsigned int heading_conf;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct pdr_aware {
        int64_t timestamp;
        int x;
        int y;
        char floor;
        int heading;
        unsigned int step;
        unsigned int distance;
        unsigned int speed;
        unsigned int pos_error;
        unsigned int heading_conf;
} __attribute__ ((packed));

ISHPDR::ISHPDR(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHAwareSensor(device, information, data)
{
        initialize();
}

ISHPDR::ISHPDR(const Sensor * refSensor, const uint32_t serial_number)
        :ISHAwareSensor(refSensor, serial_number)
{
        initialize();
}

ISHPDR::~ISHPDR()
{

}

void ISHPDR::initialize()
{

}

size_t ISHPDR::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct pdr_raw);

        if (bufSize % sizeof(struct pdr_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct pdr_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct pdr_aware));

        const struct pdr_raw *pdr = reinterpret_cast<const struct pdr_raw *>(buf);
        struct pdr_aware *aware = reinterpret_cast<struct pdr_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = pdr[i].timestamp * US_TO_NS;
                aware[i].x = pdr[i].x;
                aware[i].y = pdr[i].y;
                aware[i].floor = pdr[i].floor;
                aware[i].heading = pdr[i].heading;
                aware[i].step = pdr[i].step;
                aware[i].distance = pdr[i].distance;
                aware[i].speed = pdr[i].speed;
                aware[i].pos_error = pdr[i].pos_error;
                aware[i].heading_conf = pdr[i].heading_conf;
        }

        return count * sizeof(struct pdr_aware);
}

size_t ISHPDR::convertToEvent(const char * buf, size_t bufSize)
{
        //Todo: implement the function
        return 0;
}
