#include "ISHHeatIndex.h"
#include "Log.h"

// LUID:0274000000000000
struct heat_index_raw {
        int64_t timestamp;
        int64_t timestamp0;
        int32_t heat_index;
        uint8_t alert;
        uint16_t custom_usage;
} __attribute__ ((packed));

struct heat_index_aware {
        int64_t timestamp;
        int32_t heat_index;
        uint8_t alert;
} __attribute__ ((packed));

ISHHeatIndex::ISHHeatIndex(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHHeatIndex::ISHHeatIndex(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHHeatIndex::~ISHHeatIndex()
{

}

void ISHHeatIndex::initialize()
{

}

size_t ISHHeatIndex::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct heat_index_raw);

        if (bufSize % sizeof(struct heat_index_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct heat_index_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct heat_index_aware));

        const struct heat_index_raw *heat_index = reinterpret_cast<const struct heat_index_raw *>(buf);
        struct heat_index_aware *aware = reinterpret_cast<struct heat_index_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = heat_index[i].timestamp * US_TO_NS;
                aware[i].heat_index = heat_index[i].heat_index;
                aware[i].alert = heat_index[i].alert;
        }

        return count * sizeof(struct heat_index_aware);
}

size_t ISHHeatIndex::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct heat_index_raw);

        if (bufSize % sizeof(struct heat_index_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct heat_index_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct heat_index_raw *heat = reinterpret_cast<const struct heat_index_raw *>(buf);
        for (size_t i = 0; i < count; i++) {
                mEvents[i].timestamp = heat[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = heat[i].heat_index;
                mEvents[i].data[1] = heat[i].alert;
        }

        return count;
}
