#ifndef _ISH_AWARE_SENSOR_H_
#define _ISH_AWARE_SENSOR_H_

#include "ISHSensor.h"

class ISHAwareSensor : public ISHSensor {
protected:
        void *ctx_handle; // Todo: move arbitrate here and remove this
        bool mContextArbitratorInitialized;
#ifdef ENABLE_CONTEXT_ARBITOR
        bool checkContextHandle();
#endif
public:
        ISHAwareSensor(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data);
        ISHAwareSensor(const Sensor * refSensor, const uint32_t serial_number);
        virtual ~ISHAwareSensor();
#ifdef ENABLE_CONTEXT_ARBITOR
        virtual bool startStreaming(Session * session, int64_t samplingPeriodUs, int64_t maxReportLatencyUs);
        virtual void removeSession(Session *session);
        virtual bool setProperty(Session * session, void * property, size_t size);
        virtual size_t getProperty(Session * session, void * command, size_t commandSize, void **property);
        virtual size_t convertToStreaming(const char * buf, size_t bufSize);
#endif
};

#endif
