#include "ISHAudioClassifier.h"
#include "Log.h"

//using namespace android;

struct audio_classifier_raw {
        int64_t timestamp;
        int64_t timestamp0;
        int32_t v;
        uint16_t custom_usage;
} __attribute__ ((packed));

struct audio_classifier_aware {
        int64_t timestamp;
        int32_t v;
} __attribute__ ((packed));

ISHAudioClassifier::ISHAudioClassifier(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHAwareSensor(device, information, data)
{
        initialize();
}

ISHAudioClassifier::ISHAudioClassifier(const Sensor * refSensor, const uint32_t serial_number)
        :ISHAwareSensor(refSensor, serial_number)
{
        initialize();
}

ISHAudioClassifier::~ISHAudioClassifier()
{
#if 0
        status_t result = aware_hw_device_close(device);
        if (result != NO_ERROR)
                ALOGE("%s line: %d close audio hw module error: %d", __FUNCTION__, __LINE__, result);
        ALOGD_IF(DEBUG, "%s line: %d close audio hw module success: %d", __FUNCTION__, __LINE__, result);
#endif
}

void ISHAudioClassifier::initialize()
{
#if 0
        status_t result = hw_get_module_by_class(AWARE_HARDWARE_MODULE_ID, AWARE_HARDWARE_MODULE_ID_PRIMARY, &module);
        if (result != NO_ERROR) {
                ALOGE("%s line: %d load audio hw module error: %d", __FUNCTION__, __LINE__, result);
                return;
        }
        ALOGD_IF(DEBUG, "%s line: %d load audio hw module success: %d", __FUNCTION__, __LINE__, result);

        result = aware_hw_device_open(module, &device);
        if (result != NO_ERROR) {
                ALOGE("%s line: %d open audio hw module error: %d", __FUNCTION__, __LINE__, result);
                return;
        }
        ALOGD_IF(DEBUG, "%s line: %d open audio hw module success: %d", __FUNCTION__, __LINE__, result);
#endif
}

size_t ISHAudioClassifier::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct audio_classifier_raw);

        if (bufSize % sizeof(struct audio_classifier_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct audio_classifier_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct audio_classifier_aware));

        const struct audio_classifier_raw *audio_classifier = reinterpret_cast<const struct audio_classifier_raw *>(buf);
        struct audio_classifier_aware *aware = reinterpret_cast<struct audio_classifier_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = audio_classifier[i].timestamp * US_TO_NS;
                aware[i].v = audio_classifier[i].v;
        }

        return count * sizeof(struct audio_classifier_aware);
}

size_t ISHAudioClassifier::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct audio_classifier_raw);

        if (bufSize % sizeof(struct audio_classifier_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct audio_classifier_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct audio_classifier_raw *audio = reinterpret_cast<const struct audio_classifier_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = audio[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = audio[i].v;
        }

        return count;
}
#if 0
bool ISHAudioClassifier::startStopImpl(bool start)
{
        bool ret = true;
        status_t result;

        if (start) {
                result = activate_aware_session(device);
                if (result != NO_ERROR) {
                        ALOGE("%s line: %d activate_aware_session error: %d", __FUNCTION__, __LINE__, result);
                        ret = false;
                } else {
                        ALOGD_IF(DEBUG, "%s line: %d activate_aware_session success: %d", __FUNCTION__, __LINE__, result);
                }
        } else {
                result = deactivate_aware_session(device);
                if (result != NO_ERROR) {
                        ALOGE("%s line: %d deactivate_aware_session error: %d", __FUNCTION__, __LINE__, result);
                        ret = false;
                } else {
                        ALOGD_IF(DEBUG, "%s line: %d deactivate_aware_session success: %d", __FUNCTION__, __LINE__, result);
                }
        }

        return ret;
}
#endif
