#include "ISHAccelerometer.h"
#include "Log.h"

struct accelerometer_raw {
        int64_t timestamp;
        int64_t timestamp0;
        int x;
        int y;
        int z;
        unsigned char shaking; // ignored by Android
} __attribute__ ((packed));

struct accelerometer_aware {
        int64_t timestamp;
        int x;
        int y;
        int z;
} __attribute__ ((packed));

ISHAccelerometer::ISHAccelerometer(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHAccelerometer::ISHAccelerometer(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHAccelerometer::~ISHAccelerometer()
{

}

void ISHAccelerometer::initialize()
{
        if (information.scale_android.size() == 3) {
                scaleX = information.scale_android[0];
                scaleY = information.scale_android[1];
                scaleZ = information.scale_android[2];
                ALOGV_IF(VERBOSE, "%s line: %d %f %f %f", __FUNCTION__, __LINE__, scaleX, scaleY, scaleZ);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scaleX = 1.0;
                scaleY = 1.0;
                scaleZ = 1.0;
        }
}

size_t ISHAccelerometer::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct accelerometer_raw);

        if (bufSize % sizeof(struct accelerometer_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct accelerometer_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct accelerometer_aware));

        const struct accelerometer_raw *accelerometer = reinterpret_cast<const struct accelerometer_raw *>(buf);
        struct accelerometer_aware *aware = reinterpret_cast<struct accelerometer_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = accelerometer[i].timestamp * US_TO_NS;
                aware[i].x = accelerometer[i].x;
                aware[i].y = accelerometer[i].y;
                aware[i].z = accelerometer[i].z;
        }

        return count * sizeof(struct accelerometer_aware);
}

size_t ISHAccelerometer::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct accelerometer_raw);

        if (bufSize % sizeof(struct accelerometer_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct accelerometer_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct accelerometer_raw *accel = reinterpret_cast<const struct accelerometer_raw *>(buf);
        for (size_t i = 0; i < count; i++) {
                mEvents[i].timestamp = accel[i].timestamp * US_TO_NS;
                mEvents[i].acceleration.x = accel[i].x * scaleX;
                mEvents[i].acceleration.y = accel[i].y * scaleY;
                mEvents[i].acceleration.z = accel[i].z * scaleZ;
                mEvents[i].acceleration.status = SENSOR_STATUS_ACCURACY_HIGH;
        }

        return count;
}
