/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _SENSOR_ENUMERATOR_H_
#define _SENSOR_ENUMERATOR_H_

#include "PlatformService.h"
#include "SensorTypeMap.h"
#include "StringBuffer.h"

class SensorEnumerator {
        SensorTypeMap sensorTypeMap;
        StringBuffer &mStringBuffer;
        void dump(struct sensor_device_t &device);
        float getUnitValue(const char * name);
        uint32_t getReportingMode(const char * reportingModeName);
        const char * getReportingModeName(uint32_t reportingMode);
        void initializeScaleInformation(const xmlNodePtr node, std::vector<float> &scaleInformation);
        sensor_axis_t getAxis(const char * axisName);
        class HandleAllocator {
                bool handleAllocated[SENSORS_HANDLE_COUNT];
                int currentHandle;
        public:
                HandleAllocator() {
                        currentHandle = SENSORS_HANDLE_BASE;
                        for (int i = 0; i < SENSORS_HANDLE_COUNT; i++)
                                handleAllocated[i] = false;
                }
                int allocateHandle() {
                        if (currentHandle < SENSORS_HANDLE_COUNT)
                                currentHandle++;
                        if (!handleAllocated[currentHandle-1]) {
                                handleAllocated[currentHandle-1] = true;
                                return currentHandle;
                        }
                        for (int i = 0; i < SENSORS_HANDLE_COUNT; i++) {
                                if (!handleAllocated[i]) {
                                        handleAllocated[i] = true;
                                        currentHandle = i + 1;
                                        return currentHandle;
                                }
                        }
                        return SENSORS_HANDLE_BASE - 1;
                }
                void releaseHandle(int handle) {
                        if (handle > SENSORS_HANDLE_COUNT)
                                return;
                        handleAllocated[handle-1] = false;
                        currentHandle = handle - 1;
                }
        };
        HandleAllocator handleAllocator;
public:
        SensorEnumerator();
        char * getStringBufferBase();
        int getStringBufferSize();
        bool enumerateSensors(std::map<int, Sensor*> &sensorList, std::vector<PlatformService *> &serviceList);
        bool initializeSensorDevice(const xmlNodePtr node, struct sensor_device_t &device, const char * typeStr);
        bool initializeSensorDevice(struct sensor_device_t &device, const char *name, const char *vendor, const char *required_permission);
        void initializeSensorAdditionalInformation(const xmlNodePtr node, sensor_additional_information_t &information);
};

#endif
