/* 
   Unix SMB/CIFS implementation.

   Manually parsed structures found in the DRS protocol

   Copyright (C) Andrew Bartlett <abartlet@samba.org> 2008
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "includes.h"
#include "librpc/gen_ndr/ndr_drsblobs.h"

/* parser auto-generated by pidl, then hand-modified by abartlet */

/* Modified to have 'count' specified */
static enum ndr_err_code ndr_push_AuthenticationInformationArray_with_count(struct ndr_push *ndr, int ndr_flags, int count, 
								 const struct AuthenticationInformationArray *r)
{
	uint32_t cntr_array_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		for (cntr_array_0 = 0; cntr_array_0 < count; cntr_array_0++) {
			NDR_CHECK(ndr_push_AuthenticationInformation(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < count; cntr_array_0++) {
			NDR_CHECK(ndr_push_AuthenticationInformation(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

/* Modified to have 'count' specified, and to allocate the array */
static enum ndr_err_code ndr_pull_AuthenticationInformationArray_with_count(struct ndr_pull *ndr, int ndr_flags, int count, struct AuthenticationInformationArray *r)
{
	uint32_t cntr_array_0;
	TALLOC_CTX *_mem_save_array_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_PULL_ALLOC_N(ndr, r->array, count);
		_mem_save_array_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->array, 0);
		for (cntr_array_0 = 0; cntr_array_0 < count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_AuthenticationInformation(ndr, NDR_SCALARS, &r->array[cntr_array_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_array_0, 0);
	}
	if (ndr_flags & NDR_BUFFERS) {
		for (cntr_array_0 = 0; cntr_array_0 < count; cntr_array_0++) {
			NDR_CHECK(ndr_pull_AuthenticationInformation(ndr, NDR_BUFFERS, &r->array[cntr_array_0]));
		}
	}
	return NDR_ERR_SUCCESS;
}

/* Modified to have 'count' specified */
_PUBLIC_ void ndr_print_AuthenticationInformationArray_with_count(struct ndr_print *ndr, const char *name, int count, const struct AuthenticationInformationArray *r)
{
	uint32_t cntr_array_0;
	ndr_print_struct(ndr, name, "AuthenticationInformationArray");
	ndr->depth++;
	ndr->print(ndr, "%s: ARRAY(%d)", "array", (int)1);
	ndr->depth++;
	for (cntr_array_0=0;cntr_array_0<count;cntr_array_0++) {
		char *idx_0=NULL;
		if (asprintf(&idx_0, "[%d]", cntr_array_0) != -1) {
			ndr_print_AuthenticationInformation(ndr, "array", &r->array[cntr_array_0]);
			free(idx_0);
		}
	}
	ndr->depth--;
	ndr->depth--;
}

/* Modified to call AuthenticationInformationArray with 'count' specified */
_PUBLIC_ enum ndr_err_code ndr_push_trustAuthInOutBlob(struct ndr_push *ndr, int ndr_flags, const struct trustAuthInOutBlob *r)
{
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->count));
		NDR_CHECK(ndr_push_relative_ptr1(ndr, r->current));
		NDR_CHECK(ndr_push_relative_ptr1(ndr, r->previous));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->current) {
			NDR_CHECK(ndr_push_relative_ptr2(ndr, r->current));
			NDR_CHECK(ndr_push_AuthenticationInformationArray_with_count(ndr, NDR_SCALARS|NDR_BUFFERS, r->count, r->current));
		}
		if (r->previous) {
			NDR_CHECK(ndr_push_relative_ptr2(ndr, r->previous));
			NDR_CHECK(ndr_push_AuthenticationInformationArray_with_count(ndr, NDR_SCALARS|NDR_BUFFERS, r->count, r->previous));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_trustAuthInOutBlob(struct ndr_pull *ndr, int ndr_flags, struct trustAuthInOutBlob *r)
{
	uint32_t _ptr_current;
	TALLOC_CTX *_mem_save_current_0;
	uint32_t _ptr_previous;
	TALLOC_CTX *_mem_save_previous_0;
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_current));
		if (_ptr_current) {
			NDR_PULL_ALLOC(ndr, r->current);
			NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->current, _ptr_current));
		} else {
			r->current = NULL;
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_previous));
		if (_ptr_previous) {
			NDR_PULL_ALLOC(ndr, r->previous);
			NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->previous, _ptr_previous));
		} else {
			r->previous = NULL;
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->current) {
			uint32_t _relative_save_offset;
			_relative_save_offset = ndr->offset;
			NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->current));
			_mem_save_current_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->current, 0);
			NDR_CHECK(ndr_pull_AuthenticationInformationArray_with_count(ndr, NDR_SCALARS|NDR_BUFFERS, r->count, r->current));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_current_0, 0);
			ndr->offset = _relative_save_offset;
		}
		if (r->previous) {
			uint32_t _relative_save_offset;
			_relative_save_offset = ndr->offset;
			NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->previous));
			_mem_save_previous_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->previous, 0);
			NDR_CHECK(ndr_pull_AuthenticationInformationArray_with_count(ndr, NDR_SCALARS|NDR_BUFFERS, r->count, r->previous));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_previous_0, 0);
			ndr->offset = _relative_save_offset;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_trustAuthInOutBlob(struct ndr_print *ndr, const char *name, const struct trustAuthInOutBlob *r)
{
	ndr_print_struct(ndr, name, "trustAuthInOutBlob");
	ndr->depth++;
	ndr_print_uint32(ndr, "count", r->count);
	ndr_print_ptr(ndr, "current", r->current);
	ndr->depth++;
	if (r->current) {
		ndr_print_AuthenticationInformationArray_with_count(ndr, "current", r->count, r->current);
	}
	ndr->depth--;
	ndr_print_ptr(ndr, "previous", r->previous);
	ndr->depth++;
	if (r->previous) {
		ndr_print_AuthenticationInformationArray_with_count(ndr, "previous", r->count, r->previous);
	}
	ndr->depth--;
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_pull_trustDomainPasswords(struct ndr_pull *ndr, int ndr_flags, struct trustDomainPasswords *r)
{
	if (ndr_flags & NDR_SCALARS) {
		uint32_t offset;
		NDR_PULL_ALIGN(ndr, 4);
		NDR_PULL_NEED_BYTES(ndr, 8);
		
		offset = ndr->offset;
		ndr->offset = ndr->data_size - 8;

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->outgoing_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->incoming_size));

		ndr->offset = offset;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->confounder, 512));
		{
			struct ndr_pull *_ndr_outgoing;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_outgoing, 0, r->outgoing_size));
			NDR_CHECK(ndr_pull_trustCurrentPasswords(_ndr_outgoing, NDR_SCALARS|NDR_BUFFERS, &r->outgoing));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_outgoing, 0, r->outgoing_size));
		}
		{
			struct ndr_pull *_ndr_incoming;
			NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_incoming, 0, r->incoming_size));
			NDR_CHECK(ndr_pull_trustCurrentPasswords(_ndr_incoming, NDR_SCALARS|NDR_BUFFERS, &r->incoming));
			NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_incoming, 0, r->incoming_size));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->outgoing_size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->incoming_size));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

