// @(#)root/eve:$Id: TEveTrackProjectedGL.cxx 21653 2008-01-11 20:23:15Z matevz $
// Authors: Matevz Tadel & Alja Mrak-Tadel: 2006, 2007

/*************************************************************************
 * Copyright (C) 1995-2007, Rene Brun and Fons Rademakers.               *
 * All rights reserved.                                                  *
 *                                                                       *
 * For the licensing terms see $ROOTSYS/LICENSE.                         *
 * For the list of contributors see $ROOTSYS/README/CREDITS.             *
 *************************************************************************/

#include "TEveTrackProjectedGL.h"
#include "TEveTrackProjected.h"
#include "TEveTrackPropagator.h"
#include "TEveProjectionManager.h"

#include "TGLIncludes.h"
#include "TGLRnrCtx.h"

//______________________________________________________________________________
// TEveTrackProjectedGL
//
// GL-renderer for TEveTrackProjected class.

ClassImp(TEveTrackProjectedGL)

//______________________________________________________________________________
TEveTrackProjectedGL::TEveTrackProjectedGL() : TEveTrackGL(), fM(0)
{
   // Constructor.

   // fDLCache = kFALSE; // Disable display list.
}

/******************************************************************************/

//______________________________________________________________________________
Bool_t TEveTrackProjectedGL::SetModel(TObject* obj, const Option_t* /*opt*/)
{
   // Set model object.

   if (TEveTrackGL::SetModel(obj) == kFALSE) return kFALSE;
   if (SetModelCheckClass(obj, TEveTrackProjected::Class())) {
      fM = dynamic_cast<TEveTrackProjected*>(obj);
      return kTRUE;
   }
   return kFALSE;
}

/******************************************************************************/

//______________________________________________________________________________
void TEveTrackProjectedGL::DirectDraw(TGLRnrCtx& rnrCtx) const
{
   // Draw track with GL.

   // printf("TEveTrackProjectedGL::DirectDraw Style %d, LOD %d\n", flags.Style(), flags.LOD());
   if (rnrCtx.DrawPass() == TGLRnrCtx::kPassOutlineLine || fM->Size() == 0)
      return;

   // lines
   Int_t start = 0;
   Float_t* p = fM->GetP();
   for (std::vector<Int_t>::iterator bpi = fM->fBreakPoints.begin();
        bpi != fM->fBreakPoints.end(); ++bpi)
   {
      Int_t size = *bpi - start;
      if (fM->fRnrLine)
         TGLUtil::RenderPolyLine(*fM, p, size);
      if (fM->fRnrPoints)
         TGLUtil::RenderPolyMarkers(*fM, p, size,
                                    rnrCtx.GetPickRadius(),
                                    rnrCtx.Selection());
      p     += 3*size;
      start +=   size;
   }

   // path-marks
   std::vector<TEvePathMark*>& pm = fM->fPathMarks;
   TEveTrackPropagator& rTP = *fM->GetPropagator();
   if (pm.size())
   {
      Float_t* pnts = new Float_t[3*pm.size()]; // maximum
      Float_t*  pnt = pnts;
      Int_t   pntsN = 0;
      Bool_t accept;
      for (std::vector<TEvePathMark*>::iterator i=pm.begin(); i!=pm.end(); ++i)
      {
         accept = kFALSE;
         switch ((*i)->fType)
         {
            case TEvePathMark::kDaughter:
               if (rTP.GetRnrDaughters())  accept = kTRUE;
               break;
            case TEvePathMark::kReference:
               if (rTP.GetRnrReferences()) accept = kTRUE;
               break;
            case TEvePathMark::kDecay:
               if (rTP.GetRnrDecay())      accept = kTRUE;
               break;
         }
         if (accept)
         {
            if ((TMath::Abs((*i)->fV.fZ) < rTP.GetMaxZ()) && ((*i)->fV.Perp() < rTP.GetMaxR()))
            {
               pnt[0] =(*i)->fV.fX;
               pnt[1] =(*i)->fV.fY;
               pnt[2] =(*i)->fV.fZ;
               fM->fProjection->ProjectPointFv(pnt);
               pnt   += 3;
               ++pntsN;
            }
         }
      }
      TGLUtil::RenderPolyMarkers(rTP.RefPMAtt(), pnts, pntsN,
                                 rnrCtx.GetPickRadius(),
                                 rnrCtx.Selection());
      delete [] pnts;
   }

   // fist vertex
   if (rTP.GetRnrFV() && fTrack->GetLastPoint())
      TGLUtil::RenderPolyMarkers(rTP.RefFVAtt(), fTrack->GetP(), 1,
                                 rnrCtx.GetPickRadius(),
                                 rnrCtx.Selection());
}
