/* SPDX-License-Identifier: GPL-2.0 */
/******************************************************************************
 *
 * Copyright(c) 2007 - 2011 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 *
 ******************************************************************************/
#ifndef __HAL_COMMON_REG_H__
#define __HAL_COMMON_REG_H__

#define MAC_ADDR_LEN				6

#define HAL_NAV_UPPER_UNIT		128		/* micro-second */

/* 8188E PKT_BUFF_ACCESS_CTRL value */
#define TXPKT_BUF_SELECT				0x69
#define RXPKT_BUF_SELECT				0xA5
#define DISABLE_TRXPKT_BUF_ACCESS		0x0


/* ----------------------------------------------------------------------------
 * Rate Definition
 * ---------------------------------------------------------------------------- */
/* CCK */
#define	RATR_1M					0x00000001
#define	RATR_2M					0x00000002
#define	RATR_55M					0x00000004
#define	RATR_11M					0x00000008
/* OFDM		 */
#define	RATR_6M					0x00000010
#define	RATR_9M					0x00000020
#define	RATR_12M					0x00000040
#define	RATR_18M					0x00000080
#define	RATR_24M					0x00000100
#define	RATR_36M					0x00000200
#define	RATR_48M					0x00000400
#define	RATR_54M					0x00000800
/* MCS 1 Spatial Stream	 */
#define	RATR_MCS0					0x00001000
#define	RATR_MCS1					0x00002000
#define	RATR_MCS2					0x00004000
#define	RATR_MCS3					0x00008000
#define	RATR_MCS4					0x00010000
#define	RATR_MCS5					0x00020000
#define	RATR_MCS6					0x00040000
#define	RATR_MCS7					0x00080000
/* MCS 2 Spatial Stream */
#define	RATR_MCS8					0x00100000
#define	RATR_MCS9					0x00200000
#define	RATR_MCS10					0x00400000
#define	RATR_MCS11					0x00800000
#define	RATR_MCS12					0x01000000
#define	RATR_MCS13					0x02000000
#define	RATR_MCS14					0x04000000
#define	RATR_MCS15					0x08000000

/* CCK */
#define RATE_1M					BIT(0)
#define RATE_2M					BIT(1)
#define RATE_5_5M				BIT(2)
#define RATE_11M				BIT(3)
/* OFDM */
#define RATE_6M					BIT(4)
#define RATE_9M					BIT(5)
#define RATE_12M				BIT(6)
#define RATE_18M				BIT(7)
#define RATE_24M				BIT(8)
#define RATE_36M				BIT(9)
#define RATE_48M				BIT(10)
#define RATE_54M				BIT(11)
/* MCS 1 Spatial Stream */
#define RATE_MCS0				BIT(12)
#define RATE_MCS1				BIT(13)
#define RATE_MCS2				BIT(14)
#define RATE_MCS3				BIT(15)
#define RATE_MCS4				BIT(16)
#define RATE_MCS5				BIT(17)
#define RATE_MCS6				BIT(18)
#define RATE_MCS7				BIT(19)
/* MCS 2 Spatial Stream */
#define RATE_MCS8				BIT(20)
#define RATE_MCS9				BIT(21)
#define RATE_MCS10				BIT(22)
#define RATE_MCS11				BIT(23)
#define RATE_MCS12				BIT(24)
#define RATE_MCS13				BIT(25)
#define RATE_MCS14				BIT(26)
#define RATE_MCS15				BIT(27)

/* ALL CCK Rate */
#define	RATE_ALL_CCK				(RATR_1M | RATR_2M | RATR_55M | RATR_11M)
#define	RATE_ALL_OFDM_AG			(RATR_6M | RATR_9M | RATR_12M | RATR_18M | RATR_24M|\
	RATR_36M | RATR_48M | RATR_54M)
#define	RATE_ALL_OFDM_1SS			(RATR_MCS0 | RATR_MCS1 | RATR_MCS2 | RATR_MCS3 |\
	RATR_MCS4 | RATR_MCS5 | RATR_MCS6 | RATR_MCS7)
#define	RATE_ALL_OFDM_2SS			(RATR_MCS8 | RATR_MCS9 | RATR_MCS10 | RATR_MCS11|\
	RATR_MCS12 | RATR_MCS13 | RATR_MCS14 | RATR_MCS15)

#define RATE_BITMAP_ALL			0xFFFFF

/* Only use CCK 1M rate for ACK */
#define RATE_RRSR_CCK_ONLY_1M		0xFFFF1
#define RATE_RRSR_WITHOUT_CCK		0xFFFF0

/* ----------------------------------------------------------------------------
 * BW_OPMODE bits				(Offset 0x603, 8bit)
 * ---------------------------------------------------------------------------- */
#define BW_OPMODE_20MHZ			BIT(2)
#define BW_OPMODE_5G				BIT(1)

/* ----------------------------------------------------------------------------
 * CAM Config Setting (offset 0x680, 1 byte)
 * ----------------------------------------------------------------------------			 */
#define CAM_VALID				BIT(15)
#define CAM_NOTVALID			0x0000
#define CAM_USEDK				BIT(5)

#define CAM_CONTENT_COUNT	8

#define CAM_NONE				0x0
#define CAM_WEP40				0x01
#define CAM_TKIP				0x02
#define CAM_AES					0x04
#define CAM_WEP104				0x05
#define CAM_SMS4				0x6

#define TOTAL_CAM_ENTRY		32
#define HALF_CAM_ENTRY			16

#define CAM_CONFIG_USEDK		_TRUE
#define CAM_CONFIG_NO_USEDK	_FALSE

#define CAM_WRITE				BIT(16)
#define CAM_READ				0x00000000
#define CAM_POLLINIG			BIT(31)

/*
 * 10. Power Save Control Registers
 *   */
#define WOW_PMEN				BIT(0) /* Power management Enable. */
#define WOW_WOMEN				BIT(1) /* WoW function on or off. */
#define WOW_MAGIC				BIT(2) /* Magic packet */
#define WOW_UWF				BIT(3) /* Unicast Wakeup frame. */

/*
 * 12. Host Interrupt Status Registers
 *
 * ----------------------------------------------------------------------------
 * 8190 IMR/ISR bits
 * ---------------------------------------------------------------------------- */
#define IMR8190_DISABLED		0x0
#define IMR_DISABLED			0x0
/* IMR DW0 Bit 0-31 */
#define IMR_BCNDMAINT6			BIT(31)		/* Beacon DMA Interrupt 6 */
#define IMR_BCNDMAINT5			BIT(30)		/* Beacon DMA Interrupt 5 */
#define IMR_BCNDMAINT4			BIT(29)		/* Beacon DMA Interrupt 4 */
#define IMR_BCNDMAINT3			BIT(28)		/* Beacon DMA Interrupt 3 */
#define IMR_BCNDMAINT2			BIT(27)		/* Beacon DMA Interrupt 2 */
#define IMR_BCNDMAINT1			BIT(26)		/* Beacon DMA Interrupt 1 */
#define IMR_BCNDOK8				BIT(25)		/* Beacon Queue DMA OK Interrupt 8 */
#define IMR_BCNDOK7				BIT(24)		/* Beacon Queue DMA OK Interrupt 7 */
#define IMR_BCNDOK6				BIT(23)		/* Beacon Queue DMA OK Interrupt 6 */
#define IMR_BCNDOK5				BIT(22)		/* Beacon Queue DMA OK Interrupt 5 */
#define IMR_BCNDOK4				BIT(21)		/* Beacon Queue DMA OK Interrupt 4 */
#define IMR_BCNDOK3				BIT(20)		/* Beacon Queue DMA OK Interrupt 3 */
#define IMR_BCNDOK2				BIT(19)		/* Beacon Queue DMA OK Interrupt 2 */
#define IMR_BCNDOK1				BIT(18)		/* Beacon Queue DMA OK Interrupt 1 */
#define IMR_TIMEOUT2			BIT(17)		/* Timeout interrupt 2 */
#define IMR_TIMEOUT1			BIT(16)		/* Timeout interrupt 1 */
#define IMR_TXFOVW				BIT(15)		/* Transmit FIFO Overflow */
#define IMR_PSTIMEOUT			BIT(14)		/* Power save time out interrupt */
#define IMR_BcnInt				BIT(13)		/* Beacon DMA Interrupt 0 */
#define IMR_RXFOVW				BIT(12)		/* Receive FIFO Overflow */
#define IMR_RDU					BIT(11)		/* Receive Descriptor Unavailable */
#define IMR_ATIMEND				BIT(10)		/* For 92C, ATIM Window End Interrupt. For 8723 and later ICs, it also means P2P CTWin End interrupt. */
#define IMR_BDOK				BIT(9)		/* Beacon Queue DMA OK Interrupt */
#define IMR_HIGHDOK				BIT(8)		/* High Queue DMA OK Interrupt */
#define IMR_TBDOK				BIT(7)		/* Transmit Beacon OK interrupt */
#define IMR_MGNTDOK			BIT(6)		/* Management Queue DMA OK Interrupt */
#define IMR_TBDER				BIT(5)		/* For 92C, Transmit Beacon Error Interrupt */
#define IMR_BKDOK				BIT(4)		/* AC_BK DMA OK Interrupt */
#define IMR_BEDOK				BIT(3)		/* AC_BE DMA OK Interrupt */
#define IMR_VIDOK				BIT(2)		/* AC_VI DMA OK Interrupt */
#define IMR_VODOK				BIT(1)		/* AC_VO DMA Interrupt */
#define IMR_ROK					BIT(0)		/* Receive DMA OK Interrupt */

/* 13. Host Interrupt Status Extension Register	 (Offset: 0x012C-012Eh) */
#define IMR_TSF_BIT32_TOGGLE	BIT(15)
#define IMR_BcnInt_E				BIT(12)
#define IMR_TXERR				BIT(11)
#define IMR_RXERR				BIT(10)
#define IMR_C2HCMD				BIT(9)
#define IMR_CPWM				BIT(8)
/* RSVD [2-7] */
#define IMR_OCPINT				BIT(1)
#define IMR_WLANOFF			BIT(0)

/* ----------------------------------------------------------------------------
 * 8723E series PCIE Host IMR/ISR bit
 * ---------------------------------------------------------------------------- */
/* IMR DW0 Bit 0-31 */
#define PHIMR_TIMEOUT2				BIT(31)
#define PHIMR_TIMEOUT1				BIT(30)
#define PHIMR_PSTIMEOUT			BIT(29)
#define PHIMR_GTINT4				BIT(28)
#define PHIMR_GTINT3				BIT(27)
#define PHIMR_TXBCNERR				BIT(26)
#define PHIMR_TXBCNOK				BIT(25)
#define PHIMR_TSF_BIT32_TOGGLE	BIT(24)
#define PHIMR_BCNDMAINT3			BIT(23)
#define PHIMR_BCNDMAINT2			BIT(22)
#define PHIMR_BCNDMAINT1			BIT(21)
#define PHIMR_BCNDMAINT0			BIT(20)
#define PHIMR_BCNDOK3				BIT(19)
#define PHIMR_BCNDOK2				BIT(18)
#define PHIMR_BCNDOK1				BIT(17)
#define PHIMR_BCNDOK0				BIT(16)
#define PHIMR_HSISR_IND_ON			BIT(15)
#define PHIMR_BCNDMAINT_E			BIT(14)
#define PHIMR_ATIMEND_E			BIT(13)
#define PHIMR_ATIM_CTW_END		BIT(12)
#define PHIMR_HISRE_IND			BIT(11)	/* RO. HISRE Indicator (HISRE & HIMRE is true, this bit is set to 1) */
#define PHIMR_C2HCMD				BIT(10)
#define PHIMR_CPWM2				BIT(9)
#define PHIMR_CPWM					BIT(8)
#define PHIMR_HIGHDOK				BIT(7)		/* High Queue DMA OK Interrupt */
#define PHIMR_MGNTDOK				BIT(6)		/* Management Queue DMA OK Interrupt */
#define PHIMR_BKDOK					BIT(5)		/* AC_BK DMA OK Interrupt */
#define PHIMR_BEDOK					BIT(4)		/* AC_BE DMA OK Interrupt */
#define PHIMR_VIDOK					BIT(3)		/* AC_VI DMA OK Interrupt */
#define PHIMR_VODOK				BIT(2)		/* AC_VO DMA Interrupt */
#define PHIMR_RDU					BIT(1)		/* Receive Descriptor Unavailable */
#define PHIMR_ROK					BIT(0)		/* Receive DMA OK Interrupt */

/* PCIE Host Interrupt Status Extension bit */
#define PHIMR_BCNDMAINT7			BIT(23)
#define PHIMR_BCNDMAINT6			BIT(22)
#define PHIMR_BCNDMAINT5			BIT(21)
#define PHIMR_BCNDMAINT4			BIT(20)
#define PHIMR_BCNDOK7				BIT(19)
#define PHIMR_BCNDOK6				BIT(18)
#define PHIMR_BCNDOK5				BIT(17)
#define PHIMR_BCNDOK4				BIT(16)
/* bit12 15: RSVD */
#define PHIMR_TXERR					BIT(11)
#define PHIMR_RXERR					BIT(10)
#define PHIMR_TXFOVW				BIT(9)
#define PHIMR_RXFOVW				BIT(8)
/* bit2-7: RSVD */
#define PHIMR_OCPINT				BIT(1)
/* bit0: RSVD */

#define UHIMR_TIMEOUT2				BIT(31)
#define UHIMR_TIMEOUT1				BIT(30)
#define UHIMR_PSTIMEOUT			BIT(29)
#define UHIMR_GTINT4				BIT(28)
#define UHIMR_GTINT3				BIT(27)
#define UHIMR_TXBCNERR				BIT(26)
#define UHIMR_TXBCNOK				BIT(25)
#define UHIMR_TSF_BIT32_TOGGLE	BIT(24)
#define UHIMR_BCNDMAINT3			BIT(23)
#define UHIMR_BCNDMAINT2			BIT(22)
#define UHIMR_BCNDMAINT1			BIT(21)
#define UHIMR_BCNDMAINT0			BIT(20)
#define UHIMR_BCNDOK3				BIT(19)
#define UHIMR_BCNDOK2				BIT(18)
#define UHIMR_BCNDOK1				BIT(17)
#define UHIMR_BCNDOK0				BIT(16)
#define UHIMR_HSISR_IND			BIT(15)
#define UHIMR_BCNDMAINT_E			BIT(14)
/* RSVD	BIT(13) */
#define UHIMR_CTW_END				BIT(12)
/* RSVD	BIT(11) */
#define UHIMR_C2HCMD				BIT(10)
#define UHIMR_CPWM2				BIT(9)
#define UHIMR_CPWM					BIT(8)
#define UHIMR_HIGHDOK				BIT(7)		/* High Queue DMA OK Interrupt */
#define UHIMR_MGNTDOK				BIT(6)		/* Management Queue DMA OK Interrupt */
#define UHIMR_BKDOK				BIT(5)		/* AC_BK DMA OK Interrupt */
#define UHIMR_BEDOK				BIT(4)		/* AC_BE DMA OK Interrupt */
#define UHIMR_VIDOK					BIT(3)		/* AC_VI DMA OK Interrupt */
#define UHIMR_VODOK				BIT(2)		/* AC_VO DMA Interrupt */
#define UHIMR_RDU					BIT(1)		/* Receive Descriptor Unavailable */
#define UHIMR_ROK					BIT(0)		/* Receive DMA OK Interrupt */

/* USB Host Interrupt Status Extension bit */
#define UHIMR_BCNDMAINT7			BIT(23)
#define UHIMR_BCNDMAINT6			BIT(22)
#define UHIMR_BCNDMAINT5			BIT(21)
#define UHIMR_BCNDMAINT4			BIT(20)
#define UHIMR_BCNDOK7				BIT(19)
#define UHIMR_BCNDOK6				BIT(18)
#define UHIMR_BCNDOK5				BIT(17)
#define UHIMR_BCNDOK4				BIT(16)
/* bit14-15: RSVD */
#define UHIMR_ATIMEND_E			BIT(13)
#define UHIMR_ATIMEND				BIT(12)
#define UHIMR_TXERR					BIT(11)
#define UHIMR_RXERR					BIT(10)
#define UHIMR_TXFOVW				BIT(9)
#define UHIMR_RXFOVW				BIT(8)
/* bit2-7: RSVD */
#define UHIMR_OCPINT				BIT(1)
/* bit0: RSVD */

#define HAL_NIC_UNPLUG_ISR			0xFFFFFFFF	/* The value when the NIC is unplugged for PCI. */
#define HAL_NIC_UNPLUG_PCI_ISR		0xEAEAEAEA	/* The value when the NIC is unplugged for PCI in PCI interrupt (page 3). */

/* ----------------------------------------------------------------------------
 * 8188 IMR/ISR bits
 * ---------------------------------------------------------------------------- */
#define IMR_DISABLED_88E			0x0
/* IMR DW0(0x0060-0063) Bit 0-31 */
#define IMR_TXCCK_88E				BIT(30)		/* TXRPT interrupt when CCX bit of the packet is set	 */
#define IMR_PSTIMEOUT_88E			BIT(29)		/* Power Save Time Out Interrupt */
#define IMR_GTINT4_88E				BIT(28)		/* When GTIMER4 expires, this bit is set to 1	 */
#define IMR_GTINT3_88E				BIT(27)		/* When GTIMER3 expires, this bit is set to 1	 */
#define IMR_TBDER_88E				BIT(26)		/* Transmit Beacon0 Error			 */
#define IMR_TBDOK_88E				BIT(25)		/* Transmit Beacon0 OK			 */
#define IMR_TSF_BIT32_TOGGLE_88E	BIT(24)		/* TSF Timer BIT32 toggle indication interrupt			 */
#define IMR_BCNDMAINT0_88E		BIT(20)		/* Beacon DMA Interrupt 0			 */
#define IMR_BCNDERR0_88E			BIT(16)		/* Beacon Queue DMA Error 0 */
#define IMR_HSISR_IND_ON_INT_88E	BIT(15)		/* HSISR Indicator (HSIMR & HSISR is true, this bit is set to 1)			 */
#define IMR_BCNDMAINT_E_88E		BIT(14)		/* Beacon DMA Interrupt Extension for Win7			 */
#define IMR_ATIMEND_88E			BIT(12)		/* CTWidnow End or ATIM Window End */
#define IMR_HISR1_IND_INT_88E		BIT(11)		/* HISR1 Indicator (HISR1 & HIMR1 is true, this bit is set to 1) */
#define IMR_C2HCMD_88E				BIT(10)		/* CPU to Host Command INT Status, Write 1 clear	 */
#define IMR_CPWM2_88E				BIT(9)			/* CPU power Mode exchange INT Status, Write 1 clear	 */
#define IMR_CPWM_88E				BIT(8)			/* CPU power Mode exchange INT Status, Write 1 clear	 */
#define IMR_HIGHDOK_88E			BIT(7)			/* High Queue DMA OK	 */
#define IMR_MGNTDOK_88E			BIT(6)			/* Management Queue DMA OK	 */
#define IMR_BKDOK_88E				BIT(5)			/* AC_BK DMA OK		 */
#define IMR_BEDOK_88E				BIT(4)			/* AC_BE DMA OK	 */
#define IMR_VIDOK_88E				BIT(3)			/* AC_VI DMA OK		 */
#define IMR_VODOK_88E				BIT(2)			/* AC_VO DMA OK	 */
#define IMR_RDU_88E					BIT(1)			/* Rx Descriptor Unavailable	 */
#define IMR_ROK_88E					BIT(0)			/* Receive DMA OK */

/* IMR DW1(0x00B4-00B7) Bit 0-31 */
#define IMR_BCNDMAINT7_88E		BIT(27)		/* Beacon DMA Interrupt 7 */
#define IMR_BCNDMAINT6_88E		BIT(26)		/* Beacon DMA Interrupt 6 */
#define IMR_BCNDMAINT5_88E		BIT(25)		/* Beacon DMA Interrupt 5 */
#define IMR_BCNDMAINT4_88E		BIT(24)		/* Beacon DMA Interrupt 4 */
#define IMR_BCNDMAINT3_88E		BIT(23)		/* Beacon DMA Interrupt 3 */
#define IMR_BCNDMAINT2_88E		BIT(22)		/* Beacon DMA Interrupt 2 */
#define IMR_BCNDMAINT1_88E		BIT(21)		/* Beacon DMA Interrupt 1 */
#define IMR_BCNDOK7_88E			BIT(20)		/* Beacon Queue DMA OK Interrupt 7 */
#define IMR_BCNDOK6_88E			BIT(19)		/* Beacon Queue DMA OK Interrupt 6 */
#define IMR_BCNDOK5_88E			BIT(18)		/* Beacon Queue DMA OK Interrupt 5 */
#define IMR_BCNDOK4_88E			BIT(17)		/* Beacon Queue DMA OK Interrupt 4 */
#define IMR_BCNDOK3_88E			BIT(16)		/* Beacon Queue DMA OK Interrupt 3 */
#define IMR_BCNDOK2_88E			BIT(15)		/* Beacon Queue DMA OK Interrupt 2 */
#define IMR_BCNDOK1_88E			BIT(14)		/* Beacon Queue DMA OK Interrupt 1 */
#define IMR_ATIMEND_E_88E			BIT(13)		/* ATIM Window End Extension for Win7 */
#define IMR_TXERR_88E				BIT(11)		/* Tx Error Flag Interrupt Status, write 1 clear. */
#define IMR_RXERR_88E				BIT(10)		/* Rx Error Flag INT Status, Write 1 clear */
#define IMR_TXFOVW_88E				BIT(9)			/* Transmit FIFO Overflow */
#define IMR_RXFOVW_88E				BIT(8)			/* Receive FIFO Overflow */

/*===================================================================
=====================================================================
Here the register defines are for 92C. When the define is as same with 92C,
we will use the 92C's define for the consistency
So the following defines for 92C is not entire!!!!!!
=====================================================================
=====================================================================*/
/*
Based on Datasheet V33---090401
Register Summary
Current IOREG MAP
0x0000h ~ 0x00FFh   System Configuration (256 Bytes)
0x0100h ~ 0x01FFh   MACTOP General Configuration (256 Bytes)
0x0200h ~ 0x027Fh   TXDMA Configuration (128 Bytes)
0x0280h ~ 0x02FFh   RXDMA Configuration (128 Bytes)
0x0300h ~ 0x03FFh   PCIE EMAC Reserved Region (256 Bytes)
0x0400h ~ 0x04FFh   Protocol Configuration (256 Bytes)
0x0500h ~ 0x05FFh   EDCA Configuration (256 Bytes)
0x0600h ~ 0x07FFh   WMAC Configuration (512 Bytes)
0x2000h ~ 0x3FFFh   8051 FW Download Region (8196 Bytes)
*/
/* ---------------------------------------------------------------------------- */
/*		 8192C (TXPAUSE) transmission pause 	(Offset 0x522, 8 bits) */
/* ---------------------------------------------------------------------------- */
/* Note:
*	The the bits of stoping AC(VO/VI/BE/BK) queue in datasheet RTL8192S/RTL8192C are wrong,
*	the correct arragement is VO - Bit0, VI - Bit1, BE - Bit2, and BK - Bit3.
*	8723 and 88E may be not correct either in the eralier version. Confirmed with DD Tim.
* By Bruce, 2011-09-22. */
#define StopBecon		BIT(6)
#define StopHigh			BIT(5)
#define StopMgt			BIT(4)
#define StopBK			BIT(3)
#define StopBE			BIT(2)
#define StopVI			BIT(1)
#define StopVO			BIT(0)

/* ----------------------------------------------------------------------------
 * 8192C (RCR) Receive Configuration Register	(Offset 0x608, 32 bits)
 * ---------------------------------------------------------------------------- */
#define RCR_APPFCS				BIT(31)	/* WMAC append FCS after pauload */
#define RCR_APP_MIC				BIT(30)	/* MACRX will retain the MIC at the bottom of the packet. */
#define RCR_APP_ICV				BIT(29)	/* MACRX will retain the ICV at the bottom of the packet. */
#define RCR_APP_PHYST_RXFF		BIT(28)	/* PHY Status is appended before RX packet in RXFF */
#define RCR_APP_BA_SSN			BIT(27)	/* SSN of previous TXBA is appended as after original RXDESC as the 4-th DW of RXDESC. */
#define RCR_VHT_DACK			BIT(26)	/* This bit to control response type for vht single mpdu data packet. 1. ACK as response 0. BA as response */
#define RCR_TCPOFLD_EN			BIT(25)	/* Enable TCP checksum offload */
#define RCR_ENMBID				BIT(24)	/* Enable Multiple BssId. Only response ACK to the packets whose DID(A1) matching to the addresses in the MBSSID CAM Entries. */
#define RCR_LSIGEN				BIT(23)	/* Enable LSIG TXOP Protection function. Search KEYCAM for each rx packet to check if LSIGEN bit is set. */
#define RCR_MFBEN				BIT(22)	/* Enable immediate MCS Feedback function. When Rx packet with MRQ = 1'b1, then search KEYCAM to find sender's MCS Feedback function and send response. */
#define RCR_DISCHKPPDLLEN		BIT(21)	/* Do not check PPDU while the PPDU length is smaller than 14 byte. */
#define RCR_PKTCTL_DLEN			BIT(20)	/* While rx path dead lock occurs, reset rx path */
#define RCR_DISGCLK				BIT(19)	/* Disable macrx clock gating control (no used) */
#define RCR_TIM_PARSER_EN		BIT(18)	/* RX Beacon TIM Parser. */
#define RCR_BC_MD_EN			BIT(17)	/* Broadcast data packet more data bit check interrupt enable.*/
#define RCR_UC_MD_EN			BIT(16)	/* Unicast data packet more data bit check interrupt enable. */
#define RCR_RXSK_PERPKT			BIT(15)	/* Executing key search per MPDU */
#define RCR_HTC_LOC_CTRL		BIT(14)	/* MFC<--HTC = 1 MFC-->HTC = 0 */
#define RCR_AMF					BIT(13)	/* Accept management type frame */
#define RCR_ACF					BIT(12)	/* Accept control type frame. Control frames BA, BAR, and PS-Poll (when in AP mode) are not controlled by this bit. They are controlled by ADF. */
#define RCR_ADF					BIT(11)	/* Accept data type frame. This bit also regulates BA, BAR, and PS-Poll (AP mode only). */
#define RCR_DISDECMYPKT			BIT(10)	/* This bit determines whether hw need to do decryption.1: If A1 match, do decryption.0: Do decryption. */
#define RCR_AICV					BIT(9)		/* Accept ICV error packet */
#define RCR_ACRC32				BIT(8)		/* Accept CRC32 error packet */
#define RCR_CBSSID_BCN			BIT(7)		/* Accept BSSID match packet (Rx beacon, probe rsp) */
#define RCR_CBSSID_DATA		BIT(6)		/* Accept BSSID match packet (Data) */
#define RCR_APWRMGT			BIT(5)		/* Accept power management packet */
#define RCR_ADD3				BIT(4)		/* Accept address 3 match packet */
#define RCR_AB					BIT(3)		/* Accept broadcast packet */
#define RCR_AM					BIT(2)		/* Accept multicast packet */
#define RCR_APM					BIT(1)		/* Accept physical match packet */
#define RCR_AAP					BIT(0)		/* Accept all unicast packet */

/* -----------------------------------------------------
 *
 *	0x0000h ~ 0x00FFh	System Configuration
 *
 * ----------------------------------------------------- */

/* 2 SYS_ISO_CTRL */
#define ISO_MD2PP				BIT(0)
#define ISO_UA2USB				BIT(1)
#define ISO_UD2CORE				BIT(2)
#define ISO_PA2PCIE				BIT(3)
#define ISO_PD2CORE				BIT(4)
#define ISO_IP2MAC				BIT(5)
#define ISO_DIOP					BIT(6)
#define ISO_DIOE					BIT(7)
#define ISO_EB2CORE				BIT(8)
#define ISO_DIOR					BIT(9)
#define PWC_EV12V				BIT(15)

/* 2 SYS_FUNC_EN */
#define FEN_BBRSTB				BIT(0)
#define FEN_BB_GLB_RSTn		BIT(1)
#define FEN_USBA				BIT(2)
#define FEN_UPLL				BIT(3)
#define FEN_USBD				BIT(4)
#define FEN_DIO_PCIE			BIT(5)
#define FEN_PCIEA				BIT(6)
#define FEN_PPLL					BIT(7)
#define FEN_PCIED				BIT(8)
#define FEN_DIOE				BIT(9)
#define FEN_CPUEN				BIT(10)
#define FEN_DCORE				BIT(11)
#define FEN_ELDR				BIT(12)
#define FEN_EN_25_1				BIT(13)
#define FEN_HWPDN				BIT(14)
#define FEN_MREGEN				BIT(15)

/* 2 APS_FSMCO */
#define PFM_LDALL				BIT(0)
#define PFM_ALDN				BIT(1)
#define PFM_LDKP				BIT(2)
#define PFM_WOWL				BIT(3)
#define EnPDN					BIT(4)
#define PDN_PL					BIT(5)
#define APFM_ONMAC				BIT(8)
#define APFM_OFF				BIT(9)
#define APFM_RSM				BIT(10)
#define AFSM_HSUS				BIT(11)
#define AFSM_PCIE				BIT(12)
#define APDM_MAC				BIT(13)
#define APDM_HOST				BIT(14)
#define APDM_HPDN				BIT(15)
#define RDY_MACON				BIT(16)
#define SUS_HOST				BIT(17)
#define ROP_ALD					BIT(20)
#define ROP_PWR					BIT(21)
#define ROP_SPS					BIT(22)
#define SOP_MRST				BIT(25)
#define SOP_FUSE				BIT(26)
#define SOP_ABG					BIT(27)
#define SOP_AMB					BIT(28)
#define SOP_RCK					BIT(29)
#define SOP_A8M					BIT(30)
#define XOP_BTCK				BIT(31)

/* 2 SYS_CLKR */
#define ANAD16V_EN				BIT(0)
#define ANA8M					BIT(1)
#define MACSLP					BIT(4)
#define LOADER_CLK_EN			BIT(5)

/* 2 9346CR /REG_SYS_EEPROM_CTRL */
#define BOOT_FROM_EEPROM		BIT(4)
#define EEPROMSEL				BIT(4)
#define EEPROM_EN				BIT(5)

/* 2 RF_CTRL */
#define RF_EN					BIT(0)
#define RF_RSTB					BIT(1)
#define RF_SDMRSTB				BIT(2)

/* 2 LDOV12D_CTRL */
#define LDV12_EN				BIT(0)
#define LDV12_SDBY				BIT(1)
#define LPLDO_HSM				BIT(2)
#define LPLDO_LSM_DIS			BIT(3)
#define _LDV12_VADJ(x)			(((x) & 0xF) << 4)

/* 2 EFUSE_TEST (For RTL8723 partially) */
#define EF_TRPT					BIT(7)
#define EF_CELL_SEL				(BIT(8) | BIT(9)) /* 00: Wifi Efuse, 01: BT Efuse0, 10: BT Efuse1, 11: BT Efuse2 */
#define LDOE25_EN				BIT(31)
#define EFUSE_SEL(x)				(((x) & 0x3) << 8)
#define EFUSE_SEL_MASK			0x300
#define EFUSE_WIFI_SEL_0		0x0
#define EFUSE_BT_SEL_0			0x1
#define EFUSE_BT_SEL_1			0x2
#define EFUSE_BT_SEL_2			0x3

/* 2 8051FWDL
 * 2 MCUFWDL */
#define MCUFWDL_EN				BIT(0)
#define MCUFWDL_RDY			BIT(1)
#define FWDL_ChkSum_rpt		BIT(2)
#define MACINI_RDY				BIT(3)
#define BBINI_RDY				BIT(4)
#define RFINI_RDY				BIT(5)
#define WINTINI_RDY				BIT(6)
#define RAM_DL_SEL				BIT(7)
#define CPU_DL_READY			BIT(15) /* add flag  by gw for fw download ready 20130826 */
#define ROM_DLEN				BIT(19)
#define CPRST					BIT(23)

/* 2 REG_SYS_CFG */
#define XCLK_VLD				BIT(0)
#define ACLK_VLD				BIT(1)
#define UCLK_VLD				BIT(2)
#define PCLK_VLD				BIT(3)
#define PCIRSTB					BIT(4)
#define V15_VLD					BIT(5)
#define SW_OFFLOAD_EN			BIT(7)
#define SIC_IDLE					BIT(8)
#define BD_MAC2					BIT(9)
#define BD_MAC1					BIT(10)
#define IC_MACPHY_MODE		BIT(11)
#define CHIP_VER				(BIT(12) | BIT(13) | BIT(14) | BIT(15))
#define BT_FUNC					BIT(16)
#define VENDOR_ID				BIT(19)
#define EXT_VENDOR_ID			(BIT(18) | BIT(19)) /* Currently only for RTL8723B */
#define PAD_HWPD_IDN			BIT(22)
#define TRP_VAUX_EN				BIT(23)	/* RTL ID */
#define TRP_BT_EN				BIT(24)
#define BD_PKG_SEL				BIT(25)
#define BD_HCI_SEL				BIT(26)
#define TYPE_ID					BIT(27)
#define RF_TYPE_ID				BIT(27)

#define RTL_ID					BIT(23) /* TestChip ID, 1:Test(RLE); 0:MP(RL) */
#define SPS_SEL					BIT(24) /* 1:LDO regulator mode; 0:Switching regulator mode */

#define CHIP_VER_RTL_MASK		0xF000	/* Bit 12 ~ 15 */
#define CHIP_VER_RTL_SHIFT		12
#define EXT_VENDOR_ID_SHIFT	18

/* 2 REG_GPIO_OUTSTS (For RTL8723 only) */
#define EFS_HCI_SEL				(BIT(0) | BIT(1))
#define PAD_HCI_SEL				(BIT(2) | BIT(3))
#define HCI_SEL					(BIT(4) | BIT(5))
#define PKG_SEL_HCI				BIT(6)
#define FEN_GPS					BIT(7)
#define FEN_BT					BIT(8)
#define FEN_WL					BIT(9)
#define FEN_PCI					BIT(10)
#define FEN_USB					BIT(11)
#define BTRF_HWPDN_N			BIT(12)
#define WLRF_HWPDN_N			BIT(13)
#define PDN_BT_N				BIT(14)
#define PDN_GPS_N				BIT(15)
#define BT_CTL_HWPDN			BIT(16)
#define GPS_CTL_HWPDN			BIT(17)
#define PPHY_SUSB				BIT(20)
#define UPHY_SUSB				BIT(21)
#define PCI_SUSEN				BIT(22)
#define USB_SUSEN				BIT(23)
#define RF_RL_ID					(BIT(31) | BIT(30) | BIT(29) | BIT(28))

/* -----------------------------------------------------
 *
 *	0x0100h ~ 0x01FFh	MACTOP General Configuration
 *
 * ----------------------------------------------------- */

/* 2 Function Enable Registers
 * 2 CR */
#define HCI_TXDMA_EN			BIT(0)
#define HCI_RXDMA_EN			BIT(1)
#define TXDMA_EN				BIT(2)
#define RXDMA_EN				BIT(3)
#define PROTOCOL_EN				BIT(4)
#define SCHEDULE_EN				BIT(5)
#define MACTXEN					BIT(6)
#define MACRXEN					BIT(7)
#define ENSWBCN					BIT(8)
#define ENSEC					BIT(9)
#define CALTMR_EN				BIT(10)	/* 32k CAL TMR enable */

/* Network type */
#define _NETTYPE(x)				(((x) & 0x3) << 16)
#define MASK_NETTYPE			0x30000
#define NT_NO_LINK				0x0
#define NT_LINK_AD_HOC			0x1
#define NT_LINK_AP				0x2
#define NT_AS_AP				0x3

/* 2 PBP - Page Size Register */
#define GET_RX_PAGE_SIZE(value)			((value) & 0xF)
#define GET_TX_PAGE_SIZE(value)			(((value) & 0xF0) >> 4)
#define _PSRX_MASK				0xF
#define _PSTX_MASK				0xF0
#define _PSRX(x)				(x)
#define _PSTX(x)				((x) << 4)

#define PBP_64					0x0
#define PBP_128					0x1
#define PBP_256					0x2
#define PBP_512					0x3
#define PBP_1024				0x4

/* 2 TX/RXDMA */
#define RXDMA_ARBBW_EN		BIT(0)
#define RXSHFT_EN				BIT(1)
#define RXDMA_AGG_EN			BIT(2)
#define QS_VO_QUEUE			BIT(8)
#define QS_VI_QUEUE				BIT(9)
#define QS_BE_QUEUE			BIT(10)
#define QS_BK_QUEUE			BIT(11)
#define QS_MANAGER_QUEUE		BIT(12)
#define QS_HIGH_QUEUE			BIT(13)

#define HQSEL_VOQ				BIT(0)
#define HQSEL_VIQ				BIT(1)
#define HQSEL_BEQ				BIT(2)
#define HQSEL_BKQ				BIT(3)
#define HQSEL_MGTQ				BIT(4)
#define HQSEL_HIQ				BIT(5)

/* For normal driver, 0x10C */
#define _TXDMA_CMQ_MAP(x)			(((x) & 0x3) << 16)
#define _TXDMA_HIQ_MAP(x)			(((x) & 0x3) << 14)
#define _TXDMA_MGQ_MAP(x)			(((x) & 0x3) << 12)
#define _TXDMA_BKQ_MAP(x)			(((x) & 0x3) << 10)
#define _TXDMA_BEQ_MAP(x)			(((x) & 0x3) << 8)
#define _TXDMA_VIQ_MAP(x)			(((x) & 0x3) << 6)
#define _TXDMA_VOQ_MAP(x)			(((x) & 0x3) << 4)

#define QUEUE_EXTRA				0
#define QUEUE_LOW				1
#define QUEUE_NORMAL			2
#define QUEUE_HIGH				3

/* 2 TRXFF_BNDY */

/* 2 LLT_INIT */
#define _LLT_NO_ACTIVE				0x0
#define _LLT_WRITE_ACCESS			0x1
#define _LLT_READ_ACCESS			0x2

#define _LLT_INIT_DATA(x)			((x) & 0xFF)
#define _LLT_INIT_ADDR(x)			(((x) & 0xFF) << 8)
#define _LLT_OP(x)					(((x) & 0x3) << 30)
#define _LLT_OP_VALUE(x)			(((x) >> 30) & 0x3)

/* -----------------------------------------------------
 *
 *	0x0200h ~ 0x027Fh	TXDMA Configuration
 *
 * ----------------------------------------------------- */
/* 2 RQPN */
#define _HPQ(x)					((x) & 0xFF)
#define _LPQ(x)					(((x) & 0xFF) << 8)
#define _PUBQ(x)					(((x) & 0xFF) << 16)
#define _NPQ(x)					((x) & 0xFF)			/* NOTE: in RQPN_NPQ register */
#define _EPQ(x)					(((x) & 0xFF) << 16)	/* NOTE: in RQPN_EPQ register */

#define HPQ_PUBLIC_DIS			BIT(24)
#define LPQ_PUBLIC_DIS			BIT(25)
#define LD_RQPN					BIT(31)

/* 2 TDECTL */
#define BLK_DESC_NUM_SHIFT			4
#define BLK_DESC_NUM_MASK			0xF

/* 2 TXDMA_OFFSET_CHK */
#define DROP_DATA_EN				BIT(9)

/* 2 AUTO_LLT */
#define BIT_SHIFT_TXPKTNUM 24
#define BIT_MASK_TXPKTNUM 0xff
#define BIT_TXPKTNUM(x) (((x) & BIT_MASK_TXPKTNUM) << BIT_SHIFT_TXPKTNUM)

#define BIT_TDE_DBG_SEL BIT(23)
#define BIT_AUTO_INIT_LLT BIT(16)

#define BIT_SHIFT_Tx_OQT_free_space 8
#define BIT_MASK_Tx_OQT_free_space 0xff
#define BIT_Tx_OQT_free_space(x) (((x) & BIT_MASK_Tx_OQT_free_space) << BIT_SHIFT_Tx_OQT_free_space)

/* -----------------------------------------------------
 *
 *	0x0120h ~ 0x0123h	RX DMA Configuration
 *
 * ----------------------------------------------------- */
#define BIT_FS_RXDONE_INT_EN				BIT(16)

/* REG_RXPKT_NUM				(Offset 0x0284) */
#define BIT_RW_RELEASE_EN				BIT(18)

/* -----------------------------------------------------
 *
 *	0x0280h ~ 0x028Bh	RX DMA Configuration
 *
 * ----------------------------------------------------- */

/* 2 REG_RXDMA_CONTROL, 0x0286h
 * Write only. When this bit is set, RXDMA will decrease RX PKT counter by one. Before
 * this bit is polled, FW shall update RXFF_RD_PTR first. This register is write pulse and auto clear.
 * #define RXPKT_RELEASE_POLL			BIT(0)
 * Read only. When RXMA finishes on-going DMA operation, RXMDA will report idle state in
 * this bit. FW can start releasing packets after RXDMA entering idle mode.
 * #define RXDMA_IDLE					BIT(1)
 * When this bit is set, RXDMA will enter this mode after on-going RXDMA packet to host
 * completed, and stop DMA packet to host. RXDMA will then report Default: 0;
 * #define RW_RELEASE_EN				BIT(2) */

/* 2 REG_RXPKT_NUM, 0x0284 */
#define	RXPKT_RELEASE_POLL	BIT(16)
#define	RXDMA_IDLE				BIT(17)
#define	RW_RELEASE_EN			BIT(18)

/* -----------------------------------------------------
 *
 *	0x0400h ~ 0x047Fh	Protocol Configuration
 *
 * ----------------------------------------------------- */
/* 2 FWHW_TXQ_CTRL */
#define EN_AMPDU_RTY_NEW			BIT(7)

/* 2 SPEC SIFS */
#define _SPEC_SIFS_CCK(x)			((x) & 0xFF)
#define _SPEC_SIFS_OFDM(x)			(((x) & 0xFF) << 8)

/* 2 RL */
#define	RETRY_LIMIT_SHORT_SHIFT			8
#define	RETRY_LIMIT_LONG_SHIFT			0

/* -----------------------------------------------------
 *
 *	0x0500h ~ 0x05FFh	EDCA Configuration
 *
 * ----------------------------------------------------- */

/* 2 EDCA setting */
#define AC_PARAM_TXOP_LIMIT_OFFSET		16
#define AC_PARAM_ECW_MAX_OFFSET			12
#define AC_PARAM_ECW_MIN_OFFSET			8
#define AC_PARAM_AIFS_OFFSET				0

#define _LRL(x)					((x) & 0x3F)
#define _SRL(x)					(((x) & 0x3F) << 8)

/* 2 BCN_CTRL */
#define EN_TXBCN_RPT			BIT(2)
#define EN_BCN_FUNCTION		BIT(3)
#define STOP_BCNQ				BIT(6)
#define DIS_RX_BSSID_FIT		BIT(6)

#define DIS_ATIM					BIT(0)
#define DIS_BCNQ_SUB			BIT(1)
#define DIS_TSF_UDT				BIT(4)

/* The same function but different bit field. */
#define DIS_TSF_UDT0_NORMAL_CHIP	BIT(4)
#define DIS_TSF_UDT0_TEST_CHIP	BIT(5)

/* 2 ACMHWCTRL */
#define AcmHw_HwEn				BIT(0)
#define AcmHw_BeqEn			BIT(1)
#define AcmHw_ViqEn				BIT(2)
#define AcmHw_VoqEn			BIT(3)
#define AcmHw_BeqStatus		BIT(4)
#define AcmHw_ViqStatus			BIT(5)
#define AcmHw_VoqStatus		BIT(6)

/* 2 */ /* REG_DUAL_TSF_RST (0x553) */
#define DUAL_TSF_RST_P2P		BIT(4)

/* 2 */ /* REG_NOA_DESC_SEL (0x5CF) */
#define NOA_DESC_SEL_0			0
#define NOA_DESC_SEL_1			BIT(4)

/* -----------------------------------------------------
 *
 *	0x0600h ~ 0x07FFh	WMAC Configuration
 *
 * ----------------------------------------------------- */

/* 2 APSD_CTRL */
#define APSDOFF					BIT(6)

/* 2 TCR */
#define TSFRST					BIT(0)
#define DIS_GCLK					BIT(1)
#define PAD_SEL					BIT(2)
#define PWR_ST					BIT(6)
#define PWRBIT_OW_EN			BIT(7)
#define ACRC						BIT(8)
#define CFENDFORM				BIT(9)
#define ICV						BIT(10)

/* 2 RCR */
#define AAP						BIT(0)
#define APM						BIT(1)
#define AM						BIT(2)
#define AB						BIT(3)
#define ADD3						BIT(4)
#define APWRMGT				BIT(5)
#define CBSSID					BIT(6)
#define CBSSID_DATA				BIT(6)
#define CBSSID_BCN				BIT(7)
#define ACRC32					BIT(8)
#define AICV						BIT(9)
#define ADF						BIT(11)
#define ACF						BIT(12)
#define AMF						BIT(13)
#define HTC_LOC_CTRL			BIT(14)
#define UC_DATA_EN				BIT(16)
#define BM_DATA_EN				BIT(17)
#define MFBEN					BIT(22)
#define LSIGEN					BIT(23)
#define EnMBID					BIT(24)
#define FORCEACK				BIT(26)
#define APP_BASSN				BIT(27)
#define APP_PHYSTS				BIT(28)
#define APP_ICV					BIT(29)
#define APP_MIC					BIT(30)
#define APP_FCS					BIT(31)

/* 2 SECCFG */
#define SCR_TxUseDK				BIT(0)			/* Force Tx Use Default Key */
#define SCR_RxUseDK				BIT(1)			/* Force Rx Use Default Key */
#define SCR_TxEncEnable			BIT(2)			/* Enable Tx Encryption */
#define SCR_RxDecEnable			BIT(3)			/* Enable Rx Decryption */
#define SCR_SKByA2				BIT(4)			/* Search kEY BY A2 */
#define SCR_NoSKMC				BIT(5)			/* No Key Search Multicast */
#define SCR_TXBCUSEDK			BIT(6)			/* Force Tx Broadcast packets Use Default Key */
#define SCR_RXBCUSEDK			BIT(7)			/* Force Rx Broadcast packets Use Default Key */
#define SCR_CHK_KEYID			BIT(8)
#define SCR_CHK_BMC				BIT(9)			/* add option to support a2+keyid+bcm */

/*REG_MBIDCAMCFG           (Offset 0x0628/0x62C)*/
#define BIT_MBIDCAM_POLL		BIT(31)
#define BIT_MBIDCAM_WT_EN		BIT(30)

#define MBIDCAM_ADDR_MASK		0x1F
#define MBIDCAM_ADDR_SHIFT		24

#define BIT_MBIDCAM_VALID		BIT(23)
#define BIT_LSIC_TXOP_EN		BIT(17)
#define BIT_CTS_EN				BIT(16)

/* -----------------------------------------------------
 *
 *	SDIO Bus Specification
 *
 * ----------------------------------------------------- */

/* I/O bus domain address mapping */
#define SDIO_LOCAL_BASE		0x10250000
#define WLAN_IOREG_BASE		0x10260000
#define FIRMWARE_FIFO_BASE	0x10270000
#define TX_HIQ_BASE				0x10310000
#define TX_MIQ_BASE				0x10320000
#define TX_LOQ_BASE				0x10330000
#define TX_EPQ_BASE				0x10350000
#define RX_RX0FF_BASE			0x10340000

/* SDIO host local register space mapping. */
#define SDIO_LOCAL_MSK				0x0FFF
#define WLAN_IOREG_MSK		0x7FFF
#define WLAN_FIFO_MSK			      	0x1FFF	/* Aggregation Length[12:0] */
#define WLAN_RX0FF_MSK				0x0003

#define SDIO_WITHOUT_REF_DEVICE_ID	0	/* Without reference to the SDIO Device ID */
#define SDIO_LOCAL_DEVICE_ID           		0	/* 0b[16], 000b[15:13] */
#define WLAN_TX_HIQ_DEVICE_ID			4	/* 0b[16], 100b[15:13] */
#define WLAN_TX_MIQ_DEVICE_ID 		5	/* 0b[16], 101b[15:13] */
#define WLAN_TX_LOQ_DEVICE_ID 		6	/* 0b[16], 110b[15:13] */
#define WLAN_TX_EXQ_DEVICE_ID		3	/* 0b[16], 011b[15:13] */
#define WLAN_RX0FF_DEVICE_ID 			7	/* 0b[16], 111b[15:13] */
#define WLAN_IOREG_DEVICE_ID 			8	/* 1b[16] */

/* SDIO Tx Free Page Index */
#define HI_QUEUE_IDX			0
#define MID_QUEUE_IDX			1
#define LOW_QUEUE_IDX				2
#define PUBLIC_QUEUE_IDX			3

#define SDIO_MAX_TX_QUEUE			3		/* HIQ, MIQ and LOQ */
#define SDIO_MAX_RX_QUEUE			1

#define SDIO_REG_TX_CTRL			0x0000 /* SDIO Tx Control */
#define SDIO_REG_HIMR				0x0014 /* SDIO Host Interrupt Mask */
#define SDIO_REG_HISR				0x0018 /* SDIO Host Interrupt Service Routine */
#define SDIO_REG_HCPWM			0x0019 /* HCI Current Power Mode */
#define SDIO_REG_RX0_REQ_LEN		0x001C /* RXDMA Request Length */
#define SDIO_REG_OQT_FREE_PG		0x001E /* OQT Free Page */
#define SDIO_REG_FREE_TXPG			0x0020 /* Free Tx Buffer Page */
#define SDIO_REG_HCPWM1			0x0024 /* HCI Current Power Mode 1 */
#define SDIO_REG_HCPWM2			0x0026 /* HCI Current Power Mode 2 */
#define SDIO_REG_FREE_TXPG_SEQ	0x0028 /* Free Tx Page Sequence */
#define SDIO_REG_HTSFR_INFO		0x0030 /* HTSF Informaion */
#define SDIO_REG_HRPWM1			0x0080 /* HCI Request Power Mode 1 */
#define SDIO_REG_HRPWM2			0x0082 /* HCI Request Power Mode 2 */
#define SDIO_REG_HPS_CLKR			0x0084 /* HCI Power Save Clock */
#define SDIO_REG_HSUS_CTRL			0x0086 /* SDIO HCI Suspend Control */
#define SDIO_REG_HIMR_ON			0x0090 /* SDIO Host Extension Interrupt Mask Always */
#define SDIO_REG_HISR_ON			0x0091 /* SDIO Host Extension Interrupt Status Always */

#define SDIO_HIMR_DISABLED			0

/* RTL8723/RTL8188E SDIO Host Interrupt Mask Register */
#define SDIO_HIMR_RX_REQUEST_MSK		BIT(0)
#define SDIO_HIMR_AVAL_MSK			BIT(1)
#define SDIO_HIMR_TXERR_MSK			BIT(2)
#define SDIO_HIMR_RXERR_MSK			BIT(3)
#define SDIO_HIMR_TXFOVW_MSK			BIT(4)
#define SDIO_HIMR_RXFOVW_MSK			BIT(5)
#define SDIO_HIMR_TXBCNOK_MSK			BIT(6)
#define SDIO_HIMR_TXBCNERR_MSK		BIT(7)
#define SDIO_HIMR_BCNERLY_INT_MSK		BIT(16)
#define SDIO_HIMR_C2HCMD_MSK			BIT(17)
#define SDIO_HIMR_CPWM1_MSK			BIT(18)
#define SDIO_HIMR_CPWM2_MSK			BIT(19)
#define SDIO_HIMR_HSISR_IND_MSK		BIT(20)
#define SDIO_HIMR_GTINT3_IND_MSK		BIT(21)
#define SDIO_HIMR_GTINT4_IND_MSK		BIT(22)
#define SDIO_HIMR_PSTIMEOUT_MSK		BIT(23)
#define SDIO_HIMR_OCPINT_MSK			BIT(24)
#define SDIO_HIMR_ATIMEND_MSK			BIT(25)
#define SDIO_HIMR_ATIMEND_E_MSK		BIT(26)
#define SDIO_HIMR_CTWEND_MSK			BIT(27)

/* RTL8188E SDIO Specific */
#define SDIO_HIMR_MCU_ERR_MSK			BIT(28)
#define SDIO_HIMR_TSF_BIT32_TOGGLE_MSK		BIT(29)

/* SDIO Host Interrupt Service Routine */
#define SDIO_HISR_RX_REQUEST			BIT(0)
#define SDIO_HISR_AVAL					BIT(1)
#define SDIO_HISR_TXERR					BIT(2)
#define SDIO_HISR_RXERR					BIT(3)
#define SDIO_HISR_TXFOVW				BIT(4)
#define SDIO_HISR_RXFOVW				BIT(5)
#define SDIO_HISR_TXBCNOK				BIT(6)
#define SDIO_HISR_TXBCNERR				BIT(7)
#define SDIO_HISR_BCNERLY_INT			BIT(16)
#define SDIO_HISR_C2HCMD				BIT(17)
#define SDIO_HISR_CPWM1				BIT(18)
#define SDIO_HISR_CPWM2				BIT(19)
#define SDIO_HISR_HSISR_IND			BIT(20)
#define SDIO_HISR_GTINT3_IND			BIT(21)
#define SDIO_HISR_GTINT4_IND			BIT(22)
#define SDIO_HISR_PSTIMEOUT			BIT(23)
#define SDIO_HISR_OCPINT				BIT(24)
#define SDIO_HISR_ATIMEND				BIT(25)
#define SDIO_HISR_ATIMEND_E			BIT(26)
#define SDIO_HISR_CTWEND				BIT(27)

/* RTL8188E SDIO Specific */
#define SDIO_HISR_MCU_ERR				BIT(28)
#define SDIO_HISR_TSF_BIT32_TOGGLE	BIT(29)

#define MASK_SDIO_HISR_CLEAR		(SDIO_HISR_TXERR |\
		SDIO_HISR_RXERR |\
		SDIO_HISR_TXFOVW |\
		SDIO_HISR_RXFOVW |\
		SDIO_HISR_TXBCNOK |\
		SDIO_HISR_TXBCNERR |\
		SDIO_HISR_C2HCMD |\
		SDIO_HISR_CPWM1 |\
		SDIO_HISR_CPWM2 |\
		SDIO_HISR_HSISR_IND |\
		SDIO_HISR_GTINT3_IND |\
		SDIO_HISR_GTINT4_IND |\
		SDIO_HISR_PSTIMEOUT |\
		SDIO_HISR_OCPINT)

/* SDIO HCI Suspend Control Register */
#define HCI_RESUME_PWR_RDY			BIT(1)
#define HCI_SUS_CTRL					BIT(0)

/* SDIO Tx FIFO related */
#define SDIO_TX_FREE_PG_QUEUE			4	/* The number of Tx FIFO free page */
#define SDIO_TX_FIFO_PAGE_SZ			128

	#define MAX_TX_AGG_PACKET_NUMBER	0xFF
	#define MAX_TX_AGG_PACKET_NUMBER_8812	64

/* -----------------------------------------------------
 *
 *	0xFE00h ~ 0xFE55h	USB Configuration
 *
 * ----------------------------------------------------- */

/* 2 USB Information (0xFE17) */
#define USB_IS_HIGH_SPEED			0
#define USB_IS_FULL_SPEED			1
#define USB_SPEED_MASK				BIT(5)

#define USB_NORMAL_SIE_EP_MASK	0xF
#define USB_NORMAL_SIE_EP_SHIFT	4

/* 2 Special Option */
#define USB_AGG_EN				BIT(3)

/* 0; Use interrupt endpoint to upload interrupt pkt
 * 1; Use bulk endpoint to upload interrupt pkt, */
#define INT_BULK_SEL			BIT(4)

/* 2REG_C2HEVT_CLEAR */
#define C2H_EVT_HOST_CLOSE		0x00	/* Set by driver and notify FW that the driver has read the C2H command message */
#define C2H_EVT_FW_CLOSE		0xFF	/* Set by FW indicating that FW had set the C2H command message and it's not yet read by driver. */

/* 2REG_MULTI_FUNC_CTRL(For RTL8723 Only) */
#define WL_HWPDN_EN			BIT(0)	/* Enable GPIO[9] as WiFi HW PDn source */
#define WL_HWPDN_SL			BIT(1)	/* WiFi HW PDn polarity control */
#define WL_FUNC_EN				BIT(2)	/* WiFi function enable */
#define WL_HWROF_EN			BIT(3)	/* Enable GPIO[9] as WiFi RF HW PDn source */
#define BT_HWPDN_EN			BIT(16)	/* Enable GPIO[11] as BT HW PDn source */
#define BT_HWPDN_SL			BIT(17)	/* BT HW PDn polarity control */
#define BT_FUNC_EN				BIT(18)	/* BT function enable */
#define BT_HWROF_EN			BIT(19)	/* Enable GPIO[11] as BT/GPS RF HW PDn source */
#define GPS_HWPDN_EN			BIT(20)	/* Enable GPIO[10] as GPS HW PDn source */
#define GPS_HWPDN_SL			BIT(21)	/* GPS HW PDn polarity control */
#define GPS_FUNC_EN			BIT(22)	/* GPS function enable */

/* 3 REG_LIFECTRL_CTRL */
#define HAL92C_EN_PKT_LIFE_TIME_BK		BIT(3)
#define HAL92C_EN_PKT_LIFE_TIME_BE		BIT(2)
#define HAL92C_EN_PKT_LIFE_TIME_VI		BIT(1)
#define HAL92C_EN_PKT_LIFE_TIME_VO		BIT(0)

#define HAL92C_MSDU_LIFE_TIME_UNIT		128	/* in us, said by Tim. */

/* 2 8192D PartNo. */
#define PARTNO_92D_NIC							(BIT7 | BIT6)
#define PARTNO_92D_NIC_REMARK				(BIT5 | BIT4)
#define PARTNO_SINGLE_BAND_VS				BIT(3)
#define PARTNO_SINGLE_BAND_VS_REMARK		BIT(1)
#define PARTNO_CONCURRENT_BAND_VC			(BIT3 | BIT2)
#define PARTNO_CONCURRENT_BAND_VC_REMARK	(BIT1 | BIT0)

/* ********************************************************
 * General definitions
 * ******************************************************** */

#define LAST_ENTRY_OF_TX_PKT_BUFFER_8188E(__Adapter)	   (IS_VENDOR_8188E_I_CUT_SERIES(__Adapter) ? 255 : 175)
#define LAST_ENTRY_OF_TX_PKT_BUFFER_8812			255
#define LAST_ENTRY_OF_TX_PKT_BUFFER_8723B		255
#define LAST_ENTRY_OF_TX_PKT_BUFFER_8192C		255
#define LAST_ENTRY_OF_TX_PKT_BUFFER_8703B		255
#define LAST_ENTRY_OF_TX_PKT_BUFFER_DUAL_MAC	127
#define LAST_ENTRY_OF_TX_PKT_BUFFER_8188F		255
#define LAST_ENTRY_OF_TX_PKT_BUFFER_8723D		255

#define POLLING_LLT_THRESHOLD				20
	#define POLLING_READY_TIMEOUT_COUNT		1000

/* GPIO BIT */
#define	HAL_8812A_HW_GPIO_WPS_BIT	BIT(2)
#define	HAL_8192C_HW_GPIO_WPS_BIT	BIT(2)
#define	HAL_8192EU_HW_GPIO_WPS_BIT	BIT(7)
#define	HAL_8188E_HW_GPIO_WPS_BIT	BIT(7)

#endif /* __HAL_COMMON_H__ */
