/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLHtmlElement.h"

#include <wtf/GetPtr.h>

#include "HTMLHtmlElement.h"
#include "KURL.h"

#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLHtmlElement)

/* Hash table */

static const HashTableValue JSHTMLHtmlElementTableValues[3] =
{
    { "version", DontDelete, (intptr_t)jsHTMLHtmlElementVersion, (intptr_t)setJSHTMLHtmlElementVersion },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLHtmlElementConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLHtmlElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSHTMLHtmlElementTableValues, 0 };
#else
    { 4, 3, JSHTMLHtmlElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLHtmlElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLHtmlElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLHtmlElementConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLHtmlElementConstructorTableValues, 0 };
#endif

class JSHTMLHtmlElementConstructor : public DOMObject {
public:
    JSHTMLHtmlElementConstructor(ExecState* exec)
        : DOMObject(JSHTMLHtmlElementConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLHtmlElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLHtmlElementConstructor::s_info = { "HTMLHtmlElementConstructor", 0, &JSHTMLHtmlElementConstructorTable, 0 };

bool JSHTMLHtmlElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHtmlElementConstructor, DOMObject>(exec, &JSHTMLHtmlElementConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLHtmlElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLHtmlElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLHtmlElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSHTMLHtmlElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLHtmlElementPrototype::s_info = { "HTMLHtmlElementPrototype", 0, &JSHTMLHtmlElementPrototypeTable, 0 };

JSObject* JSHTMLHtmlElementPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLHtmlElement>(exec);
}

const ClassInfo JSHTMLHtmlElement::s_info = { "HTMLHtmlElement", &JSHTMLElement::s_info, &JSHTMLHtmlElementTable, 0 };

JSHTMLHtmlElement::JSHTMLHtmlElement(PassRefPtr<Structure> structure, PassRefPtr<HTMLHtmlElement> impl)
    : JSHTMLElement(structure, impl)
{
}

JSObject* JSHTMLHtmlElement::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLHtmlElementPrototype(JSHTMLHtmlElementPrototype::createStructure(JSHTMLElementPrototype::self(exec)));
}

bool JSHTMLHtmlElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHtmlElement, Base>(exec, &JSHTMLHtmlElementTable, this, propertyName, slot);
}

JSValuePtr jsHTMLHtmlElementVersion(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLHtmlElement* imp = static_cast<HTMLHtmlElement*>(static_cast<JSHTMLHtmlElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->version());
}

JSValuePtr jsHTMLHtmlElementConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLHtmlElement*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLHtmlElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLHtmlElement, Base>(exec, propertyName, value, &JSHTMLHtmlElementTable, this, slot);
}

void setJSHTMLHtmlElementVersion(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLHtmlElement* imp = static_cast<HTMLHtmlElement*>(static_cast<JSHTMLHtmlElement*>(thisObject)->impl());
    imp->setVersion(valueToStringWithNullCheck(exec, value));
}

JSValuePtr JSHTMLHtmlElement::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLHtmlElementConstructor>(exec);
}


}
