/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLDocument.h"

#include <wtf/GetPtr.h>

#include "AtomicString.h"
#include "Element.h"
#include "HTMLCollection.h"
#include "HTMLDocument.h"
#include "JSElement.h"
#include "JSHTMLCollection.h"
#include "KURL.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLDocument)

/* Hash table */

static const HashTableValue JSHTMLDocumentTableValues[17] =
{
    { "embeds", DontDelete|ReadOnly, (intptr_t)jsHTMLDocumentEmbeds, (intptr_t)0 },
    { "plugins", DontDelete|ReadOnly, (intptr_t)jsHTMLDocumentPlugins, (intptr_t)0 },
    { "scripts", DontDelete|ReadOnly, (intptr_t)jsHTMLDocumentScripts, (intptr_t)0 },
    { "all", 0, (intptr_t)jsHTMLDocumentAll, (intptr_t)setJSHTMLDocumentAll },
    { "width", DontDelete|ReadOnly, (intptr_t)jsHTMLDocumentWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsHTMLDocumentHeight, (intptr_t)0 },
    { "dir", DontDelete, (intptr_t)jsHTMLDocumentDir, (intptr_t)setJSHTMLDocumentDir },
    { "designMode", DontDelete, (intptr_t)jsHTMLDocumentDesignMode, (intptr_t)setJSHTMLDocumentDesignMode },
    { "compatMode", DontDelete|ReadOnly, (intptr_t)jsHTMLDocumentCompatMode, (intptr_t)0 },
    { "activeElement", DontDelete|ReadOnly, (intptr_t)jsHTMLDocumentActiveElement, (intptr_t)0 },
    { "bgColor", DontDelete, (intptr_t)jsHTMLDocumentBgColor, (intptr_t)setJSHTMLDocumentBgColor },
    { "fgColor", DontDelete, (intptr_t)jsHTMLDocumentFgColor, (intptr_t)setJSHTMLDocumentFgColor },
    { "alinkColor", DontDelete, (intptr_t)jsHTMLDocumentAlinkColor, (intptr_t)setJSHTMLDocumentAlinkColor },
    { "linkColor", DontDelete, (intptr_t)jsHTMLDocumentLinkColor, (intptr_t)setJSHTMLDocumentLinkColor },
    { "vlinkColor", DontDelete, (intptr_t)jsHTMLDocumentVlinkColor, (intptr_t)setJSHTMLDocumentVlinkColor },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsHTMLDocumentConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDocumentTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSHTMLDocumentTableValues, 0 };
#else
    { 36, 31, JSHTMLDocumentTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSHTMLDocumentConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDocumentConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSHTMLDocumentConstructorTableValues, 0 };
#else
    { 1, 0, JSHTMLDocumentConstructorTableValues, 0 };
#endif

class JSHTMLDocumentConstructor : public DOMObject {
public:
    JSHTMLDocumentConstructor(ExecState* exec)
        : DOMObject(JSHTMLDocumentConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSHTMLDocumentPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSHTMLDocumentConstructor::s_info = { "HTMLDocumentConstructor", 0, &JSHTMLDocumentConstructorTable, 0 };

bool JSHTMLDocumentConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDocumentConstructor, DOMObject>(exec, &JSHTMLDocumentConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLDocumentPrototypeTableValues[9] =
{
    { "open", DontDelete|Function, (intptr_t)jsHTMLDocumentPrototypeFunctionOpen, (intptr_t)0 },
    { "close", DontDelete|Function, (intptr_t)jsHTMLDocumentPrototypeFunctionClose, (intptr_t)0 },
    { "write", DontDelete|Function, (intptr_t)jsHTMLDocumentPrototypeFunctionWrite, (intptr_t)1 },
    { "writeln", DontDelete|Function, (intptr_t)jsHTMLDocumentPrototypeFunctionWriteln, (intptr_t)1 },
    { "clear", DontDelete|Function, (intptr_t)jsHTMLDocumentPrototypeFunctionClear, (intptr_t)0 },
    { "captureEvents", DontDelete|Function, (intptr_t)jsHTMLDocumentPrototypeFunctionCaptureEvents, (intptr_t)0 },
    { "releaseEvents", DontDelete|Function, (intptr_t)jsHTMLDocumentPrototypeFunctionReleaseEvents, (intptr_t)0 },
    { "hasFocus", DontDelete|Function, (intptr_t)jsHTMLDocumentPrototypeFunctionHasFocus, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLDocumentPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSHTMLDocumentPrototypeTableValues, 0 };
#else
    { 17, 15, JSHTMLDocumentPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLDocumentPrototype::s_info = { "HTMLDocumentPrototype", 0, &JSHTMLDocumentPrototypeTable, 0 };

JSObject* JSHTMLDocumentPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSHTMLDocument>(exec);
}

bool JSHTMLDocumentPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLDocumentPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLDocument::s_info = { "HTMLDocument", &JSDocument::s_info, &JSHTMLDocumentTable, 0 };

JSHTMLDocument::JSHTMLDocument(PassRefPtr<Structure> structure, PassRefPtr<HTMLDocument> impl)
    : JSDocument(structure, impl)
{
}

JSObject* JSHTMLDocument::createPrototype(ExecState* exec)
{
    return new (exec) JSHTMLDocumentPrototype(JSHTMLDocumentPrototype::createStructure(JSDocumentPrototype::self(exec)));
}

bool JSHTMLDocument::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    if (canGetItemsForName(exec, static_cast<HTMLDocument*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSHTMLDocument, Base>(exec, &JSHTMLDocumentTable, this, propertyName, slot);
}

JSValuePtr jsHTMLDocumentEmbeds(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->embeds()));
}

JSValuePtr jsHTMLDocumentPlugins(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->plugins()));
}

JSValuePtr jsHTMLDocumentScripts(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->scripts()));
}

JSValuePtr jsHTMLDocumentAll(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLDocument*>(asObject(slot.slotBase()))->all(exec);
}

JSValuePtr jsHTMLDocumentWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->width());
}

JSValuePtr jsHTMLDocumentHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->height());
}

JSValuePtr jsHTMLDocumentDir(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->dir());
}

JSValuePtr jsHTMLDocumentDesignMode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->designMode());
}

JSValuePtr jsHTMLDocumentCompatMode(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->compatMode());
}

JSValuePtr jsHTMLDocumentActiveElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->activeElement()));
}

JSValuePtr jsHTMLDocumentBgColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->bgColor());
}

JSValuePtr jsHTMLDocumentFgColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->fgColor());
}

JSValuePtr jsHTMLDocumentAlinkColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->alinkColor());
}

JSValuePtr jsHTMLDocumentLinkColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->linkColor());
}

JSValuePtr jsHTMLDocumentVlinkColor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->vlinkColor());
}

JSValuePtr jsHTMLDocumentConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLDocument*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSHTMLDocument::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLDocument, Base>(exec, propertyName, value, &JSHTMLDocumentTable, this, slot);
}

void setJSHTMLDocumentAll(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    static_cast<JSHTMLDocument*>(thisObject)->setAll(exec, value);
}

void setJSHTMLDocumentDir(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(thisObject)->impl());
    imp->setDir(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLDocumentDesignMode(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(thisObject)->impl());
    imp->setDesignMode(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLDocumentBgColor(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(thisObject)->impl());
    imp->setBgColor(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLDocumentFgColor(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(thisObject)->impl());
    imp->setFgColor(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLDocumentAlinkColor(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(thisObject)->impl());
    imp->setAlinkColor(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLDocumentLinkColor(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(thisObject)->impl());
    imp->setLinkColor(valueToStringWithNullCheck(exec, value));
}

void setJSHTMLDocumentVlinkColor(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLDocument* imp = static_cast<HTMLDocument*>(static_cast<JSHTMLDocument*>(thisObject)->impl());
    imp->setVlinkColor(valueToStringWithNullCheck(exec, value));
}

JSValuePtr JSHTMLDocument::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSHTMLDocumentConstructor>(exec);
}

JSValuePtr jsHTMLDocumentPrototypeFunctionOpen(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLDocument::s_info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(asObject(thisValue));
    return castedThisObj->open(exec, args);
}

JSValuePtr jsHTMLDocumentPrototypeFunctionClose(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLDocument::s_info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(asObject(thisValue));
    HTMLDocument* imp = static_cast<HTMLDocument*>(castedThisObj->impl());

    imp->close();
    return jsUndefined();
}

JSValuePtr jsHTMLDocumentPrototypeFunctionWrite(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLDocument::s_info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(asObject(thisValue));
    return castedThisObj->write(exec, args);
}

JSValuePtr jsHTMLDocumentPrototypeFunctionWriteln(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLDocument::s_info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(asObject(thisValue));
    return castedThisObj->writeln(exec, args);
}

JSValuePtr jsHTMLDocumentPrototypeFunctionClear(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLDocument::s_info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(asObject(thisValue));
    HTMLDocument* imp = static_cast<HTMLDocument*>(castedThisObj->impl());

    imp->clear();
    return jsUndefined();
}

JSValuePtr jsHTMLDocumentPrototypeFunctionCaptureEvents(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLDocument::s_info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(asObject(thisValue));
    HTMLDocument* imp = static_cast<HTMLDocument*>(castedThisObj->impl());

    imp->captureEvents();
    return jsUndefined();
}

JSValuePtr jsHTMLDocumentPrototypeFunctionReleaseEvents(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLDocument::s_info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(asObject(thisValue));
    HTMLDocument* imp = static_cast<HTMLDocument*>(castedThisObj->impl());

    imp->releaseEvents();
    return jsUndefined();
}

JSValuePtr jsHTMLDocumentPrototypeFunctionHasFocus(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLDocument::s_info))
        return throwError(exec, TypeError);
    JSHTMLDocument* castedThisObj = static_cast<JSHTMLDocument*>(asObject(thisValue));
    HTMLDocument* imp = static_cast<HTMLDocument*>(castedThisObj->impl());


    JSC::JSValuePtr result = jsBoolean(imp->hasFocus());
    return result;
}


}
