/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "Document.h"
#include "Frame.h"
#include "SVGDocumentExtensions.h"
#include "SVGElement.h"
#include "SVGAnimatedTemplate.h"
#include "JSSVGElementInstance.h"

#include <wtf/GetPtr.h>

#include "JSSVGElement.h"
#include "JSSVGElementInstance.h"
#include "JSSVGElementInstanceList.h"
#include "JSSVGUseElement.h"
#include "SVGElement.h"
#include "SVGElementInstance.h"
#include "SVGElementInstanceList.h"
#include "SVGUseElement.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSSVGElementInstanceTableEntries[] =
{
    { "childNodes", JSSVGElementInstance::ChildNodesAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "parentNode", JSSVGElementInstance::ParentNodeAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "firstChild", JSSVGElementInstance::FirstChildAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "correspondingUseElement", JSSVGElementInstance::CorrespondingUseElementAttrNum, DontDelete|ReadOnly, 0, &JSSVGElementInstanceTableEntries[8] },
    { "lastChild", JSSVGElementInstance::LastChildAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "correspondingElement", JSSVGElementInstance::CorrespondingElementAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "previousSibling", JSSVGElementInstance::PreviousSiblingAttrNum, DontDelete|ReadOnly, 0, &JSSVGElementInstanceTableEntries[9] },
    { "nextSibling", JSSVGElementInstance::NextSiblingAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSSVGElementInstanceTable = 
{
    2, 10, JSSVGElementInstanceTableEntries, 8
};

/* Hash table for prototype */

static const HashEntry JSSVGElementInstancePrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSSVGElementInstancePrototypeTable = 
{
    2, 1, JSSVGElementInstancePrototypeTableEntries, 1
};

const ClassInfo JSSVGElementInstancePrototype::info = { "SVGElementInstancePrototype", 0, &JSSVGElementInstancePrototypeTable, 0 };

JSObject* JSSVGElementInstancePrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSSVGElementInstancePrototype>(exec, "[[JSSVGElementInstance.prototype]]");
}

const ClassInfo JSSVGElementInstance::info = { "SVGElementInstance", 0, &JSSVGElementInstanceTable, 0 };

JSSVGElementInstance::JSSVGElementInstance(ExecState* exec, SVGElementInstance* impl)
    : m_impl(impl)
{
    setPrototype(JSSVGElementInstancePrototype::self(exec));
}

JSSVGElementInstance::~JSSVGElementInstance()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSSVGElementInstance::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGElementInstance, KJS::DOMObject>(exec, &JSSVGElementInstanceTable, this, propertyName, slot);
}

JSValue* JSSVGElementInstance::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case CorrespondingElementAttrNum: {
        SVGElementInstance* imp = static_cast<SVGElementInstance*>(impl());

        return toJS(exec, WTF::getPtr(imp->correspondingElement()));
    }
    case CorrespondingUseElementAttrNum: {
        SVGElementInstance* imp = static_cast<SVGElementInstance*>(impl());

        return toJS(exec, WTF::getPtr(imp->correspondingUseElement()));
    }
    case ParentNodeAttrNum: {
        SVGElementInstance* imp = static_cast<SVGElementInstance*>(impl());

        return toJS(exec, WTF::getPtr(imp->parentNode()));
    }
    case ChildNodesAttrNum: {
        SVGElementInstance* imp = static_cast<SVGElementInstance*>(impl());

        return toJS(exec, WTF::getPtr(imp->childNodes()));
    }
    case FirstChildAttrNum: {
        SVGElementInstance* imp = static_cast<SVGElementInstance*>(impl());

        return toJS(exec, WTF::getPtr(imp->firstChild()));
    }
    case LastChildAttrNum: {
        SVGElementInstance* imp = static_cast<SVGElementInstance*>(impl());

        return toJS(exec, WTF::getPtr(imp->lastChild()));
    }
    case PreviousSiblingAttrNum: {
        SVGElementInstance* imp = static_cast<SVGElementInstance*>(impl());

        return toJS(exec, WTF::getPtr(imp->previousSibling()));
    }
    case NextSiblingAttrNum: {
        SVGElementInstance* imp = static_cast<SVGElementInstance*>(impl());

        return toJS(exec, WTF::getPtr(imp->nextSibling()));
    }
    }
    return 0;
}

KJS::JSValue* toJS(KJS::ExecState* exec, SVGElementInstance* obj)
{
    return KJS::cacheDOMObject<SVGElementInstance, JSSVGElementInstance>(exec, obj);
}
SVGElementInstance* toSVGElementInstance(KJS::JSValue* val)
{
    return val->isObject(&JSSVGElementInstance::info) ? static_cast<JSSVGElementInstance*>(val)->impl() : 0;
}

}

#endif // ENABLE(SVG)
