/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMMenu.h

Description:

    This file defines class PMMenu.

Environment (opt):

    OS: Ubuntu,
    SE: Code::Blocks8.02

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Zhang Hui   2008-7-20

  =====================================================================

****************************************************************************/

#ifndef PMMENU_H_INCLUDED
#define PMMENU_H_INCLUDED

#include <wx/menu.h>
#include "PMTrayIcon.h"
#include "PMApp.h"
#include "DialogRegister.h"
#include "PMDialog.h"
#include "ConfigurationFileEditor.h"
#include "PMUtility.h"
#include "DeviceDisableDialog.h"
#include "PMTrayIcon.h"

enum MENUITEM
{
    MENU_PM_DLG ,
    MENU_BATTERY_INFO ,
    MENU_EXIT,
    MENU_CLASS_DEFAUT,
    MENU_MAX_PERFORM,
    MENU_EREEADER,
    MENU_CUSTOMER1,
    MENU_CUSTOMER2,
    MENU_CUSTOMER3
};

class PMMenu : public wxMenu
{
public:
    //constructor
    PMMenu(const wxString& title = _T(""), long style = 0);
    //destructor
    ~PMMenu(){}
    //initial the menu
    void InitMenu();
    //open pm dialog action
    void OpenPMDialog(wxCommandEvent& event);
    //open battery info dialog
    void OpenBatteryInfoDlg(wxCommandEvent& event);
    //exit app
    void ExitApp(wxCommandEvent& event);
    //switch scheme
    void ChangeScheme(wxCommandEvent& event);
    //clean all menu items
    void DestroyItems();

private:

    vector<PSchemeList_t> m_schemeList;
    int m_switchWarning;
    //initial scheme list
    int InitSchemeList();
    //map event
    DECLARE_EVENT_TABLE()
};



#endif // PMMENU_H_INCLUDED
