/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMBalloonWnd.h

Description:

    This file defines class PMBalloonWnd.

Environment (opt):

    OS: Ubuntu,
    SE: Code::Blocks8.02

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Zhang Hui   2008-7-20

  =====================================================================

****************************************************************************/

#ifndef PMBalloonWnd_H_INCLUDED
#define PMBalloonWnd_H_INCLUDED

#include <wx/event.h>
#include <wx/timer.h>
#include <wx/frame.h>
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/dcprint.h>
#include <wx/dcclient.h>
#include <wx/image.h>
#include <wx/statbmp.h>
#include "BitmapDialog.h"
#include <wx/msgdlg.h>
#include <wx/hyperlink.h>
#include <vector>

#include "BatteryInfoMgmtProxy.h"
#include "PowerSchemeMgmtProxy.h"
#include "PMTrayIcon.h"

using namespace std;

enum BalloonCtrl
{
    CAPACITY_REMAINING = wxID_ANY,
    TIME_REMAININF = wxID_ANY,
    LINK = wxID_ANY
};

class PMBalloonWnd :  public wxBitmapDialog
{
    public:
        //constructor
        PMBalloonWnd(wxWindow *dlg, const wxString& title);
        //destructor
        virtual ~PMBalloonWnd();

        //click event to device list balloon
        void OnClickToList(wxMouseEvent & event);
        //click event to battery info balloon
        void OnClickToInfo(wxMouseEvent & event);
        //show balloon
        void showBalloon();
        //initial battery info balloon
        void InitStatusBalloon();
        //initial device list balloon
        void InitDeviceListBalloon(int alert = 0);
        //mouse on event
        void MouseOnAction(wxMouseEvent& event);
        //mouse leave event
        void MouseLeaveAction(wxMouseEvent& event);
        //position the balloon
        void MovePosition();
        //initial the notification area
        void PopupNotification();

    private:

        wxStaticText* title1;
        wxStaticText* title2;
        wxHyperlinkCtrl* title3;
        wxStaticText* title4;
        wxStaticText* title5;
        wxHyperlinkCtrl* title6;
        wxStaticBitmap *staticBitmap1;

        //map event
        DECLARE_EVENT_TABLE();

};

#endif // PMBalloonWnd_H_INCLUDED
