/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_ACCEL_DEF_H
#define DCS_ACCEL_DEF_H

#include "DCSCommon.h"

/** Acceleration data. */
typedef struct DCS_Accel_Data_S {
    CHAR AccelX; /**< Acceleration in X-Axis */
    CHAR AccelY; /**< Acceleration in Y-Axis */
    CHAR AccelZ; /**< Acceleration in Z-Axis */
} DCS_Accel_Data, *PDCS_Accel_Data;

/** Constants for screen orientation. */
typedef enum DCS_SystemOrientation_E {
	DCS_SYSTEM_ORIENTATION_NORMAL,
	DCS_SYSTEM_ORIENTATION_CW90,
	DCS_SYSTEM_ORIENTATION_CW180,
	DCS_SYSTEM_ORIENTATION_CW270
} DCS_SystemOrientation;

#endif /* DCS_ACCEL_DEF_H */
