/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMEditDialog.cpp

Description:

    This file implements class PMEditDialog.

Environment (opt):

    OS: Ubuntu,
    SE: Code::Blocks8.02

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Zhang Hui   2008-7-20

  =====================================================================

****************************************************************************/

#include "include/PMEditDialog.h"
#include <wx/imaglist.h>
//(*InternalHeaders(PMEditDialog)
#include <wx/intl.h>
#include <wx/string.h>
//*)

#include "include/PMGlobalConstant.h"
#include "include/DataMiddle.h"

//(*IdInit(PMEditDialog)
const long PMEditDialog::ID_STATICTEXT_UI_E_SCHEMENAME = wxNewId();
const long PMEditDialog::ID_TEXTCTRL_SCHEMENAME = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_DC_POWERSETTINGS = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_DC_LCDBRIGHTNESS = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_DC_LANSPEED = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_DC_TURNOFFDISPLAY = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_DC_ENTERSYSSTANDBY = wxNewId();
const long PMEditDialog::ID_CHECKBOX_DC_DISABLEWIRELESS = wxNewId();
const long PMEditDialog::ID_CHECKBOX_DC_DISABLELAN = wxNewId();
const long PMEditDialog::ID_COMBOBOX_DC_LCDBRIGHTNESS = wxNewId();
const long PMEditDialog::ID_COMBOBOX_DC_LANSPEED = wxNewId();
const long PMEditDialog::ID_COMBOBOX_DC_TURNOFFDISPLAY = wxNewId();
const long PMEditDialog::ID_COMBOBOX_DC_ENTERSYSSTANDBY = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_DC_EFFECTIVEOFSETTINGS = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_DC_PERFORMANCE = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_Dc_LCDBRIGHTNESS2 = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_DC_BATTERYLIFE = wxNewId();
const long PMEditDialog::ID_GAUGE_DC_PERFORMANCE = wxNewId();
const long PMEditDialog::ID_GAUGE_DC_LCDBRIGHTNESS = wxNewId();
const long PMEditDialog::ID_GAUGE_DC_BATTERYLIFE = wxNewId();
const long PMEditDialog::ID_STATICLINE1 = wxNewId();
const long PMEditDialog::ID_PANEL_DC_SETTINGS = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_AC_POWERSETTINGS = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_AC_LCDBRIGHTNESS = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_AC_LANSPEED = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_AC_TURNOFFDISPLAY = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_AC_ENTERSYSSTANDBY = wxNewId();
const long PMEditDialog::ID_CHECKBOX_AC_DISABLEWIRELESS = wxNewId();
const long PMEditDialog::ID_CHECKBOX_AC_DISABLELAN = wxNewId();
const long PMEditDialog::ID_COMBOBOX_AC_LANSPEED = wxNewId();
const long PMEditDialog::ID_COMBOBOX7 = wxNewId();
const long PMEditDialog::ID_COMBOBOX_AC_LCDBRIGHTNESS = wxNewId();
const long PMEditDialog::ID_COMBOBOX_AC_ENTERSYSSTANDBY = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_AC_PERFORMANCE = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_AC_LCDBRIGHTNESS2 = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_AC_EFFECTIVEOFSETTINGS = wxNewId();
const long PMEditDialog::ID_STATICTEXT_UI_AC_BATTERYLIFE = wxNewId();
const long PMEditDialog::ID_GAUGE_AC_LCDBRIGHTNESS = wxNewId();
const long PMEditDialog::ID_GAUGE_AC_PERFORMANCE = wxNewId();
const long PMEditDialog::ID_STATICTEXT_AC_BATTERYLIFE = wxNewId();
const long PMEditDialog::ID_STATICLINE2 = wxNewId();
const long PMEditDialog::ID_PANEL_AC_SETTINGS = wxNewId();
const long PMEditDialog::ID_NOTEBOOK_Settings = wxNewId();
const long PMEditDialog::ID_BUTTON_RESET = wxNewId();
const long PMEditDialog::ID_BUTTON_SAVE = wxNewId();
const long PMEditDialog::ID_BUTTON_CANCEL = wxNewId();
//*)

BEGIN_EVENT_TABLE(PMEditDialog,wxDialog)
	//(*EventTable(PMEditDialog)
	//*)
END_EVENT_TABLE()

/**constructor*/
PMEditDialog::PMEditDialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(PMEditDialog)
	//*)
	Create(parent, wxID_ANY, _("Edit Power Scheme"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	SetClientSize(wxSize(550,405));
	Move(wxPoint(-1,-1));
	StaticText_UI_E_SchemeName = new wxStaticText(this, ID_STATICTEXT_UI_E_SCHEMENAME, _("Scheme Name:"), wxPoint(15,15), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_E_SCHEMENAME"));
	StaticText_UI_E_SchemeName->Wrap(180);
	TextCtrl_SchemeName = new wxTextCtrl(this, ID_TEXTCTRL_SCHEMENAME, wxEmptyString, wxPoint(200,10), wxSize(250,27), 0, wxDefaultValidator, _T("ID_TEXTCTRL_SCHEMENAME"));

	Settings = new wxNotebook(this, ID_NOTEBOOK_Settings, wxPoint(15,50), wxSize(520,305), 0, _T("ID_NOTEBOOK_Settings"));

	Panel_DC_Settings = new wxPanel(Settings, ID_PANEL_DC_SETTINGS, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL_DC_SETTINGS"));
	StaticText_UI_DC_PowerSettings = new wxStaticText(Panel_DC_Settings, ID_STATICTEXT_UI_DC_POWERSETTINGS, _("Power Settings"), wxPoint(10,15), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_DC_POWERSETTINGS"));

	StaticText_UI_DC_LCDBrightness = new wxStaticText(Panel_DC_Settings, ID_STATICTEXT_UI_DC_LCDBRIGHTNESS, _("Display Brightness:"), wxPoint(10,45), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_DC_LCDBRIGHTNESS"));
	StaticText_UI_DC_LCDBrightness->Wrap(150);
	StaticText_UI_DC_LANSpeed = new wxStaticText(Panel_DC_Settings, ID_STATICTEXT_UI_DC_LANSPEED, _("LAN Speed:"), wxPoint(10,90), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_DC_LANSPEED"));
	StaticText_UI_DC_LANSpeed->Wrap(150);
	StaticText_UI_DC_TurnOffDisplay = new wxStaticText(Panel_DC_Settings, ID_STATICTEXT_UI_DC_TURNOFFDISPLAY, _("Turn off Display:"), wxPoint(10,135), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_DC_TURNOFFDISPLAY"));
	StaticText_UI_DC_TurnOffDisplay->Wrap(150);
	StaticText_UI_DC_EnterSysStandby = new wxStaticText(Panel_DC_Settings, ID_STATICTEXT_UI_DC_ENTERSYSSTANDBY, _("Enter System Standby:"), wxPoint(10,180), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_DC_ENTERSYSSTANDBY"));
	StaticText_UI_DC_EnterSysStandby->Wrap(150);

	ComboBox_DC_LCDBrightness = new wxComboBox(Panel_DC_Settings, ID_COMBOBOX_DC_LCDBRIGHTNESS, wxEmptyString, wxPoint(175,40), wxSize(150,25), 0, 0, wxCB_READONLY|wxCB_DROPDOWN|wxHSCROLL, wxDefaultValidator, _T("ID_COMBOBOX_DC_LCDBRIGHTNESS"));
	ComboBox_DC_LCDBrightness->SetMaxSize(wxSize(150,25));
	ComboBox_DC_LANSpeed = new wxComboBox(Panel_DC_Settings, ID_COMBOBOX_DC_LANSPEED, wxEmptyString, wxPoint(175,85), wxSize(150,25), 0, 0, wxCB_READONLY|wxCB_DROPDOWN|wxHSCROLL, wxDefaultValidator, _T("ID_COMBOBOX_DC_LANSPEED"));
	ComboBox_DC_TurnOffDisplay = new wxComboBox(Panel_DC_Settings, ID_COMBOBOX_DC_TURNOFFDISPLAY, wxEmptyString, wxPoint(175,130), wxSize(150,25), 0, 0, wxCB_READONLY|wxCB_DROPDOWN|wxHSCROLL, wxDefaultValidator, _T("ID_COMBOBOX_DC_TURNOFFDISPLAY"));
	ComboBox_DC_EnterSYSStandby = new wxComboBox(Panel_DC_Settings, ID_COMBOBOX_DC_ENTERSYSSTANDBY, wxEmptyString, wxPoint(175,175), wxSize(150,25), 0, 0, wxCB_READONLY|wxCB_DROPDOWN|wxHSCROLL, wxDefaultValidator, _T("ID_COMBOBOX_DC_ENTERSYSSTANDBY"));

	CheckBox_DC_DisableWireless = new wxCheckBox(Panel_DC_Settings, ID_CHECKBOX_DC_DISABLEWIRELESS, _("Disable WiFi"), wxPoint(10,215), wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX_DC_DISABLEWIRELESS"));
	CheckBox_DC_DisableWireless->SetValue(false);
	CheckBox_DC_DisableLAN = new wxCheckBox(Panel_DC_Settings, ID_CHECKBOX_DC_DISABLELAN, _("Disable LAN"), wxPoint(10,240), wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX_DC_DISABLELAN"));
	CheckBox_DC_DisableLAN->SetValue(false);

	StaticText_UI_DC_EffectiveOfSettings = new wxStaticText(Panel_DC_Settings, ID_STATICTEXT_UI_DC_EFFECTIVEOFSETTINGS, _("Effective of Settings"), wxPoint(355,15), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_DC_EFFECTIVEOFSETTINGS"));
	StaticText_UI_DC_EffectiveOfSettings->Wrap(130);
	StaticText_UI_DC_Performance = new wxStaticText(Panel_DC_Settings, ID_STATICTEXT_UI_DC_PERFORMANCE, _("Performance"), wxPoint(355,45), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_DC_PERFORMANCE"));
	StaticText_UI_DC_Performance->Wrap(130);
	StaticText_UI_DC_LCDBrightness2 = new wxStaticText(Panel_DC_Settings, ID_STATICTEXT_UI_Dc_LCDBRIGHTNESS2, _("Display Brightness"), wxPoint(355,105), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_Dc_LCDBRIGHTNESS2"));
	StaticText_UI_DC_LCDBrightness2->Wrap(130);
	StaticText_UI_DC_BatteryLife = new wxStaticText(Panel_DC_Settings, ID_STATICTEXT_UI_DC_BATTERYLIFE, _("Battery Life"), wxPoint(355,165), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_DC_BATTERYLIFE"));
	StaticText_UI_DC_BatteryLife->Wrap(130);

	Gauge_DC_Performance = new wxGauge(Panel_DC_Settings, ID_GAUGE_DC_PERFORMANCE, 100, wxPoint(355,77), wxSize(150,18), 0, wxDefaultValidator, _T("ID_GAUGE_DC_PERFORMANCE"));
	Gauge_DC_LCDBrightness = new wxGauge(Panel_DC_Settings, ID_GAUGE_DC_LCDBRIGHTNESS, 100, wxPoint(355,137), wxSize(150,18), 0, wxDefaultValidator, _T("ID_GAUGE_DC_LCDBRIGHTNESS"));
	Gauge_DC_BatteryLife = new wxGauge(Panel_DC_Settings, ID_GAUGE_DC_BATTERYLIFE, 100, wxPoint(355,197), wxSize(150,18), 0, wxDefaultValidator, _T("ID_GAUGE_DC_BATTERYLIFE"));
	StaticLine1 = new wxStaticLine(Panel_DC_Settings, ID_STATICLINE1, wxPoint(340,0), wxSize(-1,270), wxLI_VERTICAL, _T("ID_STATICLINE1"));

	Panel_AC_Settings = new wxPanel(Settings, ID_PANEL_AC_SETTINGS, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL_AC_SETTINGS"));
	StaticText_UI_AC_PowerSettings = new wxStaticText(Panel_AC_Settings, ID_STATICTEXT_UI_AC_POWERSETTINGS, _("Power Settings"), wxPoint(10,15), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_AC_POWERSETTINGS"));
    StaticText_UI_AC_LCDBrightness = new wxStaticText(Panel_AC_Settings, ID_STATICTEXT_UI_AC_LCDBRIGHTNESS, _("Display Brightness:"), wxPoint(10,45), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_AC_LCDBRIGHTNESS"));
	StaticText_UI_AC_LCDBrightness->Wrap(150);
	StaticText_UI_AC_LANSpeed = new wxStaticText(Panel_AC_Settings, ID_STATICTEXT_UI_AC_LANSPEED, _("LAN Speed:"), wxPoint(10,90), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_AC_LANSPEED"));
	StaticText_UI_AC_LANSpeed->Wrap(150);
	StaticText_UI_AC_TurnOffDisplay = new wxStaticText(Panel_AC_Settings, ID_STATICTEXT_UI_AC_TURNOFFDISPLAY, _("Turn off Display:"), wxPoint(10,135), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_AC_TURNOFFDISPLAY"));
	StaticText_UI_AC_TurnOffDisplay->Wrap(150);
	StaticText_UI_AC_EnterSYSStandby = new wxStaticText(Panel_AC_Settings, ID_STATICTEXT_UI_AC_ENTERSYSSTANDBY, _("Enter System Standby:"), wxPoint(10,180), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_AC_ENTERSYSSTANDBY"));
    StaticText_UI_AC_EnterSYSStandby->Wrap(150);

	ComboBox_AC_LCDBrightness = new wxComboBox(Panel_AC_Settings, ID_COMBOBOX_AC_LCDBRIGHTNESS, wxEmptyString, wxPoint(175,40), wxSize(150,25), 0, 0, wxCB_READONLY|wxCB_DROPDOWN|wxHSCROLL, wxDefaultValidator, _T("ID_COMBOBOX_AC_LCDBRIGHTNESS"));
	ComboBox_AC_LANSpeed = new wxComboBox(Panel_AC_Settings, ID_COMBOBOX_AC_LANSPEED, wxEmptyString, wxPoint(175,85), wxSize(150,25), 0, 0, wxCB_READONLY|wxCB_DROPDOWN|wxHSCROLL, wxDefaultValidator, _T("ID_COMBOBOX_AC_LANSPEED"));
	ComboBox_AC_TurnOffDisplay = new wxComboBox(Panel_AC_Settings, ID_COMBOBOX7, wxEmptyString, wxPoint(175,130), wxSize(150,25), 0, 0, wxCB_READONLY|wxCB_DROPDOWN|wxHSCROLL, wxDefaultValidator, _T("ID_COMBOBOX7"));
	ComboBox_AC_EnterSYSStandby = new wxComboBox(Panel_AC_Settings, ID_COMBOBOX_AC_ENTERSYSSTANDBY, wxEmptyString, wxPoint(175,175), wxSize(150,25), 0, 0, wxCB_READONLY|wxCB_DROPDOWN|wxHSCROLL, wxDefaultValidator, _T("ID_COMBOBOX_AC_ENTERSYSSTANDBY"));
	CheckBox_AC_DisableWireless = new wxCheckBox(Panel_AC_Settings, ID_CHECKBOX_AC_DISABLEWIRELESS, _("Disable WiFi"), wxPoint(10,215), wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX_AC_DISABLEWIRELESS"));
	CheckBox_AC_DisableWireless->SetValue(false);
	CheckBox_AC_DisableLAN = new wxCheckBox(Panel_AC_Settings, ID_CHECKBOX_AC_DISABLELAN, _("Disable LAN"), wxPoint(10,240), wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX_AC_DISABLELAN"));
	CheckBox_AC_DisableLAN->SetValue(false);

    StaticText_UI_AC_EffectiveOfSettings = new wxStaticText(Panel_AC_Settings, ID_STATICTEXT_UI_AC_EFFECTIVEOFSETTINGS, _("Effective of Settings"), wxPoint(355,15), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_AC_EFFECTIVEOFSETTINGS"));
	StaticText_UI_AC_EffectiveOfSettings->Wrap(130);
	StaticText_UI_AC_Performance = new wxStaticText(Panel_AC_Settings, ID_STATICTEXT_UI_AC_PERFORMANCE, _("Performance"), wxPoint(355,45), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_AC_PERFORMANCE"));
    StaticText_UI_AC_Performance->Wrap(130);
    StaticText_UI_AC_LCDBrightness2 = new wxStaticText(Panel_AC_Settings, ID_STATICTEXT_UI_AC_LCDBRIGHTNESS2, _("Display Brightness"), wxPoint(355,105), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_AC_LCDBRIGHTNESS2"));
	StaticText_UI_AC_LCDBrightness2->Wrap(130);
	StaticText_UI_AC_BatteryLife = new wxStaticText(Panel_AC_Settings, ID_STATICTEXT_UI_AC_BATTERYLIFE, _("Battery Life"), wxPoint(355,165), wxDefaultSize, 0, _T("ID_STATICTEXT_UI_AC_BATTERYLIFE"));
	StaticText_UI_AC_BatteryLife->Wrap(130);

	Gauge_AC_LCDBrightness = new wxGauge(Panel_AC_Settings, ID_GAUGE_AC_LCDBRIGHTNESS, 100, wxPoint(355,137), wxSize(150,18), 0, wxDefaultValidator, _T("ID_GAUGE_AC_LCDBRIGHTNESS"));
	Gauge_AC_Performance = new wxGauge(Panel_AC_Settings, ID_GAUGE_AC_PERFORMANCE, 100, wxPoint(355,77), wxSize(150,18), 0, wxDefaultValidator, _T("ID_GAUGE_AC_PERFORMANCE"));
	StaticText_AC_BatteryLife = new wxStaticText(Panel_AC_Settings, ID_STATICTEXT_AC_BATTERYLIFE, _("Not Applicable"), wxPoint(355,197), wxDefaultSize, 0, _T("ID_STATICTEXT_AC_BATTERYLIFE"));
    StaticText_AC_BatteryLife->Wrap(130);

	StaticLine2 = new wxStaticLine(Panel_AC_Settings, ID_STATICLINE2, wxPoint(340,1), wxSize(-1,270), wxLI_VERTICAL, _T("ID_STATICLINE2"));
	Settings->AddPage(Panel_DC_Settings, _("Battery Settings"), true);
	Settings->AddPage(Panel_AC_Settings, _("AC Settings"), false);

	Button_Reset = new wxButton(this, ID_BUTTON_RESET, _("Reset Default"), wxPoint(15,365), wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON_RESET"));
	Button_Save = new wxButton(this, ID_BUTTON_SAVE, _("Save"), wxPoint(350,365), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BUTTON_SAVE"));
	Button_Save->SetDefault();
	Button_Cancel = new wxButton(this, ID_BUTTON_CANCEL, _("Cancel"), wxPoint(450,365), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BUTTON_CANCEL"));

	Connect(ID_BUTTON_RESET,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PMEditDialog::OnButton_ResetClick);
	Connect(ID_BUTTON_SAVE,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PMEditDialog::OnButton_SaveClick);
	Connect(ID_BUTTON_CANCEL,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&PMEditDialog::OnButton_CancelClick);
	Connect(wxID_ANY,wxEVT_CLOSE_WINDOW,(wxObjectEventFunction)&PMEditDialog::OnClose);

    Connect(ID_COMBOBOX_DC_LCDBRIGHTNESS,wxEVT_COMMAND_COMBOBOX_SELECTED,(wxObjectEventFunction)&PMEditDialog::OnComboBox_DCSelect);
    Connect(ID_COMBOBOX_DC_LANSPEED,wxEVT_COMMAND_COMBOBOX_SELECTED,(wxObjectEventFunction)&PMEditDialog::OnComboBox_DCSelect);
    Connect(ID_COMBOBOX_AC_LCDBRIGHTNESS,wxEVT_COMMAND_COMBOBOX_SELECTED,(wxObjectEventFunction)&PMEditDialog::OnComboBox_ACSelect);
    Connect(ID_COMBOBOX_AC_LANSPEED,wxEVT_COMMAND_COMBOBOX_SELECTED,(wxObjectEventFunction)&PMEditDialog::OnComboBox_ACSelect);

    SetIcon(wxIcon(TITLE_ICON));

    // Set font
    wxFont StaticTextFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("Sans"),wxFONTENCODING_DEFAULT);
    wxFont StaticTextBoldFont(10,wxSWISS,wxFONTSTYLE_NORMAL,wxBOLD,false,_T("Sans"),wxFONTENCODING_DEFAULT);

    // Set name font
    StaticText_UI_E_SchemeName->SetFont(StaticTextFont);
    TextCtrl_SchemeName->SetFont(StaticTextFont);

    // Set DC settings font
    StaticText_UI_DC_PowerSettings->SetFont(StaticTextBoldFont);
    StaticText_UI_DC_EffectiveOfSettings->SetFont(StaticTextBoldFont);
    StaticText_UI_DC_PowerSettings->SetForegroundColour(wxColour(20,80,190));
    StaticText_UI_DC_EffectiveOfSettings->SetForegroundColour(wxColour(20,80,190));

    StaticText_UI_DC_LCDBrightness->SetFont(StaticTextFont);
    StaticText_UI_DC_LANSpeed->SetFont(StaticTextFont);
	StaticText_UI_DC_TurnOffDisplay->SetFont(StaticTextFont);
	StaticText_UI_DC_EnterSysStandby->SetFont(StaticTextFont);
	CheckBox_DC_DisableWireless->SetFont(StaticTextFont);
	CheckBox_DC_DisableLAN->SetFont(StaticTextFont);
	ComboBox_DC_LCDBrightness->SetFont(StaticTextFont);
	ComboBox_DC_LANSpeed->SetFont(StaticTextFont);
	ComboBox_DC_TurnOffDisplay->SetFont(StaticTextFont);
	ComboBox_DC_EnterSYSStandby->SetFont(StaticTextFont);
	StaticText_UI_DC_Performance->SetFont(StaticTextFont);
	StaticText_UI_DC_LCDBrightness2->SetFont(StaticTextFont);
	StaticText_UI_DC_BatteryLife->SetFont(StaticTextFont);

    // Set AC settings font
    StaticText_UI_AC_PowerSettings->SetFont(StaticTextBoldFont);
    StaticText_UI_AC_EffectiveOfSettings->SetFont(StaticTextBoldFont);
    StaticText_UI_AC_PowerSettings->SetForegroundColour(wxColour(20,80,190));
    StaticText_UI_AC_EffectiveOfSettings->SetForegroundColour(wxColour(20,80,190));

    StaticText_UI_AC_LCDBrightness->SetFont(StaticTextFont);
    StaticText_UI_AC_LANSpeed->SetFont(StaticTextFont);
	StaticText_UI_AC_TurnOffDisplay->SetFont(StaticTextFont);
	StaticText_UI_AC_EnterSYSStandby->SetFont(StaticTextFont);
	CheckBox_AC_DisableWireless->SetFont(StaticTextFont);
	CheckBox_AC_DisableLAN->SetFont(StaticTextFont);
	ComboBox_AC_LCDBrightness->SetFont(StaticTextFont);
	ComboBox_AC_LANSpeed->SetFont(StaticTextFont);
	ComboBox_AC_TurnOffDisplay->SetFont(StaticTextFont);
	ComboBox_AC_EnterSYSStandby->SetFont(StaticTextFont);
	StaticText_UI_AC_Performance->SetFont(StaticTextFont);
	StaticText_UI_AC_LCDBrightness2->SetFont(StaticTextFont);
	StaticText_UI_AC_BatteryLife->SetFont(StaticTextFont);
	StaticText_AC_BatteryLife->SetFont(StaticTextFont);

    //Set the UI Strings
    TextCtrl_SchemeName->SetMaxLength(20);

    //DC Settings
    Gauge_DC_Performance->SetRange(100);
    Gauge_DC_LCDBrightness->SetRange(100);
    Gauge_DC_BatteryLife->SetRange(100);

    //AC Settings
    Gauge_AC_Performance->SetRange(100);
    Gauge_AC_LCDBrightness->SetRange(100);

    wxImageList *imageList = new wxImageList;
    imageList->Add(wxBitmap(PIC_PATH + wxT("BatteryTab.png"), wxBITMAP_TYPE_PNG));
    imageList->Add(wxBitmap(PIC_PATH + wxT("ACTab.png"), wxBITMAP_TYPE_PNG));
    Settings->AssignImageList(imageList);

    Settings->SetPageImage(0, 0);
    Settings->SetPageImage(1, 1);

    //////////////// Init member varial //////////////////////
    DataMiddle::GetInstance()->AttachPMEditDlg(this);

    //m_ptagSchemeInfo_t = NULL;
    m_ptagSchemeInfo_t = new Scheme_Info;
    m_ptagSchemeInfo_t->ACSettings = new Scheme_Settings;
    m_ptagSchemeInfo_t->DCSettings = new Scheme_Settings;
    m_iDefaultSchemeFlag = 0;
}

/**destructor*/
PMEditDialog::~PMEditDialog()
{
	//(*Destroy(PMEditDialog)
	//*)

    if (m_ptagSchemeInfo_t)
    {
    	delete m_ptagSchemeInfo_t;
        m_ptagSchemeInfo_t = NULL;
    }

    DataMiddle::GetInstance()->DettachPMEditDlg();
}

/**intial the PMEditDialog*/
int PMEditDialog::Init(int schemeId, int isAC)
{
    m_iSchemeId = schemeId;

    Settings->SetSelection(isAC);

    //Init the scheme info
    m_ptagSchemeInfo_t->SchemeId = m_iSchemeId;

    if (SUCCESS != PowerSchemeMgmtProxy::GetInstance()->QueryPwrScheme(m_ptagSchemeInfo_t) ||
        NULL == m_ptagSchemeInfo_t)
    {
        return 0;
    }

    m_iDefaultSchemeFlag = m_ptagSchemeInfo_t->IsDefault;

    if (1 == m_iDefaultSchemeFlag)
    {
        TextCtrl_SchemeName->Disable();
        if(isAC)
        {
            ComboBox_AC_LCDBrightness->SetFocus();
        }
        else
        {
            ComboBox_DC_LCDBrightness->SetFocus();
        }

    }
    else
    {
        TextCtrl_SchemeName->SetFocus();
        Button_Reset->Disable();
    }

    SetComboboxValue();

    if (0 == SetSchemeInfo(m_ptagSchemeInfo_t))
    {
        return 0;
    }

    return 1;

}

/**set the comboBox value*/
void PMEditDialog::SetComboboxValue(void)
{
    SETTING_ITEM_MAPPING schemeItemsMap;
    PowerSchemeMgmtProxy::GetInstance()->GetSettingItems(schemeItemsMap);

    //LCD Brightness
    vLCDBrightnessItems = schemeItemsMap[LCD_BRIGHTNESS];

    for (vector<string>::size_type ix = 0; ix != vLCDBrightnessItems.size(); ++ix)
    {
        ComboBox_DC_LCDBrightness->Append(PMUtility::StringToWxString(vLCDBrightnessItems[ix].Description));
        ComboBox_AC_LCDBrightness->Append(PMUtility::StringToWxString(vLCDBrightnessItems[ix].Description));
    }

    //LAN Speed
    vLANSpeedItems = schemeItemsMap[LAN_SPEED];
    for (vector<string>::size_type ix = 0; ix != vLANSpeedItems.size(); ++ix)
    {
        ComboBox_DC_LANSpeed->Append(PMUtility::StringToWxString(vLANSpeedItems[ix].Description));
        ComboBox_AC_LANSpeed->Append(PMUtility::StringToWxString(vLANSpeedItems[ix].Description));
    }
    //TurnOffDisplay
    vCloseLCDItems = schemeItemsMap[CLOSE_LCD];
    for (vector<string>::size_type ix = 0; ix != vCloseLCDItems.size(); ++ix)
    {
        ComboBox_DC_TurnOffDisplay->Append(PMUtility::StringToWxString(vCloseLCDItems[ix].Description));
        ComboBox_AC_TurnOffDisplay->Append(PMUtility::StringToWxString(vCloseLCDItems[ix].Description));
    }
    //EnterSYSStandby
    vStandbyItems = schemeItemsMap[STANDBY];
    for (vector<string>::size_type ix = 0; ix != vStandbyItems.size(); ++ix)
    {
        ComboBox_DC_EnterSYSStandby->Append(PMUtility::StringToWxString(vStandbyItems[ix].Description));
        ComboBox_AC_EnterSYSStandby->Append(PMUtility::StringToWxString(vStandbyItems[ix].Description));
    }
}

/**save scheme info modified*/
int PMEditDialog::SaveSchemeInfo()
{
    //Geting DC Value
    //LCDBrightness
    m_ptagSchemeInfo_t->DCSettings->LCDBrightness = ComboBox_DC_LCDBrightness->GetCurrentSelection();
    //LANSpeed
    m_ptagSchemeInfo_t->DCSettings->LANSpeed = ComboBox_DC_LANSpeed->GetCurrentSelection();
    //CloseLCD
    m_ptagSchemeInfo_t->DCSettings->CloseLCD = ComboBox_DC_TurnOffDisplay->GetCurrentSelection();
    //Standby
    m_ptagSchemeInfo_t->DCSettings->Standby = ComboBox_DC_EnterSYSStandby->GetCurrentSelection();
    //LANStatus
    bool isChecked = CheckBox_DC_DisableLAN->GetValue();
    if ( isChecked )
    {
        m_ptagSchemeInfo_t->DCSettings->LANStatus = 0;
    }
    else
    {
        m_ptagSchemeInfo_t->DCSettings->LANStatus = 1;
    }
    //WLANStatus
    isChecked = CheckBox_DC_DisableWireless->GetValue();
    if ( isChecked )
    {
        m_ptagSchemeInfo_t->DCSettings->WLANStatus = 0;
    }
    else
    {
        m_ptagSchemeInfo_t->DCSettings->WLANStatus = 1;
    }

    //Geting AC Value
    //LCDBrightness
    m_ptagSchemeInfo_t->ACSettings->LCDBrightness = ComboBox_AC_LCDBrightness->GetCurrentSelection();
    //LANSpeed
    m_ptagSchemeInfo_t->ACSettings->LANSpeed = ComboBox_AC_LANSpeed->GetCurrentSelection();
    //CloseLCD
    m_ptagSchemeInfo_t->ACSettings->CloseLCD = ComboBox_AC_TurnOffDisplay->GetCurrentSelection();
    //Standby
    m_ptagSchemeInfo_t->ACSettings->Standby = ComboBox_AC_EnterSYSStandby->GetCurrentSelection();
    //LANStatus
    isChecked = CheckBox_AC_DisableLAN->GetValue();
    if ( isChecked )
    {
        m_ptagSchemeInfo_t->ACSettings->LANStatus = 0;
    }
    else
    {
        m_ptagSchemeInfo_t->ACSettings->LANStatus = 1;
    }
    //WLANStatus
    isChecked = CheckBox_AC_DisableWireless->GetValue();
    if ( isChecked )
    {
        m_ptagSchemeInfo_t->ACSettings->WLANStatus = 0;
    }
    else
    {
        m_ptagSchemeInfo_t->ACSettings->WLANStatus = 1;
    }


    return 1;
}

/**set dialog content*/
int PMEditDialog::SetSchemeInfo(PScheme_Info pSchemeInfo)
{
    //
    if (NULL == pSchemeInfo)
    {
        return 0;
    }

    //Set Scheme Name
    TextCtrl_SchemeName->SetValue(PMUtility::StringToWxString(pSchemeInfo->SchemeName));

    SetSchemeDCInfo(pSchemeInfo->DCSettings);
    SetSchemeACInfo(pSchemeInfo->ACSettings);
    return 1;
}

/**set scheme's DC info*/
int PMEditDialog::SetSchemeDCInfo(PScheme_Settings dcSettingsInfo)
{
    if ( NULL == dcSettingsInfo )
    {
        return 0;
    }

    //Set DC Value
    int index = 0;
    map<string, int> valueMap;
    index = dcSettingsInfo->LCDBrightness;
    ComboBox_DC_LCDBrightness->SetSelection(index);
    valueMap.insert(make_pair(LCD_BRIGHTNESS, index));

    index = dcSettingsInfo->LANSpeed;
    ComboBox_DC_LANSpeed->SetSelection(index);
    valueMap.insert(make_pair(LAN_SPEED, index));

    index = dcSettingsInfo->CloseLCD;
    ComboBox_DC_TurnOffDisplay->SetSelection(index);

    index = dcSettingsInfo->Standby;
    ComboBox_DC_EnterSYSStandby->SetSelection(index);

    index = dcSettingsInfo->LANStatus;
    CheckBox_DC_DisableLAN->SetValue(!index);

    index = dcSettingsInfo->WLANStatus;
    CheckBox_DC_DisableWireless->SetValue(!index);

    //Update AC effectiveness
    UpdateDCEffectiveness(valueMap);

    return 1;
}

/**set scheme's AC info*/
int PMEditDialog::SetSchemeACInfo(PScheme_Settings acSettingsInfo)
{
    if ( NULL == acSettingsInfo )
    {
        return 0;
    }

    //Set AC Value
    int index = 0;
    map<string, int> valueMap;

    index = acSettingsInfo->LCDBrightness;
    ComboBox_AC_LCDBrightness->SetSelection(index);
    valueMap.insert(make_pair(LCD_BRIGHTNESS, index));

    index = acSettingsInfo->LANSpeed;
    ComboBox_AC_LANSpeed->SetSelection(index);
    valueMap.insert(make_pair(LAN_SPEED, index));

    index = acSettingsInfo->CloseLCD;
    ComboBox_AC_TurnOffDisplay->SetSelection(index);

    index = acSettingsInfo->Standby;
    ComboBox_AC_EnterSYSStandby->SetSelection(index);

    index = acSettingsInfo->LANStatus;
    CheckBox_AC_DisableLAN->SetValue(!index);

    index = acSettingsInfo->WLANStatus;
    CheckBox_AC_DisableWireless->SetValue(!index);

    UpdateACEffectiveness(valueMap);
    return 1;
}

/**update UI content*/
void PMEditDialog::UpdateDeviceStatus(int isAC, vector<string> &changedDeviceVector, int schemeId)
{
    if (//(!DataMiddle::GetInstance()->IsEditingTheScheme(m_iSchemeId)) ||
        (m_iSchemeId != schemeId) ||
        (changedDeviceVector.size() <= 0))
    {
        return;
    }

    if (1 == isAC)
    {
        for (vector<string>::size_type ix = 0; ix != changedDeviceVector.size(); ++ix)
        {
            string varName = changedDeviceVector[ix];

            if (0 == varName.compare(LAN_STATUS))
            {
                CheckBox_AC_DisableLAN->SetValue(false);
            }

             if (0 == varName.compare(WLAN_STATUS))
            {
                CheckBox_AC_DisableWireless->SetValue(false);
            }
        }
    }
    else
    {
        for (vector<string>::size_type ix = 0; ix != changedDeviceVector.size(); ++ix)
        {
            string varName = changedDeviceVector[ix];

            if (0 == varName.compare(LAN_STATUS))
            {
                CheckBox_DC_DisableLAN->SetValue(false);
            }

             if (0 == varName.compare(WLAN_STATUS))
            {
                CheckBox_DC_DisableWireless->SetValue(false);
            }
        }
    }
}

/**update DC Effectiveness*/
int PMEditDialog::UpdateDCEffectiveness(map<string, int>& valueMap)
{
    int percent = 0;

    PowerSchemeMgmtProxy::GetInstance()->CalculatePerformance(valueMap, percent);
    if ( percent > 100 )
    {
        percent = 100;
    }
    Gauge_DC_Performance->SetValue(percent);

    PowerSchemeMgmtProxy::GetInstance()->CalculateDisplayBrightness(valueMap, percent);
    if ( percent > 100 )
    {
        percent = 100;
    }
    Gauge_DC_LCDBrightness->SetValue(percent);

    PowerSchemeMgmtProxy::GetInstance()->CalculateBatteryLife(valueMap, percent);
    if ( percent > 100 )
    {
        percent = 100;
    }
    Gauge_DC_BatteryLife->SetValue(percent);

    return 1;
}

/**update AC Effectiveness*/
int PMEditDialog::UpdateACEffectiveness(map<string, int>& valueMap)
{
    int percent = 0;
    PowerSchemeMgmtProxy::GetInstance()->CalculatePerformance(valueMap, percent);
    if ( percent > 100 )
    {
        percent = 100;
    }
    Gauge_AC_Performance->SetValue(percent);

    PowerSchemeMgmtProxy::GetInstance()->CalculateDisplayBrightness(valueMap, percent);
    if ( percent > 100 )
    {
        percent = 100;
    }
    Gauge_AC_LCDBrightness->SetValue(percent);

    return 1;
}

/**save button click event handler*/
void PMEditDialog::OnButton_SaveClick(wxCommandEvent& event)
{
    wxString name = (TextCtrl_SchemeName->GetValue()).Trim(true);
    name.Trim(false);

    if ( name.IsEmpty() )
    {
        wxMessageBox(_("Please enter scheme name."),
                    _T(""), wxICON_WARNING | wxOK, this);

        return;
    }

    if ( 1 == PMUtility::CheckSchemeName(name))
    {
         wxMessageBox(_("Power scheme name can not contain >, <, &, \", \'."),
                    _T(""), wxICON_WARNING | wxOK, this);

        return ;
    }

    ConfigurationFileEditor editor;
    vector<PSchemeList_t> schemeVec;
    editor.Read(schemeVec);
    string schemeName = PMUtility::WxStringToString(name);
    vector<PSchemeList_t>::size_type editedSchemeIndex = 0;

    for (vector<PSchemeList_t>::size_type ix = 0; ix != schemeVec.size(); ++ix)
    {
        if ( (0 != (schemeName.compare(m_ptagSchemeInfo_t->SchemeName )))
            && (0 == (schemeVec[ix]->name).compare(schemeName)) )
        {
            wxMessageBox(_("The name has already been used."),
            _T(""), wxICON_WARNING | wxOK, this);

            return;
        }

        if (schemeVec[ix]->id == m_iSchemeId)
        {
            editedSchemeIndex = ix;
        }

    }

    // Update options info
    schemeVec[editedSchemeIndex]->name = schemeName;
    editor.Edit(schemeVec[editedSchemeIndex]);

    // Update configuration file
    m_ptagSchemeInfo_t->SchemeName = schemeName;
    m_ptagSchemeInfo_t->SchemeId = m_iSchemeId;
    //Save the change
    SaveSchemeInfo();
    PowerSchemeMgmtProxy::GetInstance()->EditPwrScheme(m_ptagSchemeInfo_t);

    int schemeId = 0;
    PowerSchemeMgmtProxy::GetInstance()->GetActivePwrScheme(schemeId);

    if ( schemeId == m_iSchemeId )
    {
        PowerSchemeMgmtProxy::GetInstance()->ApplyPwrScheme(schemeId);
    }

    DataMiddle::GetInstance()->UpdateOptionsDlgUI();

    // Update PM dialog UI
    DataMiddle::GetInstance()->UpdatePMDialog(m_ptagSchemeInfo_t);
//    DataMiddle::GetInstance()->UpdatePMDlgEditingScheme(0);

    Destroy();
}

/**cancel button click event handler*/
void PMEditDialog::OnButton_CancelClick(wxCommandEvent& event)
{
    //Close the window without saving change
    m_ptagSchemeInfo_t = NULL;

//    DataMiddle::GetInstance()->UpdatePMDlgEditingScheme(0);

    Destroy();
}

/**reset button click event handler*/
void PMEditDialog::OnButton_ResetClick(wxCommandEvent& event)
{
    if (wxMessageBox(_("Are you sure you want to reset this power scheme?"),
                _T(""),
                wxICON_QUESTION | wxCANCEL | wxOK ,
                this) == wxCANCEL )
    {
        return;
    }

    //reset the default scheme
    PScheme_Settings dcSettings = new Scheme_Settings;
    PScheme_Settings acSettings = new Scheme_Settings;

    PowerSchemeMgmtProxy::GetInstance()->ResetDefaultScheme(m_iSchemeId, 0, dcSettings);

    if (NULL == dcSettings)
    {
        return;
    }

    PowerSchemeMgmtProxy::GetInstance()->ResetDefaultScheme(m_iSchemeId, 1, acSettings);

    if (NULL == acSettings)
    {
        return;
    }

    SetSchemeDCInfo(dcSettings);
    SetSchemeACInfo(acSettings);

    if ( dcSettings)
    {
        delete dcSettings;
    }

    if ( acSettings)
    {
        delete acSettings;
    }
}

/**comboBox select event handler*/
void PMEditDialog::OnComboBox_DCSelect(wxCommandEvent& event)
{
    map<string, int> valueMap;
    int value = ComboBox_DC_LCDBrightness->GetCurrentSelection();
    valueMap.insert(make_pair(LCD_BRIGHTNESS, value));

    value = ComboBox_DC_LANSpeed->GetCurrentSelection();
    valueMap.insert(make_pair(LAN_SPEED, value));

    UpdateDCEffectiveness(valueMap);
}

/**comboBox select event handler*/
void PMEditDialog::OnComboBox_ACSelect(wxCommandEvent& event)
{
    map<string, int> valueMap;
    int value = ComboBox_AC_LCDBrightness->GetCurrentSelection();
    valueMap.insert(make_pair(LCD_BRIGHTNESS, value));

    value = ComboBox_AC_LANSpeed->GetCurrentSelection();
    valueMap.insert(make_pair(LAN_SPEED, value));

    UpdateACEffectiveness(valueMap);
}

/**window close event handler*/
void PMEditDialog::OnClose(wxCloseEvent& event)
{
    m_ptagSchemeInfo_t = NULL;

//    DataMiddle::GetInstance()->UpdatePMDlgEditingScheme(0);
    Destroy();
}
