/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PowerSchemeMgmtProxy.h

Description:

    This file defines class PowerSchemeMgmtProxy.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef POWERSCHEMEMGMTPROXY_H_INCLUDED
#define POWERSCHEMEMGMTPROXY_H_INCLUDED

#include <wx/string.h>

#include <cstdlib>
#include <string>
#include <iostream>
#include <map>
#include <vector>
using namespace std;

#include "tinyxml.h"
#include "PMApi.h"

const int APPLY_FAILED = -1;
const int SUCCESS = 0;
const int OPERATON_DENIED = 2;
const int FAILED = 6;
const int STRING_MAX_LEN = 256;
const int EFFECTIVE_ITEMS_COUNT = 2;

/* Name of scheme settings variable. */
const char LCD_BRIGHTNESS[] = "LCDBrightness";
const char LAN_SPEED[] = "LANSpeed";
const char CLOSE_LCD[] = "CloseLCD";
const char STANDBY[] = "Standby";
const char LAN_STATUS[] = "LAN";
const char WLAN_STATUS[] = "Wireless";

/* Node name in CommonSettings.xml. */
const string COMMON_SETTINGS("globalsettings");
const string COMMON_PERSONAL("personalscheme");
const string COMMON_ITEMS("items");
const string COMMON_DEVICES("devices");
const string COMMON_EFFECTIVE("effectiveness");

/* Name of effectiveness variable. */
const string PERFORMANCE("Performance");
const string DISPLAY("DisplayBrightness");
const string BATTERYLIFE("BatteryLife");

const string SETTINGS("settings");
const string NAME_ATTRIBUTE("name");
const string DESC_ATTRIBUTE("description");
const string VALUE_ATTRIBUTE("value");
const string SCHEME_ITEM("item");
const string SCHEMES("schemes");
const string SCHEME("scheme");
const string ACVALUE("acvalue");
const string DCVALUE("dcvalue");
const string SCHEME_ID("schemeid");
const string DEFAULT_ATTRIBUTE("isdefault");
const string MAX_ATTRIBUTE("max");

const int TIMELIST_SECOND[] = {60, 120, 180, 300, 600, 900, 1200, 1500, 1800, 2700, 3600, 7200, 108000, 144000, 180000, 0};

typedef struct tagSchemeSettings
{
    int LCDBrightness;
    int LANSpeed;
    int CloseLCD;
    int Standby;
    int LANStatus;
    int WLANStatus;
}Scheme_Settings, *PScheme_Settings;

typedef struct tagSchemeInfo
{
    int SchemeId;
    int IsDefault;
    string SchemeName;
    PScheme_Settings ACSettings;
    PScheme_Settings DCSettings;
}Scheme_Info, *PScheme_Info;

typedef struct tagSettingItemInfo
{
    int Value;
    string Name;
    string Description;
}Setting_Item_Info, *PSetting_Item_Info;

typedef vector<Setting_Item_Info> SETTING_ITEM_VECTOR;
typedef map<string, SETTING_ITEM_VECTOR> SETTING_ITEM_MAPPING;
typedef map<string, int> STRING_MAP;


class PowerSchemeMgmtProxy
{
public:
    //destructor
    ~PowerSchemeMgmtProxy();
    //get sington instance
    static PowerSchemeMgmtProxy* GetInstance();
    //get active scheme ID
    int GetActivePwrScheme(int &schemeId);
    //add scheme
    int AddPwrScheme(int &schemeId, PScheme_Info scheme);
    //apply scheme settings
    int ApplyPwrScheme(int schemeId);
    //delete scheme
    int DeletePwrScheme(int schemeId);
    //edit scheme
    int EditPwrScheme(PScheme_Info scheme);
    //edit scheme settings
    int EditPwrSchemeSettings(int schemeId, int isAC, PScheme_Settings schemeSettings);
    //query scheme info
    int QueryPwrScheme(PScheme_Info scheme);
    //query scheme settings
    int QueryPwrSchemeSettings(int schemeId, int isAC, PScheme_Settings schemeSettings);
    //get scheme setting
    int GetPwrVariable(int schemeId, BOOL isAC, const char *pVarName, int &value);
    //set scheme setting
    int SetPwrVariable(int schemeId, BOOL isAC, const char *pVarName, int value);
    //edit scheme name
    int EditPowerSchemeName(string schemeName, int schemeId);
    //get scheme is default
    int GetPowerDefaultAttribute(int schemeId, int &isDefault);
    //get disabled devices
    int GetDisabledDevices(int schemeId, int isAC, vector<string> &devicesVec);
    //set disabled devices
    int SetDisabledDevices(int schemeId, int isAC, vector<string> &devicesVec, int value);
    //reset scheme settings
    int ResetDefaultScheme(int schemeId, int isAC, PScheme_Settings schemeSettings);
    //get setting items
    int GetSettingItems(SETTING_ITEM_MAPPING &settingItemsMapping);
    //get default scheme name
    int GetPersonalSchemeDefaultName(vector<string> &nameVec);
    //get max count of scheme
    int GetMaxNumberOfSchemes(int &maxNum);
    //get devices description
    int GetDevicesDesc(map<string, string> &deviceDescMap);
    //calculate effectiveness
    int CalculateEffectiveness(map<string, int>& valueMap, string varName);
    //calculate performance
    int CalculatePerformance(map<string, int>& valueMap, int &persent);
    //calculate display brightness
    int CalculateDisplayBrightness(map<string, int>& valueMap, int &persent);
    //calculate battery life
    int CalculateBatteryLife(map<string, int>& valueMap, int &persent);
    //get scheme max count
    int GetPwrVariableMaxCount(const char *itemName, int &count);
    //calculate effective range
    int CalculateEffectiveRange(string effectiveName, int &maxRange, int &minRange);
    //init the scheme setting and apply it
    int InitScheme();
    static unsigned long g_CloseLCDTime;
    //get system idle time
    unsigned long GetIdleTime();

    static unsigned long g_SuspendTime;
    //suspend action
    static bool EnterSuspend();

    static int g_LanOvertime;

    void InitCommonResourceFilePath(wxString language);
    void InitDefaultResourceFilePath(wxString language);
    void InitHelpResourceFilePath(wxString language);
    void GetCommonResourceFilePath(string& filePath);
    void GetDefaultResourceFilePath(string& filePath);
    void GetHelpResourceFilePath(wxString& filePath);

private:
    //constructor
    PowerSchemeMgmtProxy();
    //get default scheme info
    int GetDefaultSchemeInfo(int schemeId, int isAC, map<string, int> &settingMapping);
    //get weight for effectiveness
    int ReadWeight();
    //apply scheme settings
    int ApplySchemeSettings(int schemeId);

    int m_hasXSCExtension;
    unsigned long m_idleTime;

    string m_CommonFilePath;
    string m_DefaultSchemeFilePath;
    wxString m_HelpFilePath;

private:
    static PowerSchemeMgmtProxy* m_pPowerSchemeMgmtProxy;

    map<string, STRING_MAP> m_EffectivenessMap;
    map<string, int> m_EffectMaxValueMap;
};
#endif // POWERSCHEMEMGMTPROXY_H_INCLUDED
