/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          PMDialog.h

Description:

    This file defines class PMDialog.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Lin Xin 2008-7-20

  =====================================================================

****************************************************************************/

#ifndef PMDIALOG_H
#define PMDIALOG_H

//(*Headers(PMDialog)
#include <wx/stattext.h>
#include <wx/statline.h>
#include <wx/statbox.h>
#include <wx/bmpbuttn.h>
#include <wx/statbmp.h>
#include <wx/button.h>
#include <wx/dialog.h>
#include <wx/combobox.h>
#include <wx/gauge.h>
//*)

#include "wx/wx.h"
#include <wx/hyperlink.h>
#include <wx/wizard.h>

#include "PowerSchemeMgmtProxy.h"
#include "PMUtility.h"
#include "ConfigurationFileEditor.h"
#include "BatteryInfoMgmtProxy.h"

#include "OptionsDialog.h"
#include "PMEditDialog.h"
#include "AboutDialog.h"
#include "PMNew1Dialog.h"
#include "DeviceDisableDialog.h"
#include "PMTrayIcon.h"


class PMDialog: public wxDialog
{
	public:
        //constructor
		PMDialog(wxWindow* parent,wxWindowID id=wxID_ANY,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		//destructor
		virtual ~PMDialog();

//        static int m_iEditingSchemeId; // The scheme is being edited and not allowed to be deleted.
        //Init Window
		void Init(void);
        //update dialog UI info
		void UpdateDlgUI(PScheme_Info pSchemeInfo);
		//update dialog UI info
		void UpdateDevicesStatus(int isAC, vector<string> &deviceVector, int schemeId);
		//update dialog UI info
		void UpdateButtonStatusAfterSwitching(int schemeId);
		//update dialog UI info
		void UpdateSchemeNameComboList(int schemeId);
		//int SetCurrentComboboxValue();

		//(*Declarations(PMDialog)
		wxStaticText* StaticText_UI_BatteryLife;
		wxStaticText* StaticText_UI_BatterySettings;
		wxStaticText* StaticText_AC_EnterSYSStandby;
		wxStaticText* StaticText_AC_LCDBrightness;
		wxStaticBitmap* StaticBitmap_DC;
		wxStaticText* StaticText_DC_LAN;
		wxStaticText* StaticText_DC_LCDBrightness;
		wxStaticText* StaticText_DC_LANSpeed;
		wxGauge* Gauge_DC_LCDBrightness;
		wxStaticText* StaticText_UI_AC_Settings;
		wxStaticText* StaticText_UI_LCDBrightness2;
		wxGauge* Gauge_AC_LCDBrightness;
		wxStaticText* StaticText_AC_LANSpeed;
		wxStaticText* StaticText_UI_PowerSettings;
		wxStaticText* StaticText_UI_Wireless;
		wxStaticText* StaticText_BatteryLife;
		wxStaticText* StaticText_UI_LCDBrightness;
		wxBitmapButton* BitmapButton2;
		wxStaticBox* StaticBox1;
		wxBitmapButton* BitmapButton1;
		wxGauge* Gauge_DC_BatteryLife;
		wxStaticLine* StaticLine2;
		wxButton* Button_Apply;
		wxStaticText* StaticText_DC_Wireless;
		wxStaticText* StaticText_UI_EnterSysStandby;
		wxComboBox* ComboBox_SchemeName;
		wxStaticBitmap* StaticBitmap_AC;
		wxStaticText* StaticText_AC_Wireless;
		wxStaticText* StaticText_AC_TurnOffDisplay;
		wxGauge* Gauge_DC_Performance;
		wxButton* Button_OK;
		wxButton* Button_Delete;
		wxButton* Button_Cancel;
		wxStaticText* StaticText_UI_SchemeName;
		wxStaticText* StaticText_UI_TurnOffDisPlay;
		wxStaticLine* StaticLine3;
		wxStaticLine* StaticLine1;
		wxButton* Button_New;
		wxButton* Button_Edit;
		wxStaticText* StaticText_UI_LAN;
		wxBitmapButton* BitmapButton3;
		wxStaticText* StaticText_AC_LAN;
		wxStaticText* StaticText_UI_LANSpeed;
		wxStaticText* StaticText_UI_Performance;
		wxStaticText* StaticText_DC_TurnOffDisplay;
		wxStaticBitmap* StaticBitmap_Top;
		wxStaticText* StaticText_DC_EnterSYSStandby;
		wxGauge* Gauge_AC_Performance;
		wxStaticText* StaticText_UI_EffectiveOfSettings;
		//*)

	protected:

		//(*Identifiers(PMDialog)
		static const long ID_STATICBITMAP_TOP;
		static const long ID_STATICTEXT_UI_SCHEMENAME;
		static const long ID_COMBOBOX_SCHEMENAME;
		static const long ID_BUTTON_EDIT;
		static const long ID_BUTTON_DELETE;
		static const long ID_BUTTON_NEW;
		static const long ID_STATICBOX1;
		static const long ID_BUTTON_OK;
		static const long ID_BUTTON_APPLY;
		static const long ID_BUTTON_CANCEL;
		static const long ID_STATICLINE1;
		static const long ID_STATICLINE2;
		static const long ID_STATICLINE3;
		static const long ID_STATICTEXT_UI_EFFECTIVEOFSETTINGS;
		static const long ID_STATICTEXT_UI_PERFORMANCE;
		static const long ID_STATICTEXT_LCDBRIGHTNESS;
		static const long ID_STATICTEXT_UI_BATTERYLIFE;
		static const long ID_STATICTEXT_UI_BATTERYSETTINGS;
		static const long ID_STATICTEXT_UI_ACSETTINGS;
		static const long ID_GAUGE_DC_PEROFRMANCE;
		static const long ID_GAUGE_DC_LCDBRIGHTNESS;
		static const long ID_GAUGE_DC_BATTERYLIFE;
		static const long ID_GAUGE_AC_PERFORMANCE;
		static const long ID_GAUGE_AC_LCDBRIGHTNESS;
		static const long ID_STATICTEXT_UI_POWERSETTINGS;
		static const long ID_STATICTEXT_UI_LCDBRIGHTNESS;
		static const long ID_STATICTEXT_UI_LANSPEED;
		static const long ID_STATICTEXT_UI_TURNOFFDISPLAY;
		static const long ID_STATICTEXT_UI_ENTERSYSSTANDBY;
		static const long ID_STATICTEXT_UI_WIRELESS;
		static const long ID_STATICTEXT_UI_LAN;
		static const long ID_STATICBITMAP_DC;
		static const long ID_STATICBITMAP_AC;
		static const long ID_STATICTEXT_DC_LCDBRIGHTNESS;
		static const long ID_STATICTEXT_DC_LANSPEED;
		static const long ID_STATICTEXT_DC_TURNOFFDISPLAY;
		static const long ID_STATICTEXT_DC_ENTERSYSSTANDBY;
		static const long ID_STATICTEXT_DC_WIRELESS;
		static const long ID_STATICTEXT_DC_LAN;
		static const long ID_STATICTEXT_AC_LCDBRIGHTNESS;
		static const long ID_STATICTEXT_AC_LANSPEED;
		static const long ID_STATICTEXT_AC_TURNOFFDISPLAY;
		static const long ID_STATICTEXT_AC_ENTERSYSSTANDBY;
		static const long ID_STATICTEXT_AC_WIRELESS;
		static const long ID_STATICTEXT_AC_LAN;
		static const long ID_STATICTEXT_BATTERYLIFE;
		static const long ID_BITMAPBUTTON1;
		static const long ID_BITMAPBUTTON2;
		static const long ID_BITMAPBUTTON3;
		//*)


	private:

		//(*Handlers(PMDialog)
		//comboBox select event
		void OnComboBox1Select(wxCommandEvent& event);
		//edit button click event
		void OnButton_EditClick(wxCommandEvent& event);
		//delete button click event
		void OnButton_DeleteClick(wxCommandEvent& event);
		//new button click event
		void OnButton_NewClick(wxCommandEvent& event);
		//options button click event
		void OnButton_OptionsClick(wxCommandEvent& event);
		//ok button click event
		void OnButton_OKClick(wxCommandEvent& event);
		//apply button click event
		void OnButton_ApplyClick(wxCommandEvent& event);
		//cancel button click event
		void OnButton_CancelClick(wxCommandEvent& event);
		//comboBox button click event
		void OnComboBox_SchemeNameSelect(wxCommandEvent& event);
		//help button click event
		void OnBitmapButtonHelpClick(wxCommandEvent& event);
		//about button click event
		void OnBitmapButtonAboutClick(wxCommandEvent& event);
		//*)

		DECLARE_EVENT_TABLE()

    private:
        //get scheme list
        int GetVectorList(void);
		//
        //int SetComboboxValue();
        //set scheme ac value
        int SetSelectSchemeACValue(PScheme_Settings acSchemeSettings);
        //set scheme dc value
        int SetSelectSchemeDCValue(PScheme_Settings dcSchemeSettings);
        //switch scheme
        void SwitchPowerScheme();

        //update dc effectivenee
        int UpdateDCEffectiveness(map<string, int>& valueMap);
        //update ac effectivenee
        int UpdateACEffectiveness(map<string, int>& valueMap);
        //close window event
        void OnClose(wxCloseEvent& event); // Click close button
        //paint window event
        void OnPaint(wxPaintEvent& event);

    private:
        //
        int m_iEditSchemeId; // Record scheme id selected from combo box

        //
        SETTING_ITEM_VECTOR vLCDBrightnessItems;
        SETTING_ITEM_VECTOR vLANSpeedItems;
        SETTING_ITEM_VECTOR vCloseLCDItems;
        SETTING_ITEM_VECTOR vStandbyItems;

};

#endif
