/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          BatteryInfoMgmtProxy.h

Description:

    This file defines class BatteryInfoMgmtProxy.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/


#ifndef BATTERYINFOMGMTPROXY_H_INCLUDED
#define BATTERYINFOMGMTPROXY_H_INCLUDED
//
#include "PMApi.h"
////

#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <ctype.h>

class BatteryInfoMgmtProxy
{

public:
    //get battery info
    static bool PM_GetBatteriesInfo(PDCS_Battery_Info batteryInfo, int& batteryIndex);
    //get battery info with battery Index
    static bool PM_GetBatteryInfo(PDCS_Battery_Info batteryInfo, int batteryIndex);
    //get battery count
    static int PM_GetBatteriesCount(unsigned long &count);
    //get ac adapter status
    static int GetACAdapterStatusOri();
    //get ac adapter status
    static int PM_GetACAdapterStatus();
    /**Deprecated*/
    static int GetACAdapterStatus(void);
    //check the ACPI is OK
    static int CheckACPIAVAI(void);
    //check the ACPI directory exist
    static int CheckACPIDirExit(const char* dir);
    //get battery info files' path
    static int GetDir(const int number, char *file, const size_t file_size, const char *dir);
    //get battery info with argument
    static int GetValueByColon(FILE *bat_file, char *value, const size_t value_size, char *key, const size_t key_size);
};


#endif // BATTERYINFOMGMTPROXY_H_INCLUDED
