/****************************************************************************

 * Copyright (c) 2008-2009, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

File Name:          DataMiddle.cpp

Description:

    This file implements class DataMiddle.

Environment (opt):

    OS: Ubuntu
    SE: Code::Block

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Deng Jing 2008-7-20

  =====================================================================

****************************************************************************/

#include "include/PMDialog.h"
#include "include/DataMiddle.h"

DataMiddle* DataMiddle::m_pDataMiddle = NULL;

DataMiddle::DataMiddle()
{
    m_pPMDialog = NULL;
    m_pPMEditDlg = NULL;
    m_pOptionsDlg = NULL;
    m_pAboutDialog = NULL;
//    m_pDeviceDlg = NULL;
}

/**singlton pattern*/
DataMiddle* DataMiddle::GetInstance()
{
    if(NULL == m_pDataMiddle)
    {
        m_pDataMiddle = new DataMiddle();
    }
    return m_pDataMiddle;
}

/**************************************************************************************************
* Function Name : UpdatePMDialog                                                                  *
* Description  : update the info of PMDialog                                                      *
* Date   : 08/07/20                                                                               *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void DataMiddle::UpdatePMDialog(PScheme_Info scheme_Info)
{
    if(m_pPMDialog != NULL)
    {
        m_pPMDialog->UpdateDlgUI(scheme_Info);
    }
}

/**************************************************************************************************
* Function Name : UpdatePMDialogDeviceStatus                                                      *
* Description  : update the info of PMDialog                                                      *
* Date   : 08/07/20                                                                               *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/

void DataMiddle::UpdatePMDialogDeviceStatus(int isAC, vector<string> &deviceVector, int schemeId)
{
    if(m_pPMDialog != NULL)
    {
        m_pPMDialog->UpdateDevicesStatus(isAC, deviceVector, schemeId);
    }
}

//void DataMiddle::UpdatePMDlgEditingScheme(int schemeId)
//{
//    if(m_pPMDialog != NULL)
//    {
//        PMDialog::m_iEditingSchemeId = schemeId;
//    }
//}


/**************************************************************************************************
* Function Name : IsEditingTheScheme                                                              *
* Description  : update the flag                                                                  *
* Date   : 08/07/20                                                                               *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
bool DataMiddle::IsEditingTheScheme(int schemeId)
{
    if ((m_pPMDialog != NULL))// && (PMDialog::m_iEditingSchemeId == schemeId))
    {
        return true;
    }

    return false;
}

/**************************************************************************************************
* Function Name : UpdatePMDlgButtonStatusAfterSwitching                                           *
* Description  : update the button status                                                         *
* Date   : 08/07/20                                                                               *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void DataMiddle::UpdatePMDlgButtonStatusAfterSwitching(int schemeId)
{
    if(m_pPMDialog != NULL)
    {
        m_pPMDialog->UpdateButtonStatusAfterSwitching(schemeId);
    }
}

/**************************************************************************************************
* Function Name : UpdatePMDlgSchemeNameList                                                       *
* Description  : update the button status                                                         *
* Date   : 08/07/20                                                                               *
* Parameter     :                                                                                 *
* Return Code  :                                                                                  *
* Author   :                                                                                      *
**************************************************************************************************/
void DataMiddle::UpdatePMDlgSchemeNameList(int schemeId)
{
    if(m_pPMDialog != NULL)
    {
        m_pPMDialog->UpdateSchemeNameComboList(schemeId);
    }
}

/**************************************************************************************************
* Function Name : AttachPMDialog
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
void DataMiddle::AttachPMDialog(PMDialog* pDialog)
{
    m_pPMDialog = pDialog;
}

/**************************************************************************************************
* Function Name : DettachPMDialog
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
void DataMiddle::DettachPMDialog()
{
    m_pPMDialog = NULL;
}

/**************************************************************************************************
* Function Name : AttachPMEditDlg
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
void DataMiddle::AttachPMEditDlg(PMEditDialog* pEditDlg)
{
    m_pPMEditDlg = pEditDlg;
}

/**************************************************************************************************
* Function Name : DettachPMEditDlg
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
void DataMiddle::DettachPMEditDlg()
{
    m_pPMEditDlg = NULL;
}

/**************************************************************************************************
* Function Name : GetPMEditDlgInstance
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
PMEditDialog* DataMiddle::GetPMEditDlgInstance()
{
    return m_pPMEditDlg;
}

/**************************************************************************************************
* Function Name : UpdatePMEditDlgDeviceStatus
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
void DataMiddle::UpdatePMEditDlgDeviceStatus(int isAC, vector<string> &changedDeviceVector, int schemeId)
{
    if (m_pPMEditDlg != NULL)
    {
        m_pPMEditDlg->UpdateDeviceStatus(isAC, changedDeviceVector, schemeId);
    }
}

/**************************************************************************************************
* Function Name : AttachOptionsDlg
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
void DataMiddle::AttachOptionsDlg(OptionsDialog* pOptionsDlg)
{
    m_pOptionsDlg = pOptionsDlg;
}

/**************************************************************************************************
* Function Name : DettachOptionsDlg
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
void DataMiddle::DettachOptionsDlg()
{
    m_pOptionsDlg = NULL;
}

/**************************************************************************************************
* Function Name : GetOptionsDlgInstance
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
OptionsDialog* DataMiddle::GetOptionsDlgInstance()
{
    return m_pOptionsDlg;
}

/**************************************************************************************************
* Function Name : UpdateOptionsDlgUI
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
void DataMiddle::UpdateOptionsDlgUI()
{
    if (m_pOptionsDlg != NULL)
    {
        m_pOptionsDlg->IniDlg();
    }
}

/**************************************************************************************************
* Function Name : AttachAboutDlg
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
void DataMiddle::AttachAboutDlg(AboutDialog* pAboutDlg)
{
    m_pAboutDialog = pAboutDlg;
}

/**************************************************************************************************
* Function Name : GetAboutDlgInstance
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
AboutDialog* DataMiddle::GetAboutDlgInstance()
{
    return m_pAboutDialog;
}

/**************************************************************************************************
* Function Name : DettachAboutDlg
* Description  :
* Date   : 08/07/20
* Parameter     :
* Return Code  :
* Author   :
**************************************************************************************************/
void DataMiddle::DettachAboutDlg()
{
    m_pAboutDialog = NULL;
}

// Device disable dialog related operation
//void DataMiddle::AttachDeviceDisableDlg(DeviceDisableDialog* pDeviceDlg)
//{
//    m_pDeviceDlg = pDeviceDlg;
//}
//
//void DataMiddle::DettachDeviceDisableDlg()
//{
//    m_pDeviceDlg = NULL;
//}
//
//DeviceDisableDialog* DataMiddle::GetDeviceDisableDlgInstance()
//{
//    return m_pDeviceDlg;
//}
