/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL ES-CM 1.1 plugin
 *
 * Copyright © 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author(s): Loïc Molinari <loic@fluendo.com>
 *            Mirco Müller <macslow@bangang.de>
 */

#ifndef __PGM_GLES_TEXT_H__
#define __PGM_GLES_TEXT_H__

#include <cairo.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include "pgmglesdrawable.h"

G_BEGIN_DECLS

#define PGM_TYPE_GLES_TEXT (pgm_gles_text_get_type())
#define PGM_GLES_TEXT(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_GLES_TEXT, PgmGlesText))
#define PGM_GLES_TEXT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_GLES_TEXT, PgmGlesTextClass))
#define PGM_IS_GLES_TEXT(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_GLES_TEXT))
#define PGM_IS_GLES_TEXT_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_GLES_TEXT))
#define PGM_GLES_TEXT_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_GLES_TEXT, PgmGlesTextClass))

typedef struct _PgmGlesText      PgmGlesText;
typedef struct _PgmGlesTextClass PgmGlesTextClass;

struct _PgmGlesText {
  PgmGlesDrawable parent;

  /* Pixmap buffer */
  guint   width, height;
  guint   size;
  guchar *buffer;

  /* Pango rendering */
  PangoContext         *pango_ctx;
  PangoFontDescription *desc;
  PangoLayout          *layout;

  /* Cairo backend */
  cairo_t              *cairo_ctx;
  cairo_surface_t      *surface;
  cairo_font_options_t *font_options;

  /* Regeneration boolean */
  gboolean size_updated;

  /* Outline conversions */
  gfloat outline_color[4];
  gfloat outline_width;

  /* Texture handling */
  PgmGlesTexture *texture;

  /* Vertex arrays */
  PgmGlesFloat fg_color[16];
  PgmGlesFloat coord[8];
  PgmGlesFloat vertex[12];
};

struct _PgmGlesTextClass {
  PgmGlesDrawableClass parent_class;
};

GType            pgm_gles_text_get_type          (void) G_GNUC_CONST;

PgmGlesDrawable *pgm_gles_text_new               (PgmDrawable *drawable,
                                                  PgmGlesViewport *glesviewport);

void             pgm_gles_text_register          (GTypeModule *module);

void             pgm_gles_text_set_label         (PgmGlesText *glestext);
void             pgm_gles_text_set_markup        (PgmGlesText *glestext);
void             pgm_gles_text_set_font_family   (PgmGlesText *glestext);
void             pgm_gles_text_set_font_height   (PgmGlesText *glestext);
void             pgm_gles_text_set_ellipsize     (PgmGlesText *glestext);
void             pgm_gles_text_set_justify       (PgmGlesText *glestext);
void             pgm_gles_text_set_alignment     (PgmGlesText *glestext);
void             pgm_gles_text_set_wrap          (PgmGlesText *glestext);
void             pgm_gles_text_set_gravity       (PgmGlesText *glestext);
void             pgm_gles_text_set_stretch       (PgmGlesText *glestext);
void             pgm_gles_text_set_style         (PgmGlesText *glestext);
void             pgm_gles_text_set_variant       (PgmGlesText *glestext);
void             pgm_gles_text_set_weight        (PgmGlesText *glestext);
void             pgm_gles_text_set_line_spacing  (PgmGlesText *glestext);
void             pgm_gles_text_set_outline_color (PgmGlesText *glestext);
void             pgm_gles_text_set_outline_width (PgmGlesText *glestext);

G_END_DECLS

#endif /* __PGM_GLES_TEXT_H__ */
