<?php
  /**************************************************************************\
  * phpGroupWare - NNTP preferences                                          *
  * http://www.phpgroupware.org                                              *
  * Written by Mark Peters <mpeters@satx.rr.com>                             *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /**************************************************************************\
  * Modified by Steve Price <steep@sdprice.plus.com>                         *
  * Modified to make the search function work properly, and work with the    *
  * nextmatchs class                                                         *
  \**************************************************************************/

	/* $Id: preferences.php,v 1.36.4.2 2006/10/24 13:56:46 skwashd Exp $ */

	$GLOBALS['phpgw_info']['flags'] = array
			(
				'currentapp'	=> 'nntp',
				'enable_nextmatchs_class' => True,
				'noheader'	=> True,
				'nonavbar'	=> True
			);

	include('../header.inc.php');

	function get_tg($where='')
	{
		$db = $GLOBALS['phpgw']->db;
		$db->query("SELECT count(con) FROM newsgroups WHERE active='Y' $where");
		$db->next_record();
		$con = $db->f(0);
		unset($db);
		return $con;
	}
	
	//===========================================================================================
	// Update
	if( isset($_REQUEST['submit']) && $_REQUEST['submit'] )
	{
		$GLOBALS['phpgw']->preferences->read_repository();

		$minarray = @unserialize(urldecode($_REQUEST['nntparray']) );

		if ( $minarray !== false && is_array($minarray) )
		{
			foreach ( $minarray as $value )
			{
				//echo "Deleting Preference $value<br />\n";
				if( isset($GLOBALS['phpgw_info']['user']['preferences']['nntp'][$value]) )
				{
					$GLOBALS['phpgw']->preferences->delete('nntp', $value);
				}
			}
		}

		for ( $i = 0 ; $i < count($_REQUEST['nntplist']); ++$i)
		{
			//echo "Setting Preference {$_REQUEST['nntplist'][$i]}<br />\n";
			$GLOBALS['phpgw']->preferences->add('nntp', $_REQUEST['nntplist'][$i], 1);
		}
		$GLOBALS['phpgw']->preferences->save_repository(True);

		$params = array() ;
		foreach (array('start', 'tg', 'search', 'query') as $field)
		{
			if (isset($_REQUEST[$field]))
			{
				$params[$field] = $_REQUEST[$field] ;
			}
		}
	
		$GLOBALS['phpgw']->redirect_link('/nntp/preferences.php', $params );
		$GLOBALS['phpgw']->common->phpgw_exit();
	}

	//===========================================================================================
	// View
	if ( !isset($_REQUEST['start']) || !$_REQUEST['start'] )
	{
		$start = 0;
	}
	else
	{
		$start = (int) $_REQUEST['start'];
	}

	if ( !isset($_REQUEST['order']) || !$_REQUEST['order'] )
	{
		$order = 1;
	}
	else
	{
		$order = (int) $_REQUEST['order'];
	}

	$sort = 'ASC';

	$orderby = '';
	if ( $order > 0 && $order < 4 ) //see below
	{
		$sort = isset($_REQUEST['sort']) && $_REQUEST['sort'] == 'DESC' ? 'DESC' : 'ASC';

		switch ($order)
		{
			case 1:
				$orderby = ' ORDER BY con '.$sort;
				break;
			case 2:
				$orderby = ' ORDER BY name '.$sort;
				break;
			case 3:
				$orderby = ' ORDER BY active '.$sort;
				break;
		}
	}

	$db2 = $GLOBALS['phpgw']->db;
	
		$query_val = get_var('query', array('POST', 'GET'), '');

		$where_str = '' ;
		if (isset($_REQUEST['search']) && $_REQUEST['search'])
				{
			$where_str = "AND name LIKE '%" . $GLOBALS['phpgw']->db->db_addslashes($query_val) ."%'" ;
			$tg = intval(get_tg($where_str));

			// if 'stop' is set then this is a search
			if (isset($_REQUEST['stop']))
				{
				// Always reset counter for a new search
				$start=0;
		}
	}



	$querystr = "SELECT con, name FROM newsgroups WHERE active='Y' $where_str $orderby";
	$db2->limit_query($querystr,$start,__LINE__,__FILE__);

	if(!$db2->num_rows())
	{
		header('Location: '.$GLOBALS['phpgw']->link('/nntp/admin.php'));
		$GLOBALS['phpgw']->common->phpgw_exit();
	}
	else
	{
		$minarray = Array();
		$nntpavail = Array();
		while($db2->next_record())
		{
			$nntpavail[] = array
					(
						'con'  => $db2->f('con'),
						'name' => $db2->f('name')
					);
			$minarray[] = $db2->f('con');
		}
		unset($db2);

		$GLOBALS['phpgw']->common->phpgw_header();
		echo parse_navbar();

	}

	$p = CreateObject('phpgwapi.Template',$GLOBALS['phpgw']->common->get_tpl_dir('nntp'));
	$templates = Array(
		'nntp_form' => 'nntp.tpl'
	);

	$p->set_file($templates);

	$p->set_block('nntp_form','nntp','nntp');
	$p->set_block('nntp_form','nntp_list','nntp_list');

	if (!isset($tg) || !$tg)
	{
		$tg = get_tg($where_str);
	}
	$first = count($minarray) ? min($minarray) : 0;

	@reset($minarray);

	$common_hidden_vars = '<input type="hidden" name="start" value="'.$start.'">'."\n"
		. '<input type="hidden" name="first" value="'.$first.'">'."\n"
		. '<input type="hidden" name="nntparray" value="'.urlencode(serialize($minarray)).'">'."\n"
					. '<input type="hidden" name="stop" value="' . 1 . "\">\n"
		. '<input type="hidden" name="tg" value="'.$tg.'">'."\n";
	if(isset($order) && $order)
	{
		$common_hidden_vars .= '<input type="hidden" name="order" value="'.$order.'">'."\n";
	}
	if(isset($sort) && $sort)
	{
		$common_hidden_vars .= '<input type="hidden" name="sort" value="'.$sort.'">'."\n";
	}

	$extra_parms = '&tg='.$tg;
	if(isset($sort) && $sort)
	{
		$extra_parms .= '&sort='.$sort;
	}
	if(isset($order) && $order)
	{
		$extra_parms .= '&order='.$order;
	}

		if( $query_val )
		{
			$extra_parms .= '&query='.$query_val;
			$extra_parms .='&search=Search' ;
			$common_hidden_vars .= 
					"<input type=\"hidden\" name=\"query\" value=\"{$query_val}\" />\n" .
					"<input type=\"hidden\" name=\"search\" value=\"Search\">";
			
		}

	$urlname = '/nntp/preferences.php';

	$p->set_var(array
		(
			'search_value'		=> $query_val,
			'search'		=> lang('search'),
			'next'			=> lang('next'),
			'nml'			=> $GLOBALS['phpgw']->nextmatchs->left($urlname,$start,$tg,$extra_parms),
			'nmr'			=> $GLOBALS['phpgw']->nextmatchs->right($urlname,$start,$tg,$extra_parms),
			'title'			=> lang('Newsgroups'),
			'action_url'		=> $GLOBALS['phpgw']->link('/nntp/preferences.php'),
			'common_hidden_vars'	=> $common_hidden_vars,
			'th_bg'			=> $GLOBALS['phpgw_info']['theme']['th_bg'],
			'th_font'		=> $GLOBALS['phpgw_info']['theme']['font'],
			'sort_con'		=> $GLOBALS['phpgw']->nextmatchs->show_sort_order($sort,'1',$order,$urlname,' # ','&tg='.$tg),
			'sort_group'		=> $GLOBALS['phpgw']->nextmatchs->show_sort_order($sort,'2',$order,$urlname,lang('Name'),'&tg='.$tg),
			'sort_active'		=> $GLOBALS['phpgw']->nextmatchs->show_sort_order($sort,'3',$order,$urlname,' '.lang('Active').' ','&tg='.$tg)
		));

	if(count($GLOBALS['phpgw_info']['user']['preferences']['nntp']))
	{
		foreach($GLOBALS['phpgw_info']['user']['preferences']['nntp'] as $group => $ignored)
		{
			$found[$group] = ' checked="checked"';
		}
	}

	foreach ( $nntpavail as $key => $value )
	{
		$tr_color = $GLOBALS['phpgw']->nextmatchs->alternate_row_color($tr_color);

		if (!$value['name'])
		{
			$value['name']  = '&nbsp;';
		}
		$p->set_var(array
			(
				'tr_color' => $tr_color,
				'con'      => $value['con'],
				'group'    => $value['name'],
				'active'   => '<input type="checkbox" name="nntplist[]" value="'.$value['con'].'"'.$found[$value['con']].'>'
			));

		$p->parse('rows','nntp_list',True);
	}

	$p->set_var(array
		(	
				'common_hidden_vars'	=>	$common_hidden_vars,
			'lang_update'	=> lang('update'),
			'checkmark'	=> $GLOBALS['phpgw']->common->get_image_path('email').'/check.gif'
		));

	$p->pparse('out','nntp');
	$GLOBALS['phpgw']->common->phpgw_footer();
?>
