# --
# Kernel/Language/sv.pm - Swedish language translation
# Copyright (C) 2004 Mats Eric Olausson <mats at synergy.se>
# Copyright (C) 2009 Mikael Mattsson" <Mikael.Mattsson at konsumvarmland.se>
# --
# $Id: sv.pm,v 1.72.2.4 2009/12/09 12:01:00 mb Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (AGPL). If you
# did not receive this file, see http://www.gnu.org/licenses/agpl.txt.
# --

package Kernel::Language::sv;

use strict;
use warnings;

use vars qw($VERSION);
$VERSION = qw($Revision: 1.72.2.4 $) [1];

sub Data {
    my $Self = shift;

    # $$START$$
    # Last translation file sync: Sat Jun 27 13:55:43 2009

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Year;)
    $Self->{DateFormat}          = '%D/%M %Y %T';
    $Self->{DateFormatLong}      = '%A %D. %B %Y %T';
    $Self->{DateFormatShort}     = '%D.%M.%Y';
    $Self->{DateInputFormat}     = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    $Self->{Translation} = {
        # Template: AAABase
        'Yes' => 'Ja',
        'No' => 'Nej',
        'yes' => 'ja',
        'no' => 'inga',
        'Off' => 'Av',
        'off' => 'av',
        'On' => 'P',
        'on' => 'p',
        'top' => 'topp',
        'end' => 'slut',
        'Done' => 'Klar',
        'Cancel' => 'Avbryt',
        'Reset' => 'Nollstll',
        'last' => 'sista',
        'before' => 'fre',
        'day' => 'dag',
        'days' => 'dagar',
        'day(s)' => 'dag(ar)',
        'hour' => 'timme',
        'hours' => 'timmar',
        'hour(s)' => '',
        'minute' => 'minut',
        'minutes' => 'minuter',
        'minute(s)' => 'minut(er)',
        'month' => 'mnad',
        'months' => 'mnader',
        'month(s)' => 'mnad(er)',
        'week' => 'vecka',
        'week(s)' => 'vecka(or)',
        'year' => 'r',
        'years' => 'r',
        'year(s)' => 'r',
        'second(s)' => 'sekund(er)',
        'seconds' => 'sekunder',
        'second' => 'sekund',
        'wrote' => 'skrev',
        'Message' => 'Meddelande',
        'Error' => 'Fel',
        'Bug Report' => 'Rapportera fel',
        'Attention' => 'OBS',
        'Warning' => 'Varning',
        'Module' => 'Modul',
        'Modulefile' => 'Modulfil',
        'Subfunction' => 'Underfunktion',
        'Line' => 'Rad',
        'Setting' => 'Instllning',
        'Settings' => 'Instllningar',
        'Example' => 'Exempel',
        'Examples' => 'Exempel',
        'valid' => 'giltig',
        'invalid' => 'ogiltig',
        '* invalid' => '* ogiltlig',
        'invalid-temporarily' => '* ogiltlig-tillflligt',
        ' 2 minutes' => ' 2 minuter',
        ' 5 minutes' => ' 5 minuter',
        ' 7 minutes' => ' 7 minuter',
        '10 minutes' => '10 minuter',
        '15 minutes' => '15 minuter',
        'Mr.' => 'Mr.',
        'Mrs.' => 'Mrs.',
        'Next' => 'Nsta',
        'Back' => 'Tillbaka',
        'Next...' => 'Nsta...',
        '...Back' => '...Tillbaka',
        '-none-' => '-inga-',
        'none' => 'inga',
        'none!' => 'inga!',
        'none - answered' => 'inga - besvarat',
        'please do not edit!' => 'Var vnlig och ndra inte detta!',
        'AddLink' => 'Lgg till lnk',
        'Link' => 'Lnk',
        'Unlink' => 'Avlnka',
        'Linked' => 'Lnkat',
        'Link (Normal)' => 'Lnk (Normal)',
        'Link (Parent)' => 'Lnk (Frlder)',
        'Link (Child)' => 'Lnk (Barn)',
        'Normal' => 'Normal',
        'Parent' => 'Frlder',
        'Child' => 'Barn',
        'Hit' => 'Trff',
        'Hits' => 'Trffar',
        'Text' => 'Text',
        'Lite' => 'Enkel',
        'User' => 'Anvndare',
        'Username' => 'Anvndarnamn',
        'Language' => 'Sprk',
        'Languages' => 'Sprk',
        'Password' => 'Lsenord',
        'Salutation' => 'Hlsning',
        'Signature' => 'Signatur',
        'Customer' => 'Kund',
        'CustomerID' => 'KundID',
        'CustomerIDs' => 'KundIDn',
        'customer' => 'kund',
        'agent' => 'agent',
        'system' => 'System',
        'Customer Info' => 'Kundinfo',
        'Customer Company' => 'Kundfretag',
        'Company' => 'Fretag',
        'go!' => 'Starta!',
        'go' => 'Starta',
        'All' => 'Alla',
        'all' => 'alla',
        'Sorry' => 'Beklagar',
        'update!' => 'Uppdatera!',
        'update' => 'uppdatera',
        'Update' => 'Uppdatera',
        'Updated!' => 'Uppdaterad!',
        'submit!' => 'Skicka!',
        'submit' => 'Skicka',
        'Submit' => 'Skicka',
        'change!' => 'ndra!',
        'Change' => 'ndra',
        'change' => 'ndra',
        'click here' => 'klicka hr',
        'Comment' => 'Kommentar',
        'Valid' => 'Giltigt',
        'Invalid Option!' => 'Ogiltligt val!',
        'Invalid time!' => 'Ogiltlig tid!',
        'Invalid date!' => 'Ogiltligt datum!',
        'Name' => 'Namn',
        'Group' => 'Grupp',
        'Description' => 'Beskrivning',
        'description' => 'beskrivning',
        'Theme' => 'Tema',
        'Created' => 'Skapat',
        'Created by' => 'Skapat av',
        'Changed' => 'ndrat',
        'Changed by' => 'ndrat av',
        'Search' => 'Sk',
        'and' => 'och',
        'between' => 'mellan',
        'Fulltext Search' => 'Fulltextskning',
        'Data' => 'Data',
        'Options' => 'Tillval',
        'Title' => 'Titel',
        'Item' => 'Enhet',
        'Delete' => 'Radera',
        'Edit' => 'Redigera',
        'View' => 'Bild',
        'Number' => 'Nummer',
        'System' => 'System',
        'Contact' => 'Kontakt',
        'Contacts' => 'Kontakter',
        'Export' => 'Exportera',
        'Up' => 'Upp',
        'Down' => 'Ner',
        'Add' => 'Lgg till',
        'Added!' => 'Tillagd',
        'Category' => 'Kategori',
        'Viewer' => 'Bevakare',
        'Expand' => 'Expandera',
        'New message' => 'Nytt meddelande',
        'New message!' => 'Nytt meddelande!',
        'Please answer this ticket(s) to get back to the normal queue view!' => 'Vnligen besvara denna/dessa renden fr att komma tillbaka till den normala k-visningsbilden!',
        'You got new message!' => 'Du har ftt ett nytt meddelande!',
        'You have %s new message(s)!' => 'Du har %s nya meddelanden!',
        'You have %s reminder ticket(s)!' => 'Du har %s pminnelse-rende(n)!',
        'The recommended charset for your language is %s!' => 'Den rekommenderade teckenuppsttningen fr ditt sprk r %s!',
        'Passwords doesn\'t match! Please try it again!' => 'Lsenorden r inte lika! Gr ett nytt frsk!',
        'Password is already in use! Please use an other password!' => 'Lsenordet anvnds redan! Anvnd ett annat lsenord!',
        'Password is already used! Please use an other password!' => 'Lsenordet har redan anvnts! Anvnd ett annat lsenord!',
        'You need to activate %s first to use it!' => 'Du mste aktivera %s frst fr att kunna anvnda det!',
        'No suggestions' => 'Inga frslag',
        'Word' => 'Ord',
        'Ignore' => 'Ignorera',
        'replace with' => 'Erstt med',
        'There is no account with that login name.' => 'Det finns inget konto med detta namn.',
        'Login failed! Your username or password was entered incorrectly.' => 'Inloggningen misslyckades! Angivet anvndarnamn och/eller lsenord r inte korrekt.',
        'Please contact your admin' => 'Vnligen kontakta administratren',
        'Logout successful. Thank you for using OTRS!' => 'Utloggningen lyckades.  Tack fr att du anvnde OTRS!',
        'Invalid SessionID!' => 'Ogiltigt SessionID!',
        'Feature not active!' => 'Funktion inte aktiverad!',
        'Notification (Event)' => 'Meddelande (Akitivtet)',
        'Login is needed!' => 'Inloggning krvs!',
        'Password is needed!' => 'Lsenord krvs!',
        'License' => 'Licens',
        'Take this Customer' => 'Vlj denna kund',
        'Take this User' => 'Vlj denna anvndare',
        'possible' => 'mjlig',
        'reject' => 'Avvisas',
        'reverse' => 'baklnges',
        'Facility' => 'Innrttning',
        'Timeover' => 'Tidsvertrdelse',
        'Pending till' => 'Vntande tills',
        'Don\'t work with UserID 1 (System account)! Create new users!' => 'Det r inte rekommenderat att arbeta som userid 1 (systemkonto)! Skapa nya anvndare!',
        'Dispatching by email To: field.' => 'Skickar ivg enligt epostmeddelandets Till:-flt.',
        'Dispatching by selected Queue.' => 'Skickar ivg enligt vald k.',
        'No entry found!' => 'Ingen inmatning funnen!',
        'Session has timed out. Please log in again.' => 'Sessionstiden har lpt ut.  Vnligen logga p igen.',
        'No Permission!' => 'Ej Behrig!',
        'To: (%s) replaced with database email!' => 'Till: (%s) ersatt med epost frn databas!',
        'Cc: (%s) added database email!' => 'Cc: (.s) tillagd med epost frn databas.',
        '(Click here to add)' => '(Klicka hr fr att lgga till)',
        'Preview' => 'Forhandsvisning',
        'Package not correctly deployed! You should reinstall the Package again!' => 'Paketet r inte korrekt installerat! Du br installera om det!',
        'Added User "%s"' => 'La till Anvndare "%s"',
        'Contract' => 'Kontrakt',
        'Online Customer: %s' => 'Kund online: %s',
        'Online Agent: %s' => 'Agent online: %s',
        'Calendar' => 'Kalender',
        'File' => 'Fil',
        'Filename' => 'Filnamn',
        'Type' => 'Typ',
        'Size' => 'Storlek',
        'Upload' => 'Ladda upp',
        'Directory' => 'Katalog',
        'Signed' => 'Signatur',
        'Sign' => 'Signerat',
        'Crypted' => 'Krypterat',
        'Crypt' => 'Kryptering',
        'Office' => 'Kontor',
        'Phone' => 'Telefon',
        'Fax' => 'Fax',
        'Mobile' => 'Mobil',
        'Zip' => 'Postnr',
        'City' => 'Stad',
        'Street' => 'Gata',
        'Country' => 'Land',
        'Location' => 'Plats',
        'installed' => 'installerad',
        'uninstalled' => 'avinstallerad',
        'Security Note: You should activate %s because application is already running!' => 'Skerhetsinfo: Du br aktivera %s fr programmet krs redan!',
        'Unable to parse Online Repository index document!' => 'Kan inte hantera onlinelagringens indexdokument',
        'No Packages for requested Framework in this Online Repository, but Packages for other Frameworks!' => 'Inga Paket fr valt Ramverk i det hr Online-Repositoryt, men paket fr andra Ramverk!',
        'No Packages or no new Packages in selected Online Repository!' => 'Inga Paket eller inga nya Paket i valt Online-Repository',
        'printed at' => 'utskriven vid',
        'Dear Mr. %s,' => 'Bste Herr %s,',
        'Dear Mrs. %s,' => 'Bste Fru %s,',
        'Dear %s,' => 'Bste %s,',
        'Hello %s,' => 'Hej %s,',
        'This account exists.' => 'Kontot finns.',
        'New account created. Sent Login-Account to %s.' => 'Nytt konto skapat. Skickade inloggningsuppgifter till %s',
        'Please press Back and try again.' => 'Tryck p baktknappen och frsk igen.',
        'Sent password token to: %s' => 'Skickade lsenordsinfo till: %s',
        'Sent new password to: %s' => 'Skickade nytt lsenord till: %s',
        'Upcoming Events' => 'Kommande Evenemang',
        'Event' => 'Evenemang',
        'Events' => 'Evenemang',
        'Invalid Token!' => 'Ogiltlig inmatning!',
        'more' => 'mer',
        'For more info see:' => 'Fr mer info:',
        'Package verification failed!' => 'Paketverifiering misslyckades!',
        'Collapse' => 'Kollapsa',
        'News' => 'Nyheter',
        'Product News' => 'Produktnyheter',
        'Bold' => 'Fet',
        'Italic' => 'Kursiv',
        'Underline' => 'Understruket',
        'Font Color' => 'Typsnittsfrg',
        'Background Color' => 'Bakgrundsfrg',
        'Remove Formatting' => 'Radera Formatering',
        'Show/Hide Hidden Elements' => 'Visa/Dlj dolda element',
        'Align Left' => 'Vnsterstll',
        'Align Center' => 'Centrera',
        'Align Right' => 'Hgerstll',
        'Justify' => 'Justera',
        'Header' => 'Huvud',
        'Indent' => 'indrag',
        'Outdent' => 'utdrag',
        'Create an Unordered List' => 'Skapa en Osorterad Lista',
        'Create an Ordered List' => 'Skapa en Sorterad Lista',
        'HTML Link' => 'HTML-Lnk',
        'Insert Image' => 'Infoga Bild',
        'CTRL' => 'CTRL',
        'SHIFT' => 'SHIFT',
        'Undo' => 'ngra',
        'Redo' => 'Gr om',

        # Template: AAAMonth
        'Jan' => 'jan',
        'Feb' => 'feb',
        'Mar' => 'mar',
        'Apr' => 'apr',
        'May' => 'maj',
        'Jun' => 'jun',
        'Jul' => 'jul',
        'Aug' => 'aug',
        'Sep' => 'sep',
        'Oct' => 'okt',
        'Nov' => 'nov',
        'Dec' => 'dec',
        'January' => 'Januari',
        'February' => 'Februari',
        'March' => 'Mars',
        'April' => 'April',
        'May_long' => 'Maj',
        'June' => 'Juni',
        'July' => 'Juli',
        'August' => 'Augusti',
        'September' => 'September',
        'October' => 'Oktober',
        'November' => 'November',
        'December' => 'December',

        # Template: AAANavBar
        'Admin-Area' => 'Administrationsrelaterat',
        'Agent-Area' => 'Agentrelaterat',
        'Ticket-Area' => 'renden',
        'Logout' => 'Logga ut',
        'Agent Preferences' => 'Agentinstllningar',
        'Preferences' => 'Instllningar',
        'Agent Mailbox' => 'Agentmailbox',
        'Stats' => 'Statistik',
        'Stats-Area' => 'Statistik',
        'Admin' => 'Administration',
        'Customer Users' => 'Kundanvndare',
        'Customer Users <-> Groups' => 'Kundanvndare <-> Grupper',
        'Users <-> Groups' => 'Anvndare <-> Grupper',
        'Roles' => 'Roller',
        'Roles <-> Users' => 'Roller <-> Anvndare',
        'Roles <-> Groups' => 'Roller <-> Grupper',
        'Salutations' => 'Hlsningar',
        'Signatures' => 'Signaturer',
        'Email Addresses' => 'Epostadresser',
        'Notifications' => 'Meddelanden',
        'Category Tree' => 'Kategoritrd',
        'Admin Notification' => 'Admin-meddelanden',

        # Template: AAAPreferences
        'Preferences updated successfully!' => 'Instllningar lagrade!',
        'Mail Management' => 'Eposthantering',
        'Frontend' => 'Grnssnitt',
        'Other Options' => 'Andra tillval',
        'Change Password' => 'Byt lsenord',
        'New password' => 'Nytt lsenord',
        'New password again' => 'Nytt lsenord (igen)',
        'Select your QueueView refresh time.' => 'Vlj automatisk uppdateringsintervall fr K-bild.',
        'Select your frontend language.' => 'Vlj sprk.',
        'Select your frontend Charset.' => 'Vlj teckenuppsttning.',
        'Select your frontend Theme.' => 'Vlj stil-tema.',
        'Select your frontend QueueView.' => 'Vlj K-bild.',
        'Spelling Dictionary' => 'Stavningslexikon',
        'Select your default spelling dictionary.' => 'Vlj standard ordbok for stavningskontroll.',
        'Max. shown Tickets a page in Overview.' => 'Max. visade renden per sida i versikt.',
        'Can\'t update password, your new passwords do not match! Please try again!' => 'Kan inte lsenordet, lsenorden r inte lika! Frsk igen!',
        'Can\'t update password, invalid characters!' => 'Kan inte ndra lsenordet, du har anvnt ogiltliga tecken!',
        'Can\'t update password, must be at least %s characters!' => 'Kan inte ndra lsenordet, det mste vara minst %s tecken lngt! ',
        'Can\'t update password, must contain 2 lower and 2 upper characters!' => 'Kan inte ndra lsenordet, det mste innehlla minst tv gemener och tv versaler! ',
        'Can\'t update password, needs at least 1 digit!' => 'Kan inte ndra lsenordet, det krvs minst en siffra!',
        'Can\'t update password, needs at least 2 characters!' => 'Kan inte ndra lsenordet, det krvs minst tv bokstver!',

        # Template: AAAStats
        'Stat' => 'Statistik',
        'Please fill out the required fields!' => 'Fyll i de tvingande flten!',
        'Please select a file!' => 'Vlj en fil!',
        'Please select an object!' => 'Vlj ett objekt!',
        'Please select a graph size!' => 'Vlj en grafstorlek!',
        'Please select one element for the X-axis!' => 'Vlj ett av elementen fr X-axeln!',
        'Please select only one element or turn off the button \'Fixed\' where the select field is marked!' => 'Vlj endast ett element, eller stng av flaggan \'Fast\' dr den r markerad!',
        'If you use a checkbox you have to select some attributes of the select field!' => 'Om du anvnder en bockruta mste du vlja ngot av attributen fr det valda fltet!',
        'Please insert a value in the selected input field or turn off the \'Fixed\' checkbox!' => 'Infoga ett vrde i valt flt, eller bocka ur \'Fast\' -rutan',
        'The selected end time is before the start time!' => 'Vald sluttid r fre starttiden!',
        'You have to select one or more attributes from the select field!' => 'Du mste vlja ett eller flera attribut i valt flt!',
        'The selected Date isn\'t valid!' => 'Valt datum r inte giltligt!',
        'Please select only one or two elements via the checkbox!' => 'Vlj bara ett eller tv element via bockrutan!',
        'If you use a time scale element you can only select one element!' => 'Om du anvnder en tidsskala kan du bara vlja ett element!',
        'You have an error in your time selection!' => 'Du har ett fel i ditt tidsval!',
        'Your reporting time interval is too small, please use a larger time scale!' => 'Ditt rapporteringsintervall r fr litet, anvnd en strre tidsskala',
        'The selected start time is before the allowed start time!' => 'Vald starttid r innan den tilltna starttiden!',
        'The selected end time is after the allowed end time!' => 'Vald sluttid r efter den tilltna sluttiden!',
        'The selected time period is larger than the allowed time period!' => 'Vald tidsperiod r strre n den tilltna tidsperioden!',
        'Common Specification' => 'Vanlig Spec.',
        'Xaxis' => 'X-axel',
        'Value Series' => 'Vrdeserie',
        'Restrictions' => 'Begrnsningar',
        'graph-lines' => 'graf-linjer',
        'graph-bars' => 'graf-block',
        'graph-hbars' => 'graf-hblock',
        'graph-points' => 'graf-punkter',
        'graph-lines-points' => 'graf-linjer-punkter',
        'graph-area' => 'graf-area',
        'graph-pie' => 'graf-paj',
        'extended' => 'utkad',
        'Agent/Owner' => 'Agent/gare',
        'Created by Agent/Owner' => 'Skapad av Agent/gare',
        'Created Priority' => 'Skapad Prioritet',
        'Created State' => 'Skapad Status',
        'Create Time' => 'Skapad Tid',
        'CustomerUserLogin' => 'KundAnvndarLogin',
        'Close Time' => 'StngTid',
        'TicketAccumulation' => 'rendeackumulering',
        'Attributes to be printed' => 'Attribut som skall skrivas ut',
        'Sort sequence' => 'Sorteringssekvens',
        'Order by' => 'Sortera efter',
        'Limit' => 'Grns',
        'Ticketlist' => 'rendelista',
        'ascending' => 'stigande',
        'descending' => 'fallande',
        'First Lock' => 'Frsta Ls',
        'Evaluation by' => 'Utvrdering av',
        'Total Time' => 'Total Tid',
        'Ticket Average' => 'rende Medel',
        'Ticket Min Time' => 'rende Min Tid',
        'Ticket Max Time' => 'rende Max Tid',
        'Number of Tickets' => 'Antal renden',
        'Article Average' => 'Artikel Medel',
        'Article Min Time' => 'Artikel Min Tid',
        'Article Max Time' => 'Artikel Max tid',
        'Number of Articles' => 'Antal Artiklar',
        'Accounted time by Agent' => 'Redovisad tid per Agent',
        'Ticket/Article Accounted Time' => 'rende/Artikel Redovisad Tid',
        'TicketAccountedTime' => 'rendeRedovisadTid',
        'Ticket Create Time' => 'rende Skapad Tid',
        'Ticket Close Time' => 'rende Stngt Tid',

        # Template: AAATicket
        'Lock' => 'Ls',
        'Unlock' => 'Ls upp',
        'History' => 'Historik',
        'Zoom' => 'Zooma',
        'Age' => 'lder',
        'Bounce' => 'Studsa',
        'Forward' => 'Vidarebefordra',
        'From' => 'Frn',
        'To' => 'Till',
        'Cc' => 'Kopia',
        'Bcc' => 'Dold kopia',
        'Subject' => 'mne',
        'Move' => 'Flytta',
        'Queue' => 'K',
        'Priority' => 'Prioritet',
        'Priority Update' => 'ndra Prioritet',
        'State' => 'Status',
        'Compose' => 'Frfatta',
        'Pending' => 'Vntande',
        'Owner' => 'gare',
        'Owner Update' => 'ndra gare',
        'Responsible' => 'Ansvarig',
        'Responsible Update' => 'ndra Ansvarig',
        'Sender' => 'Avsndare',
        'Article' => 'Artikel',
        'Ticket' => 'rende',
        'Createtime' => 'Tidpunkt fr skapande',
        'plain' => 'r',
        'Email' => 'Epost',
        'email' => 'epost',
        'Close' => 'Stng',
        'Action' => 'tgrd',
        'Attachment' => 'Bifogat dokument',
        'Attachments' => 'Bifogade dokument',
        'This message was written in a character set other than your own.' => 'Detta meddelande r skrivet med en annan teckenuppsttning n den du anvnder.',
        'If it is not displayed correctly,' => 'Ifall det inte visas korrekt,',
        'This is a' => 'Detta r en',
        'to open it in a new window.' => 'fr att ppna i ett nytt fnster',
        'This is a HTML email. Click here to show it.' => 'Detta r ett HTML-email. Klicka hr fr att visa.',
        'Free Fields' => 'Fria Flt',
        'Merge' => 'Sammanfoga',
        'merged' => 'sammanfogat',
        'closed successful' => 'Lst och stngt',
        'closed unsuccessful' => 'Olst men stngt',
        'new' => 'ny',
        'open' => 'ppen',
        'Open' => 'ppen',
        'closed' => 'stngt',
        'Closed' => 'Stngt',
        'removed' => 'borttagen',
        'pending reminder' => 'vntar p pminnelse',
        'pending auto' => 'vntar p auto',
        'pending auto close+' => 'vntar p att stngas (lst)',
        'pending auto close-' => 'vntar p att stngas (olst)',
        'email-external' => 'email externt',
        'email-internal' => 'email internt',
        'note-external' => 'notis externt',
        'note-internal' => 'notis internt',
        'note-report' => 'notis till rapport',
        'phone' => 'telefon',
        'sms' => 'sms',
        'webrequest' => 'web-anmodan',
        'lock' => 'lst',
        'unlock' => 'upplst',
        'very low' => 'planeras',
        'low' => 'lg',
        'normal' => 'normal',
        'high' => 'hg',
        'very high' => 'kritisk',
        '1 very low' => '1 Planeras',
        '2 low' => '2 lg',
        '3 normal' => '3 medium',
        '4 high' => '4 hg',
        '5 very high' => '5 kritisk',
        'Ticket "%s" created!' => 'rende "%s" skapad!',
        'Ticket Number' => 'rendenummer',
        'Ticket Object' => 'rendeobjekt',
        'No such Ticket Number "%s"! Can\'t link it!' => 'rendenummer "%s" finns inte, kan inte lnka dit!',
        'Don\'t show closed Tickets' => 'Visa inte stngda renden',
        'Show closed Tickets' => 'Visa stngda renden',
        'New Article' => 'Ny artikel',
        'Email-Ticket' => 'Epostrende',
        'Create new Email Ticket' => 'Skapa nytt Epostrende',
        'Phone-Ticket' => 'Telefonrende',
        'Search Tickets' => 'Sk renden',
        'Edit Customer Users' => 'Redigera Kundanvndare',
        'Edit Customer Company' => 'Redigera Kundfretag',
        'Bulk Action' => 'Massfrndring',
        'Bulk Actions on Tickets' => 'Massfrndring av renden',
        'Send Email and create a new Ticket' => 'Skicka Epost och skapa nytt rende',
        'Create new Email Ticket and send this out (Outbound)' => 'Skapa nytt Epostrende och skicka detta (Utgende)',
        'Create new Phone Ticket (Inbound)' => 'Skapa nytt Telefonrende (Inkommande)',
        'Overview of all open Tickets' => 'versikt ver alla ppna renden',
        'Locked Tickets' => 'Lsta renden',
        'Watched Tickets' => 'Bevakade renden',
        'Watched' => 'Bevakade',
        'Subscribe' => 'Bevaka',
        'Unsubscribe' => 'Bevaka inte',
        'Lock it to work on it!' => 'Ls rende fr att arbeta med det!',
        'Unlock to give it back to the queue!' => 'Ls upp fr att lgga tillbaka rendet till kn!',
        'Shows the ticket history!' => 'Visar rendehistoriken!',
        'Print this ticket!' => 'Skriv ut detta rende!',
        'Change the ticket priority!' => 'ndra rendets prioritet!',
        'Change the ticket free fields!' => 'ndra rendets fria flt!',
        'Link this ticket to an other objects!' => 'Koppla rendet till andra objekt!',
        'Change the ticket owner!' => 'ndra rendets gare!',
        'Change the ticket customer!' => 'ndra rendets kund!',
        'Add a note to this ticket!' => 'Lgg till en notis p rendet!',
        'Merge this ticket!' => 'Sl samman rendet!',
        'Set this ticket to pending!' => 'Stt rendet som vntande!',
        'Close this ticket!' => 'Stng rendet!',
        'Look into a ticket!' => 'Visa rendet!',
        'Delete this ticket!' => 'Radera rendet!',
        'Mark as Spam!' => 'Markera som SPAM!',
        'My Queues' => 'Mina ker',
        'Shown Tickets' => 'Visade renden',
        'Your email with ticket number "<OTRS_TICKET>" is merged to "<OTRS_MERGE_TO_TICKET>".' => 'Ditt epostrende med nummer "<OTRS_TICKET>" har slagits samman med "<OTRS_MERGE_TO_TICKET>".',
        'Ticket %s: first response time is over (%s)!' => 'rende %s: frsta tgrdstid har passerats (%s)!',
        'Ticket %s: first response time will be over in %s!' => 'rende %s: frsta tgrdstid har passerats om %s!',
        'Ticket %s: update time is over (%s)!' => 'rende %s: uppdateringstid har passerats (%s)!',
        'Ticket %s: update time will be over in %s!' => 'rende %s: uppdateringstid har passerats om %s!',
        'Ticket %s: solution time is over (%s)!' => 'rende %s: lsningstid har passerats (%s)!',
        'Ticket %s: solution time will be over in %s!' => 'rende %s: lsningstid har passerats om %s!',
        'There are more escalated tickets!' => 'Det finns fler eskalerade renden!',
        'New ticket notification' => 'Meddelande om nyskapat rende',
        'Send me a notification if there is a new ticket in "My Queues".' => 'Skicka mig ett meddelande om det finns nya renden i "Mina Ker".',
        'Follow up notification' => 'Meddelande om uppfljning',
        'Send me a notification if a customer sends a follow up and I\'m the owner of the ticket or the ticket is unlocked and is in one of my subscribed queues.' => 'Skicka mig ett meddelande om kundkorrespondens fr renden som jag r gare till.',
        'Ticket lock timeout notification' => 'Meddela mig d tiden gtt ut fr ett rende-ls',
        'Send me a notification if a ticket is unlocked by the system.' => 'Skicka mig ett meddelande ifall systemet tar bort lset p ett rende.',
        'Move notification' => 'Meddelande om ndring av k',
        'Send me a notification if a ticket is moved into one of "My Queues".' => 'Skicka mig ett meddelande ifall ett rende flyttas till en av "Mina ker"',
        'Your queue selection of your favourite queues. You also get notified about those queues via email if enabled.' => 'Ditt urval av favoritker. Du blir ocks meddelad om dessa ker via epost om det aktiverats.',
        'Custom Queue' => 'Utvald k',
        'QueueView refresh time' => 'Automatisk uppdateringsintervall f K-bild',
        'Screen after new ticket' => 'Skrm efter inmatning av nytt rende',
        'Select your screen after creating a new ticket.' => 'Vlj skrmbild som visas efter registrering av ny hnvisning/rende.',
        'Closed Tickets' => 'Lsta renden',
        'Show closed tickets.' => 'Visa lsta renden.',
        'Max. shown Tickets a page in QueueView.' => 'Max. visade renden per sida i K-bild.',
        'Watch notification' => 'Bevakningsmeddelanden',
        'Send me a notification of an watched ticket like an owner of an ticket.' => '',
        'Out Of Office' => 'Ej p Kontoret',
        'Select your out of office time.' => 'Vlj din fnvarotid.',
        'CompanyTickets' => 'Fretagsrenden',
        'MyTickets' => 'Mina renden',
        'New Ticket' => 'Nytt rende',
        'Create new Ticket' => 'Skapa nytt rende',
        'Customer called' => 'Kund ringde',
        'phone call' => 'telefonsamtal',
        'Reminder Reached' => 'Pminnelse Finns',
        'Reminder Tickets' => 'Pminnelse renden',
        'Escalated Tickets' => 'Eskalerade renden',
        'New Tickets' => 'Nya renden',
        'Open Tickets / Need to be answered' => 'ppna renden / Mste besvaras',
        'Tickets which need to be answered!' => 'renden som mste besvaras!',
        'All new tickets!' => 'Alla nya renden!',
        'All tickets which are escalated!' => 'Alla renden som har eskalerats!',
        'All tickets where the reminder date has reached!' => 'Alla renden dr pmminnelsetiden ntts!',
        'Responses' => 'Svar',
        'Responses <-> Queue' => 'Svar <-> K',
        'Auto Responses' => 'AutoSvar',
        'Auto Responses <-> Queue' => 'AutoSvar <-> K',
        'Attachments <-> Responses' => '<Bifogade filer <-> Svar',
        'History::Move' => 'Ticket moved into Queue "%s" (%s) from Queue "%s" (%s).',
        'History::TypeUpdate' => 'Updated Type to %s (ID=%s).',
        'History::ServiceUpdate' => 'Updated Service to %s (ID=%s).',
        'History::SLAUpdate' => 'Updated SLA to %s (ID=%s).',
        'History::NewTicket' => 'New Ticket [%s] created (Q=%s;P=%s;S=%s).',
        'History::FollowUp' => 'FollowUp for [%s]. %s',
        'History::SendAutoReject' => 'AutoReject sent to "%s".',
        'History::SendAutoReply' => 'AutoReply sent to "%s".',
        'History::SendAutoFollowUp' => 'AutoFollowUp sent to "%s".',
        'History::Forward' => 'Forwarded to "%s".',
        'History::Bounce' => 'Bounced to "%s".',
        'History::SendAnswer' => 'Email sent to "%s".',
        'History::SendAgentNotification' => '"%s"-notification sent to "%s".',
        'History::SendCustomerNotification' => 'Notification sent to "%s".',
        'History::EmailAgent' => 'Email sent to customer.',
        'History::EmailCustomer' => 'Added email. %s',
        'History::PhoneCallAgent' => 'Agent called customer.',
        'History::PhoneCallCustomer' => 'Customer called us.',
        'History::AddNote' => 'Added note (%s)',
        'History::Lock' => 'Locked ticket.',
        'History::Unlock' => 'Unlocked ticket.',
        'History::TimeAccounting' => '%s time unit(s) accounted. Now total %s time unit(s).',
        'History::Remove' => '%s',
        'History::CustomerUpdate' => 'Updated: %s',
        'History::PriorityUpdate' => 'Changed priority from "%s" (%s) to "%s" (%s).',
        'History::OwnerUpdate' => 'New owner is "%s" (ID=%s).',
        'History::LoopProtection' => 'Loop-Protection! No auto-response sent to "%s".',
        'History::Misc' => '%s',
        'History::SetPendingTime' => 'Updated: %s',
        'History::StateUpdate' => 'Old: "%s" New: "%s"',
        'History::TicketFreeTextUpdate' => 'Updated: %s=%s;%s=%s;',
        'History::WebRequestCustomer' => 'Customer request via web.',
        'History::TicketLinkAdd' => 'Added link to ticket "%s".',
        'History::TicketLinkDelete' => 'Deleted link to ticket "%s".',
        'History::Subscribe' => 'Added subscription for user "%s".',
        'History::Unsubscribe' => 'Removed subscription for user "%s".',

        # Template: AAAWeekDay
        'Sun' => 'sn',
        'Mon' => 'mn',
        'Tue' => 'tis',
        'Wed' => 'ons',
        'Thu' => 'tor',
        'Fri' => 'fre',
        'Sat' => 'lr',

        # Template: AdminAttachmentForm
        'Attachment Management' => 'Hantering av bifogade dokument',

        # Template: AdminAutoResponseForm
        'Auto Response Management' => 'Autosvar-hantering',
        'Response' => 'Svar',
        'Auto Response From' => 'autosvar-avsndare',
        'Note' => 'Notis',
        'Useable options' => 'Anvndbara tillgg',
        'To get the first 20 character of the subject.' => 'Fr att f dom frsta 20 tecknen i renderaden',
        'To get the first 5 lines of the email.' => 'Fr att f dom frsta fem raderna i mejlet',
        'To get the realname of the sender (if given).' => 'Fr att f avsndarens riktiga namn (om angivet).',
        'To get the article attribute (e. g. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> and <OTRS_CUSTOMER_Body>).' => 'Fr att f artikelns attribut (t.ex. (<OTRS_CUSTOMER_From>, <OTRS_CUSTOMER_To>, <OTRS_CUSTOMER_Cc>, <OTRS_CUSTOMER_Subject> och <OTRS_CUSTOMER_Body)).',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>).' => 'Val av nuvarande kunds data (t.ex. <OTRS_CUSTOMER_DATA_UserFirstname>).',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>).' => 'rende-garval (t.ex. <OTRS_OWNER_UserFirstname>).',
        'Ticket responsible options (e. g. <OTRS_RESPONSIBLE_UserFirstname>).' => 'rende-Ansvarigval (t.ex. <OTRS_RESPONSIBLE_USerFirstname>).',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>).' => 'Val fr anvndaren som begrde tgrden (t.ex. <OTRS_CURRENT_UserFirstname>).',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).' => 'Val fr rendedata (t.ex. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>).',
        'Config options (e. g. <OTRS_CONFIG_HttpType>).' => 'Instllningsval (t.ex. <OTRS_CONFIG_HttpType>).',

        # Template: AdminCustomerCompanyForm
        'Customer Company Management' => 'Kundfretagshantering',
        'Search for' => 'Sk efter',
        'Add Customer Company' => 'Lgg till Kundfretag',
        'Add a new Customer Company.' => 'Lgg till ett nytt Kundfretag.',
        'List' => 'Lista',
        'This values are required.' => 'Dessa vrden r tvingande.',
        'This values are read only.' => 'Dessa vrden r skrivskyddade.',

        # Template: AdminCustomerUserForm
        'The message being composed has been closed.  Exiting.' => 'Det tilhrande redigeringsfnstret har stngts. Avslutar.',
        'This window must be called from compose window' => 'Denna funktion mste startas frn redigeringsfnstret',
        'Customer User Management' => 'Kundanvndare',
        'Add Customer User' => 'Lgg till Kundanvndare',
        'Source' => 'Klla',
        'Create' => 'Skapa',
        'Customer user will be needed to have a customer history and to login via customer panel.' => 'Kundanvndare krvs fr att hlla kundhistorik och fr att dom ska kunna logga in via kundpanelen.',

        # Template: AdminCustomerUserGroupChangeForm
        'Customer Users <-> Groups Management' => 'Kundanvndare <-> Grupphantering',
        'Change %s settings' => 'ndra %s-instllningar',
        'Select the user:group permissions.' => 'Vlj anvndar:grupp-rttigheter.',
        'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Om ingenting r valt finns inga rttigheter i denna grupp (renden i denna grupp kommer inte att finnas tillgngliga fr anvndaren).',
        'Permission' => 'Rttighet',
        'ro' => 'ls',
        'Read only access to the ticket in this group/queue.' => 'Endast lsrttighet till renden i denna grupp/k.',
        'rw' => 'skriv',
        'Full read and write access to the tickets in this group/queue.' => 'Fulla ls- och skrivrttigheter till renden i denna grupp/k.',

        # Template: AdminCustomerUserGroupForm

        # Template: AdminCustomerUserService
        'Customer Users <-> Services Management' => 'Kundanvndare <-> Tjnsthantering',
        'CustomerUser' => 'Kundanvndare',
        'Service' => 'Tjnst',
        'Edit default services.' => 'Redigera standardtjnster',
        'Search Result' => 'Skeresultat',
        'Allocate services to CustomerUser' => 'Allokera tjnster till Kundanvndare',
        'Active' => 'Aktivera',
        'Allocate CustomerUser to service' => 'Allokera Kundanvndare till tjnst',

        # Template: AdminEmail
        'Message sent to' => 'Meddelande skickat till',
        'A message should have a subject!' => 'Ett meddelande mste ha en mnesrad!',
        'Recipients' => 'Mottagare',
        'Body' => 'Meddelandetext',
        'Send' => 'Skicka',

        # Template: AdminGenericAgent
        'GenericAgent' => 'GenerellAgent',
        'Job-List' => 'Jobblista',
        'Last run' => 'Senaste krning',
        'Run Now!' => 'Kr Nu!',
        'x' => 'x',
        'Save Job as?' => 'Spara Jobb som?',
        'Is Job Valid?' => 'r Jobbet Giltligt?',
        'Is Job Valid' => 'r Jobbet Giltligt',
        'Schedule' => 'Schema',
        'Currently this generic agent job will not run automatically.' => 'Fr nrvarande kommer detta jobb inte kras automatiskt.',
        'To enable automatic execution select at least one value from minutes, hours and days!' => 'Fr att aktivera automatisk krning mste du minst vlja ett vrde frn minuter, timmar och dagar!',
        'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Fritextsk i artiklar (t.ex. "Mo*ot" eller "Ktt*")',
        '(e. g. 10*5155 or 105658*)' => 't.ex. 10*5144 eller 105658*',
        '(e. g. 234321)' => 't.ex. 163736',
        'Customer User Login' => 'kundanvndare loginnamn',
        '(e. g. U5150)' => 't.ex. INGJAN',
        'SLA' => 'SLA',
        'Agent' => 'Agent',
        'Ticket Lock' => 'rendels',
        'TicketFreeFields' => 'rendeFriaFlt',
        'Create Times' => 'Skapat-Tider',
        'No create time settings.' => 'Inga Skapat-Tider.',
        'Ticket created' => 'rende skapat',
        'Ticket created between' => 'rendet skapat mellan',
        'Close Times' => 'Stngt-Tider',
        'No close time settings.' => 'Inga Stngt-Tider',
        'Ticket closed' => 'rende stngt',
        'Ticket closed between' => 'rende stngt mellan',
        'Pending Times' => 'Avvaktar-Tider',
        'No pending time settings.' => 'Inga Avvaktar-Tider',
        'Ticket pending time reached' => 'rende vntetid ndd',
        'Ticket pending time reached between' => 'rende vntetid ndd mellan',
        'Escalation Times' => 'Eskalerings-Tider',
        'No escalation time settings.' => 'Inga Eskalerings-Tider',
        'Ticket escalation time reached' => 'rende Eskaleringstid ndd',
        'Ticket escalation time reached between' => 'rende Eskaleringstid ndd mellan',
        'Escalation - First Response Time' => 'Eskalering - Frsta responstid',
        'Ticket first response time reached' => 'rende frsta responstid ndd',
        'Ticket first response time reached between' => 'rende frsta responstid ndd mellan',
        'Escalation - Update Time' => 'Eskalering - Uppdateringstid',
        'Ticket update time reached' => 'rende uppdateringstid ndd',
        'Ticket update time reached between' => 'rende uppdaterings tid ndd mellan',
        'Escalation - Solution Time' => 'Eskalering - Lsningstid',
        'Ticket solution time reached' => 'rende lsningstid ndd',
        'Ticket solution time reached between' => 'rende lsningstid ndd mellan',
        'New Service' => 'Ny tjnst',
        'New SLA' => 'Ny SLA',
        'New Priority' => 'Ny Prioritet',
        'New Queue' => 'Ny K',
        'New State' => 'Ny Status',
        'New Agent' => 'Ny Agent',
        'New Owner' => 'Ny gare',
        'New Customer' => 'Ny Kund',
        'New Ticket Lock' => 'Nytt rendels',
        'New Type' => 'Ny Typ',
        'New Title' => 'Ny Titel',
        'New TicketFreeFields' => 'Ny TicketFriaFlt',
        'Add Note' => 'Lgg till anteckning',
        'Time units' => 'Tidsenheter',
        'CMD' => 'CMD',
        'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => 'Detta kommando kommer utfras. ARG[0] blir dess rendenummer. ARG[1] dess rende-id.',
        'Delete tickets' => 'Radera renden',
        'Warning! This tickets will be removed from the database! This tickets are lost!' => 'Varning! Dessa renden kommer raderas frn databasen! rendena frloras!',
        'Send Notification' => 'Skicka Meddelande',
        'Param 1' => 'Param 1',
        'Param 2' => 'Param 2',
        'Param 3' => 'Param 3',
        'Param 4' => 'Param 4',
        'Param 5' => 'Param 5',
        'Param 6' => 'Param 6',
        'Send agent/customer notifications on changes' => 'Meddela agent/kund angende ndringar',
        'Save' => 'Spara',
        '%s Tickets affected! Do you really want to use this job?' => '%s renden pverkas! Vill du verkligen anvnda detta jobb?',

        # Template: AdminGroupForm
        'WARNING: When you change the name of the group \'admin\', before making the appropriate changes in the SysConfig, you will be locked out of the administrations panel! If this happens, please rename the group back to admin per SQL statement.' =>          'VARNING: Nr du ndrar namnet p gruppen \'admin\', innan du gr lmpliga ndringar i SysConfig, kommer du lsas ut ur administrationspanelen! Om detta intrffar, dp om grubben tillbaka till admin via SQL. ',
        'Group Management' => 'grupphantering',
        'Add Group' => 'Lgg till Grupp',
        'Add a new Group.' => 'Lgg till en ny Grupp.',
        'The admin group is to get in the admin area and the stats group to get stats area.' => '\'admin\'-gruppen ger tillgng till Admin-arean, \'stats\'-gruppen till Statistik-arean.',
        'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Skapa nya grupper fr att kunna hantera olika rttigheter fr skilda grupper av agenter (t.ex. inkpsavdelning, supportavdelning, frsljningsavdelning, ...).',
        'It\'s useful for ASP solutions.' => 'Nyttigt fr ASP-lsningar.',

        # Template: AdminLog
        'System Log' => 'Systemlogg',
        'Time' => 'Tid',

        # Template: AdminMailAccount
        'Mail Account Management' => 'Epostkontohantering',
        'Host' => 'Vrd',
        'Trusted' => 'Betrodd',
        'Dispatching' => 'Frdelning',
        'All incoming emails with one account will be dispatched in the selected queue!' => 'Inkommande email frn POP3-konton sorteras till vald k!',
        'If your account is trusted, the already existing X-OTRS header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => 'om ditt konto r betrott, kommer befinglig X-OTRS-header anvndas vid ankomst (Fr prioritering, ...) PostMasterfilter kommer anvndas nd.',

        # Template: AdminNavigationBar
        'Users' => 'Anvndare',
        'Groups' => 'Grupper',
        'Misc' => 'Div',

        # Template: AdminNotificationEventForm
        'Notification Management' => 'Meddelandehantering',
        'Add Notification' => 'Lgg till Meddelande',
        'Add a new Notification.' => 'Lgg till nytt Meddelande',
        'Name is required!' => 'Namn krvs!',
        'Event is required!' => 'Aktivitet krvs!',
        'A message should have a body!' => 'Ett meddelande mste innehlla en meddelandetext!',
        'Recipient' => 'Mottagare',
        'Group based' => 'Gruppbaserad',
        'Agent based' => 'Agentbaserad',
        'Email based' => 'Epostbaserad',
        'Article Type' => 'Artikeltyp',
        'Only for ArticleCreate Event.' => 'Endast fr ArtikelSkapa-Aktivitet',
        'Subject match' => 'renderad matchar',
        'Body match' => 'Kropp matchar',
        'Notifications are sent to an agent or a customer.' => 'Meddelanden skickats till agenter eller kunder.',
        'To get the first 20 character of the subject (of the latest agent article).' => 'Fr att f de frsta 20 tecknen i renderaden (p senaste agentartikeln).',
        'To get the first 5 lines of the body (of the latest agent article).' => 'Fr att f de frsta fem raderna i kroppen (p senaste agentartikeln).',
        'To get the article attribute (e. g. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> and <OTRS_AGENT_Body>).' => 'Fr att f artikelattributen (t.ex. (<OTRS_AGENT_From>, <OTRS_AGENT_To>, <OTRS_AGENT_Cc>, <OTRS_AGENT_Subject> och <OTRS_AGENT_Body>).',
        'To get the first 20 character of the subject (of the latest customer article).' => 'Fr att d de frsta 20 tecknen i renderaden (p senaste kundartikeln).',
        'To get the first 5 lines of the body (of the latest customer article).' => 'Fr att f de fem frsta raderna i kroppen (p senaste kundartikeln).',

        # Template: AdminNotificationForm
        'Notification' => 'Meddelande',

        # Template: AdminPackageManager
        'Package Manager' => 'Pakethanterare',
        'Uninstall' => 'Avinstallera',
        'Version' => 'Version',
        'Do you really want to uninstall this package?' => 'Vill du verkligen avinstallera detta paket?',
        'Reinstall' => 'Ominstallera',
        'Do you really want to reinstall this package (all manual changes get lost)?' => 'Vill du verligen ominstallera detta paket (Alla manuella ndringar frsvinner)?',
        'Continue' => 'Fortstt',
        'Install' => 'Installera',
        'Package' => 'Paket',
        'Online Repository' => 'Online Repository',
        'Vendor' => 'Leverantr',
        'Module documentation' => 'Moduldokumentation',
        'Upgrade' => 'Uppgradera',
        'Local Repository' => 'Local Repository',
        'Status' => 'Status',
        'Overview' => 'versikt',
        'Download' => 'Nerladdning',
        'Rebuild' => 'Rebuild',
        'ChangeLog' => 'ndringslogg',
        'Date' => 'Datum',
        'Filelist' => 'Fillista',
        'Download file from package!' => 'Ladda ner fil frn paket!',
        'Required' => 'Krvs',
        'PrimaryKey' => 'Primrnyckel',
        'AutoIncrement' => 'AutoInkrement',
        'SQL' => 'SQL',
        'Diff' => 'Diff',

        # Template: AdminPerformanceLog
        'Performance Log' => 'Prestandalogg',
        'This feature is enabled!' => 'Denna funktion r aktiverad!',
        'Just use this feature if you want to log each request.' => 'Anvnd endast denna funktion om du vill logga varje request.',
        'Activating this feature might affect your system performance!' => 'Att aktivera denna funktion kan pverka din systemprestanda!',
        'Disable it here!' => 'Avaktivera det hr!',
        'This feature is disabled!' => 'Denna funktion r avaktiverad!',
        'Enable it here!' => 'Aktivera den hr!',
        'Logfile too large!' => 'Loggfilen r fr stor!',
        'Logfile too large, you need to reset it!' => 'Loggfilen r fr stor, du mste terstlla den!',
        'Range' => 'Intervall',
        'Interface' => 'Interface',
        'Requests' => 'Requests',
        'Min Response' => 'Min respons',
        'Max Response' => 'Max respons',
        'Average Response' => 'Medel respons',
        'Period' => 'Period',
        'Min' => 'Min',
        'Max' => 'Max',
        'Average' => 'Medel',

        # Template: AdminPGPForm
        'PGP Management' => 'PGP-Hantering',
        'Result' => 'Resultat',
        'Identifier' => 'Identifierare',
        'Bit' => 'Bit',
        'Key' => 'Nyckel',
        'Fingerprint' => 'Fingeravtryck',
        'Expires' => 'Upphr',
        'In this way you can directly edit the keyring configured in SysConfig.' => 'P det hr sttet kan du direkt redigera nyckelringen som r instlld i SysConfig.',

        # Template: AdminPostMasterFilter
        'PostMaster Filter Management' => 'PostMaster Filter',
        'Filtername' => 'Filternamn',
        'Stop after match' => 'Avsluta efter trff',
        'Match' => 'Trff',
        'Value' => 'Innehll',
        'Set' => 'Anvnd',
        'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => 'Snd eller filtrera inkommande epost baserad p X-Headers! RegExp r ocks mjlig.',
        'If you want to match only the email address, use EMAILADDRESS:info@example.com in From, To or Cc.' => 'Om du bara vill hantera epostadressen, anvnd EMAILADDRESS:info@example.com i Frn, Till eller CC.',
        'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => 'Om du anvnder RegExp, kan du ocks anvnda trffvrdet i ()= ssom [***] i \'Set\'.',

        # Template: AdminPriority
        'Priority Management' => 'Prioritet',
        'Add Priority' => 'Lgg till Prioritet',
        'Add a new Priority.' => 'Lgg till ny Prioritet.',

        # Template: AdminQueueAutoResponseForm
        'Queue <-> Auto Responses Management' => 'K <-> Autosvar',
        'settings' => 'instllningar',

        # Template: AdminQueueForm
        'Queue Management' => 'Khantering',
        'Sub-Queue of' => 'Underk till',
        'Unlock timeout' => 'Tidsintervall fr borttagning av ls',
        '0 = no unlock' => '0 = ingen upplsning',
        'Only business hours are counted.' => 'Endast kontorstid rknas.',
        '0 = no escalation' => '0 = ingen upptrappning',
        'Notify by' => 'Meddela via',
        'Follow up Option' => 'Korrespondens p lst rende',
        'Ticket lock after a follow up' => 'rendet lses efter uppfljningsmail',
        'Systemaddress' => 'Systemadress',
        'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Ifall ett rende som r lst av en agent men nd inte blir besvarat inom denna tid, kommer lset automatiskt att tas bort.',
        'Escalation time' => 'Upptrappningstid',
        'If a ticket will not be answered in this time, just only this ticket will be shown.' => 'Ifall ett rende inte blir besvarat inom denna tid, visas enbart detta rende.',
        'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Ifall en kund skickar uppfljningsmail p ett lst rende, blir rendet lst till frra garen.',
        'Will be the sender address of this queue for email answers.' => 'Avsndaradress fr email i denna K.',
        'The salutation for email answers.' => 'Hlsningsfras fr email-svar.',
        'The signature for email answers.' => 'Signatur fr email-svar.',
        'Customer Move Notify' => 'Meddelande om flytt av kund',
        'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS skickar ett meddelande till kunden ifall rendet flyttas.',
        'Customer State Notify' => 'Meddelande om statusndring fr Kund',
        'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS skickar ett meddelande till kunden vid statusuppdatering.',
        'Customer Owner Notify' => 'Meddelande om byte av gare av Kund',
        'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS skickar ett meddelande till kunden vid garbyte.',

        # Template: AdminQueueResponsesChangeForm
        'Responses <-> Queue Management' => 'Svar <-> Ker',

        # Template: AdminQueueResponsesForm
        'Answer' => 'Svar',

        # Template: AdminResponseAttachmentChangeForm
        'Responses <-> Attachments Management' => 'Svar <-> Bifogade filer',

        # Template: AdminResponseAttachmentForm

        # Template: AdminResponseForm
        'Response Management' => 'Hantera svar',
        'A response is default text to write faster answer (with default text) to customers.' => 'Ett svar r en standardtext fr att underltta besvarandet av vanliga kundfrgor.',
        'Don\'t forget to add a new response a queue!' => 'Kom ihg att lgga till ett nytt svar till en k!',
        'The current ticket state is' => 'Nuvarande rendestatus',
        'Your email address is new' => 'Din epostadress r ny',

        # Template: AdminRoleForm
        'Role Management' => 'Roller',
        'Add Role' => 'Lgg till Roll',
        'Add a new Role.' => 'Lgg till ny Roll.',
        'Create a role and put groups in it. Then add the role to the users.' => 'Skapa en roll och lgg grupper i den. Lgg sedan till rollen till anvndare.',
        'It\'s useful for a lot of users and groups.' => 'Det r anvndbart fr mnga anvndare och grupper.',

        # Template: AdminRoleGroupChangeForm
        'Roles <-> Groups Management' => 'Roller <-> Grupper',
        'move_into' => 'Flytta till',
        'Permissions to move tickets into this group/queue.' => 'Rtt att flytta renden i denna grupp/K.',
        'create' => 'Skapa',
        'Permissions to create tickets in this group/queue.' => 'Rtt att skapa renden i denna grupp/K.',
        'owner' => 'gare',
        'Permissions to change the ticket owner in this group/queue.' => 'Rtt att ndra rende-gare i denna grupp/K.',
        'priority' => 'prioritet',
        'Permissions to change the ticket priority in this group/queue.' => 'Rtt att ndra rendeprioritet i denna grupp/K.',

        # Template: AdminRoleGroupForm
        'Role' => 'Roll',

        # Template: AdminRoleUserChangeForm
        'Roles <-> Users Management' => 'Roller <-> Anvndare',
        'Select the role:user relations.' => 'Vlj roll:anvndar relationer',

        # Template: AdminRoleUserForm

        # Template: AdminSalutationForm
        'Salutation Management' => 'Hantering av Hlsningsfraser',
        'Add Salutation' => 'Lgg till Hlsningsfras',
        'Add a new Salutation.' => 'Lgg till en ny Hlsningsfras.',

        # Template: AdminSecureMode
        'Secure Mode need to be enabled!' => 'Skert lge mste sls p!',
        'Secure mode will (normally) be set after the initial installation is completed.' => 'Skert lge anvnda (normalt) efter iledande installation r slutfrd.',
        'Secure mode must be disabled in order to reinstall using the web-installer.' => 'Skert lge mste sls av fr att kunna ominstallera via webb-installeraren.',
        'If Secure Mode is not activated, activate it via SysConfig because your application is already running.' => 'Om skert lge inte r aktiverat, sl p det via SysConfig, fr din applikation krs redan.',

        # Template: AdminSelectBoxForm
        'SQL Box' => 'SQL Box',
        'Go' => 'Kr',
        'Select Box Result' => 'Select Box Resultat',

        # Template: AdminService
        'Service Management' => 'Tjnster',
        'Add Service' => 'Lgg till Tjnst',
        'Add a new Service.' => 'Lgg till ny Tjnst.',
        'Sub-Service of' => 'UnderTjnst till',

        # Template: AdminSession
        'Session Management' => 'Sessionshantering',
        'Sessions' => 'Sessioner',
        'Uniq' => 'Unika',
        'Kill all sessions' => 'Terminera alla sessioner',
        'Session' => 'Session',
        'Content' => 'Innehll',
        'kill session' => 'Terminera session',

        # Template: AdminSignatureForm
        'Signature Management' => 'Signaturer',
        'Add Signature' => 'Lgg till Signatur',
        'Add a new Signature.' => 'Lgg till ny Signatur.',

        # Template: AdminSLA
        'SLA Management' => 'SLA',
        'Add SLA' => 'Lgg till SLA',
        'Add a new SLA.' => 'Lgg till ny SLA.',

        # Template: AdminSMIMEForm
        'S/MIME Management' => 'S/MIME',
        'Add Certificate' => 'Lgg till Certifikat',
        'Add Private Key' => 'Lgg till Privat Nyckel',
        'Secret' => 'Hemlighet',
        'Hash' => 'Hash',
        'In this way you can directly edit the certification and private keys in file system.' => 'P det hr sttet kan du redigera certifikat och nycklar p filsystemet.',

        # Template: AdminStateForm
        'State Management' => 'Status',
        'Add State' => 'Lgg till Status',
        'Add a new State.' => 'Lgg till ny Status.',
        'State Type' => 'Statustyp',
        'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Se till att du ocks uppdaterade standardstatusarna i Kernel/Config.pm!',
        'See also' => 'Se ocks',

        # Template: AdminSysConfig
        'SysConfig' => 'SysConfig',
        'Group selection' => 'Gruppval',
        'Show' => 'Visa',
        'Download Settings' => 'Ladda ner instllningar',
        'Download all system config changes.' => 'Ladda ner alla systemkonfigurationsndringar.',
        'Load Settings' => 'Ladda Instllningar',
        'Subgroup' => 'Undergrupp',
        'Elements' => 'Element',

        # Template: AdminSysConfigEdit
        'Config Options' => 'Konfigureringsinstllningar',
        'Default' => 'Standard',
        'New' => 'Nytt',
        'New Group' => 'Ny Grupp',
        'Group Ro' => 'Grupp Ro',
        'New Group Ro' => 'Ny Grupp Ro',
        'NavBarName' => 'NavigationsRadNamn',
        'NavBar' => 'NavigationsRad',
        'Image' => 'Bild',
        'Prio' => 'Prioritet',
        'Block' => 'Blockera',
        'AccessKey' => 'tkomstTangent',

        # Template: AdminSystemAddressForm
        'System Email Addresses Management' => 'System-emailadresser',
        'Add System Address' => 'Lgg till Systemadress',
        'Add a new System Address.' => 'Lgg till ny Systemadress',
        'Realname' => 'Fullstndigt namn',
        'All email addresses get excluded on replaying on composing an email.' => 'Alla epostadresser exkluderas vid skapande av epost',
        'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Alla inkommande mail till denna adressat (To:) delas ut till vald k.',

        # Template: AdminTypeForm
        'Type Management' => 'rendetyp',
        'Add Type' => 'Lgg till Typ',
        'Add a new Type.' => 'Lgg till ny Typ',

        # Template: AdminUserForm
        'User Management' => 'Anvndare',
        'Add User' => 'Lgg till Anvndare',
        'Add a new Agent.' => 'Lgg till ny Agent.',
        'Login as' => 'Logga in som',
        'Firstname' => 'Frnamn',
        'Lastname' => 'Efternamn',
        'Start' => 'Start',
        'End' => 'Slut',
        'User will be needed to handle tickets.' => 'Anvndare krvs fr att hantera renden.',
        'Don\'t forget to add a new user to groups and/or roles!' => 'Glm inte att lgga nya anvndare i grupper och/eller roller!',

        # Template: AdminUserGroupChangeForm
        'Users <-> Groups Management' => 'Anvndare <-> Grupper',

        # Template: AdminUserGroupForm

        # Template: AgentBook
        'Address Book' => 'Adressbok',
        'Return to the compose screen' => 'Stng fnstret',
        'Discard all changes and return to the compose screen' => 'Bortse frn ndringarna och stng fnstret',

        # Template: AgentCalendarSmall

        # Template: AgentCalendarSmallIcon

        # Template: AgentCustomerSearch

        # Template: AgentCustomerTableView

        # Template: AgentDashboard
        'Dashboard' => 'Dashboard',

        # Template: AgentDashboardCalendarOverview
        'in' => 'i',

        # Template: AgentDashboardImage

        # Template: AgentDashboardProductNotify
        '%s %s is available!' => '%s %s r tillgnlig!',
        'Please update now.' => 'Vnligen uppdatera nu.',
        'Release Note' => 'Release Note',
        'Level' => 'Niv',

        # Template: AgentDashboardRSSOverview
        'Posted %s ago.' => 'Postad fr %s sedan.',

        # Template: AgentDashboardTicketOverview

        # Template: AgentDashboardTicketStats

        # Template: AgentInfo
        'Info' => 'Info',

        # Template: AgentLinkObject
        'Link Object: %s' => 'Lnkobjekt: %s',
        'Object' => 'Objekt',
        'Link Object' => 'Lnka objekt',
        'with' => 'med',
        'Select' => 'Vlj',
        'Unlink Object: %s' => 'Avlnka objekt: %s',

        # Template: AgentLookup
        'Lookup' => 'Sl upp',

        # Template: AgentNavigationBar

        # Template: AgentPreferencesForm

        # Template: AgentSpelling
        'Spell Checker' => 'Stavningskontroll',
        'spelling error(s)' => 'Stavfel',
        'or' => 'eller',
        'Apply these changes' => 'Verkstll ndringar',

        # Template: AgentStatsDelete
        'Do you really want to delete this Object?' => 'Vll du verkligen radera detta Objekt?',

        # Template: AgentStatsEditRestrictions
        'Select the restrictions to characterise the stat' => 'Vlj begrnsningar som karaktriserar statistiken',
        'Fixed' => 'Fast',
        'Please select only one element or turn off the button \'Fixed\'.' => 'Vlj endast ett vrde, eller sl av knappen \'Fast\'.',
        'Absolut Period' => 'Absolut period',
        'Between' => 'Mellan',
        'Relative Period' => 'Relativ period',
        'The last' => 'De senaste',
        'Finish' => 'Slut',
        'Here you can make restrictions to your stat.' => 'Hr kan du stta restriktioner p din statistik.',
        'If you remove the hook in the "Fixed" checkbox, the agent generating the stat can change the attributes of the corresponding element.' => 'Om du raderar innehllet i "Fast" bockrutan, kan agenten som genererar statistiken ndra attributen p motsvarande element.',

        # Template: AgentStatsEditSpecification
        'Insert of the common specifications' => '',
        'Permissions' => '',
        'Format' => '',
        'Graphsize' => '',
        'Sum rows' => '',
        'Sum columns' => '',
        'Cache' => '',
        'Required Field' => '',
        'Selection needed' => '',
        'Explanation' => '',
        'In this form you can select the basic specifications.' => '',
        'Attribute' => '',
        'Title of the stat.' => '',
        'Here you can insert a description of the stat.' => '',
        'Dynamic-Object' => '',
        'Here you can select the dynamic object you want to use.' => '',
        '(Note: It depends on your installation how many dynamic objects you can use)' => '',
        'Static-File' => '',
        'For very complex stats it is possible to include a hardcoded file.' => '',
        'If a new hardcoded file is available this attribute will be shown and you can select one.' => '',
        'Permission settings. You can select one or more groups to make the configurated stat visible for different agents.' => '',
        'Multiple selection of the output format.' => '',
        'If you use a graph as output format you have to select at least one graph size.' => '',
        'If you need the sum of every row select yes' => '',
        'If you need the sum of every column select yes.' => '',
        'Most of the stats can be cached. This will speed up the presentation of this stat.' => '',
        '(Note: Useful for big databases and low performance server)' => '',
        'With an invalid stat it isn\'t feasible to generate a stat.' => '',
        'This is useful if you want that no one can get the result of the stat or the stat isn\'t ready configurated.' => '',

        # Template: AgentStatsEditValueSeries
        'Select the elements for the value series' => '',
        'Scale' => '',
        'minimal' => '',
        'Please remember, that the scale for value series has to be larger than the scale for the X-axis (e.g. X-Axis => Month, ValueSeries => Year).' => '',
        'Here you can define the value series. You have the possibility to select one or two elements. Then you can select the attributes of elements. Each attribute will be shown as single value series. If you don\'t select any attribute all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

        # Template: AgentStatsEditXaxis
        'Select the element, which will be used at the X-axis' => '',
        'maximal period' => '',
        'minimal scale' => '',
        'Here you can define the x-axis. You can select one element via the radio button. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',

        # Template: AgentStatsImport
        'Import' => '',
        'File is not a Stats config' => '',
        'No File selected' => '',

        # Template: AgentStatsOverview
        'Results' => 'Resultat',
        'Total hits' => 'Totalt hittade',
        'Page' => 'Sida',

        # Template: AgentStatsPrint
        'Print' => 'Skriv ut',
        'No Element selected.' => '',

        # Template: AgentStatsView
        'Export Config' => '',
        'Information about the Stat' => '',
        'Exchange Axis' => '',
        'Configurable params of static stat' => '',
        'No element selected.' => '',
        'maximal period from' => '',
        'to' => '',
        'With the input and select fields you can configurate the stat at your needs. Which elements of a stat you can edit depends on your stats administrator who configurated the stat.' => '',

        # Template: AgentTicketBounce
        'A message should have a To: recipient!' => 'Ett meddelande mste ha en mottagare i Till:-fltet!',
        'You need a email address (e. g. customer@example.com) in To:!' => 'I Till-fltet mste anges en giltig emailadress (t.ex. kund@exempeldomain.se)!',
        'Bounce ticket' => 'Skicka ver rende',
        'Ticket locked!' => 'rendet lst',
        'Ticket unlock!' => 'rendet upplst',
        'Bounce to' => 'Skicka ver till',
        'Next ticket state' => 'Nsta rendestatus',
        'Inform sender' => 'Informera avsndare',
        'Send mail!' => 'Skicka mail!',

        # Template: AgentTicketBulk
        'You need to account time!' => 'Du mste redovisa tiden!',
        'Ticket Bulk Action' => 'rendemassfrndring',
        'Spell Check' => 'Stavningskontroll',
        'Note type' => 'Anteckningstyp',
        'Next state' => 'Nsta tillstnd',
        'Pending date' => 'Vntande datum',
        'Merge to' => 'Sl samman med',
        'Merge to oldest' => 'Sl samman till ldsta',
        'Link together' => 'Lnka',
        'Link to Parent' => 'Lnka med Frlder',
        'Unlock Tickets' => 'Ls upp renden',

        # Template: AgentTicketClose
        'Ticket Type is required!' => 'rendetyp krvs!',
        'A required field is:' => 'Ett tvingande flt r:',
        'Close ticket' => 'Stng rende',
        'Previous Owner' => 'Tidigare gare',
        'Inform Agent' => 'Meddela Agent',
        'Optional' => 'Valfri',
        'Inform involved Agents' => 'Meddela inblandade agenter',
        'Attach' => 'Bifoga',

        # Template: AgentTicketCompose
        'A message must be spell checked!' => 'Stavningskontroll mste utfras p alla meddelanden!',
        'Compose answer for ticket' => 'Frfatta svar till rende',
        'Pending Date' => 'Vntar till',
        'for pending* states' => 'fr vntetillstnd',

        # Template: AgentTicketCustomer
        'Change customer of ticket' => 'ndra kund fr rende',
        'Set customer user and customer id of a ticket' => 'Ange kundanvndare och organisations-id fr ett rende',
        'Customer User' => 'Kundanvndare',
        'Search Customer' => 'Sk kund',
        'Customer Data' => 'Kunddata',
        'Customer history' => 'Kundhistorik',
        'All customer tickets.' => 'Alla kundrenden.',

        # Template: AgentTicketEmail
        'Compose Email' => 'Skriv email',
        'new ticket' => 'Nytt rende',
        'Refresh' => 'Uppdatera',
        'Clear To' => 'Rensa Till',
        'All Agents' => 'Alla agenter',

        # Template: AgentTicketEscalation

        # Template: AgentTicketForward
        'Article type' => 'Artikeltyp',

        # Template: AgentTicketFreeText
        'Change free text of ticket' => 'ndra friatextflt i rende',

        # Template: AgentTicketHistory
        'History of' => 'Historik fr',

        # Template: AgentTicketLocked

        # Template: AgentTicketMerge
        'You need to use a ticket number!' => 'Du mste ange ett rendenummer!',
        'Ticket Merge' => 'Sl samman',

        # Template: AgentTicketMove
        'If you want to account time, please provide Subject and Text!' => '',
        'Move Ticket' => 'Flytta rende',

        # Template: AgentTicketNote
        'Add note to ticket' => 'Lgg till anteckning till rende',

        # Template: AgentTicketOverviewMedium
        'First Response Time' => 'Frsta Responstid',
        'Service Time' => 'Tjnsttid',
        'Update Time' => 'Uppdateringstid',
        'Solution Time' => 'Lsningstid',

        # Template: AgentTicketOverviewMediumMeta
        'You need min. one selected Ticket!' => 'Du mste ha minst ett valt rende!',

        # Template: AgentTicketOverviewNavBar
        'Filter' => 'Filter',
        'Change search options' => 'ndra skinstllningar',
        'Tickets' => 'renden',
        'of' => 'av',

        # Template: AgentTicketOverviewNavBarSmall

        # Template: AgentTicketOverviewPreview
        'Compose Answer' => 'Skriv svar',
        'Contact customer' => 'Kontakta kund',
        'Change queue' => 'ndra k',

        # Template: AgentTicketOverviewPreviewMeta

        # Template: AgentTicketOverviewSmall
        'sort upward' => 'Sortera stigande',
        'up' => 'stigande',
        'sort downward' => 'Sortera sjunkande',
        'down' => 'sjunkande',
        'Escalation in' => 'Upptrappning om',
        'Locked' => 'Lst',

        # Template: AgentTicketOwner
        'Change owner of ticket' => 'ndra ett rendes gare',

        # Template: AgentTicketPending
        'Set Pending' => 'Markera som vntande',

        # Template: AgentTicketPhone
        'Phone call' => 'Telefonsamtal',
        'Clear From' => 'Nollstll Frn:',

        # Template: AgentTicketPhoneOutbound

        # Template: AgentTicketPlain
        'Plain' => 'Enkel',

        # Template: AgentTicketPrint
        'Ticket-Info' => 'rendeinfo',
        'Accounted time' => 'Redovisad tid',
        'Linked-Object' => 'Lnkat objekt',
        'by' => 'av',

        # Template: AgentTicketPriority
        'Change priority of ticket' => 'ndra rendeprioritet',

        # Template: AgentTicketQueue
        'Tickets shown' => 'renden som visas',
        'Tickets available' => 'Tillgngliga renden',
        'All tickets' => 'Alla renden',
        'Queues' => 'Ker',
        'Ticket escalation!' => 'rende-upptrappning!',

        # Template: AgentTicketResponsible
        'Change responsible of ticket' => 'ndra ansvarig p rendet',

        # Template: AgentTicketSearch
        'Ticket Search' => 'rende-sk',
        'Profile' => 'Profil',
        'Search-Template' => 'Skmall',
        'TicketFreeText' => 'rendeFriText',
        'Created in Queue' => 'Skapad i K',
        'Article Create Times' => 'Artikel Skapad Tider',
        'Article created' => 'Artikel skapad',
        'Article created between' => 'Artikel skapad mellan',
        'Change Times' => 'ndringsTider',
        'No change time settings.' => 'Inga ndringstider',
        'Ticket changed' => 'rende ndrat',
        'Ticket changed between' => 'rende ndrat mellan',
        'Result Form' => 'Resultatbild',
        'Save Search-Profile as Template?' => 'Spara skkriterier som mall?',
        'Yes, save it with name' => 'Ja, spara med namn',

        # Template: AgentTicketSearchOpenSearchDescriptionFulltext
        'Fulltext' => 'Fritext',

        # Template: AgentTicketSearchOpenSearchDescriptionTicketNumber

        # Template: AgentTicketSearchResultPrint

        # Template: AgentTicketZoom
        'Expand View' => 'Expandera vy',
        'Collapse View' => 'Minimera vy',
        'Split' => 'Dela',

        # Template: AgentTicketZoomArticleFilterDialog
        'Article filter settings' => 'Artikelfilterinstllningar',
        'Save filter settings as default' => 'Spara filterinstllningar som standard',

        # Template: AgentWindowTab

        # Template: AJAX

        # Template: Copyright

        # Template: CustomerAccept

        # Template: CustomerCalendarSmallIcon

        # Template: CustomerError
        'Traceback' => 'tersprning',

        # Template: CustomerFooter
        'Powered by' => 'Drivs av',

        # Template: CustomerFooterSmall

        # Template: CustomerHeader

        # Template: CustomerHeaderSmall

        # Template: CustomerLogin
        'Login' => 'Login',
        'Lost your password?' => 'Glmt lsenordet?',
        'Request new password' => 'Be om nytt lsenord',
        'Create Account' => 'Skapa konto',

        # Template: CustomerNavigationBar
        'Welcome %s' => 'Vlkommen %s',

        # Template: CustomerPreferencesForm

        # Template: CustomerStatusView

        # Template: CustomerTicketMessage

        # Template: CustomerTicketPrint

        # Template: CustomerTicketSearch
        'Times' => 'Tider',
        'No time settings.' => 'Inga tidsinstllningar.',

        # Template: CustomerTicketSearchOpenSearchDescription

        # Template: CustomerTicketSearchResultCSV

        # Template: CustomerTicketSearchResultPrint

        # Template: CustomerTicketSearchResultShort

        # Template: CustomerTicketZoom

        # Template: CustomerWarning

        # Template: Error
        'Click here to report a bug!' => 'Klicka hr fr att rapportera ett fel!',

        # Template: Footer
        'Top of Page' => 'Brjan av sidan',

        # Template: FooterSmall

        # Template: Header
        'Home' => 'Hem',

        # Template: HeaderSmall

        # Template: Installer
        'Web-Installer' => 'Web-installation',
        'Welcome to %s' => 'Vlkommen till %s',
        'Accept license' => 'Acceptera licens',
        'Don\'t accept license' => 'Acceptera inte licens',
        'Admin-User' => 'Admin-anvndare',
        'If you have set a root password for your database, it must be entered here. If not, leave this field empty. For security reasons we do recommend setting a root password. For more information please refer to your database documentation.' =>          'Om du har ett root-lsenord fr databasen mste det anges hr. Annars lmnar du fltet tomt. Av skerhetssjl rekommenderar vi dig att du har ett rootlsenord. Fr mer information hnvisas du till databasdokumentationen.',
        'Admin-Password' => 'Admin-Lsen',
        'Database-User' => 'Databas-Anvndare',
        'default \'hot\'' => 'default \'hot\'',
        'DB connect host' => 'DB anslutninsvrd (host)',
        'Database' => 'Databas',
        'Default Charset' => 'Standard teckenuppsttning',
        'utf8' => 'utf8',
        'false' => 'falsk',
        'SystemID' => 'SystemID',
        '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(Unikt id fr detta system.  Alla rendenummer och http-sessionsid brjar med denna id)',
        'System FQDN' => 'System FQDN',
        '(Full qualified domain name of your system)' => '(Fullt kvalificerat dns-namn fr ditt system)',
        'AdminEmail' => 'Admin-email',
        '(Email of the system admin)' => '(Email till systemadmin)',
        'Organization' => 'Organisation',
        'Log' => 'Logg',
        'LogModule' => 'LoggningsModul',
        '(Used log backend)' => '(Valt logg-backend)',
        'Logfile' => 'Loggfil',
        '(Logfile just needed for File-LogModule!)' => '(Loggfil behvs enbart fr File-LogModule!)',
        'Webfrontend' => 'Webb-grnssnitt',
        'Use utf-8 it your database supports it!' => 'Anvnd utf-8 ifall din databas stdjer det!',
        'Default Language' => 'Standardsprk',
        '(Used default language)' => '(Valt standardsprk)',
        'CheckMXRecord' => 'KontrolleraMXFlt',
        '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '(Kontrollerar mx-uppslag fr uppgivna emailadresser i meddelanden som skrivs.  Anvnd inte CheckMXRecord om din OTRS-maskin r bakom en uppringd lina!)',
        'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Fr att kunna anvnda OTRS, mste fljende rad skrivas p kommandoraden som root.',
        'Restart your webserver' => 'Starta om din webbserver',
        'After doing so your OTRS is up and running.' => 'Efter detta r OTRS igng.',
        'Start page' => 'Startsida',
        'Your OTRS Team' => 'Ditt OTRS-Team',

        # Template: LinkObject

        # Template: Login

        # Template: Motd

        # Template: NoPermission
        'No Permission' => 'Ingen tkomst',

        # Template: Notify
        'Important' => 'Viktigt',

        # Template: PrintFooter
        'URL' => 'URL',

        # Template: PrintHeader
        'printed by' => 'utskrivet av',

        # Template: PublicDefault

        # Template: Redirect

        # Template: Test
        'OTRS Test Page' => 'OTRS Test-sida',
        'Counter' => 'Rknare',

        # Template: Warning

        # Template: YUI

        # Misc
        'Edit Article' => 'Redigera Artikel',
        'Create Database' => 'Skapa databas',
        'DB Host' => 'DB Vrd (host)',
        'Ticket Number Generator' => 'rende-nummergenerator',
        'Symptom' => 'Symptom',
        'U' => 'U',
        'Site' => 'Plats',
        'Customer history search (e. g. "ID342425").' => 'Sk efter kundhistorik (t.ex. "ID342425").',
        'Can not delete link with %s!' => 'Kan inte radera lnk med %s!',
        'for agent firstname' => 'fr agents frnamn',
        'Close!' => 'Stng!',
        'Subgroup \'' => 'Undergrupp \'',
        'No means, send agent and customer notifications on changes.' => 'Nej betyder, snd agent och kundmeddelanden vid ndringar.',
        'A web calendar' => 'En webbkalender',
        'to get the realname of the sender (if given)' => 'fr att f fram avsndarens fulla namn (om mjligt)',
        'OTRS DB Name' => 'OTRS DB namn',
        'Notification (Customer)' => 'Meddelande (Kund)',
        'Select Source (for add)' => 'Vlj klla (fr tillgg)',
        'Options of the ticket data (e. g. &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)' => 'Val fr rende data (t.ex &lt;OTRS_TICKET_Number&gt;, &lt;OTRS_TICKET_ID&gt;, &lt;OTRS_TICKET_Queue&gt;, &lt;OTRS_TICKET_State&gt;)',
        'Child-Object' => 'Barn-Objekt',
        'Days' => 'Dagar',
        'Queue ID' => 'K-id',
        'Config options (e. g. <OTRS_CONFIG_HttpType>)' => 'Konfigurationsval (t.ex. <OTRS_CONFIG_HttpType>)',
        'System History' => 'Systemhistorik',
        'customer realname' => 'Fullt kundnamn',
        'Pending messages' => 'Vntande meddelanden',
        'Port' => 'Port',
        'for agent login' => 'fr agents login',
        'Keyword' => 'Nyckelord',
        'Close type' => 'Stngningstyp',
        'DB Admin User' => 'DB Adminanvndare',
        'for agent user id' => 'fr agents anvndar-id',
        'Change user <-> group settings' => 'ndra anvndar- <-> grupp-instllningar',
        'Problem' => 'Problem',
        'for ' => 'fr',
        'Escalation' => 'Eskalering',
        '"}' => '"}',
        'Order' => 'Sortering',
        'next step' => 'nsta steg',
        'Follow up' => 'Uppfljning',
        'Customer history search' => 'Kundhistorik',
        'Admin-Email' => 'Admin-email',
        'Stat#' => 'Stat#',
        'Create new database' => 'Skapa ny databas',
        'Keywords' => 'Nyckelord',
        'Ticket Escalation View' => 'rendeeskaleringsvy',
        'Today' => 'Idag',
        'No * possible!' => 'Wildcards * inte tilltna!',
        'Options ' => 'Tillval',
        'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Tillval fr nuvarande anvndare som begrde denna tgrd (t.ex. <OTRS_CURRENT_USERFIRSTNAME>)',
        'Message for new Owner' => 'Meddelande till ny gare',
        'to get the first 5 lines of the email' => 'fr att f fram de frsta 5 raderna av emailen',
        'Sort by' => 'Sortera efter',
        'OTRS DB Password' => 'OTRS DB lsenord',
        'Last update' => 'Senast ndrat',
        'Tomorrow' => 'Imorgon',
        'to get the first 20 character of the subject' => 'fr att f fram de frste 20 tecknen i mnesbeskrivningen',
        'Select the customeruser:service relations.' => 'Vlj Kund:Servicerelationer',
        'DB Admin Password' => 'DB Adminlsenord',
        'Drop Database' => 'Radera databas',
        'Here you can define the x-axis. You can select one element via the radio button. Then you you have to select two or more attributes of the element. If you make no selection all attributes of the element will be used if you generate a stat. As well a new attribute is added since the last configuration.' => '',
        'FileManager' => 'Filhanterare',
        'Options of the current customer user data (e. g. <OTRS_CUSTOMER_DATA_UserFirstname>)' => 'ger tillgng till data fr gllande kund (t.ex. <OTRS_CUSTOMER_DATA_UserFirstname>)',
        'Pending type' => 'Vntande typ',
        'Comment (internal)' => 'Kommentar (intern)',
        'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'rendegarval (T.ex. <OTRS_OWNER_USERFIRSTNAME>)',
        'Minutes' => 'Minuter',
        'Options of the ticket data (e. g. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => '<rendedataval (t.ex. <OTRS_TICKET_Number>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)',
        '(Used ticket number format)' => '(Valt format fr rendenummer)',
        'Reminder' => 'Pminnelse',
        ' (work units)' => ' (arbetsenheter)',
        'Next Week' => 'Nsta Vecka',
        'Operation' => 'tgrd',
        'accept license' => 'godknn licens',
        'for agent lastname' => 'fr agents efternamn',
        'Options of the current user who requested this action (e. g. <OTRS_CURRENT_UserFirstname>)' => 'ger tillgng till data fr agenten som utfr handlingen (t.ex. <OTRS_CURRENT_UserFirstname>)',
        'Reminder messages' => 'Pminnelsemeddelanden',
        'Parent-Object' => 'Frlderobjekt',
        'Of couse this feature will take some system performance it self!' => 'Denna funktion kommer i sig sjlv anvnda viss systemprestanda!',
        'IMAPS' => 'IMAPS',
        'Detail' => 'Detalj',
        'Your own Ticket' => 'Ditt eget rende',
        'TicketZoom' => 'rende Zoom',
        'Don\'t forget to add a new user to groups!' => 'Glm inte att lgga in en ny anvndare i en grupp!',
        'Open Tickets' => 'ppna renden',
        'CreateTicket' => 'Skapa rende',
        'You have to select two or more attributes from the select field!' => 'Du mste vlja minst tv eller fler attribut!',
        'System Settings' => 'Systeminstllningar',
        'WebWatcher' => '',
        'Hours' => 'Timmar',
        'Finished' => 'Klar',
        'Account Type' => 'Kontotyp',
        'D' => 'N',
        'System Status' => 'Systemmeddelanden',
        'All messages' => 'Alla meddelanden',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_ID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => '',
        'Object already linked as %s.' => '',
        'A article should have a title!' => '',
        'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => '',
        'All email addresses get excluded on replaying on composing and email.' => '',
        'don\'t accept license' => 'godknn inte licens',
        'A web mail client' => '',
        'IMAP' => '',
        'Compose Follow up' => 'Skriv uppfljningssvar',
        'Options of the ticket data (e. g. <OTRS_TICKET_TicketNumber>, <OTRS_TICKET_TicketID>, <OTRS_TICKET_Queue>, <OTRS_TICKET_State>)' => '',
        'Article time' => '',
        'Ticket owner options (e. g. <OTRS_OWNER_UserFirstname>)' => 'ger tillgang till data fr agenten som str som gare till rendet (t.ex. <OTRS_OWNER_UserFirstname>)',
        'DB Type' => 'DB typ',
        'kill all sessions' => 'Terminera alla sessioner',
        'to get the from line of the email' => 'fr att f fram avsndarraden i emailen',
        'Solution' => 'Lsning',
        'QueueView' => 'Ker',
        'Select Box' => 'SQL-access',
        'New messages' => 'Nya meddelanden',
        'Can not create link with %s!' => '',
        'Linked as' => '',
        'modified' => '',
        'Calculator' => '',
        'Delete old database' => 'Radera gammal databas',
        'A web file manager' => '',
        'Have a lot of fun!' => 'Ha det s roligt!',
        'send' => 'Skicka',
        'Send no notifications' => '',
        'Note Text' => 'Anteckingstext',
        'POP3 Account Management' => 'Administration av POP3-Konto',
        'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => '',
        'System State Management' => 'Hantering av systemstatus',
        'OTRS DB User' => 'OTRS DB anvndare',
        'Mailbox' => '',
        'PhoneView' => 'Tel.samtal',
        'maximal period form' => '',
        'Management Summary' => '',
        'Escaladed Tickets' => '',
        'Yes means, send no agent and customer notifications on changes.' => '',
        'POP3' => '',
        'POP3S' => '',
        'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further information.' => 'Emailen med rendenummer "<OTRS_TICKET>" har skickats ver till "<OTRS_BOUNCE_TO>". Vnligen kontakta denna adress fr vidare hnvisningar.',
        'Ticket Status View' => '',
        'Modified' => 'ndrat',
        'Ticket selected for bulk action!' => 'rende valt fr massfrndring!',
        'Agent Dashboard' => 'Kontrollpanel',
        'TimeAccounting' => 'Tidsredovisning',
        'A Survey module' => 'Underskningsmodul',
        'Survey' => 'Underskning',
        'FAQ-Area' => 'Frgor och svar',
        'FAQ' => 'FAQ',
        'StatusView' => 'Statusvy',
        'My Locked Tickets' => 'Mina Lsta renden',
        '%s is not writable!' => '',
        'Cannot create %s!' => '',
    };
    # $$STOP$$
    return;
}

1;
