#ifndef __iwl_trans_int_idi_h__
#define __iwl_trans_int_idi_h__

#include <linux/types.h>

struct iwl_trans;

#ifdef CPTCFG_IWLWIFI_IDI_OVER_PCI

/* AUX (TX during scan dwell) queue */
#define IWL_AUX_QUEUE		10
void iwl_pcie_reset_ict(struct iwl_trans *trans);

#endif

/* This is a really nasty hack to avoid redeclaring this struct when both
 * iwl-trans-{pcie,idi)-int.h
 */
#if !defined(__iwl_trans_int_pcie_h__)

struct iwl_rx_mem_buffer {
	dma_addr_t page_dma;
	struct page *page;
	struct list_head list;
};

#endif

struct iwl_idi_dma_ptr {
	dma_addr_t dma;		/* physical dma address */
	u32 align_offset;		/* offset to 16 BYTEs alignment */
	void *addr;		/* virtual address */
	size_t size;		/* size of the allocated block for freeing */
};

int iwl_idi_alloc_sg_list(struct iwl_trans *trans,
			struct iwl_idi_dma_ptr *sg_list,
			size_t size);

void iwl_idi_free_sg_list(struct iwl_trans *trans,
			struct iwl_idi_dma_ptr *sg_list);

#endif
