/*
 * Copyright 2018 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#include "amdgpu.h"
#include "soc15.h"

#include "soc15_common.h"
#include "soc15_hw_ip.h"

static void wreg32_idx_byteoffset(struct amdgpu_device *adev, u32 offset, u32 value) {

	static u32 maxoffset = 0;
	static int count = 0;

	WREG32(0xc, offset);
	RREG32(0xc);
	WREG32(0xd, value);
	RREG32(0xd);

	if (offset > maxoffset)
		maxoffset = offset;

	count++;
	if (count % 100 == 0) {
		DRM_INFO("%5d registers written, max offset %08x\n", count, maxoffset);
		msleep(1);
	}

}

static void vg20_lsd_soc_init_with_umc(struct amdgpu_device *adev)
{

		wreg32_idx_byteoffset(adev, 0x10131800, 0x40a40);
		wreg32_idx_byteoffset(adev, 0x10141010, 0x10000000);
		wreg32_idx_byteoffset(adev, 0x10134008, 0xfa042021);
		wreg32_idx_byteoffset(adev, 0x387C, 0x3);
		wreg32_idx_byteoffset(adev, 0x381C, 0x30000);
		wreg32_idx_byteoffset(adev, 0x101237A4, 0x8000100f);
		wreg32_idx_byteoffset(adev, 0x101237A8, 0x140f);
		wreg32_idx_byteoffset(adev, 0x3780, 0x1);
		wreg32_idx_byteoffset(adev, 0x1403BC0, 0x100040);
		wreg32_idx_byteoffset(adev, 0x1403BC4, 0x100140);
		wreg32_idx_byteoffset(adev, 0x1403BC8, 0x100240);
		wreg32_idx_byteoffset(adev, 0x1403BCC, 0x100300);
		/* End nbio_init_sequence on GPU 0 */

		wreg32_idx_byteoffset(adev, 0x11100060, 0x2830);
		wreg32_idx_byteoffset(adev, 0x3780, 0x1);
		/* Done with NBIO Init on GPU 0 */

		/* Start with DF Init on GPU 0*/
		wreg32_idx_byteoffset(adev, 0x1D040, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C668, 0x31a1b74);
		wreg32_idx_byteoffset(adev, 0x1C66C, 0x36666332);
		wreg32_idx_byteoffset(adev, 0x1C7F8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C72C, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x460001);
		wreg32_idx_byteoffset(adev, 0x1CE94, 0xaf);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x470001);
		wreg32_idx_byteoffset(adev, 0x1CE94, 0xaf);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C730, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C600, 0x1000001);
		wreg32_idx_byteoffset(adev, 0x1C604, 0x2001);
		wreg32_idx_byteoffset(adev, 0x1C608, 0x380007f);
		wreg32_idx_byteoffset(adev, 0x1C60C, 0x7000007);
		wreg32_idx_byteoffset(adev, 0x1C4A8, 0x40);
		wreg32_idx_byteoffset(adev, 0x1C73C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C598, 0x138);
		wreg32_idx_byteoffset(adev, 0x1C59C, 0x44041);
		wreg32_idx_byteoffset(adev, 0x1C594, 0x40);
		wreg32_idx_byteoffset(adev, 0x1C584, 0x138);
		wreg32_idx_byteoffset(adev, 0x1C588, 0x44041);
		wreg32_idx_byteoffset(adev, 0x1C58C, 0x30);
		wreg32_idx_byteoffset(adev, 0x1C590, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C5F0, 0x90);
		wreg32_idx_byteoffset(adev, 0x1C5F4, 0x8000);
		wreg32_idx_byteoffset(adev, 0x1C5F8, 0x8e);
		wreg32_idx_byteoffset(adev, 0x1C5FC, 0x8000);
		wreg32_idx_byteoffset(adev, 0x1C4AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C5EC, 0x4090c);
		wreg32_idx_byteoffset(adev, 0x1C490, 0xbe);
		wreg32_idx_byteoffset(adev, 0x1C494, 0x8000);
		wreg32_idx_byteoffset(adev, 0x1C498, 0xac);
		wreg32_idx_byteoffset(adev, 0x1C49C, 0x8000);
		wreg32_idx_byteoffset(adev, 0x1C488, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C48C, 0x540980c);
		wreg32_idx_byteoffset(adev, 0x1C4B0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4B8, 0x8);
		wreg32_idx_byteoffset(adev, 0x1C4BC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4C0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4C4, 0x6fc81);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x480001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x490001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x4a0001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x4b0001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x4c0001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x4d0001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x4e0001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x4f0001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x500001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x510001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x520001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x530001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x540001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x550001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x560001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x570001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x580001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x590001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x5a0001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x5b0001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x5c0001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x5d0001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x5e0001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x5f0001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x600001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x610001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x620001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x630001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x640001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x650001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x660001);
		wreg32_idx_byteoffset(adev, 0x1DDA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x480001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x4000003);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x4107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1001818);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x40a11);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x40a11);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x40a11);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x1018);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0xc12);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x60606);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x80808);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x5020000);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x6040000);
		wreg32_idx_byteoffset(adev, 0x1DD3C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD2C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD4C, 0x5);
		wreg32_idx_byteoffset(adev, 0x1DD34, 0x6);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7cfffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC50, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC70, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC90, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x490001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x8000007);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x24107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1003031);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x161c);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1015);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x6060603);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x8080804);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x2000004);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x4000006);
		wreg32_idx_byteoffset(adev, 0x1DD3C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD2C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD4C, 0x505);
		wreg32_idx_byteoffset(adev, 0x1DD34, 0x606);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7fffff3);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x10800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x10400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC50, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC70, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC90, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC54, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC74, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC94, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB4, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x4a0001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x8000007);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x84107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1003031);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x161c);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1015);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x6060603);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x8080804);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x2000004);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x4000006);
		wreg32_idx_byteoffset(adev, 0x1DD3C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD2C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD4C, 0x505);
		wreg32_idx_byteoffset(adev, 0x1DD34, 0x606);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7fffff3);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x10800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x10400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC50, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC70, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC90, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC54, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC74, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC94, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB4, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x4b0001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x4000003);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x74107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1001818);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x40a11);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x40a11);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x40a11);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x1018);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0xc12);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x60606);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x80808);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x5020000);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x6040000);
		wreg32_idx_byteoffset(adev, 0x1DD3C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD2C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD4C, 0x5);
		wreg32_idx_byteoffset(adev, 0x1DD34, 0x6);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7cfffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC50, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC70, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC90, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x4c0001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x8000007);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x44107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1003031);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x161c);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1015);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x6060603);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x8080804);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x2000004);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x4000006);
		wreg32_idx_byteoffset(adev, 0x1DD3C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD2C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD4C, 0x505);
		wreg32_idx_byteoffset(adev, 0x1DD34, 0x606);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7fffff3);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x10800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x10400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC50, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC70, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC90, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC54, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC74, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC94, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB4, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x4d0001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x8000007);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0xb4107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1003031);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x161c);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1015);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x6060603);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x8080804);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x2000004);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x4000006);
		wreg32_idx_byteoffset(adev, 0x1DD3C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD2C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD4C, 0x505);
		wreg32_idx_byteoffset(adev, 0x1DD34, 0x606);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7fffff3);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x10800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x10400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC50, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC70, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC90, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC54, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC74, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC94, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB4, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x4e0001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x8000007);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x44107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1003031);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x161c);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1015);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x6060603);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x8080804);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x2000004);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x4000006);
		wreg32_idx_byteoffset(adev, 0x1DD3C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD2C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD4C, 0x505);
		wreg32_idx_byteoffset(adev, 0x1DD34, 0x606);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7fffff3);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x10800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x10400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC50, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC70, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC90, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC54, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC74, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC94, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB4, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x4f0001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x8000007);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x84107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1003031);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x161c);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1015);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x6060603);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x8080804);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x2000004);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x4000006);
		wreg32_idx_byteoffset(adev, 0x1DD3C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD2C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD4C, 0x505);
		wreg32_idx_byteoffset(adev, 0x1DD34, 0x606);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7fffff3);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x10800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x10400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC50, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC70, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC90, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC54, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC74, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC94, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB4, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x500001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x4000003);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x54107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1001818);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x40a11);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x40a11);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x40a11);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x1018);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0xc12);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x60606);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x80808);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x5020000);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x6040000);
		wreg32_idx_byteoffset(adev, 0x1DD3C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD2C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD4C, 0x5);
		wreg32_idx_byteoffset(adev, 0x1DD34, 0x6);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7cfffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC50, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC70, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC90, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x510001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x8000007);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x34107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1003031);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x161c);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1015);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x6060603);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x8080804);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x2000004);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x4000006);
		wreg32_idx_byteoffset(adev, 0x1DD3C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD2C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD4C, 0x505);
		wreg32_idx_byteoffset(adev, 0x1DD34, 0x606);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7fffff3);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x10800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x10400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC50, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC70, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC90, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC54, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC74, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC94, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB4, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x520001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x8000007);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x44107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1003031);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x161c);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1015);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x6060603);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x8080804);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x2000004);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x4000006);
		wreg32_idx_byteoffset(adev, 0x1DD3C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD2C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD4C, 0x505);
		wreg32_idx_byteoffset(adev, 0x1DD34, 0x606);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7fffff3);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x10800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x10400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC50, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC70, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC90, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC54, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC74, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC94, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB4, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x530001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x4000003);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x64107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1001818);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x40a11);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x40a11);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x40a11);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x1018);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0xc12);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x60606);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x80808);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x5020000);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x6040000);
		wreg32_idx_byteoffset(adev, 0x1DD3C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD2C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD4C, 0x5);
		wreg32_idx_byteoffset(adev, 0x1DD34, 0x6);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7cfffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC50, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC70, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC90, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x540001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x8000007);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x84107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1003031);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x161c);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1015);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x6060603);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x8080804);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x2000004);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x4000006);
		wreg32_idx_byteoffset(adev, 0x1DD3C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD2C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD4C, 0x505);
		wreg32_idx_byteoffset(adev, 0x1DD34, 0x606);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7fffff3);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x10800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x10400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC50, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC70, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC90, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC54, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC74, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC94, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB4, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x550001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x8000007);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x4107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1003031);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x161c);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1015);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x6060603);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x8080804);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x2000004);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x4000006);
		wreg32_idx_byteoffset(adev, 0x1DD3C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD2C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD4C, 0x505);
		wreg32_idx_byteoffset(adev, 0x1DD34, 0x606);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7fffff3);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x10800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x10400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC50, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC70, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC90, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC54, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC74, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC94, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB4, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x560001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x8000007);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x84107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1003031);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x161c);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1015);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x6060603);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x8080804);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x2000004);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x4000006);
		wreg32_idx_byteoffset(adev, 0x1DD3C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD2C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD4C, 0x505);
		wreg32_idx_byteoffset(adev, 0x1DD34, 0x606);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7fffff3);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x10800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x10400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC50, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC70, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC90, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC54, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC74, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC94, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB4, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x570001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x8000007);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0xf4107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1003031);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x142209);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x161c);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1015);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x6060603);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x8080804);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x2000004);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x4000006);
		wreg32_idx_byteoffset(adev, 0x1DD3C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD2C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD4C, 0x505);
		wreg32_idx_byteoffset(adev, 0x1DD34, 0x606);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7fffff3);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x10800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x10400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x8400);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x20);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC50, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC70, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC90, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC54, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC74, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC94, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCB4, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x580001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x2000001);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0xd4107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1030001);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x201);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x201);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x201);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x1c0f);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1e11);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x1001);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0xe01);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x618);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x616);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffe7ff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x42000);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x400000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x48400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x400000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x3);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x590001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x8000003);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x94107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x10a0003);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0xc0201);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0xc0201);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0xc0201);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x1c1f);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1621);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x18000603);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x16000603);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x9000904);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0xa000c06);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7fffff3);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x10800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x10400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x21000);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x200000);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x20400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x200000);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x4);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x5a0001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x2000001);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0xf4107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1060001);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x1e1f);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1618);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0xc0903);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x100c03);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0xc0604);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x100806);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffe7ff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x10800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x10400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x5b0001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0xd4107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1030000);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x201);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x201);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x201);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x2020);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1212);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0xc06);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x160a);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0xc06);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x160a);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x5c0001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x2000001);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x64107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1030001);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x201);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x201);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x201);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x1c0f);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1e11);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x1001);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0xe01);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x618);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x616);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffe7ff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x42000);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x400000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x48400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x400000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x3);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x5d0001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x4000003);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x74107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1060003);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x1c1f);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1621);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x180603);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x160603);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x90904);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0xa0c06);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7cfffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x10800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x10400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x21000);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x200000);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x20400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x200000);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x4);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x5e0001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x2000001);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x14107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1060001);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x1e1f);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1618);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0xc0903);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x100c03);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0xc0604);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x100806);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffe7ff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x10800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x10400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x110000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x5f0001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x2000000);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x24107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1030000);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x201);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x201);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x201);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x2020);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1212);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0xc06);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x160a);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0xc06);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x160a);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x600001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0xa4107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1050000);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x2020);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1a1a);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0xa0808);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0xc0a0a);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0xa0808);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0xc0a0a);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x610001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x1000000);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0xd4107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1050000);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x2020);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1a1a);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0xa0808);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0xc0a0a);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0xa0808);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0xc0a0a);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x620001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x2000001);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x4);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0xc4107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1030001);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x1819);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1915);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0xe0601);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0xe0a01);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x910);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0xa0e);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x31800);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x300000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x30400);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x300000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x630001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x2000001);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0xb4107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1030001);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x1e14);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x2218);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0xc0c);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0xa0a);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0xa0c0c);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0xa0a0a);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x200000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x200000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x2);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x640001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x2000001);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x5);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x54107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1030001);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x40201);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x2022);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x2115);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0xe0106);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0xe0a0a);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x1809);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x160a);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x200000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x200000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x42000);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x4);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x40400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x650001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x4000003);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x84107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1030003);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0xc0201);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0xc0201);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0xc0201);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x1a23);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1819);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0x118);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x8040116);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0x1008);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x20e0a);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7fffff3);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x400000);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x400000);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x31800);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x300000);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x30400);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x300000);
		wreg32_idx_byteoffset(adev, 0x1DC48, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC68, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC88, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC4C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC6C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC8C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCAC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x660001);
		wreg32_idx_byteoffset(adev, 0x1DDF0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DDF8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1DD14, 0x24107800);
		wreg32_idx_byteoffset(adev, 0x1DD18, 0x1030000);
		wreg32_idx_byteoffset(adev, 0x1DD1C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1DD08, 0x201);
		wreg32_idx_byteoffset(adev, 0x1DD0C, 0x201);
		wreg32_idx_byteoffset(adev, 0x1DD04, 0x201);
		wreg32_idx_byteoffset(adev, 0x1DD20, 0x2020);
		wreg32_idx_byteoffset(adev, 0x1DD24, 0x1818);
		wreg32_idx_byteoffset(adev, 0x1DD38, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DD40, 0xc0c);
		wreg32_idx_byteoffset(adev, 0x1DD28, 0x1010);
		wreg32_idx_byteoffset(adev, 0x1DD48, 0xc0c);
		wreg32_idx_byteoffset(adev, 0x1DD30, 0x1010);
		wreg32_idx_byteoffset(adev, 0x1C510, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C51C, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C514, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1C520, 0x7ffffff);
		wreg32_idx_byteoffset(adev, 0x1DC40, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC60, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC80, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC44, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC64, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DC84, 0x0);
		wreg32_idx_byteoffset(adev, 0x1DCA4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C840, 0x800000);
		wreg32_idx_byteoffset(adev, 0x1C844, 0xec404206);
		wreg32_idx_byteoffset(adev, 0x1C848, 0x220201f6);
		wreg32_idx_byteoffset(adev, 0x1C84C, 0xd);
		wreg32_idx_byteoffset(adev, 0x1C850, 0x83e4e08);
		wreg32_idx_byteoffset(adev, 0x1C894, 0x1450001);
		wreg32_idx_byteoffset(adev, 0x1D9F8, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0x1D9FC, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0x1D0F0, 0xfe861ee0);
		wreg32_idx_byteoffset(adev, 0x1D0FC, 0x2f);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1001011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x20001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x30001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1001011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x40001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x50001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1001011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x60001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1001011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x70001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x80001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x90001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1001011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0xa0001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1001011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0xb0001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0xc0001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1001011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0xd0001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0xe0001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0xf0001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1001011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x100001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1001011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x110001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x120001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x130001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1001011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x140001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x150001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1001011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x160001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1001011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x170001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x180001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x190001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1001011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x1a0001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1001011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x1b0001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x1c0001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1001011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x1d0001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x1e0001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x1f0001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C4A0, 0x42424202);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1001011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x20);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9C8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9DC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9CC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9EC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C9F0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x200001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x210001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x220001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x230001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x240001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x250001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x260001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x270001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x280001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x290001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x2a0001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x2b0001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x2c0001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x2d0001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x2e0001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x2f0001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x300001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x310001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x320001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x330001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x340001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x350001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x360001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x370001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x380001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x390001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x3a0001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x3b0001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x3c0001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x3d0001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x3e0001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x3f0001);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x86);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x2);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x21818);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff0173);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x80000);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x400001);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x6);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x2020);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff01ff);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x410001);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x6);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x2020);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff01ff);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x420001);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x43);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1CE00, 0xa2000);
		wreg32_idx_byteoffset(adev, 0x1CE0C, 0x16);
		wreg32_idx_byteoffset(adev, 0x1C460, 0x450045);
		wreg32_idx_byteoffset(adev, 0x1C464, 0x430043);
		wreg32_idx_byteoffset(adev, 0x1C4E0, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E4, 0x10);
		wreg32_idx_byteoffset(adev, 0x1C4E8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C4D0, 0x18);
		wreg32_idx_byteoffset(adev, 0x1C4A4, 0x1ff01ff);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D0D0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1D0D4, 0xc);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x460001);
		wreg32_idx_byteoffset(adev, 0x1CE98, 0x3);
		wreg32_idx_byteoffset(adev, 0x1CE80, 0x4f);
		wreg32_idx_byteoffset(adev, 0x1CE84, 0x9f);
		wreg32_idx_byteoffset(adev, 0x1CE9C, 0x25243888);
		wreg32_idx_byteoffset(adev, 0x1CEA4, 0x11282894);
		wreg32_idx_byteoffset(adev, 0x1CEA8, 0xe0000f);
		wreg32_idx_byteoffset(adev, 0x1CE90, 0x40640010);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C618, 0x2000);
		wreg32_idx_byteoffset(adev, 0x1C6E0, 0x7e6a14e9);
		wreg32_idx_byteoffset(adev, 0x1C6E4, 0x94a0c408);
		wreg32_idx_byteoffset(adev, 0x1C6E8, 0xc1a9625a);
		wreg32_idx_byteoffset(adev, 0x1C6EC, 0xe43ee220);
		wreg32_idx_byteoffset(adev, 0x1C6F0, 0x60316b41);
		wreg32_idx_byteoffset(adev, 0x1C6F4, 0xd5b85760);
		wreg32_idx_byteoffset(adev, 0x1C6F8, 0x2b589527);
		wreg32_idx_byteoffset(adev, 0x1C6FC, 0xc7a447aa);
		wreg32_idx_byteoffset(adev, 0x1C6D0, 0x83103ba1);
		wreg32_idx_byteoffset(adev, 0x1C6D4, 0x668446d5);
		wreg32_idx_byteoffset(adev, 0x1C6D8, 0xf6592b5f);
		wreg32_idx_byteoffset(adev, 0x1C6DC, 0xfce059a);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x5614351);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1CE88, 0x37e20000);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x1);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x470001);
		wreg32_idx_byteoffset(adev, 0x1CE98, 0x3);
		wreg32_idx_byteoffset(adev, 0x1CE80, 0x4f);
		wreg32_idx_byteoffset(adev, 0x1CE84, 0x9f);
		wreg32_idx_byteoffset(adev, 0x1CE9C, 0x25243888);
		wreg32_idx_byteoffset(adev, 0x1CEA4, 0x11282894);
		wreg32_idx_byteoffset(adev, 0x1CEA8, 0x60000f);
		wreg32_idx_byteoffset(adev, 0x1CE90, 0x9d000010);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C618, 0x2000);
		wreg32_idx_byteoffset(adev, 0x1C6E0, 0x62c06669);
		wreg32_idx_byteoffset(adev, 0x1C6E4, 0xa1b42b58);
		wreg32_idx_byteoffset(adev, 0x1C6E8, 0x75f0e8fd);
		wreg32_idx_byteoffset(adev, 0x1C6EC, 0xa73b2946);
		wreg32_idx_byteoffset(adev, 0x1C6F0, 0xa30106a);
		wreg32_idx_byteoffset(adev, 0x1C6F4, 0x44235d43);
		wreg32_idx_byteoffset(adev, 0x1C6F8, 0xe83784c5);
		wreg32_idx_byteoffset(adev, 0x1C6FC, 0xaee1454);
		wreg32_idx_byteoffset(adev, 0x1C6D0, 0x778df19d);
		wreg32_idx_byteoffset(adev, 0x1C6D4, 0x6e622afe);
		wreg32_idx_byteoffset(adev, 0x1C6D8, 0xb2daede3);
		wreg32_idx_byteoffset(adev, 0x1C6DC, 0x445cc41e);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x6224542);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1CE88, 0x2eb20000);
		wreg32_idx_byteoffset(adev, 0x1C08C, 0x1);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x430001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C574, 0x410000e);
		wreg32_idx_byteoffset(adev, 0x1C578, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C57C, 0x410000e);
		wreg32_idx_byteoffset(adev, 0x1C580, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C560, 0x1010);
		wreg32_idx_byteoffset(adev, 0x1C564, 0x410007f);
		wreg32_idx_byteoffset(adev, 0x1C568, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C56C, 0x410007f);
		wreg32_idx_byteoffset(adev, 0x1C570, 0x0);
		wreg32_idx_byteoffset(adev, 0x1CBF8, 0x4a2a400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x440001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C574, 0x4);
		wreg32_idx_byteoffset(adev, 0x1C578, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C57C, 0x4);
		wreg32_idx_byteoffset(adev, 0x1C580, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C560, 0x808);
		wreg32_idx_byteoffset(adev, 0x1C564, 0x410417f);
		wreg32_idx_byteoffset(adev, 0x1C568, 0x1041041);
		wreg32_idx_byteoffset(adev, 0x1C56C, 0x410417f);
		wreg32_idx_byteoffset(adev, 0x1C570, 0x1041041);
		wreg32_idx_byteoffset(adev, 0x1CBF8, 0x4a2a400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C3F8, 0x6650c);
		wreg32_idx_byteoffset(adev, 0x1C350, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C354, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C358, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C35C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C360, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C364, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C124, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C120, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C12C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C128, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C134, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C130, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C13C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C138, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C144, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C140, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C14C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C148, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x10001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x20001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x30001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x40001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x50001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x60001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x70001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x80001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x90001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0xa0001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0xb0001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0xc0001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0xd0001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0xe0001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0xf0001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x100001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x110001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x120001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x130001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x140001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x150001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x160001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x170001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x180001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x190001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x1a0001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x1b0001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x1c0001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x1d0001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x1e0001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x1f0001);
		wreg32_idx_byteoffset(adev, 0x1C114, 0x7f000);
		wreg32_idx_byteoffset(adev, 0x1C110, 0x21);
		wreg32_idx_byteoffset(adev, 0x1C11C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C118, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C1B4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C304, 0x7ff00);
		wreg32_idx_byteoffset(adev, 0x1C308, 0x7ff3c);
		wreg32_idx_byteoffset(adev, 0x1C30C, 0x3ff801);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C314, 0x7ff40);
		wreg32_idx_byteoffset(adev, 0x1C318, 0x7ffbc);
		wreg32_idx_byteoffset(adev, 0x1C31C, 0x3ffa01);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1C324, 0x7ffc0);
		wreg32_idx_byteoffset(adev, 0x1C328, 0x7ffcc);
		wreg32_idx_byteoffset(adev, 0x1C32C, 0x3ffe01);
		wreg32_idx_byteoffset(adev, 0x1C320, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1C334, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C338, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C33C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C330, 0x400);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x400001);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x410001);
		wreg32_idx_byteoffset(adev, 0x1C300, 0xc0401);
		wreg32_idx_byteoffset(adev, 0x1C310, 0x80401);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x450001);
		wreg32_idx_byteoffset(adev, 0x1C300, 0x40401);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x450001);
		wreg32_idx_byteoffset(adev, 0x1C3F0, 0x1);
		wreg32_idx_byteoffset(adev, 0x1C760, 0x400000);
		wreg32_idx_byteoffset(adev, 0x1C764, 0x400000);
		wreg32_idx_byteoffset(adev, 0x1C768, 0x400000);
		wreg32_idx_byteoffset(adev, 0x1C76C, 0x400000);
		wreg32_idx_byteoffset(adev, 0x1C770, 0x400000);
		wreg32_idx_byteoffset(adev, 0x1C774, 0x400000);
		wreg32_idx_byteoffset(adev, 0x1C778, 0x400000);
		wreg32_idx_byteoffset(adev, 0x1C77C, 0x400000);
		wreg32_idx_byteoffset(adev, 0x1C78C, 0x200);
		wreg32_idx_byteoffset(adev, 0x1C740, 0x22312223);
		wreg32_idx_byteoffset(adev, 0x1C744, 0x22312223);
		wreg32_idx_byteoffset(adev, 0x1C748, 0x22312223);
		wreg32_idx_byteoffset(adev, 0x1C74C, 0x22312223);
		wreg32_idx_byteoffset(adev, 0x1C788, 0xff);
		wreg32_idx_byteoffset(adev, 0x1C738, 0x26d400);
		wreg32_idx_byteoffset(adev, 0x1D490, 0x2);
		wreg32_idx_byteoffset(adev, 0x1D504, 0x4000000);
		wreg32_idx_byteoffset(adev, 0x1D4FC, 0xe0000280);
		wreg32_idx_byteoffset(adev, 0x1D4F8, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D508, 0xc0700420);
		wreg32_idx_byteoffset(adev, 0x1C468, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C678, 0x1010011);
		wreg32_idx_byteoffset(adev, 0x1C67C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C5AC, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D7C4, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C780, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C784, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C46C, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C724, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0x1C728, 0xe);
		wreg32_idx_byteoffset(adev, 0x1C504, 0x2);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x0);
		wreg32_idx_byteoffset(adev, 0x1D040, 0x0);
		wreg32_idx_byteoffset(adev, 0x1C504, 0x3);
		wreg32_idx_byteoffset(adev, 0x11EE0864, 0x0);
		wreg32_idx_byteoffset(adev, 0x11EE1864, 0x0);
		wreg32_idx_byteoffset(adev, 0x11EE2864, 0x0);
		wreg32_idx_byteoffset(adev, 0x11EE3864, 0x0);
		wreg32_idx_byteoffset(adev, 0x11EF0034, 0x1);
		wreg32_idx_byteoffset(adev, 0x111402D8, 0x340079c);


		wreg32_idx_byteoffset(adev, 0x681B8, 0x3);
		wreg32_idx_byteoffset(adev, 0x683B8, 0x3);

		/*Start with InitMmhub on GPU 0 */
		wreg32_idx_byteoffset(adev, 0x68E18, 0x0007a640);
		wreg32_idx_byteoffset(adev, 0x68E14, 0x00000009);
		wreg32_idx_byteoffset(adev, 0x68E18, 0x0002a64a);
		wreg32_idx_byteoffset(adev, 0x68E14, 0x0000000d);
		wreg32_idx_byteoffset(adev, 0x68E18, 0x0002a680);
		wreg32_idx_byteoffset(adev, 0x68E14, 0x00000011);
		wreg32_idx_byteoffset(adev, 0x68E18, 0x0006a684);
		wreg32_idx_byteoffset(adev, 0x68E14, 0x00000019);
		wreg32_idx_byteoffset(adev, 0x68E18, 0x000ea68e);
		wreg32_idx_byteoffset(adev, 0x68E14, 0x00000029);
		wreg32_idx_byteoffset(adev, 0x68E18, 0x0000a69e);
		wreg32_idx_byteoffset(adev, 0x68E14, 0x0000002b);
		wreg32_idx_byteoffset(adev, 0x68E18, 0x0034a6c0);
		wreg32_idx_byteoffset(adev, 0x68E14, 0x00000061);
		wreg32_idx_byteoffset(adev, 0x68E18, 0x0083a707);
		wreg32_idx_byteoffset(adev, 0x68E14, 0x000000e6);
		wreg32_idx_byteoffset(adev, 0x68E18, 0x0008a7a4);
		wreg32_idx_byteoffset(adev, 0x68E14, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x68E18, 0x0001a7b8);
		wreg32_idx_byteoffset(adev, 0x68E14, 0x000000f3);
		wreg32_idx_byteoffset(adev, 0x68E18, 0x0000a7dc);
		wreg32_idx_byteoffset(adev, 0x68E14, 0x000000f5);
		wreg32_idx_byteoffset(adev, 0x68E18, 0x0012a7f5);
		wreg32_idx_byteoffset(adev, 0x68E14, 0x00000109);
		wreg32_idx_byteoffset(adev, 0x68E18, 0x0012a810);
		wreg32_idx_byteoffset(adev, 0x68E14, 0x0000011d);
		wreg32_idx_byteoffset(adev, 0x68E18, 0x0007a82c);
		wreg32_idx_byteoffset(adev, 0x68E1C, 0x00494000);
		wreg32_idx_byteoffset(adev, 0x68E20, 0x00019000);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x0025a000);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x00000027);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x002ca02c);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x00000055);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x0002a061);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x00000059);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x0017a068);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x00000072);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x0018a100);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x0000008c);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x0004a132);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x00000092);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x000ca141);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x000000a0);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x002fa158);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x000000d1);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x0017a1d0);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x000000ea);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x0001a1e9);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x000000ed);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x0013a1ec);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x00000102);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x0007a201);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x0000010b);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x0003a20a);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x00000110);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x0007a580);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x00000119);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x0000a590);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x0000011b);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x0004a594);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x00000121);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x0001a59c);
		wreg32_idx_byteoffset(adev, 0x68E40, 0x00000124);
		wreg32_idx_byteoffset(adev, 0x68E44, 0x0007a82c);
		wreg32_idx_byteoffset(adev, 0x68E48, 0x00258000);
		wreg32_idx_byteoffset(adev, 0x68E4C, 0x00004800);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x0025a080);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x00000027);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x002ca0ac);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x00000055);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x0002a0e1);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x00000059);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x0017a0e8);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x00000072);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x0018a240);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x0000008c);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x0004a272);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x00000092);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x000ca281);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x000000a0);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x002fa298);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x000000d1);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x0017a310);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x000000ea);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x0001a329);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x000000ed);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x0013a32c);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x00000102);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x0007a341);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x0000010b);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x0003a34a);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x00000110);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x0007a580);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x00000119);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x0000a590);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x0000011b);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x0004a594);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x00000121);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x0001a59c);
		wreg32_idx_byteoffset(adev, 0x68E6C, 0x00000124);
		wreg32_idx_byteoffset(adev, 0x68E70, 0x0007a82c);
		wreg32_idx_byteoffset(adev, 0x68E74, 0x00258000);
		wreg32_idx_byteoffset(adev, 0x68E78, 0x00004800);
		wreg32_idx_byteoffset(adev, 0x68000, 0xfe5fe0f8);
		wreg32_idx_byteoffset(adev, 0x68400, 0x55555554);
		wreg32_idx_byteoffset(adev, 0x68038, 0xfe5fe0fa);
		wreg32_idx_byteoffset(adev, 0x68400, 0x65555554);
		wreg32_idx_byteoffset(adev, 0x68008, 0xfe5fe0f8);
		wreg32_idx_byteoffset(adev, 0x68400, 0x65555544);
		wreg32_idx_byteoffset(adev, 0x6800C, 0xfe5fe0f8);
		wreg32_idx_byteoffset(adev, 0x68400, 0x65555504);
		wreg32_idx_byteoffset(adev, 0x68010, 0xfe5fe0f8);
		wreg32_idx_byteoffset(adev, 0x68400, 0x65555404);
		wreg32_idx_byteoffset(adev, 0x68014, 0xfe5fe0f8);
		wreg32_idx_byteoffset(adev, 0x68400, 0x65555004);
		wreg32_idx_byteoffset(adev, 0x68200, 0xfe5fe0f8);
		wreg32_idx_byteoffset(adev, 0x68900, 0x55555554);
		wreg32_idx_byteoffset(adev, 0x68204, 0xfe5fe0f8);
		wreg32_idx_byteoffset(adev, 0x68900, 0x55555550);
		wreg32_idx_byteoffset(adev, 0x68230, 0xfe5fe0f8);
		wreg32_idx_byteoffset(adev, 0x68900, 0x54555550);
		wreg32_idx_byteoffset(adev, 0x68290, 0x7800e408);
		wreg32_idx_byteoffset(adev, 0x68230, 0xfe5fe0f0);
		wreg32_idx_byteoffset(adev, 0x680B0, 0xfe5fe0f8);
		wreg32_idx_byteoffset(adev, 0x68408, 0x55555554);
		wreg32_idx_byteoffset(adev, 0x680E8, 0xfe5fe0fa);
		wreg32_idx_byteoffset(adev, 0x68408, 0x65555554);
		wreg32_idx_byteoffset(adev, 0x680B8, 0xfe5fe0f8);
		wreg32_idx_byteoffset(adev, 0x68408, 0x65555544);
		wreg32_idx_byteoffset(adev, 0x680BC, 0xfe5fe0f8);
		wreg32_idx_byteoffset(adev, 0x68408, 0x65555504);
		wreg32_idx_byteoffset(adev, 0x680C0, 0xfe5fe0f8);
		wreg32_idx_byteoffset(adev, 0x68408, 0x65555404);
		wreg32_idx_byteoffset(adev, 0x680C4, 0xfe5fe0f8);
		wreg32_idx_byteoffset(adev, 0x68408, 0x65555004);
		wreg32_idx_byteoffset(adev, 0x680C8, 0xfe5fe0f8);
		wreg32_idx_byteoffset(adev, 0x68408, 0x65554004);
		wreg32_idx_byteoffset(adev, 0x682B0, 0xfe5fe0f8);
		wreg32_idx_byteoffset(adev, 0x68908, 0x55555554);
		wreg32_idx_byteoffset(adev, 0x682B4, 0xfe5fe0f8);
		wreg32_idx_byteoffset(adev, 0x68908, 0x55555550);
		wreg32_idx_byteoffset(adev, 0x68CC8, 0x000107bf);
		wreg32_idx_byteoffset(adev, 0x68CC8, 0x000707bf);
		wreg32_idx_byteoffset(adev, 0x681B8, 0x00000003);
		wreg32_idx_byteoffset(adev, 0x683B8, 0x00000003);
		wreg32_idx_byteoffset(adev, 0x68090, 0x7be0e408);
		wreg32_idx_byteoffset(adev, 0x687C8, 0x000107bf);
		wreg32_idx_byteoffset(adev, 0x687C8, 0x000707bf);
		wreg32_idx_byteoffset(adev, 0x68004, 0xfe5fe069);
		wreg32_idx_byteoffset(adev, 0x68004, 0xfe5fe669);
		wreg32_idx_byteoffset(adev, 0x68008, 0xfe5fe0a8);
		wreg32_idx_byteoffset(adev, 0x68008, 0xfe5feaa8);
		wreg32_idx_byteoffset(adev, 0x6800C, 0xfe5fe0a8);
		wreg32_idx_byteoffset(adev, 0x6800C, 0xfe5feaa8);
		wreg32_idx_byteoffset(adev, 0x68010, 0xfe5fe0a8);
		wreg32_idx_byteoffset(adev, 0x68010, 0xfe5feaa8);
		wreg32_idx_byteoffset(adev, 0x68014, 0xfe5fe0a8);
		wreg32_idx_byteoffset(adev, 0x68014, 0xfe5feaa8);
		wreg32_idx_byteoffset(adev, 0x68200, 0xfe5fe0a8);
		wreg32_idx_byteoffset(adev, 0x68200, 0xfe5feaa8);
		wreg32_idx_byteoffset(adev, 0x68204, 0xfe5fe0a8);
		wreg32_idx_byteoffset(adev, 0x68204, 0xfe5feaa8);
		wreg32_idx_byteoffset(adev, 0x680B4, 0xfe5fe069);
		wreg32_idx_byteoffset(adev, 0x680B4, 0xfe5fe669);
		wreg32_idx_byteoffset(adev, 0x680B8, 0xfe5fe0c8);
		wreg32_idx_byteoffset(adev, 0x680B8, 0xfe5fecc8);
		wreg32_idx_byteoffset(adev, 0x680BC, 0xfe5fe0a8);
		wreg32_idx_byteoffset(adev, 0x680BC, 0xfe5feaa8);
		wreg32_idx_byteoffset(adev, 0x680C0, 0xfe5fe0a8);
		wreg32_idx_byteoffset(adev, 0x680C0, 0xfe5feaa8);
		wreg32_idx_byteoffset(adev, 0x680C4, 0xfe5fe0a8);
		wreg32_idx_byteoffset(adev, 0x680C4, 0xfe5feaa8);
		wreg32_idx_byteoffset(adev, 0x680C8, 0xfe5fe0a8);
		wreg32_idx_byteoffset(adev, 0x680C8, 0xfe5feaa8);
		wreg32_idx_byteoffset(adev, 0x682B0, 0xfe5fe0a8);
		wreg32_idx_byteoffset(adev, 0x682B0, 0xfe5feaa8);
		wreg32_idx_byteoffset(adev, 0x682B4, 0xfe5fe0a8);
		wreg32_idx_byteoffset(adev, 0x682B4, 0xfe5feaa8);
		wreg32_idx_byteoffset(adev, 0x682B8, 0xfe5fe069);
		wreg32_idx_byteoffset(adev, 0x682B8, 0xfe5fe669);
		wreg32_idx_byteoffset(adev, 0x6A0B0, 0x00101010);
		wreg32_idx_byteoffset(adev, 0x6A0B4, 0x0010101f);
		wreg32_idx_byteoffset(adev, 0x6A0CC, 0x00002541);
		wreg32_idx_byteoffset(adev, 0x6A0CC, 0x00002141);
		wreg32_idx_byteoffset(adev, 0x69A00, 0x00080603);
		wreg32_idx_byteoffset(adev, 0x69A5C, 0x00000081);
		wreg32_idx_byteoffset(adev, 0x69A5C, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x69B04, 0x007ffe81);
		wreg32_idx_byteoffset(adev, 0x69D34, 0x01010000);
		wreg32_idx_byteoffset(adev, 0x69DB4, 0x01011fff);
		wreg32_idx_byteoffset(adev, 0x69B40, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x69B40, 0x0000000c);
		wreg32_idx_byteoffset(adev, 0x69B40, 0x0000001c);
		wreg32_idx_byteoffset(adev, 0x69B40, 0x0000003c);
		wreg32_idx_byteoffset(adev, 0x69B40, 0x0000007c);
		wreg32_idx_byteoffset(adev, 0x69B40, 0x000000fc);
		wreg32_idx_byteoffset(adev, 0x69B40, 0x000001fc);
		wreg32_idx_byteoffset(adev, 0x69B40, 0x000003fc);
		wreg32_idx_byteoffset(adev, 0x69B40, 0x000007fc);
		wreg32_idx_byteoffset(adev, 0x69B40, 0x00000ffc);
		wreg32_idx_byteoffset(adev, 0x69B40, 0x00001ffc);
		wreg32_idx_byteoffset(adev, 0x69B40, 0x00003ffc);
		wreg32_idx_byteoffset(adev, 0x69B40, 0x00007ffc);
		wreg32_idx_byteoffset(adev, 0x69B40, 0x0000fffc);
		wreg32_idx_byteoffset(adev, 0x69B40, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x69600, 0x00050b00);
		wreg32_idx_byteoffset(adev, 0x69D38, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x69DB8, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x69CB8, 0x00000000);
		/*## End with InitMmhub on GPU 0*/

		/* insert MMHUB seq here.*/
		wreg32_idx_byteoffset(adev, 0x3D80, 0x10100000);
		wreg32_idx_byteoffset(adev, 0x3D88, 0x00000010);
		/* Done with MMHUB Init on GPU 0*/

		/*Start with UMC Init on GPU 0*/
		wreg32_idx_byteoffset(adev, 0x4B644, 0x800000ff);
		/* Start with UmcInit() on GPU 0*/
	 	wreg32_idx_byteoffset(adev, 0x57200, 0x00000101);
		wreg32_idx_byteoffset(adev, 0x157200, 0x00000101);
		wreg32_idx_byteoffset(adev, 0x257200, 0x00000101);
		wreg32_idx_byteoffset(adev, 0x357200, 0x00000101);
		wreg32_idx_byteoffset(adev, 0x457200, 0x00000101);
		wreg32_idx_byteoffset(adev, 0x557200, 0x00000101);
		wreg32_idx_byteoffset(adev, 0x657200, 0x00000101);
		wreg32_idx_byteoffset(adev, 0x757200, 0x00000101);
		wreg32_idx_byteoffset(adev, 0x571E8, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x1571E8, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x2571E8, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x3571E8, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x4571E8, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x5571E8, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x6571E8, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x7571E8, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x571E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1571E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2571E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3571E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4571E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5571E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6571E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7571E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x571E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1571E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2571E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3571E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4571E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5571E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6571E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7571E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x57170, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x157170, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x257170, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x357170, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x457170, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x557170, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x657170, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x757170, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5717C, 0x040e7d98);
		wreg32_idx_byteoffset(adev, 0x15717C, 0x040e7d98);
		wreg32_idx_byteoffset(adev, 0x25717C, 0x040e7d98);
		wreg32_idx_byteoffset(adev, 0x35717C, 0x040e7d98);
		wreg32_idx_byteoffset(adev, 0x45717C, 0x040e7d98);
		wreg32_idx_byteoffset(adev, 0x55717C, 0x040e7d98);
		wreg32_idx_byteoffset(adev, 0x65717C, 0x040e7d98);
		wreg32_idx_byteoffset(adev, 0x75717C, 0x040e7d98);
		wreg32_idx_byteoffset(adev, 0x57178, 0x00e3950b);
		wreg32_idx_byteoffset(adev, 0x157178, 0x00e3950b);
		wreg32_idx_byteoffset(adev, 0x257178, 0x00e3950b);
		wreg32_idx_byteoffset(adev, 0x357178, 0x00e3950b);
		wreg32_idx_byteoffset(adev, 0x457178, 0x00e3950b);
		wreg32_idx_byteoffset(adev, 0x557178, 0x00e3950b);
		wreg32_idx_byteoffset(adev, 0x657178, 0x00e3950b);
		wreg32_idx_byteoffset(adev, 0x757178, 0x00e3950b);
		wreg32_idx_byteoffset(adev, 0x57180, 0x001bff78);
		wreg32_idx_byteoffset(adev, 0x157180, 0x001bff78);
		wreg32_idx_byteoffset(adev, 0x257180, 0x001bff78);
		wreg32_idx_byteoffset(adev, 0x357180, 0x001bff78);
		wreg32_idx_byteoffset(adev, 0x457180, 0x001bff78);
		wreg32_idx_byteoffset(adev, 0x557180, 0x001bff78);
		wreg32_idx_byteoffset(adev, 0x657180, 0x001bff78);
		wreg32_idx_byteoffset(adev, 0x757180, 0x001bff78);
		wreg32_idx_byteoffset(adev, 0x57184, 0x00e8d63e);
		wreg32_idx_byteoffset(adev, 0x157184, 0x00e8d63e);
		wreg32_idx_byteoffset(adev, 0x257184, 0x00e8d63e);
		wreg32_idx_byteoffset(adev, 0x357184, 0x00e8d63e);
		wreg32_idx_byteoffset(adev, 0x457184, 0x00e8d63e);
		wreg32_idx_byteoffset(adev, 0x557184, 0x00e8d63e);
		wreg32_idx_byteoffset(adev, 0x657184, 0x00e8d63e);
		wreg32_idx_byteoffset(adev, 0x757184, 0x00e8d63e);
		wreg32_idx_byteoffset(adev, 0x57174, 0x04538e50);
		wreg32_idx_byteoffset(adev, 0x157174, 0x04538e50);
		wreg32_idx_byteoffset(adev, 0x257174, 0x04538e50);
		wreg32_idx_byteoffset(adev, 0x357174, 0x04538e50);
		wreg32_idx_byteoffset(adev, 0x457174, 0x04538e50);
		wreg32_idx_byteoffset(adev, 0x557174, 0x04538e50);
		wreg32_idx_byteoffset(adev, 0x657174, 0x04538e50);
		wreg32_idx_byteoffset(adev, 0x757174, 0x04538e50);
		wreg32_idx_byteoffset(adev, 0x57188, 0x04493f6b);
		wreg32_idx_byteoffset(adev, 0x157188, 0x04493f6b);
		wreg32_idx_byteoffset(adev, 0x257188, 0x04493f6b);
		wreg32_idx_byteoffset(adev, 0x357188, 0x04493f6b);
		wreg32_idx_byteoffset(adev, 0x457188, 0x04493f6b);
		wreg32_idx_byteoffset(adev, 0x557188, 0x04493f6b);
		wreg32_idx_byteoffset(adev, 0x657188, 0x04493f6b);
		wreg32_idx_byteoffset(adev, 0x757188, 0x04493f6b);
		wreg32_idx_byteoffset(adev, 0x5718C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15718C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25718C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35718C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45718C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55718C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65718C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75718C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x571A8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1571A8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2571A8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3571A8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4571A8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5571A8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6571A8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7571A8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x571C4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1571C4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2571C4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3571C4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4571C4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5571C4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6571C4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7571C4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x57198, 0x038a57ee);
		wreg32_idx_byteoffset(adev, 0x157198, 0x038a57ee);
		wreg32_idx_byteoffset(adev, 0x257198, 0x038a57ee);
		wreg32_idx_byteoffset(adev, 0x357198, 0x038a57ee);
		wreg32_idx_byteoffset(adev, 0x457198, 0x038a57ee);
		wreg32_idx_byteoffset(adev, 0x557198, 0x038a57ee);
		wreg32_idx_byteoffset(adev, 0x657198, 0x038a57ee);
		wreg32_idx_byteoffset(adev, 0x757198, 0x038a57ee);
		wreg32_idx_byteoffset(adev, 0x571B4, 0x0040c703);
		wreg32_idx_byteoffset(adev, 0x1571B4, 0x0040c703);
		wreg32_idx_byteoffset(adev, 0x2571B4, 0x0040c703);
		wreg32_idx_byteoffset(adev, 0x3571B4, 0x0040c703);
		wreg32_idx_byteoffset(adev, 0x4571B4, 0x0040c703);
		wreg32_idx_byteoffset(adev, 0x5571B4, 0x0040c703);
		wreg32_idx_byteoffset(adev, 0x6571B4, 0x0040c703);
		wreg32_idx_byteoffset(adev, 0x7571B4, 0x0040c703);
		wreg32_idx_byteoffset(adev, 0x571D0, 0x0178f557);
		wreg32_idx_byteoffset(adev, 0x1571D0, 0x0178f557);
		wreg32_idx_byteoffset(adev, 0x2571D0, 0x0178f557);
		wreg32_idx_byteoffset(adev, 0x3571D0, 0x0178f557);
		wreg32_idx_byteoffset(adev, 0x4571D0, 0x0178f557);
		wreg32_idx_byteoffset(adev, 0x5571D0, 0x0178f557);
		wreg32_idx_byteoffset(adev, 0x6571D0, 0x0178f557);
		wreg32_idx_byteoffset(adev, 0x7571D0, 0x0178f557);
		wreg32_idx_byteoffset(adev, 0x57194, 0x04be3ff0);
		wreg32_idx_byteoffset(adev, 0x157194, 0x04be3ff0);
		wreg32_idx_byteoffset(adev, 0x257194, 0x04be3ff0);
		wreg32_idx_byteoffset(adev, 0x357194, 0x04be3ff0);
		wreg32_idx_byteoffset(adev, 0x457194, 0x04be3ff0);
		wreg32_idx_byteoffset(adev, 0x557194, 0x04be3ff0);
		wreg32_idx_byteoffset(adev, 0x657194, 0x04be3ff0);
		wreg32_idx_byteoffset(adev, 0x757194, 0x04be3ff0);
		wreg32_idx_byteoffset(adev, 0x571B0, 0x04673dc5);
		wreg32_idx_byteoffset(adev, 0x1571B0, 0x04673dc5);
		wreg32_idx_byteoffset(adev, 0x2571B0, 0x04673dc5);
		wreg32_idx_byteoffset(adev, 0x3571B0, 0x04673dc5);
		wreg32_idx_byteoffset(adev, 0x4571B0, 0x04673dc5);
		wreg32_idx_byteoffset(adev, 0x5571B0, 0x04673dc5);
		wreg32_idx_byteoffset(adev, 0x6571B0, 0x04673dc5);
		wreg32_idx_byteoffset(adev, 0x7571B0, 0x04673dc5);
		wreg32_idx_byteoffset(adev, 0x571CC, 0x05b51842);
		wreg32_idx_byteoffset(adev, 0x1571CC, 0x05b51842);
		wreg32_idx_byteoffset(adev, 0x2571CC, 0x05b51842);
		wreg32_idx_byteoffset(adev, 0x3571CC, 0x05b51842);
		wreg32_idx_byteoffset(adev, 0x4571CC, 0x05b51842);
		wreg32_idx_byteoffset(adev, 0x5571CC, 0x05b51842);
		wreg32_idx_byteoffset(adev, 0x6571CC, 0x05b51842);
		wreg32_idx_byteoffset(adev, 0x7571CC, 0x05b51842);
		wreg32_idx_byteoffset(adev, 0x5719C, 0x063c818f);
		wreg32_idx_byteoffset(adev, 0x15719C, 0x063c818f);
		wreg32_idx_byteoffset(adev, 0x25719C, 0x063c818f);
		wreg32_idx_byteoffset(adev, 0x35719C, 0x063c818f);
		wreg32_idx_byteoffset(adev, 0x45719C, 0x063c818f);
		wreg32_idx_byteoffset(adev, 0x55719C, 0x063c818f);
		wreg32_idx_byteoffset(adev, 0x65719C, 0x063c818f);
		wreg32_idx_byteoffset(adev, 0x75719C, 0x063c818f);
		wreg32_idx_byteoffset(adev, 0x571B8, 0x07512627);
		wreg32_idx_byteoffset(adev, 0x1571B8, 0x07512627);
		wreg32_idx_byteoffset(adev, 0x2571B8, 0x07512627);
		wreg32_idx_byteoffset(adev, 0x3571B8, 0x07512627);
		wreg32_idx_byteoffset(adev, 0x4571B8, 0x07512627);
		wreg32_idx_byteoffset(adev, 0x5571B8, 0x07512627);
		wreg32_idx_byteoffset(adev, 0x6571B8, 0x07512627);
		wreg32_idx_byteoffset(adev, 0x7571B8, 0x07512627);
		wreg32_idx_byteoffset(adev, 0x571D4, 0x07473b3c);
		wreg32_idx_byteoffset(adev, 0x1571D4, 0x07473b3c);
		wreg32_idx_byteoffset(adev, 0x2571D4, 0x07473b3c);
		wreg32_idx_byteoffset(adev, 0x3571D4, 0x07473b3c);
		wreg32_idx_byteoffset(adev, 0x4571D4, 0x07473b3c);
		wreg32_idx_byteoffset(adev, 0x5571D4, 0x07473b3c);
		wreg32_idx_byteoffset(adev, 0x6571D4, 0x07473b3c);
		wreg32_idx_byteoffset(adev, 0x7571D4, 0x07473b3c);
		wreg32_idx_byteoffset(adev, 0x571A0, 0x03dbd9ed);
		wreg32_idx_byteoffset(adev, 0x1571A0, 0x03dbd9ed);
		wreg32_idx_byteoffset(adev, 0x2571A0, 0x03dbd9ed);
		wreg32_idx_byteoffset(adev, 0x3571A0, 0x03dbd9ed);
		wreg32_idx_byteoffset(adev, 0x4571A0, 0x03dbd9ed);
		wreg32_idx_byteoffset(adev, 0x5571A0, 0x03dbd9ed);
		wreg32_idx_byteoffset(adev, 0x6571A0, 0x03dbd9ed);
		wreg32_idx_byteoffset(adev, 0x7571A0, 0x03dbd9ed);
		wreg32_idx_byteoffset(adev, 0x571BC, 0x03e3b861);
		wreg32_idx_byteoffset(adev, 0x1571BC, 0x03e3b861);
		wreg32_idx_byteoffset(adev, 0x2571BC, 0x03e3b861);
		wreg32_idx_byteoffset(adev, 0x3571BC, 0x03e3b861);
		wreg32_idx_byteoffset(adev, 0x4571BC, 0x03e3b861);
		wreg32_idx_byteoffset(adev, 0x5571BC, 0x03e3b861);
		wreg32_idx_byteoffset(adev, 0x6571BC, 0x03e3b861);
		wreg32_idx_byteoffset(adev, 0x7571BC, 0x03e3b861);
		wreg32_idx_byteoffset(adev, 0x571D8, 0x043c67fe);
		wreg32_idx_byteoffset(adev, 0x1571D8, 0x043c67fe);
		wreg32_idx_byteoffset(adev, 0x2571D8, 0x043c67fe);
		wreg32_idx_byteoffset(adev, 0x3571D8, 0x043c67fe);
		wreg32_idx_byteoffset(adev, 0x4571D8, 0x043c67fe);
		wreg32_idx_byteoffset(adev, 0x5571D8, 0x043c67fe);
		wreg32_idx_byteoffset(adev, 0x6571D8, 0x043c67fe);
		wreg32_idx_byteoffset(adev, 0x7571D8, 0x043c67fe);
		wreg32_idx_byteoffset(adev, 0x57190, 0x050be7f7);
		wreg32_idx_byteoffset(adev, 0x157190, 0x050be7f7);
		wreg32_idx_byteoffset(adev, 0x257190, 0x050be7f7);
		wreg32_idx_byteoffset(adev, 0x357190, 0x050be7f7);
		wreg32_idx_byteoffset(adev, 0x457190, 0x050be7f7);
		wreg32_idx_byteoffset(adev, 0x557190, 0x050be7f7);
		wreg32_idx_byteoffset(adev, 0x657190, 0x050be7f7);
		wreg32_idx_byteoffset(adev, 0x757190, 0x050be7f7);
		wreg32_idx_byteoffset(adev, 0x571AC, 0x00bd2fdb);
		wreg32_idx_byteoffset(adev, 0x1571AC, 0x00bd2fdb);
		wreg32_idx_byteoffset(adev, 0x2571AC, 0x00bd2fdb);
		wreg32_idx_byteoffset(adev, 0x3571AC, 0x00bd2fdb);
		wreg32_idx_byteoffset(adev, 0x4571AC, 0x00bd2fdb);
		wreg32_idx_byteoffset(adev, 0x5571AC, 0x00bd2fdb);
		wreg32_idx_byteoffset(adev, 0x6571AC, 0x00bd2fdb);
		wreg32_idx_byteoffset(adev, 0x7571AC, 0x00bd2fdb);
		wreg32_idx_byteoffset(adev, 0x571C8, 0x018411be);
		wreg32_idx_byteoffset(adev, 0x1571C8, 0x018411be);
		wreg32_idx_byteoffset(adev, 0x2571C8, 0x018411be);
		wreg32_idx_byteoffset(adev, 0x3571C8, 0x018411be);
		wreg32_idx_byteoffset(adev, 0x4571C8, 0x018411be);
		wreg32_idx_byteoffset(adev, 0x5571C8, 0x018411be);
		wreg32_idx_byteoffset(adev, 0x6571C8, 0x018411be);
		wreg32_idx_byteoffset(adev, 0x7571C8, 0x018411be);
		wreg32_idx_byteoffset(adev, 0x571A4, 0x0103733f);
		wreg32_idx_byteoffset(adev, 0x1571A4, 0x0103733f);
		wreg32_idx_byteoffset(adev, 0x2571A4, 0x0103733f);
		wreg32_idx_byteoffset(adev, 0x3571A4, 0x0103733f);
		wreg32_idx_byteoffset(adev, 0x4571A4, 0x0103733f);
		wreg32_idx_byteoffset(adev, 0x5571A4, 0x0103733f);
		wreg32_idx_byteoffset(adev, 0x6571A4, 0x0103733f);
		wreg32_idx_byteoffset(adev, 0x7571A4, 0x0103733f);
		wreg32_idx_byteoffset(adev, 0x571C0, 0x03e82c2d);
		wreg32_idx_byteoffset(adev, 0x1571C0, 0x03e82c2d);
		wreg32_idx_byteoffset(adev, 0x2571C0, 0x03e82c2d);
		wreg32_idx_byteoffset(adev, 0x3571C0, 0x03e82c2d);
		wreg32_idx_byteoffset(adev, 0x4571C0, 0x03e82c2d);
		wreg32_idx_byteoffset(adev, 0x5571C0, 0x03e82c2d);
		wreg32_idx_byteoffset(adev, 0x6571C0, 0x03e82c2d);
		wreg32_idx_byteoffset(adev, 0x7571C0, 0x03e82c2d);
		wreg32_idx_byteoffset(adev, 0x571DC, 0x01886ca5);
		wreg32_idx_byteoffset(adev, 0x1571DC, 0x01886ca5);
		wreg32_idx_byteoffset(adev, 0x2571DC, 0x01886ca5);
		wreg32_idx_byteoffset(adev, 0x3571DC, 0x01886ca5);
		wreg32_idx_byteoffset(adev, 0x4571DC, 0x01886ca5);
		wreg32_idx_byteoffset(adev, 0x5571DC, 0x01886ca5);
		wreg32_idx_byteoffset(adev, 0x6571DC, 0x01886ca5);
		wreg32_idx_byteoffset(adev, 0x7571DC, 0x01886ca5);
		wreg32_idx_byteoffset(adev, 0x57020, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x157020, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x257020, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x357020, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x457020, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x557020, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x657020, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x757020, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x57010, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x157010, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x257010, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x357010, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x457010, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x557010, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x657010, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x757010, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x5721C, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x50104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x52104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x54104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x56104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x150104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x152104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x154104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x156104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x250104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x252104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x254104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x256104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x350104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x352104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x354104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x356104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x450104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x452104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x454104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x456104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x550104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x552104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x554104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x556104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x650104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x652104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x654104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x656104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x750104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x752104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x754104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x756104, 0x30408008);
		wreg32_idx_byteoffset(adev, 0x50104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x52104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x54104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x56104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x150104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x152104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x154104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x156104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x250104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x252104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x254104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x256104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x350104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x352104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x354104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x356104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x450104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x452104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x454104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x456104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x550104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x552104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x554104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x556104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x650104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x652104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x654104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x656104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x750104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x752104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x754104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x756104, 0xb0408008);
		wreg32_idx_byteoffset(adev, 0x50100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x52100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x54100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x56100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x150100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x152100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x154100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x156100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x250100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x252100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x254100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x256100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x350100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x352100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x354100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x356100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x450100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x452100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x454100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x456100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x550100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x552100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x554100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x556100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x650100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x652100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x654100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x656100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x750100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x752100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x754100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x756100, 0x00000103);
		wreg32_idx_byteoffset(adev, 0x50000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x52000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x54000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x56000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x150000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x152000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x154000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x156000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x250000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x252000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x254000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x256000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x350000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x352000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x354000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x356000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x450000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x452000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x454000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x456000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x550000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x552000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x554000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x556000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x650000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x652000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x654000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x656000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x750000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x752000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x754000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x756000, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x50010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756010, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756014, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x52030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x54030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x56030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x150030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x152030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x154030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x156030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x250030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x252030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x254030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x256030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x350030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x352030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x354030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x356030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x450030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x452030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x454030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x456030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x550030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x552030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x554030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x556030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x650030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x652030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x654030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x656030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x750030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x752030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x754030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x756030, 0x00100408);
		wreg32_idx_byteoffset(adev, 0x50020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x52020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x54020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x56020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x150020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x152020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x154020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x156020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x250020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x252020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x254020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x256020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x350020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x352020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x354020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x356020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x450020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x452020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x454020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x456020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x550020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x552020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x554020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x556020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x650020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x652020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x654020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x656020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x750020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x752020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x754020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x756020, 0xfffffffe);
		wreg32_idx_byteoffset(adev, 0x50028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756028, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x52040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x54040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x56040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x150040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x152040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x154040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x156040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x250040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x252040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x254040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x256040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x350040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x352040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x354040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x356040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x450040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x452040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x454040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x456040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x550040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x552040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x554040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x556040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x650040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x652040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x654040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x656040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x750040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x752040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x754040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x756040, 0x03055376);
		wreg32_idx_byteoffset(adev, 0x50054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756054, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x52050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x54050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x56050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x150050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x152050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x154050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x156050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x250050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x252050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x254050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x256050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x350050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x352050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x354050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x356050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x450050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x452050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x454050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x456050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x550050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x552050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x554050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x556050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x650050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x652050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x654050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x656050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x750050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x752050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x754050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x756050, 0xfe4cb753);
		wreg32_idx_byteoffset(adev, 0x500C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x520C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x540C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x560C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1500C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1520C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1540C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1560C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2500C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2520C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2540C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2560C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3500C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3520C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3540C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3560C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4500C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4520C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4540C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4560C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5500C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5520C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5540C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5560C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6500C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6520C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6540C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6560C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7500C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7520C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7540C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7560C8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x500CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x520CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x540CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x560CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1500CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1520CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1540CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1560CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2500CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2520CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2540CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2560CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3500CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3520CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3540CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3560CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4500CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4520CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4540CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4560CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5500CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5520CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5540CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5560CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6500CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6520CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6540CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6560CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7500CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7520CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7540CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7560CC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x500D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x520D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x540D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x560D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1500D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1520D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1540D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1560D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2500D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2520D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2540D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2560D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3500D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3520D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3540D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3560D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4500D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4520D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4540D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4560D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5500D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5520D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5540D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5560D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6500D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6520D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6540D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6560D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7500D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7520D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7540D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7560D0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x500D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x520D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x540D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x560D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1500D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1520D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1540D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1560D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2500D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2520D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2540D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2560D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3500D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3520D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3540D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3560D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4500D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4520D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4540D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4560D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5500D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5520D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5540D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5560D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6500D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6520D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6540D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6560D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7500D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7520D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7540D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7560D4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x500D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x520D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x540D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x560D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1500D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1520D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1540D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1560D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2500D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2520D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2540D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2560D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3500D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3520D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3540D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3560D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4500D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4520D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4540D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4560D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5500D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5520D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5540D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5560D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6500D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6520D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6540D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6560D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7500D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7520D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7540D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7560D8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x500E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x520E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x540E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x560E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1500E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1520E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1540E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1560E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2500E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2520E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2540E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2560E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3500E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3520E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3540E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3560E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4500E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4520E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4540E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4560E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5500E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5520E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5540E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5560E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6500E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6520E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6540E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6560E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7500E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7520E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7540E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7560E8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x500E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x520E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x540E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x560E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1500E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1520E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1540E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1560E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2500E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2520E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2540E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2560E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3500E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3520E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3540E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3560E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4500E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4520E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4540E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4560E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5500E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5520E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5540E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5560E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6500E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6520E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6540E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6560E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7500E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7520E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7540E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7560E0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x500E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x520E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x540E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x560E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1500E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1520E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1540E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x1560E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2500E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2520E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2540E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x2560E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3500E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3520E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3540E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x3560E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4500E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4520E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4540E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x4560E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5500E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5520E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5540E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5560E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6500E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6520E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6540E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x6560E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7500E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7520E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7540E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x7560E4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756C14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x52204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x54204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x56204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x150204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x152204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x154204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x156204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x250204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x252204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x254204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x256204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x350204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x352204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x354204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x356204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x450204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x452204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x454204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x456204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x550204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x552204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x554204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x556204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x650204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x652204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x654204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x656204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x750204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x752204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x754204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x756204, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x50208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x52208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x54208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x56208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x150208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x152208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x154208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x156208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x250208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x252208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x254208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x256208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x350208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x352208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x354208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x356208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x450208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x452208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x454208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x456208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x550208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x552208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x554208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x556208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x650208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x652208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x654208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x656208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x750208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x752208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x754208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x756208, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x5020C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x5220C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x5420C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x5620C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x15020C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x15220C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x15420C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x15620C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x25020C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x25220C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x25420C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x25620C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x35020C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x35220C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x35420C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x35620C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x45020C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x45220C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x45420C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x45620C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x55020C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x55220C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x55420C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x55620C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x65020C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x65220C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x65420C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x65620C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x75020C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x75220C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x75420C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x75620C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x50210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x52210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x54210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x56210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x150210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x152210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x154210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x156210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x250210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x252210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x254210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x256210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x350210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x352210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x354210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x356210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x450210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x452210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x454210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x456210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x550210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x552210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x554210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x556210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x650210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x652210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x654210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x656210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x750210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x752210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x754210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x756210, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x50214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x52214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x54214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x56214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x150214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x152214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x154214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x156214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x250214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x252214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x254214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x256214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x350214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x352214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x354214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x356214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x450214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x452214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x454214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x456214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x550214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x552214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x554214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x556214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x650214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x652214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x654214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x656214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x750214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x752214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x754214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x756214, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x50218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x52218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x54218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x56218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x150218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x152218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x154218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x156218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x250218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x252218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x254218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x256218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x350218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x352218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x354218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x356218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x450218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x452218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x454218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x456218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x550218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x552218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x554218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x556218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x650218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x652218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x654218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x656218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x750218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x752218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x754218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x756218, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x5021C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5221C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5421C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5621C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15021C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15221C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15421C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15621C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25021C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25221C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25421C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25621C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35021C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35221C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35421C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35621C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45021C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45221C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45421C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45621C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55021C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55221C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55421C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55621C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65021C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65221C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65421C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65621C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75021C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75221C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75421C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75621C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x52220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x54220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x56220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x150220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x152220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x154220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x156220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x250220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x252220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x254220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x256220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x350220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x352220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x354220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x356220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x450220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x452220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x454220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x456220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x550220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x552220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x554220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x556220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x650220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x652220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x654220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x656220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x750220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x752220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x754220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x756220, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x50224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x52224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x54224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x56224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x150224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x152224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x154224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x156224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x250224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x252224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x254224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x256224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x350224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x352224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x354224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x356224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x450224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x452224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x454224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x456224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x550224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x552224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x554224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x556224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x650224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x652224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x654224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x656224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x750224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x752224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x754224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x756224, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x50228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x52228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x54228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x56228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x150228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x152228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x154228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x156228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x250228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x252228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x254228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x256228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x350228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x352228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x354228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x356228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x450228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x452228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x454228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x456228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x550228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x552228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x554228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x556228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x650228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x652228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x654228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x656228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x750228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x752228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x754228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x756228, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x50230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x52230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x54230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x56230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x150230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x152230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x154230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x156230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x250230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x252230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x254230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x256230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x350230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x352230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x354230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x356230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x450230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x452230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x454230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x456230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x550230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x552230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x554230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x556230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x650230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x652230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x654230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x656230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x750230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x752230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x754230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x756230, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x50234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x52234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x54234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x56234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x150234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x152234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x154234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x156234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x250234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x252234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x254234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x256234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x350234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x352234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x354234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x356234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x450234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x452234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x454234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x456234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x550234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x552234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x554234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x556234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x650234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x652234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x654234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x656234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x750234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x752234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x754234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x756234, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x50238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x52238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x54238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x56238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x150238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x152238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x154238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x156238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x250238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x252238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x254238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x256238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x350238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x352238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x354238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x356238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x450238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x452238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x454238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x456238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x550238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x552238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x554238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x556238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x650238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x652238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x654238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x656238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x750238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x752238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x754238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x756238, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x5023C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5223C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5423C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5623C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15023C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15223C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15423C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15623C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25023C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25223C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25423C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25623C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35023C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35223C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35423C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35623C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45023C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45223C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45423C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45623C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55023C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55223C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55423C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55623C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65023C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65223C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65423C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65623C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75023C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75223C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75423C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75623C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x52240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x54240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x56240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x150240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x152240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x154240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x156240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x250240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x252240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x254240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x256240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x350240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x352240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x354240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x356240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x450240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x452240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x454240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x456240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x550240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x552240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x554240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x556240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x650240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x652240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x654240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x656240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x750240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x752240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x754240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x756240, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x50244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x52244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x54244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x56244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x150244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x152244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x154244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x156244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x250244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x252244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x254244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x256244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x350244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x352244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x354244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x356244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x450244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x452244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x454244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x456244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x550244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x552244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x554244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x556244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x650244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x652244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x654244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x656244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x750244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x752244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x754244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x756244, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x50250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x52250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x54250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x56250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x150250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x152250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x154250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x156250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x250250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x252250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x254250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x256250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x350250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x352250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x354250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x356250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x450250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x452250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x454250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x456250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x550250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x552250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x554250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x556250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x650250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x652250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x654250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x656250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x750250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x752250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x754250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x756250, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x50254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x52254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x54254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x56254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x150254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x152254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x154254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x156254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x250254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x252254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x254254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x256254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x350254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x352254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x354254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x356254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x450254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x452254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x454254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x456254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x550254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x552254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x554254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x556254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x650254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x652254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x654254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x656254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x750254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x752254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x754254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x756254, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x50258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x52258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x54258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x56258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x150258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x152258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x154258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x156258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x250258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x252258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x254258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x256258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x350258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x352258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x354258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x356258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x450258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x452258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x454258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x456258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x550258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x552258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x554258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x556258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x650258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x652258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x654258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x656258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x750258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x752258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x754258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x756258, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x5025C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x5225C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x5425C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x5625C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x15025C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x15225C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x15425C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x15625C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x25025C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x25225C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x25425C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x25625C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x35025C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x35225C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x35425C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x35625C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x45025C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x45225C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x45425C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x45625C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x55025C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x55225C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x55425C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x55625C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x65025C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x65225C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x65425C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x65625C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x75025C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x75225C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x75425C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x75625C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x50304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x52304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x54304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x56304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x150304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x152304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x154304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x156304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x250304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x252304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x254304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x256304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x350304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x352304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x354304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x356304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x450304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x452304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x454304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x456304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x550304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x552304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x554304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x556304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x650304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x652304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x654304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x656304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x750304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x752304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x754304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x756304, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x50308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x52308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x54308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x56308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x150308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x152308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x154308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x156308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x250308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x252308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x254308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x256308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x350308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x352308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x354308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x356308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x450308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x452308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x454308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x456308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x550308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x552308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x554308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x556308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x650308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x652308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x654308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x656308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x750308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x752308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x754308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x756308, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x5030C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x5230C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x5430C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x5630C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x15030C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x15230C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x15430C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x15630C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x25030C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x25230C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x25430C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x25630C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x35030C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x35230C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x35430C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x35630C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x45030C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x45230C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x45430C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x45630C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x55030C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x55230C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x55430C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x55630C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x65030C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x65230C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x65430C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x65630C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x75030C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x75230C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x75430C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x75630C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x50310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x52310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x54310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x56310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x150310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x152310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x154310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x156310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x250310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x252310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x254310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x256310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x350310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x352310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x354310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x356310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x450310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x452310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x454310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x456310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x550310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x552310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x554310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x556310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x650310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x652310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x654310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x656310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x750310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x752310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x754310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x756310, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x50314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x52314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x54314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x56314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x150314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x152314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x154314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x156314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x250314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x252314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x254314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x256314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x350314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x352314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x354314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x356314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x450314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x452314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x454314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x456314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x550314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x552314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x554314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x556314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x650314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x652314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x654314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x656314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x750314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x752314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x754314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x756314, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x50318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x52318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x54318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x56318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x150318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x152318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x154318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x156318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x250318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x252318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x254318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x256318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x350318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x352318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x354318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x356318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x450318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x452318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x454318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x456318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x550318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x552318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x554318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x556318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x650318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x652318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x654318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x656318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x750318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x752318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x754318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x756318, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x5031C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5231C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5431C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5631C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15031C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15231C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15431C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15631C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25031C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25231C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25431C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25631C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35031C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35231C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35431C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35631C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45031C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45231C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45431C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45631C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55031C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55231C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55431C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55631C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65031C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65231C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65431C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65631C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75031C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75231C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75431C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75631C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x52320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x54320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x56320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x150320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x152320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x154320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x156320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x250320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x252320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x254320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x256320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x350320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x352320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x354320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x356320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x450320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x452320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x454320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x456320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x550320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x552320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x554320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x556320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x650320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x652320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x654320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x656320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x750320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x752320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x754320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x756320, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x50324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x52324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x54324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x56324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x150324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x152324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x154324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x156324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x250324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x252324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x254324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x256324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x350324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x352324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x354324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x356324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x450324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x452324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x454324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x456324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x550324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x552324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x554324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x556324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x650324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x652324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x654324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x656324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x750324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x752324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x754324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x756324, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x50328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x52328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x54328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x56328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x150328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x152328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x154328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x156328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x250328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x252328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x254328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x256328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x350328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x352328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x354328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x356328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x450328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x452328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x454328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x456328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x550328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x552328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x554328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x556328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x650328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x652328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x654328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x656328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x750328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x752328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x754328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x756328, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x50330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x52330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x54330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x56330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x150330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x152330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x154330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x156330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x250330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x252330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x254330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x256330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x350330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x352330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x354330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x356330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x450330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x452330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x454330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x456330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x550330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x552330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x554330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x556330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x650330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x652330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x654330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x656330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x750330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x752330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x754330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x756330, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x50334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x52334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x54334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x56334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x150334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x152334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x154334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x156334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x250334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x252334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x254334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x256334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x350334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x352334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x354334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x356334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x450334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x452334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x454334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x456334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x550334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x552334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x554334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x556334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x650334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x652334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x654334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x656334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x750334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x752334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x754334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x756334, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x50338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x52338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x54338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x56338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x150338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x152338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x154338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x156338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x250338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x252338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x254338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x256338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x350338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x352338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x354338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x356338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x450338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x452338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x454338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x456338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x550338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x552338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x554338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x556338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x650338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x652338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x654338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x656338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x750338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x752338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x754338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x756338, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x5033C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5233C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5433C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5633C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15033C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15233C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15433C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15633C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25033C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25233C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25433C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25633C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35033C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35233C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35433C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35633C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45033C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45233C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45433C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45633C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55033C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55233C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55433C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55633C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65033C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65233C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65433C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65633C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75033C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75233C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75433C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75633C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x52340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x54340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x56340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x150340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x152340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x154340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x156340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x250340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x252340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x254340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x256340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x350340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x352340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x354340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x356340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x450340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x452340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x454340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x456340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x550340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x552340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x554340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x556340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x650340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x652340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x654340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x656340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x750340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x752340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x754340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x756340, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x50344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x52344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x54344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x56344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x150344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x152344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x154344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x156344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x250344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x252344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x254344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x256344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x350344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x352344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x354344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x356344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x450344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x452344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x454344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x456344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x550344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x552344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x554344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x556344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x650344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x652344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x654344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x656344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x750344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x752344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x754344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x756344, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x50350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x52350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x54350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x56350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x150350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x152350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x154350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x156350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x250350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x252350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x254350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x256350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x350350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x352350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x354350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x356350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x450350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x452350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x454350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x456350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x550350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x552350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x554350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x556350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x650350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x652350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x654350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x656350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x750350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x752350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x754350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x756350, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x50354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x52354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x54354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x56354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x150354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x152354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x154354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x156354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x250354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x252354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x254354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x256354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x350354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x352354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x354354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x356354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x450354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x452354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x454354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x456354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x550354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x552354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x554354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x556354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x650354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x652354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x654354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x656354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x750354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x752354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x754354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x756354, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x50358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x52358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x54358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x56358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x150358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x152358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x154358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x156358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x250358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x252358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x254358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x256358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x350358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x352358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x354358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x356358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x450358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x452358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x454358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x456358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x550358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x552358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x554358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x556358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x650358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x652358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x654358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x656358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x750358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x752358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x754358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x756358, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x5035C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x5235C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x5435C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x5635C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x15035C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x15235C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x15435C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x15635C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x25035C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x25235C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x25435C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x25635C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x35035C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x35235C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x35435C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x35635C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x45035C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x45235C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x45435C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x45635C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x55035C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x55235C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x55435C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x55635C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x65035C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x65235C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x65435C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x65635C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x75035C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x75235C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x75435C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x75635C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x50404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x52404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x54404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x56404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x150404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x152404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x154404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x156404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x250404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x252404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x254404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x256404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x350404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x352404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x354404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x356404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x450404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x452404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x454404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x456404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x550404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x552404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x554404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x556404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x650404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x652404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x654404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x656404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x750404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x752404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x754404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x756404, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x50408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x52408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x54408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x56408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x150408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x152408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x154408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x156408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x250408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x252408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x254408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x256408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x350408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x352408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x354408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x356408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x450408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x452408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x454408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x456408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x550408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x552408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x554408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x556408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x650408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x652408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x654408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x656408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x750408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x752408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x754408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x756408, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x5040C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x5240C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x5440C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x5640C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x15040C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x15240C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x15440C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x15640C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x25040C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x25240C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x25440C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x25640C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x35040C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x35240C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x35440C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x35640C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x45040C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x45240C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x45440C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x45640C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x55040C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x55240C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x55440C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x55640C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x65040C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x65240C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x65440C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x65640C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x75040C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x75240C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x75440C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x75640C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x50410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x52410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x54410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x56410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x150410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x152410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x154410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x156410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x250410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x252410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x254410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x256410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x350410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x352410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x354410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x356410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x450410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x452410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x454410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x456410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x550410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x552410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x554410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x556410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x650410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x652410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x654410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x656410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x750410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x752410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x754410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x756410, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x50414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x52414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x54414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x56414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x150414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x152414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x154414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x156414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x250414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x252414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x254414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x256414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x350414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x352414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x354414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x356414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x450414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x452414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x454414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x456414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x550414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x552414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x554414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x556414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x650414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x652414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x654414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x656414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x750414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x752414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x754414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x756414, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x50418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x52418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x54418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x56418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x150418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x152418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x154418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x156418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x250418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x252418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x254418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x256418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x350418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x352418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x354418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x356418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x450418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x452418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x454418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x456418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x550418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x552418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x554418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x556418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x650418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x652418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x654418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x656418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x750418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x752418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x754418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x756418, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x5041C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5241C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5441C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5641C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15041C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15241C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15441C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15641C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25041C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25241C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25441C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25641C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35041C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35241C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35441C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35641C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45041C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45241C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45441C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45641C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55041C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55241C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55441C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55641C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65041C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65241C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65441C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65641C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75041C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75241C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75441C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75641C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x52420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x54420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x56420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x150420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x152420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x154420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x156420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x250420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x252420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x254420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x256420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x350420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x352420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x354420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x356420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x450420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x452420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x454420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x456420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x550420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x552420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x554420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x556420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x650420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x652420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x654420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x656420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x750420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x752420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x754420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x756420, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x50424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x52424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x54424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x56424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x150424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x152424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x154424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x156424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x250424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x252424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x254424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x256424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x350424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x352424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x354424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x356424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x450424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x452424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x454424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x456424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x550424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x552424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x554424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x556424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x650424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x652424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x654424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x656424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x750424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x752424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x754424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x756424, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x50428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x52428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x54428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x56428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x150428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x152428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x154428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x156428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x250428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x252428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x254428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x256428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x350428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x352428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x354428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x356428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x450428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x452428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x454428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x456428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x550428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x552428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x554428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x556428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x650428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x652428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x654428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x656428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x750428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x752428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x754428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x756428, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x50430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x52430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x54430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x56430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x150430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x152430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x154430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x156430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x250430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x252430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x254430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x256430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x350430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x352430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x354430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x356430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x450430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x452430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x454430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x456430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x550430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x552430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x554430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x556430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x650430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x652430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x654430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x656430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x750430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x752430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x754430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x756430, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x50434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x52434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x54434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x56434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x150434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x152434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x154434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x156434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x250434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x252434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x254434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x256434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x350434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x352434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x354434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x356434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x450434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x452434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x454434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x456434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x550434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x552434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x554434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x556434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x650434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x652434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x654434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x656434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x750434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x752434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x754434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x756434, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x50438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x52438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x54438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x56438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x150438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x152438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x154438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x156438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x250438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x252438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x254438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x256438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x350438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x352438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x354438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x356438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x450438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x452438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x454438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x456438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x550438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x552438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x554438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x556438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x650438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x652438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x654438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x656438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x750438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x752438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x754438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x756438, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x5043C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5243C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5443C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5643C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15043C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15243C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15443C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15643C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25043C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25243C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25443C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25643C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35043C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35243C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35443C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35643C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45043C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45243C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45443C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45643C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55043C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55243C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55443C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55643C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65043C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65243C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65443C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65643C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75043C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75243C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75443C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75643C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x52440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x54440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x56440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x150440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x152440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x154440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x156440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x250440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x252440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x254440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x256440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x350440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x352440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x354440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x356440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x450440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x452440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x454440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x456440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x550440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x552440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x554440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x556440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x650440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x652440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x654440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x656440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x750440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x752440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x754440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x756440, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x50444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x52444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x54444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x56444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x150444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x152444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x154444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x156444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x250444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x252444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x254444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x256444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x350444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x352444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x354444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x356444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x450444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x452444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x454444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x456444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x550444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x552444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x554444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x556444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x650444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x652444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x654444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x656444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x750444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x752444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x754444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x756444, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x50450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x52450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x54450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x56450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x150450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x152450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x154450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x156450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x250450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x252450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x254450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x256450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x350450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x352450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x354450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x356450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x450450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x452450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x454450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x456450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x550450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x552450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x554450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x556450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x650450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x652450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x654450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x656450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x750450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x752450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x754450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x756450, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x50454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x52454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x54454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x56454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x150454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x152454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x154454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x156454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x250454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x252454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x254454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x256454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x350454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x352454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x354454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x356454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x450454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x452454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x454454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x456454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x550454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x552454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x554454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x556454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x650454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x652454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x654454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x656454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x750454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x752454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x754454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x756454, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x50458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x52458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x54458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x56458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x150458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x152458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x154458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x156458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x250458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x252458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x254458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x256458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x350458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x352458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x354458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x356458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x450458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x452458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x454458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x456458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x550458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x552458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x554458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x556458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x650458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x652458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x654458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x656458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x750458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x752458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x754458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x756458, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x5045C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x5245C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x5445C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x5645C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x15045C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x15245C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x15445C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x15645C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x25045C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x25245C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x25445C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x25645C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x35045C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x35245C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x35445C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x35645C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x45045C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x45245C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x45445C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x45645C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x55045C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x55245C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x55445C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x55645C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x65045C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x65245C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x65445C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x65645C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x75045C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x75245C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x75445C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x75645C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x50504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x52504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x54504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x56504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x150504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x152504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x154504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x156504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x250504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x252504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x254504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x256504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x350504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x352504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x354504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x356504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x450504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x452504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x454504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x456504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x550504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x552504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x554504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x556504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x650504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x652504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x654504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x656504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x750504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x752504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x754504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x756504, 0x0c0c0c04);
		wreg32_idx_byteoffset(adev, 0x50508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x52508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x54508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x56508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x150508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x152508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x154508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x156508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x250508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x252508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x254508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x256508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x350508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x352508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x354508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x356508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x450508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x452508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x454508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x456508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x550508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x552508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x554508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x556508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x650508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x652508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x654508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x656508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x750508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x752508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x754508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x756508, 0x10100010);
		wreg32_idx_byteoffset(adev, 0x5050C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x5250C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x5450C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x5650C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x15050C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x15250C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x15450C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x15650C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x25050C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x25250C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x25450C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x25650C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x35050C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x35250C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x35450C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x35650C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x45050C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x45250C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x45450C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x45650C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x55050C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x55250C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x55450C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x55650C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x65050C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x65250C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x65450C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x65650C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x75050C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x75250C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x75450C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x75650C, 0x0e040404);
		wreg32_idx_byteoffset(adev, 0x50510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x52510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x54510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x56510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x150510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x152510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x154510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x156510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x250510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x252510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x254510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x256510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x350510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x352510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x354510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x356510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x450510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x452510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x454510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x456510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x550510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x552510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x554510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x556510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x650510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x652510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x654510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x656510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x750510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x752510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x754510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x756510, 0x48900024);
		wreg32_idx_byteoffset(adev, 0x50514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x52514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x54514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x56514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x150514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x152514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x154514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x156514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x250514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x252514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x254514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x256514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x350514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x352514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x354514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x356514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x450514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x452514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x454514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x456514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x550514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x552514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x554514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x556514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x650514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x652514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x654514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x656514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x750514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x752514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x754514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x756514, 0x000e0a04);
		wreg32_idx_byteoffset(adev, 0x50518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x52518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x54518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x56518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x150518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x152518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x154518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x156518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x250518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x252518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x254518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x256518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x350518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x352518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x354518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x356518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x450518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x452518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x454518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x456518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x550518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x552518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x554518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x556518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x650518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x652518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x654518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x656518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x750518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x752518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x754518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x756518, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x5051C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5251C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5451C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5651C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15051C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15251C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15451C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15651C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25051C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25251C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25451C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25651C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35051C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35251C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35451C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35651C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45051C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45251C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45451C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45651C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55051C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55251C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55451C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55651C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65051C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65251C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65451C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65651C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75051C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75251C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75451C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75651C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x52520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x54520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x56520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x150520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x152520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x154520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x156520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x250520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x252520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x254520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x256520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x350520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x352520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x354520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x356520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x450520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x452520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x454520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x456520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x550520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x552520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x554520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x556520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x650520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x652520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x654520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x656520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x750520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x752520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x754520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x756520, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x50524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x52524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x54524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x56524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x150524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x152524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x154524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x156524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x250524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x252524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x254524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x256524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x350524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x352524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x354524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x356524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x450524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x452524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x454524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x456524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x550524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x552524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x554524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x556524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x650524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x652524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x654524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x656524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x750524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x752524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x754524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x756524, 0x03110300);
		wreg32_idx_byteoffset(adev, 0x50528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x52528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x54528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x56528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x150528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x152528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x154528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x156528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x250528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x252528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x254528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x256528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x350528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x352528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x354528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x356528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x450528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x452528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x454528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x456528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x550528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x552528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x554528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x556528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x650528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x652528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x654528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x656528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x750528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x752528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x754528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x756528, 0x000a080a);
		wreg32_idx_byteoffset(adev, 0x50530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x52530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x54530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x56530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x150530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x152530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x154530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x156530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x250530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x252530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x254530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x256530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x350530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x352530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x354530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x356530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x450530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x452530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x454530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x456530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x550530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x552530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x554530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x556530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x650530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x652530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x654530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x656530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x750530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x752530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x754530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x756530, 0x00001e78);
		wreg32_idx_byteoffset(adev, 0x50534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x52534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x54534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x56534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x150534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x152534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x154534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x156534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x250534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x252534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x254534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x256534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x350534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x352534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x354534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x356534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x450534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x452534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x454534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x456534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x550534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x552534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x554534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x556534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x650534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x652534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x654534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x656534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x750534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x752534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x754534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x756534, 0x20201008);
		wreg32_idx_byteoffset(adev, 0x50538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x52538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x54538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x56538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x150538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x152538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x154538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x156538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x250538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x252538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x254538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x256538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x350538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x352538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x354538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x356538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x450538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x452538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x454538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x456538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x550538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x552538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x554538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x556538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x650538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x652538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x654538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x656538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x750538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x752538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x754538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x756538, 0x0000010e);
		wreg32_idx_byteoffset(adev, 0x5053C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5253C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5453C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5653C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15053C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15253C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15453C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15653C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25053C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25253C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25453C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25653C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35053C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35253C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35453C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35653C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45053C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45253C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45453C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45653C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55053C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55253C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55453C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55653C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65053C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65253C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65453C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65653C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75053C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75253C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75453C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75653C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x52540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x54540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x56540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x150540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x152540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x154540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x156540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x250540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x252540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x254540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x256540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x350540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x352540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x354540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x356540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x450540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x452540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x454540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x456540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x550540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x552540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x554540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x556540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x650540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x652540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x654540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x656540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x750540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x752540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x754540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x756540, 0x000000f0);
		wreg32_idx_byteoffset(adev, 0x50544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x52544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x54544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x56544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x150544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x152544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x154544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x156544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x250544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x252544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x254544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x256544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x350544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x352544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x354544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x356544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x450544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x452544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x454544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x456544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x550544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x552544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x554544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x556544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x650544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x652544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x654544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x656544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x750544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x752544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x754544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x756544, 0x3a3a0008);
		wreg32_idx_byteoffset(adev, 0x50550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x52550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x54550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x56550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x150550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x152550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x154550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x156550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x250550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x252550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x254550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x256550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x350550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x352550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x354550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x356550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x450550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x452550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x454550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x456550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x550550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x552550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x554550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x556550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x650550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x652550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x654550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x656550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x750550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x752550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x754550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x756550, 0x000a0000);
		wreg32_idx_byteoffset(adev, 0x50554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x52554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x54554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x56554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x150554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x152554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x154554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x156554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x250554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x252554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x254554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x256554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x350554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x352554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x354554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x356554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x450554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x452554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x454554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x456554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x550554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x552554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x554554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x556554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x650554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x652554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x654554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x656554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x750554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x752554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x754554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x756554, 0x0a00000a);
		wreg32_idx_byteoffset(adev, 0x50558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x52558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x54558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x56558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x150558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x152558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x154558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x156558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x250558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x252558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x254558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x256558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x350558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x352558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x354558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x356558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x450558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x452558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x454558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x456558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x550558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x552558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x554558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x556558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x650558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x652558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x654558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x656558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x750558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x752558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x754558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x756558, 0x010c0202);
		wreg32_idx_byteoffset(adev, 0x5055C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x5255C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x5455C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x5655C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x15055C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x15255C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x15455C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x15655C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x25055C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x25255C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x25455C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x25655C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x35055C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x35255C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x35455C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x35655C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x45055C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x45255C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x45455C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x45655C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x55055C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x55255C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x55455C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x55655C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x65055C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x65255C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x65455C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x65655C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x75055C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x75255C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x75455C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x75655C, 0x000c2a2a);
		wreg32_idx_byteoffset(adev, 0x50260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x52260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x54260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x56260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x150260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x152260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x154260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x156260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x250260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x252260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x254260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x256260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x350260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x352260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x354260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x356260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x450260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x452260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x454260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x456260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x550260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x552260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x554260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x556260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x650260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x652260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x654260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x656260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x750260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x752260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x754260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x756260, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x50360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x52360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x54360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x56360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x150360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x152360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x154360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x156360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x250360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x252360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x254360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x256360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x350360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x352360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x354360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x356360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x450360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x452360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x454360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x456360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x550360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x552360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x554360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x556360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x650360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x652360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x654360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x656360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x750360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x752360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x754360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x756360, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x50460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x52460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x54460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x56460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x150460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x152460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x154460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x156460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x250460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x252460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x254460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x256460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x350460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x352460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x354460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x356460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x450460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x452460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x454460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x456460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x550460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x552460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x554460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x556460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x650460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x652460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x654460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x656460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x750460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x752460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x754460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x756460, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x50560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x52560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x54560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x56560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x150560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x152560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x154560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x156560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x250560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x252560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x254560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x256560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x350560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x352560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x354560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x356560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x450560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x452560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x454560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x456560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x550560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x552560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x554560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x556560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x650560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x652560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x654560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x656560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x750560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x752560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x754560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x756560, 0x00000100);
		wreg32_idx_byteoffset(adev, 0x50200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x52200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x54200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x56200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x150200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x152200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x154200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x156200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x250200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x252200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x254200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x256200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x350200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x352200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x354200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x356200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x450200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x452200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x454200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x456200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x550200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x552200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x554200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x556200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x650200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x652200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x654200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x656200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x750200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x752200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x754200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x756200, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x50300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x52300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x54300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x56300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x150300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x152300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x154300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x156300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x250300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x252300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x254300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x256300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x350300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x352300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x354300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x356300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x450300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x452300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x454300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x456300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x550300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x552300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x554300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x556300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x650300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x652300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x654300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x656300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x750300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x752300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x754300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x756300, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x50400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x52400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x54400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x56400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x150400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x152400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x154400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x156400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x250400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x252400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x254400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x256400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x350400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x352400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x354400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x356400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x450400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x452400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x454400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x456400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x550400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x552400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x554400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x556400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x650400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x652400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x654400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x656400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x750400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x752400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x754400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x756400, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x50500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x52500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x54500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x56500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x150500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x152500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x154500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x156500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x250500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x252500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x254500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x256500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x350500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x352500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x354500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x356500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x450500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x452500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x454500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x456500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x550500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x552500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x554500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x556500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x650500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x652500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x654500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x656500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x750500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x752500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x754500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x756500, 0x0000011e);
		wreg32_idx_byteoffset(adev, 0x5010C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x5210C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x5410C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x5610C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x15010C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x15210C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x15410C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x15610C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x25010C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x25210C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x25410C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x25610C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x35010C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x35210C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x35410C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x35610C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x45010C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x45210C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x45410C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x45610C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x55010C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x55210C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x55410C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x55610C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x65010C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x65210C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x65410C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x65610C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x75010C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x75210C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x75410C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x75610C, 0x00101004);
		wreg32_idx_byteoffset(adev, 0x50110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x52110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x54110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x56110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x150110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x152110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x154110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x156110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x250110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x252110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x254110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x256110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x350110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x352110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x354110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x356110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x450110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x452110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x454110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x456110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x550110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x552110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x554110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x556110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x650110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x652110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x654110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x656110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x750110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x752110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x754110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x756110, 0x00101820);
		wreg32_idx_byteoffset(adev, 0x50114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x52114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x54114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x56114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x150114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x152114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x154114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x156114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x250114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x252114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x254114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x256114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x350114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x352114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x354114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x356114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x450114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x452114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x454114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x456114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x550114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x552114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x554114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x556114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x650114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x652114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x654114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x656114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x750114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x752114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x754114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x756114, 0x18182018);
		wreg32_idx_byteoffset(adev, 0x50168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756168, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5016C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5216C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5416C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5616C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15016C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15216C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15416C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15616C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25016C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25216C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25416C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25616C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35016C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35216C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35416C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35616C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45016C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45216C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45416C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45616C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55016C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55216C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55416C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55616C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65016C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65216C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65416C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65616C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75016C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75216C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75416C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75616C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x501E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x521E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x541E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x561E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x1501E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x1521E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x1541E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x1561E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x2501E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x2521E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x2541E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x2561E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x3501E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x3521E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x3541E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x3561E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x4501E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x4521E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x4541E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x4561E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x5501E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x5521E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x5541E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x5561E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x6501E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x6521E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x6541E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x6561E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x7501E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x7521E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x7541E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x7561E0, 0x00000002);
		wreg32_idx_byteoffset(adev, 0x50070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x52070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x54070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x56070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x150070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x152070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x154070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x156070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x250070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x252070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x254070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x256070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x350070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x352070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x354070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x356070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x450070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x452070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x454070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x456070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x550070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x552070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x554070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x556070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x650070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x652070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x654070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x656070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x750070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x752070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x754070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x756070, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x50078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x52078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x54078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x56078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x150078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x152078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x154078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x156078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x250078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x252078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x254078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x256078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x350078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x352078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x354078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x356078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x450078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x452078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x454078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x456078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x550078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x552078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x554078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x556078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x650078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x652078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x654078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x656078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x750078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x752078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x754078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x756078, 0x00001000);
		wreg32_idx_byteoffset(adev, 0x5111C, 0x40000008);
		wreg32_idx_byteoffset(adev, 0x50120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x52120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x54120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x56120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x150120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x152120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x154120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x156120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x250120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x252120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x254120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x256120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x350120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x352120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x354120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x356120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x450120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x452120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x454120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x456120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x550120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x552120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x554120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x556120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x650120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x652120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x654120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x656120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x750120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x752120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x754120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x756120, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x51124, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x50DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756DC0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x52164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x54164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x56164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x150164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x152164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x154164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x156164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x250164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x252164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x254164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x256164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x350164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x352164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x354164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x356164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x450164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x452164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x454164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x456164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x550164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x552164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x554164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x556164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x650164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x652164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x654164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x656164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x750164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x752164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x754164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x756164, 0x00000270);
		wreg32_idx_byteoffset(adev, 0x50284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x52284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x54284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x56284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x150284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x152284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x154284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x156284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x250284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x252284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x254284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x256284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x350284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x352284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x354284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x356284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x450284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x452284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x454284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x456284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x550284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x552284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x554284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x556284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x650284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x652284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x654284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x656284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x750284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x752284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x754284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x756284, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x50384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x52384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x54384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x56384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x150384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x152384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x154384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x156384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x250384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x252384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x254384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x256384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x350384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x352384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x354384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x356384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x450384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x452384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x454384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x456384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x550384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x552384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x554384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x556384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x650384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x652384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x654384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x656384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x750384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x752384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x754384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x756384, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x50484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x52484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x54484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x56484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x150484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x152484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x154484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x156484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x250484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x252484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x254484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x256484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x350484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x352484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x354484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x356484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x450484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x452484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x454484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x456484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x550484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x552484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x554484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x556484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x650484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x652484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x654484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x656484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x750484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x752484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x754484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x756484, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x50584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x52584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x54584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x56584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x150584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x152584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x154584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x156584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x250584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x252584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x254584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x256584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x350584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x352584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x354584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x356584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x450584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x452584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x454584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x456584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x550584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x552584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x554584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x556584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x650584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x652584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x654584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x656584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x750584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x752584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x754584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x756584, 0x00000777);
		wreg32_idx_byteoffset(adev, 0x50148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756148, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5014C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5214C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5414C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5614C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15014C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15214C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15414C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15614C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25014C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25214C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25414C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25614C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35014C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35214C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35414C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35614C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45014C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45214C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45414C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45614C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55014C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55214C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55414C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55614C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65014C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65214C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65414C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65614C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75014C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75214C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75414C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75614C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756D80, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756D88, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756DB0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756DB4, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756DB8, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756DBC, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x52138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x54138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x56138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x150138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x152138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x154138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x156138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x250138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x252138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x254138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x256138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x350138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x352138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x354138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x356138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x450138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x452138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x454138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x456138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x550138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x552138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x554138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x556138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x650138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x652138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x654138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x656138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x750138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x752138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x754138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x756138, 0x03204060);
		wreg32_idx_byteoffset(adev, 0x5013C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x5213C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x5413C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x5613C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x15013C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x15213C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x15413C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x15613C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x25013C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x25213C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x25413C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x25613C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x35013C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x35213C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x35413C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x35613C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x45013C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x45213C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x45413C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x45613C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x55013C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x55213C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x55413C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x55613C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x65013C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x65213C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x65413C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x65613C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x75013C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x75213C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x75413C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x75613C, 0x00000017);
		wreg32_idx_byteoffset(adev, 0x50130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756130, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x500F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x520F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x540F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x560F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x1500F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x1520F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x1540F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x1560F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x2500F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x2520F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x2540F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x2560F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x3500F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x3520F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x3540F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x3560F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x4500F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x4520F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x4540F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x4560F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x5500F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x5520F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x5540F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x5560F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x6500F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x6520F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x6540F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x6560F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x7500F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x7520F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x7540F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x7560F4, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x5012C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x5212C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x5412C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x5612C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x15012C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x15212C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x15412C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x15612C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x25012C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x25212C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x25412C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x25612C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x35012C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x35212C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x35412C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x35612C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x45012C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x45212C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x45412C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x45612C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x55012C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x55212C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x55412C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x55612C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x65012C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x65212C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x65412C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x65612C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x75012C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x75212C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x75412C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x75612C, 0x41180469);
		wreg32_idx_byteoffset(adev, 0x50DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756DD0, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756288, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756388, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756488, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756588, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x52108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x54108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x56108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x150108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x152108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x154108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x156108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x250108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x252108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x254108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x256108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x350108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x352108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x354108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x356108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x450108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x452108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x454108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x456108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x550108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x552108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x554108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x556108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x650108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x652108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x654108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x656108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x750108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x752108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x754108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x756108, 0x0c400001);
		wreg32_idx_byteoffset(adev, 0x57080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x157080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x257080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x357080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x457080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x557080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x657080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x757080, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5703C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15703C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25703C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35703C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45703C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55703C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65703C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75703C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x57038, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x157038, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x257038, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x357038, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x457038, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x557038, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x657038, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x757038, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x57040, 0x0067220a);
		wreg32_idx_byteoffset(adev, 0x157040, 0x0067220a);
		wreg32_idx_byteoffset(adev, 0x257040, 0x0067220a);
		wreg32_idx_byteoffset(adev, 0x357040, 0x0067220a);
		wreg32_idx_byteoffset(adev, 0x457040, 0x0067220a);
		wreg32_idx_byteoffset(adev, 0x557040, 0x0067220a);
		wreg32_idx_byteoffset(adev, 0x657040, 0x0067220a);
		wreg32_idx_byteoffset(adev, 0x757040, 0x0067220a);
		wreg32_idx_byteoffset(adev, 0x57044, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x157044, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x257044, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x357044, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x457044, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x557044, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x657044, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x757044, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x57048, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x157048, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x257048, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x357048, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x457048, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x557048, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x657048, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x757048, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5704C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x15704C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x25704C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x35704C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x45704C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x55704C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x65704C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x75704C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x52118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x54118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x56118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x150118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x152118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x154118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x156118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x250118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x252118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x254118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x256118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x350118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x352118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x354118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x356118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x450118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x452118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x454118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x456118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x550118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x552118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x554118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x556118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x650118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x652118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x654118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x656118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x750118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x752118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x754118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x756118, 0x00000047);
		wreg32_idx_byteoffset(adev, 0x50140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756140, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756C20, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756D04, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x52D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x54D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x56D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x150D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x152D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x154D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x156D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x250D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x252D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x254D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x256D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x350D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x352D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x354D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x356D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x450D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x452D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x454D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x456D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x550D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x552D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x554D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x556D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x650D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x652D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x654D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x656D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x750D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x752D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x754D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x756D2C, 0x0001678d);
		wreg32_idx_byteoffset(adev, 0x50D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x52D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x54D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x56D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x150D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x152D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x154D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x156D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x250D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x252D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x254D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x256D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x350D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x352D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x354D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x356D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x450D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x452D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x454D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x456D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x550D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x552D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x554D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x556D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x650D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x652D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x654D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x656D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x750D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x752D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x754D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x756D28, 0xd4fd61c8);
		wreg32_idx_byteoffset(adev, 0x50D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756D08, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x52D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x54D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x56D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x150D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x152D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x154D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x156D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x250D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x252D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x254D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x256D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x350D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x352D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x354D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x356D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x450D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x452D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x454D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x456D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x550D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x552D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x554D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x556D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x650D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x652D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x654D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x656D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x750D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x752D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x754D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x756D34, 0x00013fdd);
		wreg32_idx_byteoffset(adev, 0x50D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x52D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x54D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x56D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x150D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x152D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x154D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x156D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x250D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x252D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x254D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x256D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x350D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x352D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x354D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x356D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x450D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x452D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x454D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x456D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x550D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x552D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x554D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x556D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x650D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x652D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x654D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x656D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x750D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x752D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x754D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x756D30, 0x96b97167);
		wreg32_idx_byteoffset(adev, 0x50D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756D0C, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x52D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x54D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x56D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x150D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x152D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x154D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x156D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x250D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x252D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x254D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x256D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x350D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x352D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x354D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x356D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x450D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x452D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x454D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x456D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x550D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x552D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x554D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x556D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x650D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x652D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x654D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x656D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x750D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x752D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x754D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x756D3C, 0x0000fa3b);
		wreg32_idx_byteoffset(adev, 0x50D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x52D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x54D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x56D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x150D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x152D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x154D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x156D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x250D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x252D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x254D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x256D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x350D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x352D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x354D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x356D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x450D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x452D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x454D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x456D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x550D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x552D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x554D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x556D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x650D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x652D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x654D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x656D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x750D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x752D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x754D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x756D38, 0x2f8dd6cd);
		wreg32_idx_byteoffset(adev, 0x50D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756D10, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x52D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x54D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x56D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x150D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x152D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x154D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x156D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x250D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x252D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x254D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x256D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x350D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x352D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x354D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x356D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x450D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x452D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x454D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x456D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x550D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x552D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x554D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x556D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x650D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x652D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x654D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x656D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x750D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x752D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x754D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x756D44, 0x00010589);
		wreg32_idx_byteoffset(adev, 0x50D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x52D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x54D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x56D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x150D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x152D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x154D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x156D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x250D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x252D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x254D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x256D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x350D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x352D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x354D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x356D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x450D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x452D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x454D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x456D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x550D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x552D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x554D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x556D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x650D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x652D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x654D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x656D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x750D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x752D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x754D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x756D40, 0x5fc68e4e);
		wreg32_idx_byteoffset(adev, 0x50D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756D14, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x50D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x52D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x54D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x56D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x150D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x152D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x154D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x156D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x250D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x252D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x254D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x256D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x350D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x352D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x354D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x356D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x450D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x452D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x454D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x456D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x550D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x552D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x554D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x556D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x650D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x652D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x654D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x656D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x750D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x752D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x754D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x756D4C, 0x0000881b);
		wreg32_idx_byteoffset(adev, 0x50D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x52D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x54D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x56D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x150D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x152D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x154D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x156D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x250D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x252D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x254D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x256D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x350D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x352D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x354D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x356D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x450D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x452D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x454D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x456D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x550D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x552D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x554D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x556D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x650D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x652D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x654D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x656D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x750D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x752D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x754D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x756D48, 0x02182082);
		wreg32_idx_byteoffset(adev, 0x50144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x52144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x54144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x56144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x150144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x152144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x154144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x156144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x250144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x252144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x254144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x256144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x350144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x352144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x354144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x356144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x450144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x452144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x454144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x456144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x550144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x552144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x554144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x556144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x650144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x652144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x654144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x656144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x750144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x752144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x754144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x756144, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x57018, 0x00004200);
		wreg32_idx_byteoffset(adev, 0x157018, 0x00004200);
		wreg32_idx_byteoffset(adev, 0x257018, 0x00004200);
		wreg32_idx_byteoffset(adev, 0x357018, 0x00004200);
		wreg32_idx_byteoffset(adev, 0x457018, 0x00004200);
		wreg32_idx_byteoffset(adev, 0x557018, 0x00004200);
		wreg32_idx_byteoffset(adev, 0x657018, 0x00004200);
		wreg32_idx_byteoffset(adev, 0x757018, 0x00004200);
		wreg32_idx_byteoffset(adev, 0x57018, 0x00004600);
		wreg32_idx_byteoffset(adev, 0x157018, 0x00004600);
		wreg32_idx_byteoffset(adev, 0x257018, 0x00004600);
		wreg32_idx_byteoffset(adev, 0x357018, 0x00004600);
		wreg32_idx_byteoffset(adev, 0x457018, 0x00004600);
		wreg32_idx_byteoffset(adev, 0x557018, 0x00004600);
		wreg32_idx_byteoffset(adev, 0x657018, 0x00004600);
		wreg32_idx_byteoffset(adev, 0x757018, 0x00004600);
		wreg32_idx_byteoffset(adev, 0x57018, 0x00004400);
		wreg32_idx_byteoffset(adev, 0x157018, 0x00004400);
		wreg32_idx_byteoffset(adev, 0x257018, 0x00004400);
		wreg32_idx_byteoffset(adev, 0x357018, 0x00004400);
		wreg32_idx_byteoffset(adev, 0x457018, 0x00004400);
		wreg32_idx_byteoffset(adev, 0x557018, 0x00004400);
		wreg32_idx_byteoffset(adev, 0x657018, 0x00004400);
		wreg32_idx_byteoffset(adev, 0x757018, 0x00004400);
		wreg32_idx_byteoffset(adev, 0x57010, 0x00000024);
		wreg32_idx_byteoffset(adev, 0x157010, 0x00000024);
		wreg32_idx_byteoffset(adev, 0x257010, 0x00000024);
		wreg32_idx_byteoffset(adev, 0x357010, 0x00000024);
		wreg32_idx_byteoffset(adev, 0x457010, 0x00000024);
		wreg32_idx_byteoffset(adev, 0x557010, 0x00000024);
		wreg32_idx_byteoffset(adev, 0x657010, 0x00000024);
		wreg32_idx_byteoffset(adev, 0x757010, 0x00000024);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00720080);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000343);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0000f00b);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000c800);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0000f00e);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000c800);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0000f011);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000c800);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0000f014);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000c800);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0000f008);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000080);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x000900de);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000fff0);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x000900df);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000ffff);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x000900e0);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000fff0);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x000900e1);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000ffef);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x000900f7);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00003210);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x000900fe);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00004000);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x000900d4);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000400);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x000900d7);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000400);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x000900f2);
		wreg32_idx_byteoffset(adev, 0x57004, 0x000009c4);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x001900f2);
		wreg32_idx_byteoffset(adev, 0x57004, 0x000009c4);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x002900f2);
		wreg32_idx_byteoffset(adev, 0x57004, 0x000009c4);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x003900f2);
		wreg32_idx_byteoffset(adev, 0x57004, 0x000009c4);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x000900f3);
		wreg32_idx_byteoffset(adev, 0x57004, 0x000000fa);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x001900f3);
		wreg32_idx_byteoffset(adev, 0x57004, 0x000000fa);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x002900f3);
		wreg32_idx_byteoffset(adev, 0x57004, 0x000000fa);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x003900f3);
		wreg32_idx_byteoffset(adev, 0x57004, 0x000000fa);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x000900f4);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000007d);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x001900f4);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000007d);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x002900f4);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000007d);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x003900f4);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000007d);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x000200aa);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000018);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x001200aa);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000018);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x002200aa);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000018);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x003200aa);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000018);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0002f087);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0002003f);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000080);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0002003c);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00020040);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090000);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090001);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000498);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090002);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00008410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090003);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000008);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090004);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090005);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000c00);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090006);
		wreg32_idx_byteoffset(adev, 0x57004, 0x000007ff);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090007);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000740);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090008);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00008c10);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090009);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000430);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009000a);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000540);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009000b);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00008c10);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009000c);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000438);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009000d);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000540);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009000e);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00008c10);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009000f);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090010);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000440);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090011);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00008c10);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090012);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090013);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090014);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00001c00);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090015);
		wreg32_idx_byteoffset(adev, 0x57004, 0x000007ff);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090016);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000740);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090017);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009c10);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090018);
		wreg32_idx_byteoffset(adev, 0x57004, 0x000004b0);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090019);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000540);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009001a);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009c10);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009001b);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000008);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009001c);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000618);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009001d);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009c10);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009001e);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009001f);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000440);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090020);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009c10);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090021);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090022);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090023);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000400);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090024);
		wreg32_idx_byteoffset(adev, 0x57004, 0x000007f8);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090025);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000440);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090026);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009c10);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090027);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000007);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090028);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000009a);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090029);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00001410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009002a);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000020);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009002b);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000788);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009002c);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00008448);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009002d);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000008);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009002e);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009002f);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00001400);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090030);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000007);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090031);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000618);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090032);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00008410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090033);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000437);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090034);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000540);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090035);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00008c10);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090036);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000570);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090037);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000540);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090038);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090039);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000008);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009003a);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009003b);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00001400);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009003c);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000530);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009003d);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000540);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009003e);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009003f);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090040);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090041);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00001400);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090042);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000430);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090043);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000540);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090044);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090045);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090046);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090047);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000400);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090048);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090049);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009004a);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000c00);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009004b);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009004c);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000540);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009004d);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009004e);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000008);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009004f);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000658);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090050);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090051);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000008);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090052);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090053);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000400);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090054);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000038);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090055);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000788);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090056);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009448);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090057);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000000a);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090058);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090059);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00001400);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009005a);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000000b);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009005b);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000048);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009005c);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009005d);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000001c);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009005e);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000340);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009005f);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090060);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000001d);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090061);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000048);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090062);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090063);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090064);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000340);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090065);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090066);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090067);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090068);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00001400);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090069);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009006a);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009006b);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00001400);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009006c);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000000c);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009006d);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000048);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009006e);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009006f);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000004);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090070);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000048);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090071);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090072);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000007);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090073);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000740);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090074);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090075);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000014);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090076);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000048);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090077);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090078);
		wreg32_idx_byteoffset(adev, 0x57004, 0x000007f8);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090079);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000440);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009007a);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009410);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009007b);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000010);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009007c);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000788);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009007d);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00009448);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009007e);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000ff80);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x0009007f);
		wreg32_idx_byteoffset(adev, 0x57004, 0x000006ff);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090080);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00008448);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090081);
		wreg32_idx_byteoffset(adev, 0x57004, 0x0000fff8);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090082);
		wreg32_idx_byteoffset(adev, 0x57004, 0x000006f7);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090083);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00008448);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090084);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090085);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x5700C, 0x00090086);
		wreg32_idx_byteoffset(adev, 0x57004, 0x00000000);
		wreg32_idx_byteoffset(adev, 0x570C8, 0x00001bd5);
		wreg32_idx_byteoffset(adev, 0x570C8, 0x00000bd5);
		while (1) {
			u32 temp_val =	RREG32(0x570c8 / 4);

			pr_err("waiting DFI_INIT_COMPLETE ...........\n");

			if (temp_val & 0x4000)
				break;

			pr_err("in the wait...........\n");
			udelay(10);
		}
		pr_err("DFI init success.");

		wreg32_idx_byteoffset(adev, 0x51124, 0x00000001);
		wreg32_idx_byteoffset(adev, 0x5111C, 0x00000008);
		wreg32_idx_byteoffset(adev, 0x57018, 0x0000c400);
		wreg32_idx_byteoffset(adev, 0x157018, 0x0000c400);
		wreg32_idx_byteoffset(adev, 0x257018, 0x0000c400);
		wreg32_idx_byteoffset(adev, 0x357018, 0x0000c400);
		wreg32_idx_byteoffset(adev, 0x457018, 0x0000c400);
		wreg32_idx_byteoffset(adev, 0x557018, 0x0000c400);
		wreg32_idx_byteoffset(adev, 0x657018, 0x0000c400);
		wreg32_idx_byteoffset(adev, 0x757018, 0x0000c400);
		wreg32_idx_byteoffset(adev, 0x5111C, 0x00030008);
		wreg32_idx_byteoffset(adev, 0x5111C, 0x00020008);
		wreg32_idx_byteoffset(adev, 0x57000, 0x0008e80f);
		wreg32_idx_byteoffset(adev, 0x5716C, 0x00100000);
		wreg32_idx_byteoffset(adev, 0x5716C, 0x00110010);
		wreg32_idx_byteoffset(adev, 0x5716C, 0x00120013);
		wreg32_idx_byteoffset(adev, 0x5716C, 0x001300cc);
		wreg32_idx_byteoffset(adev, 0x5716C, 0x00140000);
		wreg32_idx_byteoffset(adev, 0x57000, 0x0008e800);
		wreg32_idx_byteoffset(adev, 0x50100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x52100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x54100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x56100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x150100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x152100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x154100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x156100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x250100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x252100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x254100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x256100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x350100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x352100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x354100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x356100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x450100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x452100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x454100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x456100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x550100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x552100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x554100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x556100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x650100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x652100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x654100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x656100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x750100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x752100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x754100, 0x80000103);
		wreg32_idx_byteoffset(adev, 0x756100, 0x80000103);
		/* Done with UmcInit() on GPU 0*/

		/* Done with UMC Init on GPU 0 */

		/* Start with GC Init on GPU 0 */
	 	wreg32_idx_byteoffset(adev, 0xABC8, 0x003f3fbf);
		wreg32_idx_byteoffset(adev, 0x9C68, 0x00000001);
		wreg32_idx_byteoffset(adev, 0xABE8, 0x0d40bff0);
		wreg32_idx_byteoffset(adev, 0xA31C, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA320, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA324, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA328, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA32C, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA330, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA334, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA338, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA33C, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA340, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA344, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA348, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA34C, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA350, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA354, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA358, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA35C, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA360, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA364, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA368, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA36C, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA370, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA374, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA378, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA37C, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA380, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA384, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA388, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA38C, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA390, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA394, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA398, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA39C, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA3A0, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA3A4, 0xffffffff);
		wreg32_idx_byteoffset(adev, 0xA3A8, 0x0000001f);
		wreg32_idx_byteoffset(adev, 0xA120, 0x00020000);
		wreg32_idx_byteoffset(adev, 0xA100, 0x00080602);
		wreg32_idx_byteoffset(adev, 0xA140, 0x60e40feb);
		/* Done with GC Init on GPU 0*/

}

static const u32 vega20_golden_init[] =
{
	0xde3, 0xffffffff, 0x00000100,
	0xde4, 0xffffffff, 0x00000000,
	0xde3, 0xffffffff, 0x00000100,
	0xde3, 0xffffffff, 0x00000100,
	0x296b, 0xffffffff, 0x00000000,
	0x2680, 0xffffffff, 0x00014104,
	0x2682, 0xffffffff, 0x0a000000,
	0x2688, 0xffffffff, 0x04000080,
	0x263e, 0xffffffff, 0x2a114042,
	0x2542, 0xffffffff, 0x010b0000,
	0x2b03, 0xffffffff, 0xb5d3f197,
	0x2b04, 0xffffffff, 0x4a2c0e68,
	0x260d, 0xffffffff, 0x00000420,
	0x22fc, 0xffffffff, 0x00000001,
	0x22fd, 0xffffffff, 0x04040000,
	0xc281, 0xffffffff, 0x00000000,
	0x127a, 0xffffffff, 0x40000051,
	0x127b, 0xffffffff, 0x3f000100,
	0x127d, 0xffffffff, 0x02831f07,
	0x12e7, 0xffffffff, 0x00403000,
	0x1347, 0xffffffff, 0x00403000,
	0x13a7, 0xffffffff, 0x00403000,
	0x1407, 0xffffffff, 0x00403000,
	0x1467, 0xffffffff, 0x00403000,
	0x14c7, 0xffffffff, 0x00403000,
	0x1527, 0xffffffff, 0x00403000,
	0x1587, 0xffffffff, 0x00403000,
	0x15e7, 0xffffffff, 0x00403000,
	0x1647, 0xffffffff, 0x00403000,
	0x187a, 0xffffffff, 0x0003c800,
	0x187b, 0xffffffff, 0x3f000100,
	0x187d, 0xffffffff, 0x02831f07,
	0x18e7, 0xffffffff, 0x00403000,
	0x1947, 0xffffffff, 0x00403000,
	0x19a7, 0xffffffff, 0x00403000,
	0x1a07, 0xffffffff, 0x00403000,
	0x1a67, 0xffffffff, 0x00403000,
	0x1ac7, 0xffffffff, 0x00403000,
	0x1b27, 0xffffffff, 0x00403000,
	0x1b87, 0xffffffff, 0x00403000,
	0x1be7, 0xffffffff, 0x00403000,
	0x1c47, 0xffffffff, 0x00403000,
	0xde3, 0xffffffff, 0x00000100,
	0xde4, 0xffffffff, 0x00000000,
	0xde3, 0xffffffff, 0x00000100,
	0xeca2, 0xffffffff, 0x00000000,
	0xeca3, 0xffffffff, 0x00000000,
	0xeca4, 0xffffffff, 0x00000000,
	0x263e, 0xffffffff, 0x28104042,
	0x263e, 0xffffffff, 0x28104042,
	0xc200, 0xffffffff, 0xe0000000,
	0x263e, 0xffffffff, 0x28104042,
	0x2b03, 0xffffffff, 0xb5d3f197,
	0x2b04, 0xffffffff, 0x4a2c0e68,
	0x2711, 0xffffffff, 0x000000ff,
	0x260c, 0xffffffff, 0x00000000,
	0x21d8, 0xffffffff, 0x00002b16,
	0x21d9, 0xffffffff, 0x00008040,
	0xc441, 0xffffffff, 0x01000108,
	0xc24d, 0xffffffff, 0x00000001,
	0xd808, 0xffffffff, 0x00000000,
	0x2300, 0xffffffff, 0x01180000,
	0xc248, 0xffffffff, 0xffffffff,
	0x2231, 0xffffffff, 0x09000000,
	0xc330, 0xffffffff, 0x00000000,
	0xc332, 0xffffffff, 0x0000df80,
	0xc336, 0xffffffff, 0x02249249,
	0xc281, 0xffffffff, 0x00000000,
	0xdc02, 0xffffffff, 0x00000000,
	0xf084, 0xffffffff, 0x00018100,
	0x2285, 0xffffffff, 0x00000007,
	0x22fc, 0xffffffff, 0x00000001,
	0x22c9, 0xffffffff, 0x00ffffff,
	0x2987, 0xffffffff, 0x00002500,
	0x2985, 0xffffffff, 0x00000001,
	0x2986, 0xffffffff, 0x00000000,
	0x2974, 0xffffffff, 0x00000000,
	0x2975, 0xffffffff, 0x000000ff,
	0x2980, 0xffffffff, 0x00000090,
	0x2981, 0xffffffff, 0x0000018f,
	0x2880, 0xffffffff, 0x00000000,
	0x2881, 0xffffffff, 0x00000000,
	0x2971, 0xffffffff, 0x00000000,
	0x2972, 0xffffffff, 0x000fffff,
	0x2984, 0xffffffff, 0x00000000,
	0x2983, 0xffffffff, 0x00000002,
	0x2982, 0xffffffff, 0x00000000,
	0x2987, 0xffffffff, 0x00002001,
	0x1a833, 0xffffffff, 0x00002500,
	0x1a831, 0xffffffff, 0x00000001,
	0x1a832, 0xffffffff, 0x00000000,
	0x1a820, 0xffffffff, 0x00000000,
	0x1a821, 0xffffffff, 0x000000ff,
	0x1a82c, 0xffffffff, 0x00000090,
	0x1a82d, 0xffffffff, 0x0000018f,
	0x1a6c0, 0xffffffff, 0x00000000,
	0x1a6c1, 0xffffffff, 0x00000000,
	0x1a81d, 0xffffffff, 0x00000000,
	0x1a81e, 0xffffffff, 0x000fffff,
	0x1a830, 0xffffffff, 0x00000000,
	0x1a82f, 0xffffffff, 0x00000002,
	0x1a82e, 0xffffffff, 0x00000000,
	0x1a833, 0xffffffff, 0x00002001,
	0xf60, 0xffffffff, 0x00900000,
	0xf62, 0xffffffff, 0x00000000,
	0xf61, 0xffffffff, 0x00000000,
	0xff3, 0xffffffff, 0x2d600861,
	0xde0, 0xffffffff, 0x00000001,
	0xe1f, 0xffffffff, 0x00000003,
};

int emu_soc_asic_init(struct amdgpu_device *adev)
{
	if (adev->asic_type == CHIP_VEGA20) {
		vg20_lsd_soc_init_with_umc(adev);

		amdgpu_device_program_register_sequence(adev,
							(const u32 *)vega20_golden_init,
							ARRAY_SIZE(vega20_golden_init));
	}

	return 0;
}

