#!/bin/bash

set -ex
ROOTFSMNT="/target"

mount --bind /sys "$ROOTFSMNT"/sys
mount --bind /proc "$ROOTFSMNT"/proc
mount --bind /dev "$ROOTFSMNT"/dev
mount --bind /run "$ROOTFSMNT"/run


cat > "$ROOTFSMNT"/remove-oem-kernel.sh <<EOF
#!/bin/bash

if [ -n "\$(dpkg -s linux-oem | grep installed)" ]; then
    apt purge -y linux-oem --autoremove
    apt purge -y linux-oem-headers-4.15.0-*
    apt purge -y linux-headers-4.15.0-*-oem
    apt purge -y linux-modules-4.15.0-*-oem
fi
exit 0
EOF

chmod +x "$ROOTFSMNT"/remove-oem-kernel.sh

chroot "$ROOTFSMNT" /remove-oem-kernel.sh
rm "$ROOTFSMNT"/remove-oem-kernel.sh

umount "$ROOTFSMNT"/sys
umount "$ROOTFSMNT"/proc
umount "$ROOTFSMNT"/dev
umount "$ROOTFSMNT"/run
