#!/bin/sh

ACTION="$1"
[ -z "$ACTION" ] && ACTION="install"

CONFIGFILE=/var/lib/update-notifier/disable-hwe-eol-messages

isAMDVGA() {
    # https://help.ubuntu.com/community/RadeonDriver
    # For some video cards, they're not listed as a "[0300] VGA compatible controller",
    # they could be: "[0302] 3D controller" or "[0380] Display controller"
    VGA=`lspci -nn | grep -e "\[0300]" -e "\[0302]" -e "\[0380]"`
    echo "$VGA"
    case "$VGA" in
        *1002:* ) 
            echo "VGA compatible controller/3D controller/Display controller: AMD/ATI"
            return 0
            ;;
    esac
    # Vendor ID: 8086(Intel), 10de(NVIDIA)
    echo "VGA compatible controller/3D controller/Display controller: Intel/NVIDIA/Other"
    return 1
}

isAMDVGA2() {
    VGA=`lspci -d "1002:" -k | grep -e "Kernel driver in use:"`
    case "$VGA" in
        *fglrx* ) 
            echo "$VGA"
            echo "VGA driver in use: fglrx"
            return 0
            ;;
    esac  
    echo "VGA driver in use: non-fglrx"
    return 1
}

checkKernelVersion() {
    KVER=`uname -r`
    case "$KVER" in
        3.19.* )
          echo "Kernel version: $KVER"
          return 1
          ;;
    esac
    echo "Kernel version is not 3.19.*"
    return 0
}

removeConfigFile() {
    if [ -f "$CONFIGFILE" ]
    then
        rm $CONFIGFILE
        echo "remove $CONFIGFILE"
    else
	echo "Can't find $CONFIGFILE"
        return 1
    fi
}

if [ "$ACTION" = "install" ]
then
    if checkKernelVersion||isAMDVGA
    then
        exit 0
    else
        removeConfigFile
    fi
fi
exit 0
