/*
* Copyright 2010 Inalogic® Inc.
*
* This program is free software: you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License, as
* published by the  Free Software Foundation; either version 2.1 or 3.0
* of the License.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranties of
* MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
* PURPOSE.  See the applicable version of the GNU Lesser General Public
* License for more details.
*
* You should have received a copy of both the GNU Lesser General Public
* License along with this program. If not, see <http://www.gnu.org/licenses/>
*
* Authored by: Brandon Schaefer <brandontschaefer@gmail.com>
*              Jay Taoko <jaytaoko@inalogic.com>
*
*/


static const std::string nux_compose_seqs_compact[] = {
"  ", "::", " ",		//nobreakspace # NO-BREAK SPACE
"!!", "::", "¡",		//exclamdown # INVERTED EXCLAMATION MARK
"|c", "c|", "c/", "/c", "::", "¢",		//CENT SIGN
"L-", "-L", "::", "£",		//POUND SIGN
"ox", "xo", "::", "¤",		//currency # CURRENCY SIGN
"Y=", "=Y", "::", "¥",		//yen # YEN SIGN
"!^", "::", "¦",		//brokenbar # BROKEN BAR
"so", "os", "::", "§",		//section # SECTION SIGN
"oc", "oC", "Oc", "OC", "::", "©",		//copyright # COPYRIGHT SIGN
"^_a", "::", "ª",		//FEMININE ORDINAL INDICATOR
"<<", "::", "«",		//guillemotleft # LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
",-", "-,", "::", "¬",		//NOT SIGN
"or", "oR", "Or", "OR", "::", "®",		//registered # REGISTERED SIGN
"oo", "::", "°",		//degree # DEGREE SIGN
"+-", "::", "±",		//plusminus # PLUS-MINUS SIGN
"^2", "::", "²",		//SUPERSCRIPT TWO
"^3", "::", "³",		//SUPERSCRIPT THREE
"mu", "::", "µ",		//MICRO SIGN
"p!", "P!", "PP", "::", "¶",		//paragraph # PILCROW SIGN
"..", "::", "·",		//MIDDLE DOT
", ", " ,", "::", "¸",		//cedilla # CEDILLA
"^1", "::", "¹",		//SUPERSCRIPT ONE
"^_o", "::", "º",		//MASCULINE ORDINAL INDICATOR
">>", "::", "»",		//guillemotright # RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
"14", "::", "¼",		//VULGAR FRACTION ONE QUARTER
"12", "::", "½",		//VULGAR FRACTION ONE HALF
"34", "::", "¾",		//VULGAR FRACTION THREE QUARTERS
"??", "::", "¿",		//questiondown # INVERTED QUESTION MARK
"`A", "::", "À",		//LATIN CAPITAL LETTER A WITH GRAVE
"'A", "::", "Á",		//LATIN CAPITAL LETTER A WITH ACUTE
"^A", "::", "Â",		//LATIN CAPITAL LETTER A WITH CIRCUMFLEX
"~A", "::", "Ã",		//LATIN CAPITAL LETTER A WITH TILDE
"\"A", "::", "Ä",		//LATIN CAPITAL LETTER A WITH DIAERESIS
"oA", "::", "Å",		//LATIN CAPITAL LETTER A WITH RING ABOVE
"AE", "::", "Æ",		//AE # LATIN CAPITAL LETTER AE
",C", "::", "Ç",		//LATIN CAPITAL LETTER C WITH CEDILLA
"`E", "::", "È",		//LATIN CAPITAL LETTER E WITH GRAVE
"'E", "::", "É",		//LATIN CAPITAL LETTER E WITH ACUTE
"^E", "::", "Ê",		//LATIN CAPITAL LETTER E WITH CIRCUMFLEX
"\"E", "::", "Ë",		//LATIN CAPITAL LETTER E WITH DIAERESIS
"`I", "::", "Ì",		//LATIN CAPITAL LETTER I WITH GRAVE
"'I", "::", "Í",		//LATIN CAPITAL LETTER I WITH ACUTE
"^I", "::", "Î",		//LATIN CAPITAL LETTER I WITH CIRCUMFLEX
"\"I", "::", "Ï",		//LATIN CAPITAL LETTER I WITH DIAERESIS
"DH", "::", "Ð",		//LATIN CAPITAL LETTER ETH
"~N", "::", "Ñ",		//LATIN CAPITAL LETTER N WITH TILDE
"`O", "::", "Ò",		//LATIN CAPITAL LETTER O WITH GRAVE
"'O", "::", "Ó",		//LATIN CAPITAL LETTER O WITH ACUTE
"^O", "::", "Ô",		//LATIN CAPITAL LETTER O WITH CIRCUMFLEX
"~O", "::", "Õ",		//LATIN CAPITAL LETTER O WITH TILDE
"\"O", "::", "Ö",		//LATIN CAPITAL LETTER O WITH DIAERESIS
"xx", "::", "×",		//MULTIPLICATION SIGN
"/O", "::", "Ø",		//LATIN CAPITAL LETTER O WITH STROKE
"`U", "::", "Ù",		//LATIN CAPITAL LETTER U WITH GRAVE
"'U", "::", "Ú",		//LATIN CAPITAL LETTER U WITH ACUTE
"^U", "::", "Û",		//LATIN CAPITAL LETTER U WITH CIRCUMFLEX
"\"U", "::", "Ü",		//LATIN CAPITAL LETTER U WITH DIAERESIS
"'Y", "::", "Ý",		//LATIN CAPITAL LETTER Y WITH ACUTE
"TH", "::", "Þ",		//LATIN CAPITAL LETTER THORN
"ss", "::", "ß",		//ssharp # LATIN SMALL LETTER SHARP S
"`a", "::", "à",		//LATIN SMALL LETTER A WITH GRAVE
"'a", "::", "á",		//LATIN SMALL LETTER A WITH ACUTE
"^a", "::", "â",		//LATIN SMALL LETTER A WITH CIRCUMFLEX
"~a", "::", "ã",		//LATIN SMALL LETTER A WITH TILDE
"\"a", "::", "ä",		//LATIN SMALL LETTER A WITH DIAERESIS
"oa", "::", "å",		//LATIN SMALL LETTER A WITH RING ABOVE
"ae", "::", "æ",		//ae # LATIN SMALL LETTER AE
",c", "::", "ç",		//LATIN SMALL LETTER C WITH CEDILLA
"`e", "::", "è",		//LATIN SMALL LETTER E WITH GRAVE
"'e", "::", "é",		//LATIN SMALL LETTER E WITH ACUTE
"^e", "::", "ê",		//LATIN SMALL LETTER E WITH CIRCUMFLEX
"\"e", "::", "ë",		//LATIN SMALL LETTER E WITH DIAERESIS
"`i", "::", "ì",		//LATIN SMALL LETTER I WITH GRAVE
"'i", "::", "í",		//LATIN SMALL LETTER I WITH ACUTE
"^i", "::", "î",		//LATIN SMALL LETTER I WITH CIRCUMFLEX
"\"i", "::", "ï",		//LATIN SMALL LETTER I WITH DIAERESIS
"dh", "::", "ð",		//LATIN SMALL LETTER ETH
"~n", "::", "ñ",		//LATIN SMALL LETTER N WITH TILDE
"`o", "::", "ò",		//LATIN SMALL LETTER O WITH GRAVE
"'o", "::", "ó",		//LATIN SMALL LETTER O WITH ACUTE
"^o", "::", "ô",		//LATIN SMALL LETTER O WITH CIRCUMFLEX
"~o", "::", "õ",		//LATIN SMALL LETTER O WITH TILDE
"\"o", "::", "ö",		//LATIN SMALL LETTER O WITH DIAERESIS
":-", "-:", "::", "÷",		//DIVISION SIGN
"/o", "::", "ø",		//LATIN SMALL LETTER O WITH STROKE
"`u", "::", "ù",		//LATIN SMALL LETTER U WITH GRAVE
"'u", "::", "ú",		//LATIN SMALL LETTER U WITH ACUTE
"^u", "::", "û",		//LATIN SMALL LETTER U WITH CIRCUMFLEX
"\"u", "::", "ü",		//LATIN SMALL LETTER U WITH DIAERESIS
"'y", "::", "ý",		//LATIN SMALL LETTER Y WITH ACUTE
"th", "::", "þ",		//LATIN SMALL LETTER THORN
"\"y", "::", "ÿ",		//LATIN SMALL LETTER Y WITH DIAERESIS
"_A", "::", "Ā",		//LATIN CAPITAL LETTER A WITH MACRON
"_a", "::", "ā",		//LATIN SMALL LETTER A WITH MACRON
"UA", "bA", "::", "Ă",		//LATIN CAPITAL LETTER A WITH BREVE
"Ua", "ba", "::", "ă",		//LATIN SMALL LETTER A WITH BREVE
";A", "::", "Ą",		//LATIN CAPITAL LETTER A WITH OGONEK
";a", "::", "ą",		//LATIN SMALL LETTER A WITH OGONEK
"'C", "::", "Ć",		//LATIN CAPITAL LETTER C WITH ACUTE
"'c", "::", "ć",		//LATIN SMALL LETTER C WITH ACUTE
"^C", "::", "Ĉ",		//LATIN CAPITAL LETTER C WITH CIRCUMFLEX
"^c", "::", "ĉ",		//LATIN SMALL LETTER C WITH CIRCUMFLEX
"cC", "::", "Č",		//LATIN CAPITAL LETTER C WITH CARON
"cc", "::", "č",		//LATIN SMALL LETTER C WITH CARON
"cD", "::", "Ď",		//LATIN CAPITAL LETTER D WITH CARON
"cd", "::", "ď",		//LATIN SMALL LETTER D WITH CARON
"-D", "/D", "::", "Đ",		//Dstroke # LATIN CAPITAL LETTER D WITH STROKE
"-d", "/d", "::", "đ",		//dstroke # LATIN SMALL LETTER D WITH STROKE
"_E", "::", "Ē",		//LATIN CAPITAL LETTER E WITH MACRON
"_e", "::", "ē",		//LATIN SMALL LETTER E WITH MACRON
"UE", "bE", "::", "Ĕ",		//LATIN CAPITAL LETTER E WITH BREVE
"Ue", "be", "::", "ĕ",		//LATIN SMALL LETTER E WITH BREVE
";E", "::", "Ę",		//LATIN CAPITAL LETTER E WITH OGONEK
";e", "::", "ę",		//LATIN SMALL LETTER E WITH OGONEK
"cE", "::", "Ě",		//LATIN CAPITAL LETTER E WITH CARON
"ce", "::", "ě",		//LATIN SMALL LETTER E WITH CARON
"^G", "::", "Ĝ",		//LATIN CAPITAL LETTER G WITH CIRCUMFLEX
"^g", "::", "ĝ",		//LATIN SMALL LETTER G WITH CIRCUMFLEX
"UG", "bG", "::", "Ğ",		//LATIN CAPITAL LETTER G WITH BREVE
"Ug", "bg", "::", "ğ",		//LATIN SMALL LETTER G WITH BREVE
",G", "::", "Ģ",		//LATIN CAPITAL LETTER G WITH CEDILLA
",g", "::", "ģ",		//LATIN SMALL LETTER G WITH CEDILLA
"^H", "::", "Ĥ",		//LATIN CAPITAL LETTER H WITH CIRCUMFLEX
"^h", "::", "ĥ",		//LATIN SMALL LETTER H WITH CIRCUMFLEX
"/H", "::", "Ħ",		//LATIN CAPITAL LETTER H WITH STROKE
"/h", "::", "ħ",		//LATIN SMALL LETTER H WITH STROKE
"~I", "::", "Ĩ",		//LATIN CAPITAL LETTER I WITH TILDE
"~i", "::", "ĩ",		//LATIN SMALL LETTER I WITH TILDE
"_I", "::", "Ī",		//LATIN CAPITAL LETTER I WITH MACRON
"_i", "::", "ī",		//LATIN SMALL LETTER I WITH MACRON
"UI", "bI", "::", "Ĭ",		//LATIN CAPITAL LETTER I WITH BREVE
"Ui", "bi", "::", "ĭ",		//LATIN SMALL LETTER I WITH BREVE
";I", "::", "Į",		//LATIN CAPITAL LETTER I WITH OGONEK
";i", "::", "į",		//LATIN SMALL LETTER I WITH OGONEK
"i.", "::", "ı",		//LATIN SMALL LETTER DOTLESS I
"^J", "::", "Ĵ",		//LATIN CAPITAL LETTER J WITH CIRCUMFLEX
"^j", "::", "ĵ",		//LATIN SMALL LETTER J WITH CIRCUMFLEX
",K", "::", "Ķ",		//LATIN CAPITAL LETTER K WITH CEDILLA
",k", "::", "ķ",		//LATIN SMALL LETTER K WITH CEDILLA
"kk", "::", "ĸ",		//LATIN SMALL LETTER KRA
"'L", "::", "Ĺ",		//LATIN CAPITAL LETTER L WITH ACUTE
"'l", "::", "ĺ",		//LATIN SMALL LETTER L WITH ACUTE
",L", "::", "Ļ",		//LATIN CAPITAL LETTER L WITH CEDILLA
",l", "::", "ļ",		//LATIN SMALL LETTER L WITH CEDILLA
"cL", "::", "Ľ",		//LATIN CAPITAL LETTER L WITH CARON
"cl", "::", "ľ",		//LATIN SMALL LETTER L WITH CARON
"/L", "::", "Ł",		//LATIN CAPITAL LETTER L WITH STROKE
"/l", "::", "ł",		//LATIN SMALL LETTER L WITH STROKE
"'N", "::", "Ń",		//LATIN CAPITAL LETTER N WITH ACUTE
"'n", "::", "ń",		//LATIN SMALL LETTER N WITH ACUTE
",N", "::", "Ņ",		//LATIN CAPITAL LETTER N WITH CEDILLA
",n", "::", "ņ",		//LATIN SMALL LETTER N WITH CEDILLA
"cN", "::", "Ň",		//LATIN CAPITAL LETTER N WITH CARON
"cn", "::", "ň",		//LATIN SMALL LETTER N WITH CARON
"NG", "::", "Ŋ",		//LATIN CAPITAL LETTER ENG
"ng", "::", "ŋ",		//LATIN SMALL LETTER ENG
"_O", "::", "Ō",		//LATIN CAPITAL LETTER O WITH MACRON
"_o", "::", "ō",		//LATIN SMALL LETTER O WITH MACRON
"UO", "bO", "::", "Ŏ",		//LATIN CAPITAL LETTER O WITH BREVE
"Uo", "bo", "::", "ŏ",		//LATIN SMALL LETTER O WITH BREVE
"=O", "::", "Ő",		//LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
"=o", "::", "ő",		//LATIN SMALL LETTER O WITH DOUBLE ACUTE
"OE", "::", "Œ",		//OE # LATIN CAPITAL LIGATURE OE
"oe", "::", "œ",		//oe # LATIN SMALL LIGATURE OE
"'R", "::", "Ŕ",		//LATIN CAPITAL LETTER R WITH ACUTE
"'r", "::", "ŕ",		//LATIN SMALL LETTER R WITH ACUTE
",R", "::", "Ŗ",		//LATIN CAPITAL LETTER R WITH CEDILLA
",r", "::", "ŗ",		//LATIN SMALL LETTER R WITH CEDILLA
"cR", "::", "Ř",		//LATIN CAPITAL LETTER R WITH CARON
"cr", "::", "ř",		//LATIN SMALL LETTER R WITH CARON
"'S", "::", "Ś",		//LATIN CAPITAL LETTER S WITH ACUTE
"'s", "::", "ś",		//LATIN SMALL LETTER S WITH ACUTE
"^S", "::", "Ŝ",		//LATIN CAPITAL LETTER S WITH CIRCUMFLEX
"^s", "::", "ŝ",		//LATIN SMALL LETTER S WITH CIRCUMFLEX
",S", "::", "Ş",		//LATIN CAPITAL LETTER S WITH CEDILLA
",s", "::", "ş",		//LATIN SMALL LETTER S WITH CEDILLA
"cS", "::", "Š",		//LATIN CAPITAL LETTER S WITH CARON
"cs", "::", "š",		//LATIN SMALL LETTER S WITH CARON
",T", "::", "Ţ",		//LATIN CAPITAL LETTER T WITH CEDILLA
",t", "::", "ţ",		//LATIN SMALL LETTER T WITH CEDILLA
"cT", "::", "Ť",		//LATIN CAPITAL LETTER T WITH CARON
"ct", "::", "ť",		//LATIN SMALL LETTER T WITH CARON
"/T", "::", "Ŧ",		//LATIN CAPITAL LETTER T WITH STROKE
"/t", "::", "ŧ",		//LATIN SMALL LETTER T WITH STROKE
"~U", "::", "Ũ",		//LATIN CAPITAL LETTER U WITH TILDE
"~u", "::", "ũ",		//LATIN SMALL LETTER U WITH TILDE
"_U", "::", "Ū",		//LATIN CAPITAL LETTER U WITH MACRON
"_u", "::", "ū",		//LATIN SMALL LETTER U WITH MACRON
"UU", "bU", "::", "Ŭ",		//LATIN CAPITAL LETTER U WITH BREVE
"Uu", "bu", "::", "ŭ",		//LATIN SMALL LETTER U WITH BREVE
"oU", "::", "Ů",		//LATIN CAPITAL LETTER U WITH RING ABOVE
"ou", "::", "ů",		//LATIN SMALL LETTER U WITH RING ABOVE
"=U", "::", "Ű",		//LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
"=u", "::", "ű",		//LATIN SMALL LETTER U WITH DOUBLE ACUTE
";U", "::", "Ų",		//LATIN CAPITAL LETTER U WITH OGONEK
";u", "::", "ų",		//LATIN SMALL LETTER U WITH OGONEK
"^W", "::", "Ŵ",		//LATIN CAPITAL LETTER W WITH CIRCUMFLEX
"^w", "::", "ŵ",		//LATIN SMALL LETTER W WITH CIRCUMFLEX
"^Y", "::", "Ŷ",		//LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
"^y", "::", "ŷ",		//LATIN SMALL LETTER Y WITH CIRCUMFLEX
"\"Y", "::", "Ÿ",		//LATIN CAPITAL LETTER Y WITH DIAERESIS
"'Z", "::", "Ź",		//LATIN CAPITAL LETTER Z WITH ACUTE
"'z", "::", "ź",		//LATIN SMALL LETTER Z WITH ACUTE
"cZ", "::", "Ž",		//LATIN CAPITAL LETTER Z WITH CARON
"cz", "::", "ž",		//LATIN SMALL LETTER Z WITH CARON
"fs", "fS", "::", "ſ",		//LATIN SMALL LETTER LONG S
"/b", "::", "ƀ",		//LATIN SMALL LETTER B WITH STROKE
"/I", "::", "Ɨ",		//LATIN CAPITAL LETTER I WITH STROKE
"/Z", "::", "Ƶ",		//LATIN CAPITAL LETTER Z WITH STROKE
"/z", "::", "ƶ",		//LATIN SMALL LETTER Z WITH STROKE
"cA", "::", "Ǎ",		//LATIN CAPITAL LETTER A WITH CARON
"ca", "::", "ǎ",		//LATIN SMALL LETTER A WITH CARON
"cI", "::", "Ǐ",		//LATIN CAPITAL LETTER I WITH CARON
"ci", "::", "ǐ",		//LATIN SMALL LETTER I WITH CARON
"cO", "::", "Ǒ",		//LATIN CAPITAL LETTER O WITH CARON
"co", "::", "ǒ",		//LATIN SMALL LETTER O WITH CARON
"cU", "::", "Ǔ",		//LATIN CAPITAL LETTER U WITH CARON
"cu", "::", "ǔ",		//LATIN SMALL LETTER U WITH CARON
"/G", "::", "Ǥ",		//LATIN CAPITAL LETTER G WITH STROKE
"/g", "::", "ǥ",		//LATIN SMALL LETTER G WITH STROKE
"cG", "::", "Ǧ",		//LATIN CAPITAL LETTER G WITH CARON
"cg", "::", "ǧ",		//LATIN SMALL LETTER G WITH CARON
"cK", "::", "Ǩ",		//LATIN CAPITAL LETTER K WITH CARON
"ck", "::", "ǩ",		//LATIN SMALL LETTER K WITH CARON
";O", "::", "Ǫ",		//LATIN CAPITAL LETTER O WITH OGONEK
";o", "::", "ǫ",		//LATIN SMALL LETTER O WITH OGONEK
"cj", "::", "ǰ",		//LATIN SMALL LETTER J WITH CARON
"'G", "::", "Ǵ",		//LATIN CAPITAL LETTER G WITH ACUTE
"'g", "::", "ǵ",		//LATIN SMALL LETTER G WITH ACUTE
"`N", "::", "Ǹ",		//LATIN CAPITAL LETTER N WITH GRAVE
"`n", "::", "ǹ",		//LATIN SMALL LETTER N WITH GRAVE
"cH", "::", "Ȟ",		//LATIN CAPITAL LETTER H WITH CARON
"ch", "::", "ȟ",		//LATIN SMALL LETTER H WITH CARON
",E", "::", "Ȩ",		//LATIN CAPITAL LETTER E WITH CEDILLA
",e", "::", "ȩ",		//LATIN SMALL LETTER E WITH CEDILLA
"_Y", "::", "Ȳ",		//LATIN CAPITAL LETTER Y WITH MACRON
"_y", "::", "ȳ",		//LATIN SMALL LETTER Y WITH MACRON
"ee", "::", "ə",		//LATIN SMALL LETTER SCHWA
"/i", "::", "ɨ",		//LATIN SMALL LETTER I WITH STROKE
",D", "::", "Ḑ",		//LATIN CAPITAL LETTER D WITH CEDILLA
",d", "::", "ḑ",		//LATIN SMALL LETTER D WITH CEDILLA
"_G", "::", "Ḡ",		//LATIN CAPITAL LETTER G WITH MACRON
"_g", "::", "ḡ",		//LATIN SMALL LETTER G WITH MACRON
"\"H", "::", "Ḧ",		//LATIN CAPITAL LETTER H WITH DIAERESIS
"\"h", "::", "ḧ",		//LATIN SMALL LETTER H WITH DIAERESIS
",H", "::", "Ḩ",		//LATIN CAPITAL LETTER H WITH CEDILLA
",h", "::", "ḩ",		//LATIN SMALL LETTER H WITH CEDILLA
"'K", "::", "Ḱ",		//LATIN CAPITAL LETTER K WITH ACUTE
"'k", "::", "ḱ",		//LATIN SMALL LETTER K WITH ACUTE
"'M", "::", "Ḿ",		//LATIN CAPITAL LETTER M WITH ACUTE
"'m", "::", "ḿ",		//LATIN SMALL LETTER M WITH ACUTE
"'P", "::", "Ṕ",		//LATIN CAPITAL LETTER P WITH ACUTE
"'p", "::", "ṕ",		//LATIN SMALL LETTER P WITH ACUTE
"~V", "::", "Ṽ",		//LATIN CAPITAL LETTER V WITH TILDE
"~v", "::", "ṽ",		//LATIN SMALL LETTER V WITH TILDE
"`W", "::", "Ẁ",		//LATIN CAPITAL LETTER W WITH GRAVE
"`w", "::", "ẁ",		//LATIN SMALL LETTER W WITH GRAVE
"'W", "::", "Ẃ",		//LATIN CAPITAL LETTER W WITH ACUTE
"'w", "::", "ẃ",		//LATIN SMALL LETTER W WITH ACUTE
"\"W", "::", "Ẅ",		//LATIN CAPITAL LETTER W WITH DIAERESIS
"\"w", "::", "ẅ",		//LATIN SMALL LETTER W WITH DIAERESIS
"\"X", "::", "Ẍ",		//LATIN CAPITAL LETTER X WITH DIAERESIS
"\"x", "::", "ẍ",		//LATIN SMALL LETTER X WITH DIAERESIS
"^Z", "::", "Ẑ",		//LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
"^z", "::", "ẑ",		//LATIN SMALL LETTER Z WITH CIRCUMFLEX
"\"t", "::", "ẗ",		//LATIN SMALL LETTER T WITH DIAERESIS
"ow", "::", "ẘ",		//LATIN SMALL LETTER W WITH RING ABOVE
"oy", "::", "ẙ",		//LATIN SMALL LETTER Y WITH RING ABOVE
"~E", "::", "Ẽ",		//LATIN CAPITAL LETTER E WITH TILDE
"~e", "::", "ẽ",		//LATIN SMALL LETTER E WITH TILDE
"`Y", "::", "Ỳ",		//LATIN CAPITAL LETTER Y WITH GRAVE
"`y", "::", "ỳ",		//LATIN SMALL LETTER Y WITH GRAVE
"~Y", "::", "Ỹ",		//LATIN CAPITAL LETTER Y WITH TILDE
"~y", "::", "ỹ",		//LATIN SMALL LETTER Y WITH TILDE
" .", "::", " ",		//PUNCTUATION SPACE
"--.", "::", "–",		//EN DASH
"---", "::", "—",		//EM DASH
"<'", "'<", "::", "‘",    //LEFT SINGLE QUOTATION MARK
">'", "'>", "::", "’",    //RIGHT SINGLE QUOTATION MARK
",'", "',", "::", "‚",    //SINGLE LOW-9 QUOTATION MARK
"<\"", "\"<", "::", "“",    //LEFT DOUBLE QUOTATION MARK
">\"", "\">", "::", "”",    //RIGHT DOUBLE QUOTATION MARK
",\"", "\",", "::", "„",    //DOUBLE LOW-9 QUOTATION MARK
"\%o", "::", "‰",		//PER MILLE SIGN
".<", "::", "‹",		//SINGLE LEFT-POINTING ANGLE QUOTATION MARK
".>", "::", "›",		//SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
"^0", "::", "⁰",		//SUPERSCRIPT ZERO
"^_i", "::", "ⁱ",		//SUPERSCRIPT LATIN SMALL LETTER I
"^4", "::", "⁴",		//SUPERSCRIPT FOUR
"^5", "::", "⁵",		//SUPERSCRIPT FIVE
"^6", "::", "⁶",		//SUPERSCRIPT SIX
"^7", "::", "⁷",		//SUPERSCRIPT SEVEN
"^8", "::", "⁸",		//SUPERSCRIPT EIGHT
"^9", "::", "⁹",		//SUPERSCRIPT NINE
"^+", "::", "⁺",		//SUPERSCRIPT PLUS SIGN
"^=", "::", "⁼",		//SUPERSCRIPT EQUALS SIGN
"^(", "::", "⁽",		//SUPERSCRIPT LEFT PARENTHESIS
"^)", "::", "⁾",		//SUPERSCRIPT RIGHT PARENTHESIS
"^_n", "::", "ⁿ",		//SUPERSCRIPT LATIN SMALL LETTER N
"_0", "::", "₀",		//SUBSCRIPT ZERO
"_1", "::", "₁",		//SUBSCRIPT ONE
"_2", "::", "₂",		//SUBSCRIPT TWO
"_3", "::", "₃",		//SUBSCRIPT THREE
"_4", "::", "₄",		//SUBSCRIPT FOUR
"_5", "::", "₅",		//SUBSCRIPT FIVE
"_6", "::", "₆",		//SUBSCRIPT SIX
"_7", "::", "₇",		//SUBSCRIPT SEVEN
"_8", "::", "₈",		//SUBSCRIPT EIGHT
"_9", "::", "₉",		//SUBSCRIPT NINE
"_+", "::", "₊",		//SUBSCRIPT PLUS SIGN
"_=", "::", "₌",		//SUBSCRIPT EQUALS SIGN
"_(", "::", "₍",		//SUBSCRIPT LEFT PARENTHESIS
"_)", "::", "₎",		//SUBSCRIPT RIGHT PARENTHESIS
"CE", "::", "₠",		//EURO-CURRENCY SIGN
"C/", "/C", "::", "₡",		//COLON SIGN
"Cr", "::", "₢",		//CRUZEIRO SIGN
"Fr", "::", "₣",		//FRENCH FRANC SIGN
"L=", "=L", "::", "₤",		//LIRA SIGN
"m/", "/m", "::", "₥",		//MILL SIGN
"N=", "=N", "::", "₦",		//NAIRA SIGN
"Pt", "::", "₧",		//PESETA SIGN
"Rs", "::", "₨",		//RUPEE SIGN
"W=", "=W", "::", "₩",		//WON SIGN
"d-", "::", "₫",		//DONG SIGN
"C=", "=C", "c=", "=c", "E=", "=E", "::", "€",		//EuroSign # EURO SIGN
"^TM", "::", "™",		//TRADE MARK SIGN
"\"\\", "::", "〝",      //REVERSED DOUBLE PRIME QUOTATION MARK
"\"/", "::", "〞",       //DOUBLE PRIME QUOTATION MARK
"\0"              //NULL so we know when to end
};

/* 
 * These are a mapping between dead keys and its composition sequence
 * All NULL chars dont match anything as of yet. To be filled in later
 */
static const char dead_keys_map[20] = {
'`',    //XK_dead_grave
'\'',   //XK_dead_acute
'^',    //XK_dead_circumflex
'~',    //XK_dead_tilde
'_',    //XK_dead_macron
'b',    //XK_dead_breve
'\0',   //XK_dead_abovedot
'"',    //XK_dead_diaeresis
'o',    //XK_dead_abovering
'=',    //XK_dead_doubleacute
'c',    //XK_dead_caron
',',    //XK_dead_cedilla 
';',    //XK_dead_ogonek
'\0',   //XK_dead_iota
'\0',   //XK_dead_voiced_sound
'\0',   //XK_dead_semivoiced_sound
'\0',   //XK_dead_belowdot
'\0',   //XK_dead_hook
'\0',   //XK_dead_horn
'\\'    //XK_dead_stroke
};
