/*******************************************************************************
**3456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
**      10        20        30        40        50        60        70        80
**
** notify-osd
**
** test-close-button.c - unit-tests for CloseButton class used by snap-decisions
**
** Copyright 2012 Canonical Ltd.
**
** Authors:
**    Mirco "MacSlow" Mueller <mirco.mueller@canonical.com>
**
** This program is free software: you can redistribute it and/or modify it
** under the terms of the GNU General Public License version 3, as published
** by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranties of
** MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
** PURPOSE.  See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*******************************************************************************/

#include <glib.h>
#include <cairo.h>

#include "config.h"
#include "close-button.h"
#include "settings.h"

static void
test_close_button_new ()
{
	CloseButton* close_button = NULL;
	Settings*    settings     = settings_new ();

	close_button = close_button_new (settings->close_button);
	g_assert (close_button != NULL);
	g_assert (IS_CLOSE_BUTTON (close_button));
	g_object_unref (close_button);
	close_button = NULL;
	settings_del (settings);
}

static void
test_close_button_del ()
{
	CloseButton* close_button = NULL;
	Settings*    settings     = settings_new ();

	close_button = close_button_new (settings->close_button);
	g_assert (close_button != NULL);
	g_assert (IS_CLOSE_BUTTON (close_button));

	close_button_del (close_button);
	g_assert (!IS_CLOSE_BUTTON (close_button));
	close_button = NULL;
	settings_del (settings);
}

static void
test_close_button_getset_position ()
{
	CloseButton* close_button = NULL;
	Settings*    settings     = settings_new ();

	close_button = close_button_new (settings->close_button);
	g_assert (close_button != NULL);
	g_assert (IS_CLOSE_BUTTON (close_button));

	gint x = 0;
	gint y = 0;

	close_button_set_position (close_button, 42, 69);
	close_button_get_position (close_button, &x, &y);
	g_assert_cmpint (x, ==, 42);
	g_assert_cmpint (y, ==, 69);

	close_button_del (close_button);
	settings_del (settings);
}

static void
test_close_button_is_hit ()
{
	CloseButton* close_button = NULL;
	Settings*    settings     = settings_new ();

	close_button = close_button_new (settings->close_button);
	g_assert (close_button != NULL);
	g_assert (IS_CLOSE_BUTTON (close_button));

	close_button_set_position (close_button, 5, 7);
	gboolean result = FALSE;
	result = close_button_is_hit (close_button, 2, 2);
	g_assert (!result);
	result = close_button_is_hit (close_button, 9, 8);
	g_assert (result);
	result = close_button_is_hit (close_button, 70, 40);
	g_assert (!result);

	close_button_del (close_button);
	settings_del (settings);
}

static void
test_close_button_getset_state ()
{
	CloseButton* close_button = NULL;
	Settings*    settings     = settings_new ();

	close_button = close_button_new (settings->close_button);
	g_assert (close_button != NULL);
	g_assert (IS_CLOSE_BUTTON (close_button));

	g_assert_cmpint (close_button_get_state (close_button),
	                 ==,
	                 CLOSE_BUTTON_STATE_NORMAL);
	close_button_set_state (close_button, CLOSE_BUTTON_STATE_HOVER);
	g_assert_cmpint (close_button_get_state (close_button),
	                 ==,
	                 CLOSE_BUTTON_STATE_HOVER);
	close_button_set_state (close_button, CLOSE_BUTTON_STATE_PRESSED);
	g_assert_cmpint (close_button_get_state (close_button),
	                 ==, CLOSE_BUTTON_STATE_PRESSED);
	close_button_set_state (close_button, CLOSE_BUTTON_STATE_NORMAL);
	g_assert_cmpint (close_button_get_state (close_button),
	                 ==,
	                 CLOSE_BUTTON_STATE_NORMAL);
	
	close_button_del (close_button);
	settings_del (settings);
}

static void
test_close_button_paint ()
{
	CloseButton* close_button = NULL;
	Settings*    settings     = settings_new ();

	close_button = close_button_new (settings->close_button);
	g_assert (close_button != NULL);
	g_assert (IS_CLOSE_BUTTON (close_button));

	cairo_surface_t* surface = NULL;
	cairo_t*         cr      = NULL;

	surface = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, 30, 80);
	cr = cairo_create (surface);
	cairo_scale (cr, 1.0, 1.0);
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	cairo_paint (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);

	close_button_set_state (close_button, CLOSE_BUTTON_STATE_NORMAL);
	close_button_set_position (close_button, 5, 5);
	close_button_paint (close_button, cr);
	close_button_set_state (close_button, CLOSE_BUTTON_STATE_HOVER);
	close_button_set_position (close_button, 5, 30);
	close_button_paint (close_button, cr);
	close_button_set_state (close_button, CLOSE_BUTTON_STATE_PRESSED);
	close_button_set_position (close_button, 5, 55);
	close_button_paint (close_button, cr);

	cairo_destroy (cr);
	cairo_surface_write_to_png (surface, "/tmp/test-close-button-paint.png");
	cairo_surface_destroy (surface);

	close_button_del (close_button);
	settings_del (settings);
}

GTestSuite *
test_close_button_create_test_suite (void)
{
	GTestSuite *ts = NULL;

	ts = g_test_create_suite ("close-button");

#define TC(x) g_test_create_case(#x, 0, NULL, NULL, x, NULL)

	g_test_suite_add(ts, TC(test_close_button_new));
	g_test_suite_add(ts, TC(test_close_button_del));
	g_test_suite_add(ts, TC(test_close_button_getset_position));
	g_test_suite_add(ts, TC(test_close_button_is_hit));
	g_test_suite_add(ts, TC(test_close_button_getset_state));
	g_test_suite_add(ts, TC(test_close_button_paint));

	return ts;
}
