/*******************************************************************************
**3456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
**      10        20        30        40        50        60        70        80
**
** notify-osd
**
** settings.c - simplified class to pass around settings like colors, sizes,
**              fonts and so on
**
** Copyright 2012 Canonical Ltd.
**
** Authors:
**    Mirco "MacSlow" Mueller <mirco.mueller@canonical.com>
**
** This program is free software: you can redistribute it and/or modify it
** under the terms of the GNU General Public License version 3, as published
** by the Free Software Foundation.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranties of
** MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
** PURPOSE.  See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License along
** with this program.  If not, see <http://www.gnu.org/licenses/>.
**
*******************************************************************************/

#include <pango/pango.h>
#include <gdk/gdk.h>

#include "settings.h"

G_DEFINE_TYPE (Settings, settings, G_TYPE_OBJECT);

/*-- internal API ------------------------------------------------------------*/

static void
settings_dispose (GObject* gobject)
{
	/* chain up to the parent class */
	G_OBJECT_CLASS (settings_parent_class)->dispose (gobject);
}

static void
settings_finalize (GObject* gobject)
{
	Settings* settings = NULL;

	// sanity checks
	g_assert (gobject);
	settings = SETTINGS (gobject);
	g_assert (settings);
	g_assert (IS_SETTINGS (settings));

	/* chain up to the parent class */
	G_OBJECT_CLASS (settings_parent_class)->finalize (gobject);
}

static void
settings_init (Settings* self)
{
	/* If you need specific construction properties to complete
	** initialization, delay initialization completion until the
	** property is set. */
}

static void
settings_get_property (GObject*    gobject,
                       guint       prop,
                       GValue*     value,
                       GParamSpec* spec)
{
	switch (prop)
	{
		default :
			G_OBJECT_WARN_INVALID_PROPERTY_ID (gobject, prop, spec);
		break;
	}
}

static void
settings_class_init (SettingsClass* klass)
{
	GObjectClass* gobject_class = G_OBJECT_CLASS (klass);

	gobject_class->dispose      = settings_dispose;
	gobject_class->finalize     = settings_finalize;
	gobject_class->get_property = settings_get_property;
}

/*-- public API --------------------------------------------------------------*/

Settings*
settings_new ()
{
	Settings* self = NULL;

	self = g_object_new (SETTINGS_TYPE, NULL);
	if (!self)
		return NULL;

	MetricConverter* mc     = metric_converter_new ();
	Parser*          parser = parser_new ();

	/* I've spent _hours_ trying to get $PKG_DATA_DIR defined and exported to
	** config.h but autotools is too much of a #@!§$%& to allow this easily,
	** so I'm happily hard-coding it here */
	parser_open (parser, "/usr/share/notify-osd/snap-decisions.json"); 

	self->button       = (SettingsButton*) g_malloc0 (sizeof (SettingsButton));
	self->split_button = (SettingsSplitButton*) g_malloc0 (sizeof (SettingsSplitButton));
	self->background   = (SettingsBackground*) g_malloc0 (sizeof (SettingsBackground));
	self->text         = (SettingsText*) g_malloc0 (sizeof (SettingsText));
	self->close_button = (SettingsCloseButton*) g_malloc0 (sizeof (SettingsCloseButton));
	self->drop_shadow  = (SettingsDropShadow*) g_malloc0 (sizeof (SettingsDropShadow));

	self->background->width                    = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "background", "width-em"));
	self->background->contracted_height        = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "background", "contracted-height-em"));
	self->background->text_width               = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "background", "text-width-em"));
	self->background->title_size               = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "background", "title-size-em"));
	self->background->title_weight             = parser_read_font_weight (parser, "background", "title-weight");
	self->background->body_size                = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "background", "body-size-em"));
	self->background->body_weight              = parser_read_font_weight (parser, "background", "body-weight");
	self->background->padding                  = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "background", "padding-em"));
	self->background->icon_size                = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "background", "icon-size-em"));
	self->background->contracted_icon_size     = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "background", "contracted-icon-size-em"));
	self->background->contracted_horiz_padding = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "background", "contracted-horizontal-padding-em"));
	self->background->contracted_vert_padding  = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "background", "contracted-vertical-padding-em"));
	self->background->button_padding           = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "background", "button-padding-em"));
	self->background->outline_thickness        = parser_read_int (parser, "background", "outline-thickness-px");
	self->background->outline_corner_radius    = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "background", "outline-corner-radius-em"));
	parser_read_color (parser, "background", "outline-color", &self->background->outline_color);
	self->background->outline_opacity          = parser_read_double (parser, "background", "outline-opacity");
	parser_read_color (parser, "background", "fill-color", &self->background->fill_color);
	self->background->fill_opacity             = parser_read_double (parser, "background", "fill-opacity");
	parser_read_color (parser, "background", "pattern-color", &self->background->pattern_color);
	self->background->pattern_opacity          = parser_read_double (parser, "background", "pattern-opacity");
	self->background->spotlight_radius         = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "background", "spotlight-radius-em"));
	self->background->spotlight_opacity        = parser_read_double (parser, "background", "spotlight-opacity");
	parser_read_color (parser, "background", "spotlight-center-color", &self->background->spotlight_center_color);
	self->background->spotlight_center_opacity = parser_read_double (parser, "background", "spotlight-center-opacity");
	parser_read_color (parser, "background", "spotlight-end-color", &self->background->spotlight_end_color);
	self->background->spotlight_end_opacity    = parser_read_double (parser, "background", "spotlight-end-opacity");
	self->background->spotlight_position_x     = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "background", "spotlight-position-x-em"));
	self->background->spotlight_position_y     = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "background", "spotlight-position-y-em"));
	parser_read_color (parser, "background", "inner-outline-color", &self->background->inner_outline_color);
	self->background->inner_outline_opacity    = parser_read_double (parser, "background", "inner-outline-opacity");
	self->background->inner_outline_thickness  = parser_read_int (parser, "background", "inner-outline-thickness-px");
	self->background->inner_outline_margin     = parser_read_int (parser, "background", "inner-outline-margin-px");
	parser_read_color (parser, "background", "inner-fill-color", &self->background->inner_fill_color);
	self->background->inner_fill_opacity       = parser_read_double (parser, "background", "inner-fill-opacity");

	self->button->width                    = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "button", "width-em"));
	self->button->height                   = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "button", "height-em"));
	self->button->line_width               = parser_read_int (parser, "button", "outline-thickness-px");
	self->button->radius                   = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "button", "outline-corner-radius-em"));
	self->button->text_size                = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "button", "text-size-em"));
	self->button->text_family              = g_strdup (parser_read_string (parser, "button", "text-family"));
	self->button->text_colors              = parser_read_colors (parser, "button", "text-color", &self->button->text_colors_num);
	self->button->text_opacities           = parser_read_doubles (parser, "button", "text-opacity", &self->button->text_opacities_num);
	self->button->text_weight              = parser_read_font_weight (parser, "button", "text-weight");
	self->button->text_margin_horiz        = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "button", "text-margin-horiz-em"));
	self->button->outline_colors           = parser_read_colors (parser, "button", "outline-color", &self->button->outline_colors_num);
	self->button->outline_opacities        = parser_read_doubles (parser, "button", "outline-opacity", &self->button->outline_opacities_num);
	self->button->fill_colors              = parser_read_colors (parser, "button", "fill-color", &self->button->fill_colors_num);
	self->button->fill_opacities           = parser_read_doubles (parser, "button", "fill-opacity", &self->button->fill_opacities_num);
	self->button->outline_colors_lit       = parser_read_colors (parser, "button", "outline-color-lit", &self->button->outline_colors_lit_num);
	self->button->outline_opacities_lit    = parser_read_doubles (parser, "button", "outline-opacity-lit", &self->button->outline_opacities_lit_num);
	self->button->fill_colors_lit          = parser_read_colors (parser, "button", "fill-color-lit", &self->button->fill_colors_lit_num);
	self->button->fill_opacities_lit       = parser_read_doubles (parser, "button", "fill-opacity-lit", &self->button->fill_opacities_lit_num);
	self->button->outline_colors_tinted    = parser_read_colors (parser, "button", "outline-color-tinted", &self->button->outline_colors_tinted_num);
	self->button->outline_opacities_tinted = parser_read_doubles (parser, "button", "outline-opacity-tinted", &self->button->outline_opacities_tinted_num);
	self->button->fill_colors_tinted       = parser_read_colors (parser, "button", "fill-color-tinted", &self->button->fill_colors_tinted_num);
	self->button->fill_opacities_tinted    = parser_read_doubles (parser, "button", "fill-opacity-tinted", &self->button->fill_opacities_tinted_num);

	self->split_button->contracted_width = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "split-button", "contracted-width-em"));
	self->split_button->contracted_height = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "split-button", "contracted-height-em"));
	self->split_button->expanded_width = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "split-button", "expanded-width-em"));
	self->split_button->expanded_height = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "split-button", "expanded-height-em"));
	self->split_button->contracted_arrow_button_size = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "split-button", "contracted-arrow-button-size-em"));
	self->split_button->contracted_arrow_button_margin = parser_read_int (parser, "split-button", "contracted-arrow-button-margin-px");
	parser_read_color (parser, "split-button", "arrow-color", &self->split_button->arrow_color);
	self->split_button->arrow_opacity = parser_read_double (parser, "split-button", "arrow-opacity");
	self->split_button->arrow_thickness = parser_read_int (parser, "split-button", "arrow-thickness-px");
	self->split_button->contracted_arrow_width = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "split-button", "contracted-arrow-width-em"));
	self->split_button->contracted_arrow_height = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "split-button", "contracted-arrow-height-em"));
	self->split_button->expanded_arrow_width = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "split-button", "expanded-arrow-width-em"));
	self->split_button->expanded_arrow_height = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "split-button", "expanded-arrow-height-em"));
	self->split_button->expanded_arrow_button_size = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "split-button", "expanded-arrow-button-size-em"));
	self->split_button->expanded_arrow_button_margin = parser_read_int (parser, "split-button", "expanded-arrow-button-margin-px");
	parser_read_color (parser, "split-button", "separator-color", &self->split_button->separator_color);
	self->split_button->separator_opacity = parser_read_double (parser, "split-button", "separator-opacity");
	self->split_button->separator_thickness = parser_read_int (parser, "split-button", "separator-thickness-px");
	self->split_button->separator_margin = parser_read_int (parser, "split-button", "separator-margin-px");

	self->text->summary_family = g_strdup (parser_read_string (parser, "text", "summary-family"));
	self->text->summary_size = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "text", "summary-size-em"));
	self->text->summary_weight = parser_read_font_weight (parser, "text", "summary-weight");
	parser_read_color (parser, "text", "summary-color", &self->text->summary_color);
	self->text->summary_opacity = parser_read_double (parser, "text", "summary-opacity");
	self->text->body_family = g_strdup (parser_read_string (parser, "text", "body-family"));
	self->text->body_size = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "text", "body-size-em"));
	self->text->body_weight = parser_read_font_weight (parser, "text", "body-weight");
	parser_read_color (parser, "text", "body-color", &self->text->body_color);
	self->text->body_opacity = parser_read_double (parser, "text", "body-opacity");
	self->text->body_max_lines = parser_read_int (parser, "text", "body-max-lines");

	self->close_button->size = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "close-button", "size-em"));
	self->close_button->outline_thickness = parser_read_int (parser, "close-button", "outline-thickness-px");
	self->close_button->outline_colors = parser_read_colors (parser, "close-button", "outline-color", &self->close_button->outline_colors_num);
	self->close_button->outline_opacities = parser_read_doubles (parser, "close-button", "outline-opacity", &self->close_button->outline_opacities_num);
	self->close_button->fill_colors = parser_read_colors (parser, "close-button", "fill-color", &self->close_button->fill_colors_num);
	self->close_button->fill_opacities = parser_read_doubles (parser, "close-button", "fill-opacity", &self->close_button->fill_opacities_num);
	self->close_button->position_x = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "close-button", "position-x-em"));
	self->close_button->position_y = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "close-button", "position-y-em"));

	parser_read_color (parser, "drop-shadow", "color", &self->drop_shadow->color);
	self->drop_shadow->opacity = parser_read_double (parser, "drop-shadow", "opacity");
    self->drop_shadow->offset_x = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "drop-shadow", "offset-x-em"));
    self->drop_shadow->offset_y = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "drop-shadow", "offset-y-em"));
	self->drop_shadow->size = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "drop-shadow", "size-em"));
	self->drop_shadow->blur = (gdouble) metric_converter_em2px (mc, parser_read_double (parser, "drop-shadow", "blur-em"));

	return self;
}

void
settings_del (Settings* self)
{
	g_return_if_fail (self && IS_SETTINGS (self));

	/* clean up */
	g_free (self->button->text_family);
	g_free (self->button->text_colors);
	g_free (self->button->text_opacities);
	g_free (self->button->outline_colors);
	g_free (self->button->outline_opacities);
	g_free (self->button->fill_colors);
	g_free (self->button->fill_opacities);
	g_free (self->button->outline_colors_lit);
	g_free (self->button->outline_opacities_lit);
	g_free (self->button->fill_colors_lit);
	g_free (self->button->fill_opacities_lit);
	g_free (self->button->outline_colors_tinted);
	g_free (self->button->outline_opacities_tinted);
	g_free (self->button->fill_colors_tinted);
	g_free (self->button->fill_opacities_tinted);
	g_free (self->button);

	g_free (self->split_button);

	g_free (self->background);

	g_free (self->text->summary_family);
	g_free (self->text->body_family);
	g_free (self->text);

	g_free (self->close_button->outline_colors);
	g_free (self->close_button->outline_opacities);
	g_free (self->close_button->fill_colors);
	g_free (self->close_button->fill_opacities);
	g_free (self->close_button);

	g_free (self->drop_shadow);

	g_object_unref (self);
}
