/*
 * Easy Network API
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_EASYNETWORKMANAGER_API_H
#define DCS_EASYNETWORKMANAGER_API_H

#include "DCSCommon.h"
#include "ENMDef.h"

#ifdef __cplusplus
extern "C" {
#endif

    /**
     * Initialize user info
     *
     * @param initUserInfo user info
     */
    DCSAPI DCS_Return_Code DCS_InitUserInfo(ENM_InitUserInfo initUserInfo);

    /**
     * Allocate IP address from DHCP
     */
    DCSAPI DCS_Return_Code DCS_AllocateDhIP();

    /**
     * Disconnect the connection from current connected AP
     */
    DCSAPI DCS_Return_Code DCS_CloseWlanConnection();

    /**
     * Search network adapters
     */
    DCSAPI DCS_Return_Code DCS_SearchAdapter();

    /**
     * Enable the specified network adapter
     *
     * @param adapterType  the specified adapter type
     */
    DCSAPI DCS_Return_Code DCS_UpAdapter(ENM_ADAPTER_TYPE adapterType);

    /**
     * Disable the specified network adapter
     *
     * @param adapterType  the specified adapter type
     */
    DCSAPI DCS_Return_Code DCS_DownAdapter(ENM_ADAPTER_TYPE adapterType);

    /**
     * Check if a specific type of network adapter exists
     *
     * @param adapterType  the specified adapter type
     * @param pOutIsUp  Out Up/Down
     */
    DCSAPI DCS_Return_Code DCS_IsExistUpAdapter(ENM_ADAPTER_TYPE adapterType,BOOL* pOutIsUp);

    /**
     * Check if a specific type of network adapters is connected
     *
     * @param adapterType  Specified adapter type
     * @param pOutIsConnect     connect/disconnect
     */
    DCSAPI DCS_Return_Code DCS_IsExistConnectAdapter(ENM_ADAPTER_TYPE adapterType,BOOL* pOutIsConnect);

    /**
     * Connect to a wireless network
     *
     * @param connectAP  Input information of connect AP
     */
    DCSAPI DCS_Return_Code DCS_ConnectAP(ENM_ConnectAP connectAP);

    /**
     * Get all available wireless access points
     *
     * @param pOutAPList  Out parameter filled with all the detected access points
     */
    DCSAPI DCS_Return_Code DCS_GetAPList(AccessPointList* pOutAPList);

    /**
     * Get the newest informations of current connected access point
     *
     * @param pOutCurrentAP  the newest AP info
     */
    DCSAPI DCS_Return_Code DCS_GetCurrentAP(APStatus* pOutCurrentAP);

    /**
	 * @Deprecated. Please refer to DCS_GetIPAddressLAN
     * Get current IP address of LAN adapter
     *
     * @param pOutIpAddress  current IP address
     */
    DCSAPI DCS_Return_Code DCS_GetIPAddressHLAN(ENM_String* pOutIpAddress);

    /**
     * Get current IP address of LAN adapter
     *
     * @param pOutIpAddress  current IP address
     */
    DCSAPI DCS_Return_Code DCS_GetIPAddressLAN(ENM_String* pOutIpAddress);

    /**
	 * @Deprecated. Please refer to DCS_GetConnectTypeLAN
     * Get the type description of current LAN adapter
     *
     * @param pOutConnectType  the type description
     */
    DCSAPI DCS_Return_Code DCS_GetConnectTypeHLAN(ENM_String* pOutConnectType);

    /**
     * Get the type description of current LAN adapter
     *
     * @param pOutConnectType  the type description
     */
    DCSAPI DCS_Return_Code DCS_GetConnectTypeLAN(ENM_String* pOutConnectType);

    /**
	 * @Deprecated. Please refer to DCS_GetNeighborInfo
     * Search neighbors
     *
     * @param pNeighborsInfo  detected neighbors
     */
    DCSAPI DCS_Return_Code DCS_GetNeighborsInfo(ENM_NEIGHBORS_INFO* pNeighborsInfo);

    /**
     * Search neighbors
     *
     * @param pNeighborsInfo  detected neighbors
     */
    DCSAPI DCS_Return_Code DCS_GetNeighborInfo(ENM_NEIGHBORS_INFO* pNeighborsInfo);

    /**
     * Enable or disable 802.1x authentication
     *
     * @param isEnable  enable/disable
     */
    DCSAPI DCS_Return_Code DCS_Enable8021xAuthentication(bool isEnable);

    /**
     * Enable or disable 802.1x authentication
     *
     * @param isEnable  enable/disable
     */
    DCSAPI DCS_Return_Code DCS_EnableInternetSharing(bool isEnable);

    /**
	 * @Deprecated. Please refer to DCS_OverwriteDefaultBrowserHomePage
     * Overwrite current home page
     *
     * @param pStrHomePage  URL of new home page
     */
    DCSAPI DCS_Return_Code DCS_OverwriteHomePage(ENM_String* pStrHomePage);

    /**
     * Overwrite current home page
     *
     * @param pStrHomePage  URL of new home page
     */
    DCSAPI DCS_Return_Code DCS_OverwriteDefaultBrowserHomePage(ENM_String* pStrHomePage);

    /**
     * Overwrite current HTTP proxy
     *
     * @param pProxyInfo  proxy information
     */
    DCSAPI DCS_Return_Code DCS_OverwriteProxy(ENM_ProxyInfo* pProxyInfo);

    /**
     * Change the IP addresses of a network adapter
     *
     * @param pAddressInfo  IP addresses
     */
    DCSAPI DCS_Return_Code DCS_SetIPAddress(ENM_AddressInfo* pAddressInfo);

    /**
     * Enable or Disable sharing files and printer
     *
     * @param isEnable  enable/disable
     */
    DCSAPI DCS_Return_Code DCS_EnableFileAndPrint(bool isEnable);

    /**
     * Enable or disable Windows firewall
     *
     * @param isEnable  enable/disable
     */
    DCSAPI DCS_Return_Code DCS_EnableWindowsFirewall(bool isEnable);

    /**
     * Verfiy whether is exist wired adapter or wireless adapter
     *
     * @param adapterType  specify the adapter type, wired or wireless
     * @param pOutIsExist  true if the adapter exists
     */
    DCSAPI DCS_Return_Code DCS_IsExistAdapter(ENM_ADAPTER_TYPE adapterType,BOOL* pOutIsExist);

    /**
	 * @Deprecated. Please refer to DCS_ImportSchoolSettings
     * Write new profile to the folder which containing system profiles
     *
     * @param pFileName  name of new profile
     */
    DCSAPI DCS_Return_Code DCS_WriteFile(ENM_String* pFileName);

    /**
     * Write new profile to the folder which containing system profiles
     *
     * @param pFileName  name of new profile
     */
    DCSAPI DCS_Return_Code DCS_ImportSchoolSettings(ENM_String* pFileName);

    /**
     * Unzip the package path
     *
     * @param pFileName  file path
     */
    DCSAPI DCS_Return_Code DCS_UnzipPackage(ENM_String* pFilePath);
    
	/**
	 * @Deprecated. Please refer to DCS_UnzipPackage
     * Upzip the package path
     *
     * @param pFileName  file path
     */
    DCSAPI DCS_Return_Code DCS_UpzipPackage(ENM_String* pFilePath);
    
    /**
	 * @Deprecated. Please refer to DCS_StartReceiveMulticastThread
     * Start listen thread
     *
     * @param pFileName  null
     */
    DCSAPI DCS_Return_Code DCS_StartListen();

    /**
     * Start receive multicast thread
     *
     * @param pFileName  null
     */
    DCSAPI DCS_Return_Code DCS_StartReceiveMulticastThread();
	
    /**
     * Typedef of the callback function to be notified when the
     * student listen and get the new package automatic.
     *
     * @param pData		obligate
     */
     typedef void (CALLBACK *DCS_Listen_Callback) (int *pData);

    /** Registers the callback function to be notified  when the student listen and get the new package automatic. */
    DCSAPI DCS_Return_Code DCS_RegisterListenCallback (DCS_Listen_Callback pCallback);

    /** Unregisters the callback function for the student listen and get the new package automatic. */
    DCSAPI DCS_Return_Code DCS_UnregisterListenCallback();

	/**
     * Execute Command.
     *
     * @param nChannel 
     */
	DCSAPI DCS_Return_Code DCS_ExecuteCommand(ENM_String* pStrCommand);

	 /**
     * Turn on or Turn off mesh function
     *
     * @param bEnable  is true / false
     */
	DCSAPI DCS_Return_Code DCS_TurnOnMesh(bool bTurnOn);

	/**
     * Set Mesh Security Information
     *
     * @param MESH_SECURITY_INFO
     */
	DCSAPI DCS_Return_Code DCS_SetMeshSecurityInfo(MESH_SECURITY_INFO* pMeshSecurityInfo);
	
	/**
     * Set Mesh ID
     *
     * @param   
     */
	DCSAPI DCS_Return_Code DCS_SetMeshID();

	/**
     * Set Mesh Auto Link
     *
     * @param nAutoLink 0: disable. 1: enable.

     */
	DCSAPI DCS_Return_Code DCS_SetMeshAutoLink(int nAutoLink);

	/**
     * Request to add a Mesh link manual.
     *
     * @param null
     */
	DCSAPI DCS_Return_Code DCS_AddMeshLink();
	
	/**
     * Request to delete a Mesh link manual
     *
     * @param null
     */
	DCSAPI DCS_Return_Code DCS_DelMeshLink();
	
	/**
     * Set Mesh Channel .
     *
     * @param nChannel 
     */
	DCSAPI DCS_Return_Code DCS_SetMeshChannel(int nChannel);

	/**
     * Set Mesh Host Name .
     *
     * @param nChannel 
     */
	DCSAPI DCS_Return_Code DCS_SetMeshHostName(ENM_String* pStrHostName);

	/**
     * Enable mesh only function.
     *
     * @param bEnableOnly 
     */
	DCSAPI DCS_Return_Code DCS_EnableMeshOnly(bool bEnableOnly);

	/**
     * Enable mesh forwarding function.
     *
     * @param bForwarding 
     */
	DCSAPI DCS_Return_Code DCS_EnableMeshForwarding(bool bForwarding);
	
	/**
     * Set mesh channel bandwidth.
     *
     * @param nBandWidth	0: 20		1: 40
     */
	DCSAPI DCS_Return_Code DCS_SetMeshChannelBandWidth(int nBandWidth);
	
	/**
     * Set mesh channel OFFSET.
     *
     * @param nFlag	0: below	1: above

     */
	DCSAPI DCS_Return_Code DCS_SetMeshChannelOFFSET(int nFlag);
	
	/**
     * Get Mesh Security Information
     *
     * @param mesh_security_info
     */
	DCSAPI DCS_Return_Code DCS_GetMeshSecurityInfo(MESH_SECURITY_INFO* pMeshSecurityInfo);

	/**
     * Get Mesh ID
     *
     * @param pStrMeshID Mesh ID
     */
	DCSAPI DCS_Return_Code DCS_GetMeshID(ENM_String* pStrMeshID);

	/**
     * Get current Auto Link setting
     *
     * @param nAutoLink 0: disable.1: enable.

     */
	DCSAPI DCS_Return_Code DCS_GetMeshAutoLink(int* nAutoLink);

	/**
     * Get List all Mesh Links status.
     *
     * @param nLinkStatus 0: idle	1: connected.

     */
	DCSAPI DCS_Return_Code DCS_GetMeshLinkStatus(int* nLinkStatus);
	
	/**
     * List all Neighbor MPs
     *
     * @param mesh_neighbor_info
     */
	DCSAPI DCS_Return_Code DCS_ListAllNeighborMPs(MESH_NEIGHBOR_INFO* pMeshNeighborInfo);
	
	/**
     * List route path on the Mesh Point
     *
     * @param rt_mesh_route_table list route path on the mesh point
     */
	DCSAPI DCS_Return_Code DCS_GetMeshRouteList(RT_MESH_ROUTE_TABLE* pRtMeshRouteTable);

	/**
     * Get Mesh Channel
     *
     * @param nChannel Mesh channel
     */
	DCSAPI DCS_Return_Code DCS_GetMeshChannel(int* nChannel);

	/**
     * Get current Mesh-Only setting.
     *
     * @param nEnableOnly 0: disable	1: enable.

     */
	DCSAPI DCS_Return_Code DCS_GetMeshOnlyMode(int* nEnableOnly);

	/**
     * Get Mesh Device Name.
     *
     * @param pStrMeshDeviceName Mesh device name
     */
	DCSAPI DCS_Return_Code DCS_GetMeshDeviceName(ENM_String* pStrMeshDeviceName);
	
	/**
     * Get Mesh Channel Band Width.
     *
     * @param nBandWidth BandWidth	0: 20		1: 40
     */
	DCSAPI DCS_Return_Code DCS_GetMeshChannelBandWidth(int* nBandWidth);

	/**
     * Get Mesh Channel Offset.
     *
     * @param nFlag 0: below	1: above
     */
	DCSAPI DCS_Return_Code DCS_GetMeshChannelOffset(int* nFlag);
	
	/** 
	 * Typedef of the callback function to be notified when the 
	 * classmate PC changes the disabled status of LAN. 
	 *
	 * @param pData		points to the disabled status
	 */
	typedef void (CALLBACK *DCS_ENM_Disable_Lan_Callback) (BOOL *pData);
	
	/** 
	 * Registers the callback function to be notified  when the 
	 * classmate PC changes the disabled status of LAN.
	 *
	 * @param pCallback		the pointer to the callback function of wired lan change
	 */
	DCSAPI DCS_Return_Code DCS_RegisterLanDisabledCallback (DCS_ENM_Disable_Lan_Callback pCallback);
	
	/** 
	 * Unregisters the callback function for LAN status changed notifications. 
	 */
	DCSAPI DCS_Return_Code DCS_UnregisterLanDisabledCallback();
	
	/** 
	 * Typedef of the callback function to be notified when the 
	 * classmate PC changes the disabled status of WLAN. 
	 *
	 * @param pData		points to the disabled status
	 */
	typedef void (CALLBACK *DCS_ENM_Disable_Wlan_Callback) (BOOL *pData);
	
	/** 
	 * Registers the callback function to be notified  when the 
	 * classmate PC changes the disabled status of WLAN.
	 *
	 * @param pCallback		the pointer to the callback function of wired lan change
	 */
	DCSAPI DCS_Return_Code DCS_RegisterWLanDisabledCallback (DCS_ENM_Disable_Wlan_Callback pCallback);
	
	/** 
	 * Unregisters the callback function for WLAN status changed notifications. 
	 */
	DCSAPI DCS_Return_Code DCS_UnregisterWLanDisabledCallback();	
	
    /**
     * Check if a specific type of network adapter exists
     *
     * @param adapterType  the specified adapter type
     */
    DCSAPI DCS_Return_Code DCS_DispatchDisableEvent(ENM_ADAPTER_TYPE adapterType);	

	/**
     * Get Mesh Host Name.
     *
     * @param pStrMeshHostName Mesh Host name
     */
	DCSAPI DCS_Return_Code DCS_GetMeshHostName(ENM_String* pStrMeshHostName);

	/**
     * Set Mesh Server.
     *
     * @param 
     */
	DCSAPI DCS_Return_Code DCS_EnableMeshServer(ENM_String* ifname);

	/**
     * Set Mesh Client.
     *
     * @param 
     */
	DCSAPI DCS_Return_Code DCS_EnableMeshClient(PMESH_GATEWAY_INFO pMeshGatewayInfo);

	/**
     * Get Mesh Gateway info.
     *
     * @param pMeshGatewayInfo the mesh gatewayinfo
     */

	DCSAPI DCS_Return_Code DCS_GetMeshGatewayInfo(PMESH_GATEWAY_INFO pMeshGatewayInfo);


#ifdef __cplusplus
}
#endif /** __cplusplus */

#endif /* DCS_EASYNETWORKMANAGER_API_H */
