#ifndef _WIN32_WLAN_SCANNER_H
#define _WIN32_WLAN_SCANNER_H

#include "WlanScanner.h"

#if defined(__WXMSW__)

const int PROFILE_MAX_SIZE = 2048;

class Win32WlanScanner : public WlanScanner
{
public:
    Win32WlanScanner();
    virtual ~Win32WlanScanner();
    bool OpenWlanHandle();
    bool CloseWlanHandle();
    bool IsHandleOpen();
    bool IsWlanAdapterGatewayAvailable();
    bool IsWlanInterfaceAvailable();
    bool IsWlanInterfaceConnected();
    void LoadProfiles();
    WlanResult StartWlanScan();
    WlanResult ScanWlanNetwork(AccessPointList* pList);
    WlanResult ConnectWlanNetwork(const APStatus* ap, const wxString& key = _T(""), int keyIndex = 1);
    bool CloseWlanConnection();
    bool UpdateCurrentAP(APStatus& apStatus);
    WlanResult RegisterWlanNotification(void* pData, bool enable);

    wxString GetCurrentWlanAdapterId();
    bool GetCurrentConnectedNetwork(APStatus* pAPStatus);

private:
    HANDLE m_hClientHandle;
    bool m_isHandleOpen;
    void* m_pBssidList;
    wxString m_open;
    wxString m_wep;
    wxString m_wpa;
    char m_openProfile[PROFILE_MAX_SIZE];
    char m_wepProfile[PROFILE_MAX_SIZE];
    char m_wpaProfile[PROFILE_MAX_SIZE];

    wxString StringToHex(const char* str, size_t length);

    bool CopyAccessPointList(AccessPointList* pNewList, AccessPointList* pSrcList);
    WlanResult GetNetworkFromWifi(AccessPointList* pList);
    WlanResult GetNetworkFromNdis(AccessPointList* pList);
    bool GetBssidList(HANDLE handle, NDIS_802_11_BSSID_LIST_EX* pBssidList);

    bool Find_80211n_IE(UCHAR *ucIE, unsigned int uiSize);
};

#endif //  __WXMSW__

#endif // _WIN32_WLAN_SCANNER_H
