#if defined(__WXMSW__)
#include "ENMUtil.h"
#include "ProfileEvent.h"
#include "SessionWnd.h"

HWND m_hSessionWnd;
LRESULT CALLBACK WndProc(HWND hWnd,UINT Message,WPARAM wParam,LPARAM lParam)
{
    switch(Message)
    {
    case WM_DESTROY:
        WTSUnRegisterSessionNotification(m_hSessionWnd);
        ::PostQuitMessage(0);
        break;

    case WM_WTSSESSION_CHANGE:
        switch(wParam)
        {
        case   WTS_SESSION_LOCK:
            ENMUtil::Log(::wxGetHomeDir() + wxT("\\log.txt"), wxString::Format(_T("WTS_SESSION_LOCK, %d"), DataCenter::GetInstance()->GetCurrentNetworkMode()));
            DataCenter::GetInstance()->StopGlobalTimer();
            break;

        case WTS_SESSION_UNLOCK:
            ENMUtil::Log(::wxGetHomeDir() + wxT("\\log.txt"), wxString(wxT("WTS_SESSION_UNLOCK")));
            DataCenter::GetInstance()->SessionUnlock(false);
            break;

        case WTS_SESSION_LOGON:
            ENMUtil::Log(::wxGetHomeDir() + wxT("\\log.txt"), wxString(wxT("WTS_SESSION_LOGON")));
            break;

        case WTS_SESSION_LOGOFF:
            ENMUtil::Log(::wxGetHomeDir() + wxT("\\log.txt"), wxString(wxT("WTS_SESSION_LOGOFF")));
            break;

        case WTS_CONSOLE_DISCONNECT:
            ENMUtil::Log(::wxGetHomeDir() + wxT("\\log.txt"), wxString(wxT("WTS_CONSOLE_DISCONNECT")));
            DataCenter::GetInstance()->SessionLock();
            break;

        case WTS_CONSOLE_CONNECT:
            ENMUtil::Log(::wxGetHomeDir() + wxT("\\log.txt"), wxString(wxT("WTS_CONSOLE_CONNECT")));
            DataCenter::GetInstance()->SessionUnlock(true);
            break;

        default:
            break;
        }

    default:
        return DefWindowProc(hWnd,Message,wParam,lParam);
    }
    return 0;
}

void SsesionWnd::CreateSsessionWnd()
{
    HINSTANCE hInstance = NULL;//AfxGetInstanceHandle();

    WNDCLASSEX wcex;
    wcex.cbClsExtra=NULL;
    wcex.cbSize=sizeof(WNDCLASSEX);
    wcex.cbWndExtra=NULL;
    wcex.hbrBackground=(HBRUSH)(COLOR_WINDOW+1);
    wcex.hCursor=::LoadCursor(NULL,IDC_ARROW);
    wcex.hIcon=NULL;
    wcex.hIconSm=NULL;
    wcex.hInstance= hInstance;
    wcex.lpfnWndProc=WndProc;
    wcex.lpszClassName=_T("EasyNetworkManagerSession");
    wcex.lpszMenuName=NULL;
    wcex.style=NULL;

    ::RegisterClassEx(&wcex);

    MSG Message;

    /*create wnd*/
    m_hSessionWnd = CreateWindow(_T("EasyNetworkManagerSession"),_T("ENMSession"),WS_OVERLAPPEDWINDOW,
    CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,NULL,NULL,hInstance,NULL);

    WTSRegisterSessionNotification(m_hSessionWnd,NOTIFY_FOR_THIS_SESSION);

     /*Msg*/
    while (GetMessage(&Message,NULL,NULL,NULL))
    {
      //send message to wnd
      DispatchMessage(&Message);
    }
    return ;

}

#endif


