
#include "ENMApp.h"
#include "ScanNetworkDlg.h"

//(*InternalHeaders(ScanNetworkDlg)
#include <wx/bitmap.h>
#include <wx/settings.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
//*)

#if defined(__WXMSW__)
#include <windows.h>
#include "CustomStaticText.h"
#endif

#include "ENMUtil.h"
#include "KeyDialog.h"
#include <wx/msgdlg.h>
#include <wx/dcclient.h>
#include <wx/tooltip.h>

#include "DataCenter.h"
#include "pic/icon_scan.xpm"

#if defined(__UNIX__)
#include "WirelessScanner.h"
#endif

#include "ProfileManagementControl.h"
#include "PolicyManager.h"
#include "EditProfileDialog.h"
#include "ProfileManagerDlg.h"
#include "SsidInputDialog.h"

#include <wx/thread.h>
static wxMutex* s_mutexProtectingTheGlobalData = NULL;

#if defined(__WXMSW__)
static wxString sndLogFile(_T("C:\\ScanNetworkDlg.log"));
static wxString srLogFile(_T("C:\\ScanRecorder.log"));
#else
static wxString sndLogFile(_T("/tmp/ScanNetworkDlg.log"));
static wxString srLogFile(_T("/tmp/ScanRecorder.log"));
#endif

ScanRecorder::ScanRecorder()
{
    s_mutexProtectingTheGlobalData = new wxMutex();

    for (int i = 0 ; i < MAX_AP_BUTTON_COUNT ; i ++)
    {
        m_aplist[i] = NULL;
    }
}

ScanRecorder::~ScanRecorder()
{
    Clear();
}

void ScanRecorder::Clear()
{
    ENMUtil::Log(srLogFile, _T("Enter ScanRecorder::Clear()"));
    s_mutexProtectingTheGlobalData->Lock();
    ENMUtil::Log(srLogFile, _T("\t Locked"));
    for ( int i = 0; i < MAX_AP_BUTTON_COUNT; i++ )
    {
        if ( m_aplist[i] == NULL )
            continue;
        ENMUtil::Log(srLogFile, wxString::Format(_T("\t Clear No.%d DetectedIcon: %08X (ap=%08X, button=%08X, label=%08X)."), i, m_aplist[i], m_aplist[i]->ap, m_aplist[i]->button, m_aplist[i]->txtLabel));
        ENMUtil::Log(srLogFile, _T("\t Clear content of icon."));
        if ( m_aplist[i]->button != NULL )
        {
            ENMUtil::Log(srLogFile, wxString::Format(_T("\t\t Clear button: %08X"), m_aplist[i]->button));
            m_aplist[i]->button->Show(false);
            m_aplist[i]->button->GetParent()->RemoveChild(m_aplist[i]->button);
            m_aplist[i]->button->SetParent(NULL);
            m_aplist[i]->button->Destroy();
//            delete m_aplist[i]->button;
            m_aplist[i]->button = NULL;
        }
        if ( m_aplist[i]->txtLabel != NULL )
        {
            ENMUtil::Log(srLogFile, wxString::Format(_T("\t\t Clear static label: %08X"), m_aplist[i]->txtLabel));
            m_aplist[i]->txtLabel->Show(false);
            m_aplist[i]->txtLabel->GetParent()->RemoveChild(m_aplist[i]->txtLabel);
            m_aplist[i]->txtLabel->SetParent(NULL);
            m_aplist[i]->txtLabel->Destroy();
//            delete m_aplist[i]->txtLabel;
            m_aplist[i]->txtLabel = NULL;
        }
        ENMUtil::Log(srLogFile, _T("\t Clear content of icon. OK\n"));
        ENMUtil::Log(srLogFile, _T("\t delete icon. OK"));
        delete m_aplist[i];
        m_aplist[i] = NULL;
        ENMUtil::Log(srLogFile, _T("\t Clear DetectedIcon. OK"));
    }
    s_mutexProtectingTheGlobalData->Unlock();
    ENMUtil::Log(srLogFile, _T("\t Unlocked"));
    ENMUtil::Log(srLogFile, _T("Return ScanRecorder::Clear\n"));
}

int ScanRecorder::AppendAPStatus(const APStatus& pap)
{
    ENMUtil::Log(srLogFile, wxString::Format(_T("Enter ScanRecorder::AppendAPStatus(pap=%08X)"), pap));
    s_mutexProtectingTheGlobalData->Lock();
    ENMUtil::Log(srLogFile, _T("\t Locked"));
    int position = -1;
    for (int i = 0 ; i < MAX_AP_BUTTON_COUNT ; i ++)
    {
        if (m_aplist[i] == NULL)
        {
            ENMUtil::Log(srLogFile, wxString::Format(_T("\t Find position: %d"), i));
            m_aplist[i] = new DetectedIcon();
            ENMUtil::Log(srLogFile, wxString::Format(_T("\t New DetectedIcon: %08X"), m_aplist[i]));
            m_aplist[i]->button = NULL;
            ENMUtil::Log(srLogFile, _T("\t Set button NULL"));
            m_aplist[i]->txtLabel = NULL;
            ENMUtil::Log(srLogFile, _T("\t Set static text NULL"));
            m_aplist[i]->label = _T("");
            ENMUtil::Log(srLogFile, _T("\t Set label \"\""));
            ENMUtil::Log(srLogFile, _T("\t Copy data from argument to APStatus"));
            m_aplist[i]->ap = pap;
            ENMUtil::Log(srLogFile, _T("\t Copy data OK"));
            position = i;
            break;
        }
    }
    s_mutexProtectingTheGlobalData->Unlock();
    ENMUtil::Log(srLogFile, _T("\t Unlocked"));
    ENMUtil::Log(srLogFile, wxString::Format(_T("Return ScanRecorder::AppendAPStatus : %d\n"), position));
    return position;
}

APStatus ScanRecorder::GetAPStatus(int index)
{
    APStatus result;
    memset(&result, 0, sizeof(APStatus));
    if ( m_aplist[index] != NULL )
    {
        result = m_aplist[index]->ap;
    }
    return result;
}

const long ScanNetworkDlg::ID_STATICBITMAP_BACKGROUND_IMAGE = wxNewId();
const long ScanNetworkDlg::ID_BUTTON_REFRESH = wxNewId();
const long ScanNetworkDlg::ID_BUTTON_CONNECT = wxNewId();
const long ScanNetworkDlg::ID_BUTTON_CANCEL = wxNewId();
const long ScanNetworkDlg::ID_STATICTEXT1 = wxNewId();
const long ScanNetworkDlg::ID_BUTTON_DETAIL = wxNewId();
const long ScanNetworkDlg::ID_TIMER_CONNECT = wxNewId();
const long ScanNetworkDlg::ID_TIMER_ALLOCATOR = wxNewId();
const long ScanNetworkDlg::ID_TIMER_SCAN = wxNewId();
const long ScanNetworkDlg::ID_LISTCTRL_DETAIL = wxNewId();
const long ScanNetworkDlg::ID_SCROLLEDWINDOW = wxNewId();
const long ScanNetworkDlg::ID_HELP = wxNewId();

#if defined(__WXMSW__)
const wxString ScanNetworkDlg::AP_CURRENT_IMAGE_NAME = _T("pic\\ap_h.png");
const wxString ScanNetworkDlg::AP_SELECTED_IMAGE_NAME = _T("pic\\ap_f.png");
const wxString ScanNetworkDlg::AP_NORMAL_IMAGE_NAME = _T("pic\\ap.png");
const wxString ScanNetworkDlg::BACKGROUND_IMAGE_NAME = _T("pic\\network.png");
#else
const wxString ScanNetworkDlg::AP_CURRENT_IMAGE_NAME = _T("pic/ap_h.png");
const wxString ScanNetworkDlg::AP_SELECTED_IMAGE_NAME = _T("pic/ap_f.png");
const wxString ScanNetworkDlg::AP_NORMAL_IMAGE_NAME = _T("pic/ap.png");
const wxString ScanNetworkDlg::BACKGROUND_IMAGE_NAME = _T("pic/network.png");
#endif

BEGIN_EVENT_TABLE(ScanNetworkDlg,wxDialog)
    EVT_INIT_DIALOG(ScanNetworkDlg::OnInit)
	EVT_CLOSE(ScanNetworkDlg::OnClose)
	EVT_WLAN_ACM(ID_WLAN_ACM_CONNECT, ScanNetworkDlg::OnWlanConnect)
	EVT_LIST_COL_BEGIN_DRAG(ID_LISTCTRL_DETAIL, ScanNetworkDlg::OnListColumnBeginDrag)
	EVT_LIST_ITEM_SELECTED(ID_LISTCTRL_DETAIL, ScanNetworkDlg::OnListCtrlDetailItemSelect)
	EVT_LIST_ITEM_DESELECTED(ID_LISTCTRL_DETAIL, ScanNetworkDlg::OnListCtrlDetailItemDeselect)
	EVT_LIST_ITEM_ACTIVATED(ID_LISTCTRL_DETAIL, ScanNetworkDlg::OnListItemActivated)
	EVT_LIST_COL_CLICK(ID_LISTCTRL_DETAIL, ScanNetworkDlg::OnListColumnClicked)
END_EVENT_TABLE()

ScanNetworkDlg::ScanNetworkDlg(wxWindow* parent, wxWindowID id, const wxPoint& pos, const wxSize& size)
        : wxDialog(), calculator(), m_sorter(7), m_scanRecorder(), m_pGaugeDialog(NULL), m_imageList(24, 24)
{
    LoadImages();
    Create(parent, wxID_ANY, _("Scan for Networks"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE | wxCLOSE_BOX, _T("wxID_ANY"));
    SetClientSize(wxSize(500,480));

    m_bgPanel = new wxPanel(this, ID_SCROLLEDWINDOW, wxPoint(0,40), wxSize(500,400), wxSTATIC_BORDER, _T("ID_SCROLLEDWINDOW"));
	m_stcBackgroundImage = new wxStaticBitmap(m_bgPanel, ID_STATICBITMAP_BACKGROUND_IMAGE, m_bmpBackground, wxPoint(0, 0), wxSize(500,400), wxSTATIC_BORDER, _T("ID_STATICBITMAP_BACKGROUND_IMAGE"));
    m_btnRefresh = new wxButton(this, ID_BUTTON_REFRESH, _("&Refresh"), wxPoint(16, 444), wxSize(90, 30), 0, wxDefaultValidator, _T("ID_BUTTON_REFRESH"));
    m_btnConnect = new wxButton(this, ID_BUTTON_CONNECT, _("C&onnect"), wxPoint(300, 444), wxSize(90, 30), 0, wxDefaultValidator, _T("ID_BUTTON_CONNECT"));
    m_btnCancel = new wxButton(this, ID_BUTTON_CANCEL, _("&Cancel"), wxPoint(394, 444), wxSize(90, 30), 0, wxDefaultValidator, _T("ID_BUTTON_CANCEL"));
    StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Select a network to connect to..."), wxPoint(8, 10), wxSize(325, 30), 0, _T("ID_STATICTEXT1"));
    m_btnDetail = new wxButton(this, ID_BUTTON_DETAIL, _("&Show Detail"), wxPoint(392, 5), wxSize(90, 30), 0, wxDefaultValidator, _T("ID_BUTTON_DETAIL"));

    m_listDetail = new wxListCtrl(this, ID_LISTCTRL_DETAIL, wxPoint(0,40), wxSize(500,400), wxLC_REPORT | wxLC_SINGLE_SEL, wxDefaultValidator, _T("ID_LISTCTRL_DETAIL"));
    m_listDetail->SetImageList(&m_imageList, wxIMAGE_LIST_SMALL);
    m_listDetail->InsertColumn(0, wxEmptyString, wxLIST_FORMAT_LEFT, 0);
    m_listDetail->InsertColumn(1, _("Name"), wxLIST_FORMAT_LEFT, 120);
    m_listDetail->InsertColumn(2, _("Signal"), wxLIST_FORMAT_LEFT, 57);
    m_listDetail->InsertColumn(3, _("Encrypt"), wxLIST_FORMAT_LEFT, 85);
    m_listDetail->InsertColumn(4, _("Connected"), wxLIST_FORMAT_LEFT, 80);
    m_listDetail->InsertColumn(5, _("Type"), wxLIST_FORMAT_LEFT, 65);
    m_listDetail->InsertColumn(6, _("Channel"), wxLIST_FORMAT_LEFT, 70);
    m_listDetail->InsertColumn(7, _("MAC Address"), wxLIST_FORMAT_LEFT, 125);
    m_listDetail->Show(false);

    Connect(ID_BUTTON_REFRESH,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ScanNetworkDlg::OnButtonRefreshClick);
    Connect(ID_BUTTON_CONNECT,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ScanNetworkDlg::OnButtonConnectClick);
    Connect(ID_BUTTON_CANCEL,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ScanNetworkDlg::OnButtonCancelClick);
    Connect(ID_BUTTON_DETAIL,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ScanNetworkDlg::OnButtonDetailClick);
	m_stcBackgroundImage->Connect(ID_STATICBITMAP_BACKGROUND_IMAGE, wxEVT_LEFT_UP, (wxObjectEventFunction)&ScanNetworkDlg::OnBackgroundBitmapClick);
    Connect(ID_HELP,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ScanNetworkDlg::OnF1Press);
    Center();

    m_isForConnect = true;
    m_isDetail = false;
    m_btnConnect->Enable(false);
    m_iSelected = -1;
    m_apArray.nCount = 0;
    m_pGaugeDialog = new GaugeDialog(this);

    wxIcon icon_scan(icon_scan_xpm);
    SetIcon(icon_scan);

    wxAcceleratorEntry entries[1];
    entries[0].Set(wxACCEL_NORMAL, WXK_F1, ID_HELP);
    wxAcceleratorTable accel(1, entries);
    SetAcceleratorTable(accel);
}

ScanNetworkDlg::~ScanNetworkDlg()
{
    m_scanRecorder.Clear();
    m_apArray.nCount = 0;
    if ( m_pGaugeDialog != NULL )
    {
        m_pGaugeDialog->Destroy();
        m_pGaugeDialog = NULL;
    }
}

unsigned int ScanNetworkDlg::GetImageIndex(const APStatus& ap, bool selected) const
{
    unsigned int uIndex = 0;
    APStatus* pCurrent = DataCenter::GetInstance()->GetCurrentAPStatus();
    if ( ap.auth != WLAN_SECURITY_NONE )
    {
        uIndex |= 0x04;
    }
    if ( pCurrent != NULL && CompareMacAddress((unsigned char*)ap.macAddress, pCurrent->macAddress) == 0 )
    {
        uIndex |= 0x02;
    }
    if ( selected )
    {
        uIndex |= 0x01;
    }
    return uIndex;
}

void ScanNetworkDlg::LoadImages()
{
#if defined(__WXMSW__)
    m_bmpAp[0].LoadFile(::wxGetApp().strAppPath + _T("pic\\ap_4.png"), wxBITMAP_TYPE_PNG);
    m_bmpAp[1].LoadFile(::wxGetApp().strAppPath + _T("pic\\ap_2.png"), wxBITMAP_TYPE_PNG);
    m_bmpAp[2].LoadFile(::wxGetApp().strAppPath + _T("pic\\ap_5.png"), wxBITMAP_TYPE_PNG);
    m_bmpAp[3].LoadFile(::wxGetApp().strAppPath + _T("pic\\ap_2.png"), wxBITMAP_TYPE_PNG);
    m_bmpAp[4].LoadFile(::wxGetApp().strAppPath + _T("pic\\ap_3.png"), wxBITMAP_TYPE_PNG);
    m_bmpAp[5].LoadFile(::wxGetApp().strAppPath + _T("pic\\ap_1.png"), wxBITMAP_TYPE_PNG);
    m_bmpAp[6].LoadFile(::wxGetApp().strAppPath + _T("pic\\ap_6.png"), wxBITMAP_TYPE_PNG);
    m_bmpAp[7].LoadFile(::wxGetApp().strAppPath + _T("pic\\ap_1.png"), wxBITMAP_TYPE_PNG);

    m_bmpBackground.LoadFile(::wxGetApp().strAppPath + _T("pic\\network.png"), wxBITMAP_TYPE_PNG);
    m_imageList.Add(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\empty.png"))));
#else
    m_bmpAp[0].LoadFile(::wxGetApp().strAppPath + _T("pic/ap_4.png"), wxBITMAP_TYPE_PNG);
    m_bmpAp[1].LoadFile(::wxGetApp().strAppPath + _T("pic/ap_2.png"), wxBITMAP_TYPE_PNG);
    m_bmpAp[2].LoadFile(::wxGetApp().strAppPath + _T("pic/ap_5.png"), wxBITMAP_TYPE_PNG);
    m_bmpAp[3].LoadFile(::wxGetApp().strAppPath + _T("pic/ap_2.png"), wxBITMAP_TYPE_PNG);
    m_bmpAp[4].LoadFile(::wxGetApp().strAppPath + _T("pic/ap_3.png"), wxBITMAP_TYPE_PNG);
    m_bmpAp[5].LoadFile(::wxGetApp().strAppPath + _T("pic/ap_1.png"), wxBITMAP_TYPE_PNG);
    m_bmpAp[6].LoadFile(::wxGetApp().strAppPath + _T("pic/ap_6.png"), wxBITMAP_TYPE_PNG);
    m_bmpAp[7].LoadFile(::wxGetApp().strAppPath + _T("pic/ap_1.png"), wxBITMAP_TYPE_PNG);

    m_bmpBackground.LoadFile(::wxGetApp().strAppPath + _T("pic/network.png"), wxBITMAP_TYPE_PNG);
    m_imageList.Add(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/empty.png"))));
#endif
}

void ScanNetworkDlg::SetDialogMode(bool forConnect)
{
    m_isForConnect = forConnect;
}

bool ScanNetworkDlg::CloseDialog(int ret)
{
    m_pGaugeDialog->Show(false);
    if ( !IsShown() )
        return true;
    if ( IsModal() )
    {
        wxDialog::EndModal(ret);
        return true;
    }
    else
    {
        return wxDialog::Show(false);
    }
}

bool ScanNetworkDlg::GetSelectedNetwork(APStatus* pAp)
{
    if ( m_isForConnect )
        return false;
    if ( pAp == NULL )
        return false;
    memcpy(pAp, &m_toSelect, sizeof(APStatus));
    return true;
}

void ScanNetworkDlg::StartRefresh()
{
    m_btnRefresh->Enable(false);
    m_btnCancel->Enable(false);
    m_btnConnect->Enable(false);
    ClearDetectedAP();
    m_listDetail->DeleteAllItems();
    m_sorter.Reset();
#if defined(__WXMSW__)
    WlanResult result = DataCenter::GetInstance()->BeginSearchAP();

    if ( result == WLAN_SUCCESS )
    {
        m_pGaugeDialog->SetProcessLabel(_("Scanning for networks..."));
        m_pGaugeDialog->Show(true);
//        m_pGaugeDialog->Raise();
    }
    else if ( result == WLAN_NO_INTERFACE )
    {
        wxMessageDialog msg(this, _("Cannot find WLAN adapter!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
    }
    else
    {
        wxMessageDialog msg(this, _("Failed to scan for networks!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
    }
#endif
#if defined(__UNIX__)
    m_pGaugeDialog->SetProcessLabel(_("Scanning for networks..."));
    m_pGaugeDialog->Show(true);
    DataCenter::GetInstance()->BeginSearchAP();
#endif
}

void ScanNetworkDlg::OnInit(wxInitDialogEvent& event)
{
    if ( m_isForConnect )
    {
        m_btnConnect->SetLabel(_("C&onnect"));
    }
    else
    {
        m_btnConnect->SetLabel(_("&OK"));
    }
    m_iSelected = -1;
    memset(&m_toSelect, 0, sizeof(APStatus));
    ShowDetail(m_isDetail = false);
    StartRefresh();
}

void ScanNetworkDlg::OnButtonCancelClick(wxCommandEvent& event)
{
    ClearDetectedAP();
    CloseDialog(wxID_CANCEL);
}

void ScanNetworkDlg::OnButtonRefreshClick(wxCommandEvent& event)
{
    StartRefresh();
}

void ScanNetworkDlg::OnButtonConnectClick(wxCommandEvent& event)
{
    if ( m_btnConnect->GetLabelText().Cmp(_("Disconnect")) == 0 )
    {
        m_btnConnect->Enable(false);
        DataCenter::GetInstance()->CloseWlanConnection();
//        RefreshIcons(m_iSelected = -1);
    }
    else
    {
        ConnectAP();
    }
}

void ScanNetworkDlg::CreateNewWirelessProfile(const APStatus& ap, int priority, const wxString& name)
{
    ProfileList_t profile;
    if ( ENMUtil::IsAdministrator() )
        profile.sPermission = "admin";
    else
        profile.sPermission = "user";
    char ps[6] = { 0 };
    sprintf(ps, "%d", priority);
    profile.sPriority = ps;
    profile.sProfileName = ENMUtil::WxStringToString(name);
    profile.sProfileIcon = "0";
    profile.sShow = "1";
    profile.stGenernalSet.ConnecType = "wireless";
    profile.stWirelessSet.SSID = (char*)ap.ssid.ucSsid;
    switch( ap.type )
    {
    case WLAN_802_11_B:
        profile.stWirelessSet.WirlessType  = "802.11b";
        break;
    case WLAN_802_11_G:
        profile.stWirelessSet.WirlessType  = "802.11g";
        break;
    case WLAN_802_11_N:
        profile.stWirelessSet.WirlessType  = "802.11n";
        break;
    default:
        profile.stWirelessSet.WirlessType  = "Automatic";
        break;
    }
    char strKeyIndex[3] = { 0 };
    sprintf(strKeyIndex, "%d", m_iKeyIdx);
    profile.stWirelessSet.stWEPSecurity.keyIndex = strKeyIndex;
    switch( ap.auth )
    {
    case WLAN_SECURITY_NONE:
        profile.stWirelessSet.WlanSecurity = "none";
        break;
    case WLAN_SECURITY_WEP:
        profile.stWirelessSet.WlanSecurity = "wep";
        profile.stWirelessSet.stWEPSecurity.value = ENMUtil::WxStringToString(m_strKey);
        break;
    case WLAN_SECURITY_WPA_PSK:
        profile.stWirelessSet.WlanSecurity = "wpa-psk";
        profile.stWirelessSet.stWPASecurity.value = ENMUtil::WxStringToString(m_strKey);
        break;
    default:
        profile.stWirelessSet.WlanSecurity = "unknown";
        break;
    }
    profile.stOtherSet.NetworkSecurity = "0";
    profile.stOtherSet.AutoRunAppFlag = "0";
    profile.stOtherSet.IPDNSFlag = "0";
    profile.stOtherSet.IsHomepage = "0";
    profile.stOtherSet.ProxyFlag = "0";
    EditProfileDialog editDialog(this, profile, true);
    if ( editDialog.ShowModal() == wxID_OK )
    {
        profile = editDialog.GetProfile();
        ProfileManagementControl* pProfileController = DataCenter::GetInstance()->GetProfileController();
        if ( pProfileController->InsertNewWirelessProfile(profile) )
        {
            ProfileManagerDlg* pProfileManagerDlg = DataCenter::GetInstance()->GetProfileManagerDlgHandle();
            pProfileManagerDlg->InsertNewProfile(profile);
            wxMessageDialog dialog(this, _("Profile created successfully."), _("Message"), wxOK | wxICON_INFORMATION);
            dialog.ShowModal();
        }
        else
        {
            wxMessageDialog dialog(this, _("Failed to create profile."), _("Message"), wxOK | wxICON_EXCLAMATION);
            dialog.ShowModal();
        }
    }
}

void ScanNetworkDlg::OnWlanConnect(WlanAcmEvent& event)
{
    if ( !IsShown() )
        return;

    ENMUtil::Log(sndLogFile, _T("Enter ScanNetworkDlg::OnWlanConnect"));
    unsigned long code = event.GetEventCode();
    if ( code == WLAN_ACM_EVENT_CONNECT_SUCCESS )
    {
        ENMUtil::Log(sndLogFile, _T("\t connect success"));
        m_pGaugeDialog->Show(false);
        wxString ssid = wxString::FromUTF8((char*)m_toConnect.ssid.ucSsid, m_toConnect.ssid.length);
//        wxString message = wxString::Format(_("Successfully connected to %s."), ssid);
        wxString message = _("Successfully connected to ") + ssid + _T(".");
        ProfileManagementControl* pProfileController = DataCenter::GetInstance()->GetProfileController();
        int checkResult = pProfileController->CheckWirelessProfileExist(m_toConnect);
//        ENMUtil::Log(sndLogFile, wxString::Format(("Enter ScanNetworkDlg::OnWlanConnect checkResult is %d"), checkResult));
        if ( checkResult == 0 )
            return;
        PolicyManager* pPolicyManager = DataCenter::GetInstance()->GetPolicyManager();
        if ( (checkResult & 0x00F00000) == 0 && pPolicyManager->IsAllowOwnerProfile() )
        {
            if ( (checkResult & 0x000F0000) == 0x00010000 )
            {
                ssid += _T("_0");
            }
            message += _("\nWould you like to create a new profile for this network?");
            wxMessageDialog dialog(this, message, _("Confirm"), wxYES_NO | wxNO_DEFAULT | wxICON_QUESTION);
            if ( dialog.ShowModal() == wxID_YES )
            {
                int priority = checkResult & 0x0000FFFF;
                CreateNewWirelessProfile(m_toConnect, priority + 1, ssid);
            }
        }
    }
    if ( code == WLAN_ACM_EVENT_CONNECT_FAILED )
    {
        ENMUtil::Log(sndLogFile, _T("\t connect failed"));
        m_pGaugeDialog->Show(false);
        unsigned long error = event.GetErrorCode();
        wxString message = _("Cannot connect. \n\nPlease check the network authentication type and \nmake sure the password was correct.");
        switch ( error )
        {
        case WLAN_ACM_ERROR_NO_INTERFACE:
            message = _("Cannot find wireless adapter!");
            break;
        case WLAN_ACM_ERROR_NO_RESPONSE:
            message = _("No response received from selected network.");
            break;
        };
        wxMessageDialog msg(this, message, _("Message"), wxOK | wxICON_EXCLAMATION);
        msg.ShowModal();
    }
    if ( code == WLAN_ACM_EVENT_DISCONNECTED && m_isForConnect )
    {
        ENMUtil::Log(sndLogFile, _T("\t disconnect"));
//        m_btnConnect->Enable(true);
        m_btnConnect->SetLabel(_("C&onnect"));
    }
//    RefreshIcons(m_iSelected);
    if ( !m_pGaugeDialog->IsShown() )
    {
        m_listDetail->DeleteAllItems();
        ENMUtil::Log(sndLogFile, _T("\t ClearDetectedAP"));
        ClearDetectedAP();
        ENMUtil::Log(sndLogFile, _T("\t UpdateUI"));
        UpdateUI(m_apArray);
        m_btnConnect->Enable(m_iSelected != -1);
        m_btnRefresh->Enable(true);
        m_btnCancel->Enable(true);
    }
    ENMUtil::Log(sndLogFile, _T("Return ScanNetworkDlg::OnWlanConnect\n"));
}

void ScanNetworkDlg::OnBackgroundBitmapClick(wxMouseEvent& event)
{
    DataCenter::GetInstance()->GetScanNetworkDlgHandle()->ProcessBackgroundClick();
}

void ScanNetworkDlg::OnBitmapButtonClick(wxCommandEvent& event)
{
    int id = event.GetId();
    int index = id - MAX_AP_BUTTON_ID;
    if (index >= 0 && index < MAX_AP_BUTTON_ID)
    {
        m_iSelected = index;
        if ( m_iSelected < m_listDetail->GetItemCount() )
        {
            m_listDetail->SetItemState(m_iSelected, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
        }
        else
        {
            DeselectAllListItem();
        }
//#if defined(__UNIX__)
//        m_btnConnect->Enable(true);
//#endif
        RefreshIcons(m_iSelected);
    }
}

void ScanNetworkDlg::OnBitmapButtonDblClick(wxMouseEvent& event)
{
    DataCenter::GetInstance()->GetScanNetworkDlgHandle()->ProcessDoubleClick();
}

void ScanNetworkDlg::OnButtonDetailClick(wxCommandEvent& event)
{
    ShowDetail(!m_isDetail);
    m_isDetail = !m_isDetail;
}

void ScanNetworkDlg::ProcessDoubleClick()
{
    m_btnConnect->Enable(false);
    APStatus selectedAP = m_scanRecorder.GetAPStatus(m_iSelected);
    APStatus* pCurrentAP = DataCenter::GetInstance()->GetCurrentAPStatus();
//    if ( m_isForConnect && pCurrentAP != NULL && selectedAP.ssid == pCurrentAP->ssid )
    if ( m_isForConnect && pCurrentAP != NULL && CompareMacAddress(selectedAP.macAddress, pCurrentAP->macAddress) == 0 )
    {
        DataCenter::GetInstance()->CloseWlanConnection();
    }
    else
    {
        ConnectAP();
    }
}

void ScanNetworkDlg::ProcessBackgroundClick()
{
    m_btnConnect->Enable(false);
    RefreshIcons(m_iSelected = -1);
    DeselectAllListItem();
    wxListEvent event(wxEVT_COMMAND_LIST_ITEM_DESELECTED, m_listDetail->GetId());
    ProcessEvent(event);
}

void ScanNetworkDlg::ConnectAP()
{
    ENMUtil::Log(sndLogFile, _T("Enter ScanNetworkDlg::ConnectAP"));
    DataCenter* pDataCenter = DataCenter::GetInstance();
    m_btnConnect->Enable(false);
    m_btnRefresh->Enable(false);
    m_btnCancel->Enable(false);
    APStatus ap;
    if ( m_isDetail )
    {
        long nItem = m_listDetail->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
        if ( nItem == -1 )
        {
            m_btnRefresh->Enable(true);
            m_btnCancel->Enable(true);
            ENMUtil::Log(sndLogFile, _T("Return ScanNetworkDlg::ConnectAP, no select\n"));
            return;
        }
        ap = m_scanRecorder.GetAPStatus(nItem);
    }
    else
    {
        if ( m_iSelected == -1 )
        {
            m_btnRefresh->Enable(true);
            m_btnCancel->Enable(true);
            ENMUtil::Log(sndLogFile, _T("Return ScanNetworkDlg::ConnectAP, no select\n"));
            return;
        }
        ap = m_scanRecorder.GetAPStatus(m_iSelected);
    }

    if ( !m_isForConnect )
    {
        m_toSelect = ap;
        m_btnRefresh->Enable(true);
        m_btnConnect->Enable(true);
        m_btnCancel->Enable(true);
        CloseDialog(wxID_OK);
        ENMUtil::Log(sndLogFile, _T("Return ScanNetworkDlg::ConnectAP, not for connect\n"));
        return;
    }

    if ( !CheckSsid(&ap) )
    {
        m_strKey.Clear();
        m_iKeyIdx = 0;
        m_btnConnect->Enable(true);
        m_btnRefresh->Enable(true);
        m_btnCancel->Enable(true);
        ENMUtil::Log(sndLogFile, _T("Return ScanNetworkDlg::ConnectAP, canceled\n"));
        return;
    }

    if ( ap.auth == WLAN_SECURITY_WEP || ap.auth == WLAN_SECURITY_WPA_PSK )
    {
        KeyDialog dlg(this, ap.auth == WLAN_SECURITY_WEP);
        m_iKeyIdx = 0;
        if ( dlg.ShowModal() == wxID_OK )
        {
            m_strKey = dlg.GetKey();
            if ( ap.auth == WLAN_SECURITY_WEP )
            {
                m_iKeyIdx = dlg.GetIdx();
            }
        }
        else
        {
            m_strKey.Clear();
            m_iKeyIdx = 0;
            m_btnConnect->Enable(true);
            m_btnRefresh->Enable(true);
            m_btnCancel->Enable(true);
            ENMUtil::Log(sndLogFile, _T("Return ScanNetworkDlg::ConnectAP, canceled\n"));
            return;
        }
    }
    else if ( ap.auth == WLAN_SECURITY_UNKNOWN )
    {
        wxMessageDialog msg(this, _("Unknown authentication mode!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_btnRefresh->Enable(true);
        m_btnCancel->Enable(true);
        ENMUtil::Log(sndLogFile, _T("Return ScanNetworkDlg::ConnectAP, unknown authentication mode\n"));
        return;
    }
    else
    {
        m_iKeyIdx = 0;
    }

#if defined(__WXMSW__)
    WlanResult result = pDataCenter->ConnectWlanNetwork(ap, m_strKey, m_iKeyIdx);
    if ( result == WLAN_SUCCESS )
    {
        wxString _strApName = wxString::FromUTF8((char*)ap.ssid.ucSsid, ap.ssid.length);
//        if ( _strApName.Length() > 20 )
//        {
//            _strApName = _strApName.Mid(0, 20);
//        }
        wxString msg = _("Connecting to ") + _strApName + _T(" ...");
        m_pGaugeDialog->SetProcessLabel(msg);
        m_pGaugeDialog->Show(true);
        m_toConnect = ap;
        m_btnRefresh->Enable(false);
    }
#endif
#if defined(__UNIX__)
    wxString msg = _("Connecting to ") + wxString::FromUTF8((char*)ap.ssid.ucSsid, ap.ssid.length) + _T(" ...");
    m_pGaugeDialog->SetProcessLabel(msg);
    m_pGaugeDialog->Show(true);
    pDataCenter->CloseWlanConnection(true);
    m_toConnect = ap;
    m_btnConnect->Enable(false);
    pDataCenter->ConnectWlanNetwork(ap, m_strKey, m_iKeyIdx, false);
#endif
    ENMUtil::Log(sndLogFile, _T("Return ScanNetworkDlg::ConnectAP, OK\n"));
}

bool ScanNetworkDlg::CheckSsid(APStatus* pAPStatus)
{
    if ( pAPStatus == NULL )
        return false;

    if ( pAPStatus->ssid.length > 0 )
        return true;

    SsidInputDialog dialog(this);
    if ( dialog.ShowModal() != wxID_OK )
        return false;

    wxString ssid = dialog.GetSsid();
    string _s = ENMUtil::WxStringToString(ssid);
    const char* pszSsid = _s.c_str();
    pAPStatus->ssid.length = ssid.Length();
    strcpy((char*)pAPStatus->ssid.ucSsid, pszSsid);
    return true;
}

void ScanNetworkDlg::ShowDetail(bool detail)
{
    m_listDetail->Show(detail);
    m_listDetail->Enable(detail);
    m_bgPanel->Show(!detail);
    m_bgPanel->Enable(!detail);
    for (int i = 0 ; i < MAX_AP_BUTTON_COUNT ; i ++)
    {
        if ( m_scanRecorder.m_aplist[i] != NULL
                && m_scanRecorder.m_aplist[i]->button != NULL
                && m_scanRecorder.m_aplist[i]->txtLabel != NULL )
        {
            m_scanRecorder.m_aplist[i]->button->Show(!detail);
            m_scanRecorder.m_aplist[i]->txtLabel->Show(!detail);
        }
    }
    if ( detail )
    {
        m_btnDetail->SetLabel(_("<< &Back"));
    }
    else
    {
        m_btnDetail->SetLabel(_("&Show Detail"));
        RefreshIcons(m_iSelected);
    }
}

void ScanNetworkDlg::OnClose(wxCloseEvent& event)
{
    m_pGaugeDialog->Show(false);
    if ( event.CanVeto() )
        event.Veto();
    ClearDetectedAP();
    CloseDialog(wxID_CANCEL);
}

void ScanNetworkDlg::ClearDetectedAP()
{
    ENMUtil::Log(sndLogFile, _T("Enter ScanNetworkDlg::ClearDetectedAP()"));
    ENMUtil::Log(sndLogFile, _T("\t Clear ScanRecorder."));
    m_scanRecorder.Clear();
    ENMUtil::Log(sndLogFile, _T("\t Clear ScanRecorder OK.\n"));
    ENMUtil::Log(sndLogFile, _T("\t Reset IconPositionCalculator."));
    calculator.Reset();
    ENMUtil::Log(sndLogFile, _T("\t Reset IconPositionCalculator OK.\n"));
    ENMUtil::Log(sndLogFile, _T("Return ScanNetworkDlg::ClearDetectedAP\n"));
}

void ScanNetworkDlg::DrawButton(const wxPoint& centerPos, int id, const wxString& label, const size_t charsOfLabel)
{
    wxPoint buttonPos(centerPos.x - AP_ICON_SIZE.GetWidth() / 2, centerPos.y - AP_ICON_SIZE.GetHeight() / 2);
#if defined(__WXMSW__)
    wxPoint labelPos(buttonPos.x + AP_ICON_SIZE.GetWidth() + 1, buttonPos.y + (AP_ICON_SIZE.GetHeight() - AP_LABEL_SIZE.GetHeight()) / 2);
    wxBitmapButton* pButton = new wxBitmapButton(m_stcBackgroundImage, MAX_AP_BUTTON_ID + id, m_bmpAp[0], buttonPos, wxDefaultSize, wxBORDER_NONE);
#endif
#if defined(__UNIX__)
    wxPoint labelPos(buttonPos.x + AP_ICON_SIZE.GetWidth() + 7, buttonPos.y + (AP_ICON_SIZE.GetHeight() - AP_LABEL_SIZE.GetHeight()) / 2 + 3);
    wxBitmapButton* pButton = new wxBitmapButton(m_bgPanel, MAX_AP_BUTTON_ID + id, m_bmpAp[0], buttonPos, wxDefaultSize, wxBORDER_NONE);
#endif
    wxToolTip* pTip = new wxToolTip(label);
    pButton->SetToolTip(pTip);
    Connect(MAX_AP_BUTTON_ID + id, wxEVT_COMMAND_BUTTON_CLICKED, (wxObjectEventFunction)&ScanNetworkDlg::OnBitmapButtonClick);
    pButton->Connect(MAX_AP_BUTTON_ID + id, wxEVT_LEFT_DCLICK, (wxObjectEventFunction)&ScanNetworkDlg::OnBitmapButtonDblClick);
    wxString newLabel = label.Length() > 0 ? label : _T("<Hidden>");
    if ( newLabel.Length() > charsOfLabel )
    {
        newLabel = label.SubString(0, charsOfLabel) + _("...");
    }
//    APStatus* currentAP = DataCenter::GetInstance()->GetCurrentAPStatus();
#if defined(__WXMSW__)
    wxStaticText* pTextLabel = new CustomStaticText(m_stcBackgroundImage, wxID_ANY, newLabel, labelPos, AP_LABEL_SIZE, wxALIGN_LEFT);
#endif
#if defined(__UNIX__)
    wxStaticText* pTextLabel = new wxStaticText(m_bgPanel, wxID_ANY, newLabel, labelPos, AP_LABEL_SIZE, wxALIGN_LEFT);
#endif

    size_t iBmpIndex = GetImageIndex(m_scanRecorder.m_aplist[id]->ap, false);
    pButton->SetBitmapLabel(m_bmpAp[iBmpIndex]);
    if ( (iBmpIndex & 0x02) == 0x02 )
    {
        pTextLabel->SetForegroundColour(wxColour(255, 0, 0));
    }
    else
    {
        pTextLabel->SetForegroundColour(wxColour(0, 0, 0));
    }

#if FALSE
    if ( currentAP != NULL && CompareMacAddress(m_scanRecorder.m_aplist[id]->ap.macAddress, currentAP->macAddress) == 0 )
//    if ( currentAP != NULL && m_scanRecorder.m_aplist[id]->ap.ssid == currentAP->ssid )
    {
        pButton->SetBitmapLabel(m_bmpCurrent);
        pTextLabel->SetForegroundColour(wxColour(255, 0, 0));
    }
    else
    {
        pButton->SetBitmapLabel(m_bmpNormal);
        pTextLabel->SetForegroundColour(wxColour(0, 0, 0));
    }
#endif

    m_scanRecorder.m_aplist[id]->button = pButton;
    m_scanRecorder.m_aplist[id]->txtLabel = pTextLabel;
    m_scanRecorder.m_aplist[id]->label = label;

    pButton->Show(!m_isDetail);
    pTextLabel->Show(!m_isDetail);
}

void ScanNetworkDlg::RefreshIcons(int selected)
{
    ENMUtil::Log(sndLogFile, wxString::Format(_T("Enter ScanNetworkDlg::RefreshIcons(%d)"), selected));
    APStatus* pCurAP = DataCenter::GetInstance()->GetCurrentAPStatus();
    ENMUtil::Log(sndLogFile, wxString::Format(_T("\t call DataCenter::GetCurrentAPStatus() : %08X"), pCurAP));
    ENMUtil::Log(sndLogFile, _T("\t Begin to refresh icons."));
    for (int i = 0 ; i < MAX_AP_BUTTON_COUNT ; i ++)
    {
        if ( m_scanRecorder.m_aplist[i] == NULL )
            continue;
        DetectedIcon* pIcon = m_scanRecorder.m_aplist[i];
        APStatus ap = pIcon->ap;
        wxBitmapButton* pButton = pIcon->button;
        wxStaticText* pText = pIcon->txtLabel;
        ENMUtil::Log(sndLogFile, wxString::Format(_T("\t\t Refresh No.%d icon: %08X (ap=%08X, button=%08X, stx=%08X)"), i, pIcon, &ap, pButton, pText));
        if ( pIcon != NULL && pButton != NULL && pText != NULL )
        {
            unsigned int iBmpIndex = GetImageIndex(ap, i == selected);
            pButton->SetBitmapLabel(m_bmpAp[iBmpIndex]);
            if ( (iBmpIndex & 0x02) == 0x02 )
            {
                pText->SetForegroundColour(wxColour(255, 0, 0));
            }
            else
            {
                pText->SetForegroundColour(wxColour(0, 0, 0));
            }
#if FALSE
//            if ( pCurAP != NULL && pCurAP->ssid == ap.ssid )
            if ( pCurAP != NULL && CompareMacAddress(pCurAP->macAddress, ap.macAddress) == 0 )
            {
                ENMUtil::Log(sndLogFile, wxString::Format(_T("\t\t No.%d is connected."), i));
                pButton->SetBitmapLabel(m_bmpCurrent);
                pText->SetForegroundColour(wxColour(255, 0, 0));
            }
            else
            {
                ENMUtil::Log(sndLogFile, wxString::Format(_T("\t\t No.%d is not connected."), i));
                pButton->SetBitmapLabel(m_bmpNormal);
                pText->SetForegroundColour(wxColour(0, 0, 0));
            }
            if ( i == selected )
            {
                ENMUtil::Log(sndLogFile, wxString::Format(_T("\t\t No.%d is selected."), i));
                pButton->SetBitmapLabel(m_bmpSelected);
            }
#endif
        }
        ENMUtil::Log(sndLogFile, wxString::Format(_T("\t\t Finish refresh No.%d icon."), i));
    }
    ENMUtil::Log(sndLogFile, _T("\t Finish to refresh icons."));

    if ( m_isForConnect )
    {
        ENMUtil::Log(sndLogFile, _T("\t ScanNetworkDlg is used for connect network."));
        APStatus* pSelAP = NULL;
        if ( selected >= 0 && selected < MAX_AP_BUTTON_COUNT && m_scanRecorder.m_aplist[selected] != NULL )
        {
            pSelAP = &m_scanRecorder.m_aplist[selected]->ap;
        }
        if ( pSelAP != NULL && pCurAP != NULL && CompareMacAddress(pSelAP->macAddress, pCurAP->macAddress) == 0 )
//        if ( pSelAP != NULL && pCurAP != NULL && pSelAP->ssid == pCurAP->ssid )
        {
            ENMUtil::Log(sndLogFile, _T("\t\t Set button label is \"Disconnect\"."));
            m_btnConnect->SetLabel(_("&Disconnect"));
        }
        else
        {
            ENMUtil::Log(sndLogFile, _T("\t\t Set button label is \"Connect\"."));
            m_btnConnect->SetLabel(_("C&onnect"));
        }
    }
    ENMUtil::Log(sndLogFile, _T("Return ScanNetworkDlg::RefreshIcons\n"));
}

void ScanNetworkDlg::UI_UpdateNetworkMode(NETWORK_MODE networkMode)
{
    switch ( networkMode )
    {
    case NETWORK_MODE_WIRED_LAN_CONNECT:
    case NETWORK_MODE_WIRED_LAN_DISCONNECT:
        m_btnRefresh->Enable(false);
        break;
    case NETWORK_MODE_WIRELESS_LAN_CONNECT:
    case NETWORK_MODE_WIRELESS_LAN_DISCONNECT:
        m_btnRefresh->Enable(true);
        break;
    case NETWORK_MODE_MESH_CONNECT:
    case NETWORK_MODE_MESH_DISCONNECT:
        break;
    case NETWORK_MODE_DISCONNECTED:
        m_btnRefresh->Enable(false);
        break;
    default:
        break;
    }
}

void ScanNetworkDlg::UI_UpdateNetworkStatusInfo(NETWORK_MODE networkMode, UI_NETWORK_STATUS_INFO& statusInfo)
{
    // Do nothing
}

void ScanNetworkDlg::UI_UpdateAPSatus(WlanResult result, const AccessPointList& apList)
{
    m_pGaugeDialog->Show(false);
    if ( !IsShown() )
        return;

    ENMUtil::Log(sndLogFile, wxString::Format(_T("Enter ScanNetworkDlg::UI_UpdateAPSatus(%d, %08X)"), result, &apList));
    ENMUtil::Log(sndLogFile, wxString::Format(_T("\t Count of detected AP: %d"), apList.nCount));
    if ( apList.nCount > 0 )
    {
        ENMUtil::Log(sndLogFile, _T("\t Clear m_apArray and copy argument data"));
        m_apArray.nCount = apList.nCount;
        memset((char*)m_apArray.apList, 0, sizeof(APStatus) * apList.nCount);
        memcpy((char*)m_apArray.apList, (char*)apList.apList, sizeof(APStatus) * apList.nCount);
        ENMUtil::Log(sndLogFile, _T("\t Copy argument OK"));
    }

    m_iSelected = -1;
    ENMUtil::Log(sndLogFile, _T("\t Set button status (true, false, true)"));
    m_btnRefresh->Enable(true);
    m_btnConnect->Enable(false);
    m_btnCancel->Enable(true);
    ENMUtil::Log(sndLogFile, _T("\t Set button status OK"));
    if ( result == WLAN_SUCCESS || result == WLAN_DATA_LOST )
    {
        ENMUtil::Log(sndLogFile, _T("\t Scan success, Begin update UI"));
        UpdateUI(apList);
        ENMUtil::Log(sndLogFile, _T("\t Update UI OK"));
    }
    else if (result == WLAN_NO_INTERFACE)
    {
        wxMessageDialog msg(this, _("Cannot find WLAN adapter!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
    }
    else
    {
        wxMessageDialog msg(this, _("Failed to scan for networks!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
    }
    m_btnCancel->SetFocus();
    ENMUtil::Log(sndLogFile, _T("\t Return ScanNetworkDlg::UI_UpdateAPSatus\n"));
}

void ScanNetworkDlg::UpdateUI(const AccessPointList& apList)
{
    ENMUtil::Log(sndLogFile, wxString::Format(_T("Enter ScanNetworkDlg::UpdateUI(%08X)"), &apList));
//    m_iSelected = -1;
    ENMUtil::Log(sndLogFile, _T("\t Set button status (true, false, true)"));
    m_btnRefresh->Enable(true);
    m_btnConnect->Enable(false);
    m_btnCancel->Enable(true);
    ENMUtil::Log(sndLogFile, _T("\t Set button status OK"));
    ENMUtil::Log(sndLogFile, wxString::Format(_T("\t Update detected ap, count: %d"), apList.nCount));
    for ( int i = 0 ; i < apList.nCount ; i++ )
    {
        APStatus ap = apList.apList[i];
        ENMUtil::Log(sndLogFile, _T("\t Append detected ap: ") + wxString::FromUTF8((char*)ap.ssid.ucSsid, ap.ssid.length));
        int id = m_scanRecorder.AppendAPStatus(ap);
        ENMUtil::Log(sndLogFile, wxString::Format(_T("\t call ScanRecorder::AppendAPStatus(%08X) : %d"), &ap, id));
        wxPoint pos;
        int charsOfLabel = 0;
        ENMUtil::Log(sndLogFile, _T("\t Calculating icon position..."));
        if ( calculator.CalculatePosition(ap, pos, &charsOfLabel) && id != -1 )
        {
            ENMUtil::Log(sndLogFile, wxString::Format(_T("\t call IconPositionCalculator::CalculatePosition(%08X, [%d, %d], [%d])"), &ap, pos.x, pos.y, charsOfLabel));
            wxString _strApName = wxString::FromUTF8((char*)ap.ssid.ucSsid, ap.ssid.length);
//            ENMUtil::Log(sndLogFile, wxString::Format(_T("\t call ScanNetworkDlg::DrawButton([%d, %d], %d, %s, %d)"), pos.x, pos.y, id, _strApName, charsOfLabel));
            DrawButton(pos, id, _strApName, charsOfLabel);
            ENMUtil::Log(sndLogFile, _T("\t Draw button OK"));
        }
        ENMUtil::Log(sndLogFile, wxString::Format(_T("\t call ScanRecorder::ShowAPInfo(%08X, %d)"), &ap, i));
        ShowAPInfo(ap, i);
        ENMUtil::Log(sndLogFile, _T("\t Show ap info in list control OK"));
        if ( i == m_iSelected )
        {
            m_listDetail->SetItemState(i, wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
        }
    }
    ENMUtil::Log(sndLogFile, _T("\t Update detected ap OK"));
//    RefreshIcons(m_iSelected = -1);
    ENMUtil::Log(sndLogFile, wxString::Format(_T("\t call RefreshIcons(%d)"), m_iSelected));
    RefreshIcons(m_iSelected);
    ENMUtil::Log(sndLogFile, _T("\t RefreshIcons OK"));
    ENMUtil::Log(sndLogFile, _T("Return ScanNetworkDlg::UpdateUI\n"));
}

void ScanNetworkDlg::ShowAPInfo(const APStatus& apStatus, long nItem)
{
//    wxString name(apStatus.name);
    wxString name = wxString::FromUTF8((char*)apStatus.ssid.ucSsid, apStatus.ssid.length);
    if ( name.Length() == 0 )
        name = _("<Hidden>");
    m_listDetail->InsertItem(nItem, wxEmptyString, 0);
    int nSubItem = 1;
//    m_listDetail->InsertItem(nItem, name);
    m_listDetail->SetItem(nItem, nSubItem++, name);

    m_listDetail->SetItem(nItem, nSubItem++, wxString::Format(_T("%d%%"), apStatus.signalQuality));

    if ( apStatus.auth == WLAN_SECURITY_NONE )
        m_listDetail->SetItem(nItem, nSubItem++, _("Unencrypted"));
    else
        m_listDetail->SetItem(nItem, nSubItem++, _("Encrypted"));

    APStatus* pCurAp = DataCenter::GetInstance()->GetCurrentAPStatus();
    if ( pCurAp != NULL && CompareMacAddress(pCurAp->macAddress, (unsigned char*)apStatus.macAddress) == 0 )
//    if ( pCurAp != NULL && pCurAp->ssid == apStatus.ssid )
        m_listDetail->SetItem(nItem, nSubItem++, _("Yes"));
    else
        m_listDetail->SetItem(nItem, nSubItem++, _("No"));

    if ( apStatus.type == WLAN_802_11_B )
        m_listDetail->SetItem(nItem, nSubItem++, _T("802.11b"));
    else if ( apStatus.type == WLAN_802_11_G )
        m_listDetail->SetItem(nItem, nSubItem++, _T("802.11g"));
    else if ( apStatus.type == WLAN_802_11_N )
        m_listDetail->SetItem(nItem, nSubItem++, _T("802.11n"));
	else
        m_listDetail->SetItem(nItem, nSubItem++, _("Unknown"));

    m_listDetail->SetItem(nItem, nSubItem++, wxString::Format(_T("%d"), apStatus.channel));
    m_listDetail->SetItem(nItem, nSubItem++, MacAddressToString(apStatus.macAddress));

    if ( pCurAp != NULL && CompareMacAddress((unsigned char*)apStatus.macAddress, pCurAp->macAddress) == 0 )
//    if ( pCurAp != NULL && apStatus.ssid == pCurAp->ssid )
    {
        m_listDetail->SetItemTextColour(nItem, wxColour(255, 0, 0));
    }
}

void ScanNetworkDlg::OnListColumnBeginDrag(wxListEvent& event)
{
    if ( event.GetColumn() == 0 )
    {
        event.Veto();
    }
}

void ScanNetworkDlg::OnListCtrlDetailItemSelect(wxListEvent& event)
{
    m_iSelected = m_listDetail->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
//    wxMessageBox(wxString::Format(_T("selected: %d"), m_iSelected), _T("list item"));
    wxListItem item;
    item.SetId(m_iSelected);
    item.SetColumn(7);
    item.SetMask(wxLIST_MASK_TEXT);
    m_listDetail->GetItem(item);
    wxString itemText = item.GetText();
//    wxString itemText = m_listDetail->GetItemText(m_iSelected);
    APStatus* pCurrentAP = DataCenter::GetInstance()->GetCurrentAPStatus();
    if ( m_isForConnect )
    {
        unsigned char pszMac[6] = { 0 };
        string _s = ENMUtil::WxStringToString(itemText);
        StringToMacAddress(pszMac, _s.c_str(), _s.length());
//        if ( pCurrentAP != NULL && itemText.Cmp(pCurrentAP->name) == 0 )
        if ( pCurrentAP != NULL && CompareMacAddress(pszMac, pCurrentAP->macAddress) == 0 )
        {
            m_btnConnect->SetLabel(_("&Disconnect"));
        }
        else
        {
            m_btnConnect->SetLabel(_("C&onnect"));
        }
    }
    m_btnConnect->Enable(true);
}

void ScanNetworkDlg::OnListCtrlDetailItemDeselect(wxListEvent& event)
{
    m_iSelected = -1;
    if ( m_isForConnect )
    {
        m_btnConnect->SetLabel(_("C&onnect"));
    }
    m_btnConnect->Enable(false);
}

void ScanNetworkDlg::OnListItemActivated(wxListEvent& event)
{
    ProcessDoubleClick();
}

void ScanNetworkDlg::OnListColumnClicked(wxListEvent& event)
{
    if ( event.GetColumn() == 0 )
        return;
    if ( m_sorter.Sort(m_apArray.apList, m_apArray.nCount, event.GetColumn() - 1) )
    {
        ClearDetectedAP();
        m_listDetail->DeleteAllItems();
        UpdateUI(m_apArray);
    }
}

void ScanNetworkDlg::OnF1Press(wxCommandEvent& event)
{
#if defined(__UNIX__)
    if(wxFileExists(wxT("/usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf")))
    {
        wxString cmd = wxT("evince /usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf --page-label=20");
        //wxExecute(cmd);
    }
#endif
#if defined(__WXMSW__)
    ENMUtil::ShowContextHelp(this, _T("ScanWirelessNetwork"));
#endif
}

void ScanNetworkDlg::DeselectAllListItem()
{
    int iItemCount = m_listDetail->GetItemCount();
    for ( int item = 0; item < iItemCount; item++ )
    {
        m_listDetail->SetItemState(item, ~wxLIST_STATE_SELECTED, wxLIST_STATE_SELECTED);
    }
}
