#ifndef _PROFILE_OTHER_SETTINGS_H_
#define _PROFILE_OTHER_SETTINGS_H_

#include <wx/wizard.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include <wx/statline.h>
#include <wx/statbox.h>
#include <wx/panel.h>
#include <wx/statbmp.h>
#include <wx/button.h>
#include <wx/dialog.h>

#include "ProfileEditor.h"
#include "AutoRunSettings.h"
#include "IPSettings.h"
#include "ProxySettings.h"
#include "NetSecrityDlg.h"
#include "CustomStaticText.h"
#include "net.h"

class ProfileOtherSettings : public wxWizardPageSimple
{
public:
    ProfileOtherSettings(wxWizard *wizard);
    CustomStaticText* m_textDes3;
    wxCheckBox* m_checkboxIP;
    wxCheckBox* m_checkboxProxy;
    wxStaticBox* m_staticboxBrowser;
    CustomStaticText* m_textOs;
    wxButton* m_buttonSet2;
    wxCheckBox* m_checkboxNs;
    wxCheckBox* m_checkboxApp;
    wxCheckBox* m_checkboxHp;
    wxTextCtrl* m_textHp;
    wxButton* m_buttonSet3;
    wxStaticBitmap* m_sbPic;
    wxStaticLine* m_lineSt3;
    wxButton* m_buttonSet1;
    wxButton* m_buttonSet4;
    vector<string> m_strAppPath;
    wxString m_strIP;
    wxString m_strSubMask;
    wxString m_strGateWayAddr;
    wxString m_strDNS;

    wxString m_strProxy;
    wxString m_strPort;
    wxString m_strUserName;
    wxString m_strPassword;

    string m_strForbidShareFileAndPrint;
    string m_strForbidShareInternet;
    string m_strStartWindowFirewall;
    NetSecrityDlg m_netSecurityDlg;

    void SetProfileType(ADAPTER_TYPE adapterType);
    OtherSettings_t GetProfileOtherSetting();

protected:
    static const long ID_PROXYCHECKBOX;
    static const long ID_HPCHECKBOX;
    static const long ID_IPCHECKBOX;
    static const long ID_APPCHECKBOX;
    static const long ID_NSCHECKBOX;
    static const long ID_DES3STATICTEXT;
    static const long ID_OSSTATICTEXT;
    static const long ID_PICSTATICBITMAP;
    static const long ID_ST3STATICLINE;
    static const long ID_SET3BUTTON;
    static const long ID_SET4BUTTON;
    static const long ID_SET2BUTTON;
    static const long ID_SET1BUTTON;
    static const long ID_BROWSERSTATICBOX;
    static const long ID_HPTEXTCTRL;
    static const long ID_HELP;

private:
    void Onm_cbNetworkSecrityClick(wxCommandEvent& event);
    void Onm_cbAppClick(wxCommandEvent& event);
    void Onm_cbDefaultClick(wxCommandEvent& event);
    void Onm_cbHomePageClick(wxCommandEvent& event);
    void Onm_cbProxyClick(wxCommandEvent& event);
    void Onm_Set1Click(wxCommandEvent& event);
    void Onm_Set2Click(wxCommandEvent& event);
    void Onm_Set3Click(wxCommandEvent& event);
    void Onm_Set4Click(wxCommandEvent& event);
    void OnF1Press(wxCommandEvent& event);

    void OnInit(wxInitDialogEvent& event);

//    AutoRunSettings autoRunDlg;
    IPSettings ipDlg;
    ProxySettings pxoxyDlg;

    DECLARE_EVENT_TABLE()
};

#endif // _PROFILE_OTHER_SETTINGS_H_
