#include "ProfileOtherSettings.h"
#include <wx/bitmap.h>
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
#include "ENMApp.h"
#include "ENMUtil.h"

const long ProfileOtherSettings::ID_PROXYCHECKBOX = wxNewId();
const long ProfileOtherSettings::ID_HPCHECKBOX = wxNewId();
const long ProfileOtherSettings::ID_IPCHECKBOX = wxNewId();
const long ProfileOtherSettings::ID_APPCHECKBOX = wxNewId();
const long ProfileOtherSettings::ID_NSCHECKBOX = wxNewId();
const long ProfileOtherSettings::ID_DES3STATICTEXT = wxNewId();
const long ProfileOtherSettings::ID_OSSTATICTEXT = wxNewId();
const long ProfileOtherSettings::ID_PICSTATICBITMAP = wxNewId();
const long ProfileOtherSettings::ID_ST3STATICLINE = wxNewId();
const long ProfileOtherSettings::ID_SET3BUTTON = wxNewId();
const long ProfileOtherSettings::ID_SET4BUTTON = wxNewId();
const long ProfileOtherSettings::ID_SET2BUTTON = wxNewId();
const long ProfileOtherSettings::ID_SET1BUTTON = wxNewId();
const long ProfileOtherSettings::ID_BROWSERSTATICBOX = wxNewId();
const long ProfileOtherSettings::ID_HPTEXTCTRL = wxNewId();
const long ProfileOtherSettings::ID_HELP = wxNewId();

BEGIN_EVENT_TABLE(ProfileOtherSettings, wxWizardPageSimple)
    EVT_INIT_DIALOG(ProfileOtherSettings::OnInit)
END_EVENT_TABLE()

ProfileOtherSettings::ProfileOtherSettings(wxWizard* wizard)
        : wxWizardPageSimple(wizard), ipDlg(this)
        , pxoxyDlg(this), m_netSecurityDlg(this)
{

#if defined(__UNIX__)
	m_sbPic = new wxStaticBitmap(this, ID_PICSTATICBITMAP, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/step1.png")).Rescale(wxSize(530,48).GetWidth(),wxSize(530,48).GetHeight())), wxPoint(-20,0), wxSize(530,48), 0, _T("ID_PICSTATICBITMAP"));
#endif
#if defined(__WXMSW__)
	m_sbPic = new wxStaticBitmap(this, ID_PICSTATICBITMAP, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\step1.png")).Rescale(wxSize(530,48).GetWidth(),wxSize(530,48).GetHeight())), wxPoint(-20,0), wxSize(530,48), 0, _T("ID_PICSTATICBITMAP"));
#endif

#if defined(__WXMSW__)
	m_checkboxNs = new wxCheckBox(this, ID_NSCHECKBOX, _("Network Security"), wxPoint(15,50), wxSize(276,32), 0, wxDefaultValidator, _T("ID_NSCHECKBOX"));
	m_checkboxNs->SetValue(false);
	m_buttonSet1 = new wxButton(this, ID_SET1BUTTON, _("Settings"), wxPoint(310,55), wxSize(130,27), 0, wxDefaultValidator, _T("ID_SET1BUTTON"));
	m_checkboxApp = new wxCheckBox(this, ID_APPCHECKBOX, _("Automatically enable applications"), wxPoint(15,90), wxSize(276,32), 0, wxDefaultValidator, _T("ID_APPCHECKBOX"));
	m_checkboxApp->SetValue(false);
	m_buttonSet2 = new wxButton(this, ID_SET2BUTTON, _("Settings"), wxPoint(310,95), wxSize(130,27), 0, wxDefaultValidator, _T("ID_SET2BUTTON"));
	m_checkboxIP = new wxCheckBox(this, ID_IPCHECKBOX, _("Overwrite default TCP/IP and DNS"), wxPoint(15,130), wxSize(276,32), 0, wxDefaultValidator, _T("ID_IPCHECKBOX"));
	m_checkboxIP->SetValue(false);
	m_buttonSet3 = new wxButton(this, ID_SET3BUTTON, _("Settings"), wxPoint(310,135), wxSize(130,27), 0, wxDefaultValidator, _T("ID_SET3BUTTON"));
	m_checkboxHp = new wxCheckBox(this, ID_HPCHECKBOX, _("Overwrite homepage"), wxPoint(15,195), wxSize(276,32), 0, wxDefaultValidator, _T("ID_HPCHECKBOX"));
	m_checkboxHp->SetValue(false);
    m_textHp = new wxTextCtrl(this, ID_HPTEXTCTRL, wxEmptyString, wxPoint(310,200), wxSize(161,24), 0, wxDefaultValidator, _T("ID_HPTEXTCTRL"));
	m_textHp->Disable();
	m_textHp->SetEditable(false);
	m_checkboxProxy = new wxCheckBox(this, ID_PROXYCHECKBOX, _("Overwrite proxy configuration"), wxPoint(15,235), wxSize(276,32), 0, wxDefaultValidator, _T("ID_PROXYCHECKBOX"));
	m_checkboxProxy->SetValue(false);
	m_buttonSet4 = new wxButton(this, ID_SET4BUTTON, _("Settings"), wxPoint(310,240), wxSize(130,27), 0, wxDefaultValidator, _T("ID_SET4BUTTON"));
	m_textDes3 = new CustomStaticText(this, ID_DES3STATICTEXT, _("Configure other settings of the network"), wxPoint(10,30), wxDefaultSize, 0, _T("ID_DES3STATICTEXT"));
	m_textOs = new CustomStaticText(this, ID_OSSTATICTEXT, _("Other Settings"), wxPoint(10,5), wxDefaultSize, 0, _T("ID_OSSTATICTEXT"));
	wxFont m_textOsFont(13, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_textOs->SetFont(m_textOsFont);
#endif

#if defined(__UNIX__)
	m_checkboxNs = new wxCheckBox(this, ID_NSCHECKBOX, _("Network Security"), wxPoint(15,50), wxSize(134,32), 0, wxDefaultValidator, _T("ID_NSCHECKBOX"));
	m_checkboxNs->SetValue(false);
	m_buttonSet1 = new wxButton(this, ID_SET1BUTTON, _("Settings"), wxPoint(280,55), wxSize(145,27), 0, wxDefaultValidator, _T("ID_SET1BUTTON"));
	m_checkboxApp = new wxCheckBox(this, ID_APPCHECKBOX, _("Automatically enable applications"), wxPoint(15,90), wxSize(246,32), 0, wxDefaultValidator, _T("ID_APPCHECKBOX"));
	m_checkboxApp->SetValue(false);
	m_buttonSet2 = new wxButton(this, ID_SET2BUTTON, _("Settings"), wxPoint(280,95), wxSize(145,27), 0, wxDefaultValidator, _T("ID_SET2BUTTON"));
	m_checkboxIP = new wxCheckBox(this, ID_IPCHECKBOX, _("Overwrite default TCP/IP and DNS"), wxPoint(15,130), wxSize(246,32), 0, wxDefaultValidator, _T("ID_IPCHECKBOX"));
	m_checkboxIP->SetValue(false);
	m_buttonSet3 = new wxButton(this, ID_SET3BUTTON, _("Settings"), wxPoint(280,135), wxSize(145,27), 0, wxDefaultValidator, _T("ID_SET3BUTTON"));
	m_checkboxHp = new wxCheckBox(this, ID_HPCHECKBOX, _("Overwrite homepage"), wxPoint(15,190), wxSize(240,32), 0, wxDefaultValidator, _T("ID_HPCHECKBOX"));
	m_checkboxHp->SetValue(false);
    m_textHp = new wxTextCtrl(this, ID_HPTEXTCTRL, wxEmptyString, wxPoint(280,195), wxSize(192,24), 0, wxDefaultValidator, _T("ID_HPTEXTCTRL"));
	m_textHp->Disable();
	m_textHp->SetEditable(false);
	m_checkboxProxy = new wxCheckBox(this, ID_PROXYCHECKBOX, _("Overwrite proxy configuration"), wxPoint(15,230), wxSize(246,32), 0, wxDefaultValidator, _T("ID_PROXYCHECKBOX"));
	m_checkboxProxy->SetValue(false);
	m_buttonSet4 = new wxButton(this, ID_SET4BUTTON, _("Settings"), wxPoint(280,235), wxSize(145,27), 0, wxDefaultValidator, _T("ID_SET4BUTTON"));
	m_textDes3 = new CustomStaticText(this, ID_DES3STATICTEXT, _("Configure other settings of the network"), wxPoint(10,30), wxDefaultSize, 0, _T("ID_DES3STATICTEXT"));
	m_textOs = new CustomStaticText(this, ID_OSSTATICTEXT, _("Other Settings"), wxPoint(10,5), wxDefaultSize, 0, _T("ID_OSSTATICTEXT"));
	wxFont m_textOsFont(13, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_textOs->SetFont(m_textOsFont);
#endif

	m_lineSt3 = new wxStaticLine(this, ID_ST3STATICLINE, wxPoint(0,48), wxSize(510,1), wxLI_HORIZONTAL, _T("ID_ST3STATICLINE"));

	m_buttonSet1->Disable();
	m_buttonSet2->Disable();
	m_buttonSet3->Disable();
	m_buttonSet4->Disable();
	m_staticboxBrowser = new wxStaticBox(this, ID_BROWSERSTATICBOX, _("Customize Internet Explorer or Firefox Browser"), wxPoint(5,176), wxSize(480,100), 0, _T("ID_BROWSERSTATICBOX"));

	Connect(ID_NSCHECKBOX,wxEVT_COMMAND_CHECKBOX_CLICKED,(wxObjectEventFunction)&ProfileOtherSettings::Onm_cbNetworkSecrityClick);
	Connect(ID_APPCHECKBOX,wxEVT_COMMAND_CHECKBOX_CLICKED,(wxObjectEventFunction)&ProfileOtherSettings::Onm_cbAppClick);
	Connect(ID_IPCHECKBOX,wxEVT_COMMAND_CHECKBOX_CLICKED,(wxObjectEventFunction)&ProfileOtherSettings::Onm_cbDefaultClick);
	Connect(ID_HPCHECKBOX,wxEVT_COMMAND_CHECKBOX_CLICKED,(wxObjectEventFunction)&ProfileOtherSettings::Onm_cbHomePageClick);
	Connect(ID_PROXYCHECKBOX,wxEVT_COMMAND_CHECKBOX_CLICKED,(wxObjectEventFunction)&ProfileOtherSettings::Onm_cbProxyClick);
	Connect(ID_SET1BUTTON,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ProfileOtherSettings::Onm_Set1Click);
	Connect(ID_SET2BUTTON,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ProfileOtherSettings::Onm_Set2Click);
	Connect(ID_SET3BUTTON,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ProfileOtherSettings::Onm_Set3Click);
	Connect(ID_SET4BUTTON,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ProfileOtherSettings::Onm_Set4Click);
	Connect(ID_HELP,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ProfileOtherSettings::OnF1Press);

    wxAcceleratorEntry entries[1];
    entries[0].Set( wxACCEL_NORMAL, WXK_F1, ID_HELP );
    wxAcceleratorTable accel(1, entries);
    SetAcceleratorTable(accel);
}

void ProfileOtherSettings::Onm_cbNetworkSecrityClick(wxCommandEvent& event)
{
    if (m_checkboxNs->IsChecked())
    {
        m_buttonSet1->Enable();
    }

    else
    {
        m_buttonSet1->Disable();
    }
}

void ProfileOtherSettings::Onm_cbAppClick(wxCommandEvent& event)
{
    if (m_checkboxApp->IsChecked())
    {
        m_buttonSet2->Enable();
    }

    else
    {
        m_buttonSet2->Disable();
    }
}

void ProfileOtherSettings::Onm_cbDefaultClick(wxCommandEvent& event)
{
    if (m_checkboxIP->IsChecked())
    {
        m_buttonSet3->Enable();
    }

    else
    {
        m_buttonSet3->Disable();
    }
}

void ProfileOtherSettings::Onm_cbProxyClick(wxCommandEvent& event)
{
    if (m_checkboxProxy->IsChecked())
    {
        m_buttonSet4->Enable();
    }

    else
    {
        m_buttonSet4->Disable();
    }
}

void ProfileOtherSettings::Onm_Set1Click(wxCommandEvent& event)
{
    if ( m_netSecurityDlg.ShowModal() == wxID_OK )
    {
        if ( m_netSecurityDlg.m_cbInternet->IsChecked() )
        {
            m_strForbidShareInternet = "1";
        }
        else
        {
            m_strForbidShareInternet = "0";
        }
#if defined(__WXMSW__)
        if ( m_netSecurityDlg.m_cbFile->IsChecked() )
        {
            m_strForbidShareFileAndPrint = "1";
        }
        else
        {
            m_strForbidShareFileAndPrint = "0";
        }

        if ( m_netSecurityDlg.m_cbFirewall->IsChecked() )
        {
            m_strStartWindowFirewall = "1";
        }
        else
        {
            m_strStartWindowFirewall = "0";
        }
#endif
    }
    else
    {
        if (m_strForbidShareInternet.empty() || "0" == m_strForbidShareInternet )
        {
            m_netSecurityDlg.m_cbInternet->SetValue(false);
        }
        else
        {
            m_netSecurityDlg.m_cbInternet->SetValue(true);
        }
#if defined(__WXMSW__)
        if (m_strForbidShareFileAndPrint.empty() || "0" == m_strForbidShareFileAndPrint )
        {
            m_netSecurityDlg.m_cbFile->SetValue(false);
        }
        else
        {
            m_netSecurityDlg.m_cbFile->SetValue(true);
        }
        if (m_strStartWindowFirewall.empty() || "0" == m_strStartWindowFirewall )
        {
            m_netSecurityDlg.m_cbFirewall->SetValue(false);
        }
        else
        {
            m_netSecurityDlg.m_cbFirewall->SetValue(true);
        }
#endif
    }
}

void ProfileOtherSettings::Onm_Set2Click(wxCommandEvent& event)
{
    wxArrayString as;
    for ( vector<string>::size_type i = 0; i < m_strAppPath.size(); i++ )
    {
        wxString strAppName = wxString::FromUTF8(m_strAppPath.at(i).c_str());
        as.Add(strAppName);
    }
    AutoRunSettings autoRunDlg(this);
    autoRunDlg.SetApplications(as);
    if( autoRunDlg.ShowModal() == wxID_OK )
    {
        wxArrayString strApps = autoRunDlg.GetApplications();
        m_strAppPath.clear();
        for( size_t i = 0; i < strApps.GetCount(); i++ )
        {
            wxString strAppName = strApps.Item(i);
            string strName = ENMUtil::WxStringToString(strAppName);
            m_strAppPath.push_back(strName);
        }
    }
//    else
//    {
//        autoRunDlg.m_LtAutoRun->DeleteAllItems();
//        if (!m_strAppPath.empty())
//        {
//            for( vector<string>::size_type i = 0; i < m_strAppPath.size(); i++)
//            {
//                wxString strAppName = wxString::FromUTF8(m_strAppPath[i].c_str());
//                autoRunDlg.m_LtAutoRun->InsertItem(autoRunDlg.m_LtAutoRun->GetItemCount(), strAppName);
//            }
//        }
//    }
}

void ProfileOtherSettings::Onm_Set3Click(wxCommandEvent& event)
{
    ipDlg.m_TcIP->SetValue(m_strIP);
    ipDlg.m_TcSm->SetValue(m_strSubMask);
    ipDlg.m_TcGa->SetValue(m_strGateWayAddr);
    ipDlg.m_TcDns->SetValue(m_strDNS);
    if( ipDlg.ShowModal() == wxID_OK )
    {
        m_strIP = ipDlg.m_TcIP->GetValue();
        m_strSubMask = ipDlg.m_TcSm->GetValue();
        m_strGateWayAddr = ipDlg.m_TcGa->GetValue();
        m_strDNS = ipDlg.m_TcDns->GetValue();
    }
    else
    {
        ipDlg.m_TcIP->SetValue(m_strIP);
        ipDlg.m_TcSm->SetValue(m_strSubMask);
        ipDlg.m_TcGa->SetValue(m_strGateWayAddr);
        ipDlg.m_TcDns->SetValue(m_strDNS);
    }
}

void ProfileOtherSettings::Onm_Set4Click(wxCommandEvent& event)
{
    if(pxoxyDlg.ShowModal() == wxID_OK)
    {
        m_strProxy = pxoxyDlg.m_TcPcoxy->GetValue();
        m_strPort = pxoxyDlg.m_TcPort->GetValue();
    }
    else
    {
        pxoxyDlg.m_TcPcoxy->SetValue(m_strProxy);
        pxoxyDlg.m_TcPort->SetValue(m_strPort);
    }
}

void ProfileOtherSettings::Onm_cbHomePageClick(wxCommandEvent& event)
{
    if (m_checkboxHp->IsChecked())
    {
        m_textHp->Enable();
        m_textHp->SetEditable(true);
    }
    else
    {
        m_textHp->Disable();
        m_textHp->SetEditable(false);
    }
}

void ProfileOtherSettings::OnF1Press(wxCommandEvent& event)
{
#if defined(__UNIX__)
    if(wxFileExists(wxT("/usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf")))
    {
        wxString cmd = wxT("evince /usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf --page-label=29");
        //wxExecute(cmd);
    }
#endif
#if defined(__WXMSW__)
    ENMUtil::ShowContextHelp(this, _T("ProfileOtherSetting"));
#endif
}

void ProfileOtherSettings::SetProfileType(ADAPTER_TYPE adapterType)
{
    bool isWireless = (adapterType == ADAPTER_WIREDLESS);
    m_checkboxNs->Enable(isWireless);
    if ( !m_checkboxNs->IsEnabled() )
    {
        m_checkboxNs->SetValue(false);
    }
    m_buttonSet1->Enable(isWireless && m_checkboxNs->IsChecked());
//    bool success = ENMUtil::GetIPAddress(m_strIP, m_strSubMask, m_strGateWayAddr, m_strDNS, adapterType);
//    m_strDNS = m_strDNS.Mid(0, m_strDNS.Find(_T(",")));
//    m_checkboxIP->SetValue(success);
//    m_buttonSet3->Enable(success);
}

OtherSettings_t ProfileOtherSettings::GetProfileOtherSetting()
{
    OtherSettings_t otherSetting;
    if( m_checkboxNs->IsChecked() )
    {
        otherSetting.NetworkSecurity = "1";
    }
    else
    {
        otherSetting.NetworkSecurity = "0";
    }

    if( m_checkboxApp->IsChecked() )
    {
        otherSetting.AutoRunAppFlag = "1";
    }
    else
    {
        otherSetting.AutoRunAppFlag = "0";
    }

    if( m_checkboxIP->IsChecked() )
    {
        otherSetting.IPDNSFlag = "1";
    }
    else
    {
        otherSetting.IPDNSFlag = "0";
    }

    if( m_checkboxHp->IsChecked() )
    {
        otherSetting.IsHomepage = "1";
    }
    else
    {
        otherSetting.IsHomepage = "0";
    }

    if( m_checkboxProxy->IsChecked() )
    {
        otherSetting.ProxyFlag = "1";
    }
    else
    {
        otherSetting.ProxyFlag = "0";
    }

    otherSetting.stNetSecurity.sForbidShareFileAndPrint = m_strForbidShareFileAndPrint;
    otherSetting.stNetSecurity.sForbidShareInternet = m_strForbidShareInternet;
    otherSetting.stNetSecurity.sStartWindowFirewall = m_strStartWindowFirewall;

    wxString currentHomePage = m_textHp->GetValue();
    currentHomePage = currentHomePage.Trim(true).Trim(false);
    otherSetting.Homepage = ENMUtil::WxStringToString(currentHomePage);

    otherSetting.stIPDNSSet.IPvalue = ENMUtil::WxStringToString(m_strIP);
    otherSetting.stIPDNSSet.SubnetAddress = ENMUtil::WxStringToString(m_strSubMask);
    otherSetting.stIPDNSSet.NetGateway = ENMUtil::WxStringToString(m_strGateWayAddr);
    otherSetting.stIPDNSSet.DNSvalue = ENMUtil::WxStringToString(m_strDNS);

    otherSetting.stProxySet.Proxy = ENMUtil::WxStringToString(m_strProxy);
    otherSetting.stProxySet.Port = ENMUtil::WxStringToString(m_strPort);

    otherSetting.AutoRunApp = m_strAppPath;

    return otherSetting;
}

void ProfileOtherSettings::OnInit(wxInitDialogEvent& event)
{

}
