/***************************************************************
 * Name:      profileMain.h
 * Purpose:   Defines Application Frame
 * Author:     ()
 * Created:   2008-07-07
 * Copyright:  ()
 * License:
 **************************************************************/

#ifndef _PROFILE_MANAGER_DIALOG_H_
#define _PROFILE_MANAGER_DIALOG_H_

#include <wx/listctrl.h>
#include <wx/menu.h>
#include <wx/panel.h>
#include <wx/bmpbuttn.h>
#include <wx/button.h>
#include <wx/frame.h>
#include <wx/dynarray.h>
#include <wx/wizard.h>

#include "ProfileGeneralSettings.h"
#include "ProfileEditor.h"
#include "ProfileManagementControl.h"
#include "ProfileEditor.h"
#include "checkedlistctrl.h"
#include "ProfileEvent.h"

class ProfileManagerDlg : public wxFrame
{
    public:
        ProfileManagerDlg(wxWindow* parent,wxWindowID id = -1);
        virtual ~ProfileManagerDlg();
        void SaveProfile();
        virtual bool Destroy();

        bool Show(bool ifShow = true);
        bool IsProfileExist(const wxString& strNewName, const wxString& strOldName = wxEmptyString) const;
        void InsertNewProfile(const ProfileList_t& profile);
        void RefreshProfile();

    private:
        bool m_bIfAdmin;
        void drawListCtrl(long ID);
        void CheckButtonStatus(long ID);
        wxCheckedListCtrl* m_lcProfile;

        void Onm_bbUpClick(wxCommandEvent& event);
        void Onm_bbDownClick(wxCommandEvent& event);
        void Onm_buttonNewClick(wxCommandEvent& event);
        void Onm_buttonEditClick(wxCommandEvent& event);
        void Onm_buttonDeleteClick(wxCommandEvent& event);
        void Onm_buttonCancelClick(wxCommandEvent& event);
        void Onm_buttonOKClick(wxCommandEvent& event);
        void Onm_checkboxSelectClick(wxCommandEvent& event);
        void Onm_lcProfileDeselected(wxCommandEvent& event);
        //*)
        void Onm_lcProfileSelected(wxCommandEvent& event);
        void Onm_miNewSelected(wxCommandEvent& event);
        void Onm_miEditSelected(wxCommandEvent& event);
        void Onm_miDeleteSelected(wxCommandEvent& event);
        void Onm_miImportSelected(wxCommandEvent& event);
        void Onm_miExportSelected(wxCommandEvent& event);
        void Onm_miExitSelected(wxCommandEvent& event);
        void OnCloseClicked(wxCloseEvent& event);
        void OnProfileChanged(ProfileEvent& event);
        bool ChangePriority(int firstPriority, int secondPriority);
        bool RemoveProfile(int priority);
        void ModifyCheckFlag(int pos,bool bCheck);
        int Confirm();
        int ConfirmOverwrite();
        bool Save();
        void OnDoubleClick(wxListEvent& event);
        void MenuHelpContent(wxCommandEvent& event);
        void CheckModifyStatus();
        void ModifyAdminCount();
        int IsGuestExist();

        static const long ID_PROFILELISTCTRL;
        static const long ID_NEWBUTTON;
        static const long ID_EDITBUTTON;
        static const long ID_DELETEBUTTON;
        static const long ID_OKBUTTON;
        static const long ID_CANCLEBUTTON;
        static const long ID_UPBITMAPBUTTON;
        static const long ID_DOWNBITMAPBUTTON;
        static const long ID_PROFILEPANEL;
        static const long ID_IMPORT;
        static const long ID_EXPORT;
        static const long ID_EXIT;
        static const long ID_NEWPROFILE;
        static const long ID_EDITPROFILE;
        static const long ID_DELETEPROFILE;
        static const long ID_HELP;
        static const long ID_CLOSE;
        static const long ID_SELECTCHECKBOX;

        wxMenuBar* m_menuProfile;
        wxMenu* m_menuFile;
        wxMenuItem* m_miExport;
        wxMenuItem* m_miImport;
        wxMenuItem* m_miNew;
        wxMenuItem* m_miEdit;
        wxMenuItem* m_miDelete;
        wxMenuItem* m_miExit;
        wxMenu* m_menuHelp;
        wxMenuItem* m_miHelp;

        wxButton* m_buttonEdit;
        wxPanel* m_panelProfile;
        wxBitmapButton* m_bbDown;
        wxButton* m_buttonDelete;
        wxButton* m_buttonOK;
        wxButton* m_buttonCancel;
        wxCheckBox* m_checkboxSelect;

        wxButton* m_buttonNew;
        wxBitmapButton* m_bbUp;

        vector<ProfileList_t> m_vProfileList;
        vector<ProfileList_t> m_vOldProfileList;

        bool m_isModified;
        int m_iAdminCount;
        bool m_isDeselected;
        wxCriticalSection m_critsectDrawlist;
        DECLARE_EVENT_TABLE()
};

#endif // _PROFILE_MANAGER_DIALOG_H_
