#include "Profile.h"

bool operator == (const NetworkSecuritySet_t& s1, const NetworkSecuritySet_t& s2)
{
    bool result = true;
    result &= s1.sForbidShareFileAndPrint == s2.sForbidShareFileAndPrint;
    result &= s1.sForbidShareInternet == s2.sForbidShareInternet;
    result &= s1.sStartWindowFirewall == s2.sStartWindowFirewall;
    return result;
}

bool operator == (const IPDNSSet_t& s1, const IPDNSSet_t& s2)
{
    bool result = true;
    result &= s1.IPvalue == s2.IPvalue;
    result &= s1.SubnetAddress == s2.SubnetAddress;
    result &= s1.NetGateway == s2.NetGateway;
    result &= s1.DNSvalue == s2.DNSvalue;
    return result;
}

bool operator == (const ProxySet_t& s1, const ProxySet_t& s2)
{
    bool result = true;
    result &= s1.Proxy == s2.Proxy;
    result &= s1.Port == s2.Port;
    return result;
}

bool operator == (const WEPSecurity_t& s1, const WEPSecurity_t& s2)
{
    bool result = true;
    result &= s1.value == s2.value;
    result &= s1.keyIndex == s2.keyIndex;
    return result;
}

bool operator == (const WPASecurity_t& s1, const WPASecurity_t& s2)
{
    bool result = true;
    result &= s1.value == s2.value;
    return result;
}

bool operator == (const GenernalSettings_t& s1, const GenernalSettings_t& s2)
{
    bool result = true;
    result &= s1.ConnecType == s2.ConnecType;
    return result;
}

bool operator == (const WirelessSettings_t& s1, const WirelessSettings_t& s2)
{
    bool result = true;
    result &= s1.SSID == s2.SSID;
    result &= s1.WirlessType == s2.WirlessType;
    result &= s1.WlanSecurity == s2.WlanSecurity;
    result &= s1.stWPASecurity == s2.stWPASecurity;
    result &= s1.stWEPSecurity == s2.stWEPSecurity;
    return result;
}

bool operator == (const OtherSettings_t& s1, const OtherSettings_t& s2)
{
    bool result = true;
    result &= s1.NetworkSecurity == s2.NetworkSecurity;
    result &= s1.AutoRunAppFlag == s2.AutoRunAppFlag;
    result &= s1.AutoRunApp == s2.AutoRunApp;
    result &= s1.IPDNSFlag == s2.IPDNSFlag;
    result &= s1.IsHomepage == s2.IsHomepage;
    result &= s1.Homepage == s2.Homepage;
    result &= s1.ProxyFlag == s2.ProxyFlag;
    result &= s1.stNetSecurity == s2.stNetSecurity;
    result &= s1.stIPDNSSet == s2.stIPDNSSet;
    result &= s1.stProxySet == s2.stProxySet;
    return result;
}

bool operator == (const ProfileList_t& pf1, const ProfileList_t& pf2)
{
    bool result = true;
    result &= pf1.sProfileName == pf2.sProfileName;
    result &= pf1.sPermission == pf2.sPermission;
    result &= pf1.sPriority == pf2.sPriority;
    result &= pf1.sProfileIcon == pf2.sProfileIcon;
    result &= pf1.sShow == pf2.sShow;
    result &= pf1.stGenernalSet == pf2.stGenernalSet;
    result &= pf1.stWirelessSet == pf2.stWirelessSet;
    result &= pf1.stOtherSet == pf2.stOtherSet;
    return result;
}

bool operator != (const ProfileList_t& pf1, const ProfileList_t& pf2)
{
    return !(pf1 == pf2);
}
