
#include "PolicyManager.h"
#include "xmlparser/tinyxml.h"

#if defined(__WXMSW__)
const wxString PolicyManager::strPolicyFile(_T("C:\\Documents and Settings\\Default User\\Application Data\\Network Neighborhood\\NetworkPolicy.xml"));
#endif
#if defined(__UNIX__)
const wxString PolicyManager::strPolicyFile(_T("/etc/Network Neighborhood/NetworkPolicy.xml"));
#endif

BEGIN_EVENT_TABLE(PolicyManager, wxEvtHandler)
END_EVENT_TABLE()

PolicyManager::PolicyManager()
{
    m_bIsAllowOwnerProfile = true;
    m_bIsAllowTurnOnWireless = true;
    m_bIsMeshEnable = true;
    m_bIsScanEnable = true;
}

PolicyManager::~PolicyManager()
{
}

bool PolicyManager::IsMeshEnable() const
{
    return m_bIsMeshEnable;
}

bool PolicyManager::IsScanEnable() const
{
    return m_bIsScanEnable;
}

bool PolicyManager::IsAllowOwnerProfile() const
{
    return m_bIsAllowOwnerProfile;
}

bool PolicyManager::IsAllowTurnOnWireless() const
{
    return m_bIsAllowTurnOnWireless;
}

bool PolicyManager::ReloadPolicy()
{
    bool enableMesh = false;
    bool enableScan = false;
    bool allowProfile = false;
    bool allowWireless = false;

    if ( !wxFileExists(strPolicyFile) )
        return false;

    //load xml file
    TiXmlDocument myDocument(wxConvFileName->cWC2MB(wxConvLocal.cWX2WC(strPolicyFile.c_str())));
    if ( !myDocument.LoadFile() )
        return false;

    //get root element
    TiXmlElement* RootElement = myDocument.RootElement();
    if ( RootElement == NULL )
        return false;

    // read EnableMesh element
    TiXmlElement* EnableMeshElement = RootElement->FirstChildElement();
    if ( EnableMeshElement == NULL )
        return false;

    int iEnableMesh = atoi(EnableMeshElement->Attribute("value"));
    enableMesh = (iEnableMesh == 1);

    // read EnableScan element
    TiXmlElement* EnableScanElement = EnableMeshElement->NextSiblingElement();
    if ( EnableScanElement == NULL )
        return false;

    int iEnableScan = atoi(EnableScanElement->Attribute("value"));
    enableScan = (iEnableScan == 1);

    // read AllowProfile element
    TiXmlElement* AllowProfileElement = EnableScanElement->NextSiblingElement();
    if ( AllowProfileElement == NULL )
        return false;

    int iAllowProfile = atoi(AllowProfileElement->Attribute("value"));
    allowProfile = (iAllowProfile == 1);

    // read AllowWireless element
    TiXmlElement* AllowWirelessElement = AllowProfileElement->NextSiblingElement();
    if ( AllowWirelessElement == NULL )
        return false;

    int iAllowWireless = atoi(AllowWirelessElement->Attribute("value"));
    allowWireless = (iAllowWireless == 1);

    // update current policy
    m_bIsMeshEnable = enableMesh;
    m_bIsScanEnable = enableScan;
    m_bIsAllowOwnerProfile = allowProfile;
    m_bIsAllowTurnOnWireless = allowWireless;

    return true;
}
