/****************************************************************************

Copyright (c) Intel Corporation (2007).

DISCLAIMER OF WARRANTY
NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR
CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY
OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS
EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR
FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT
THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL
BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON
ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.
SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL
NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,
TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY
UPDATES, ENHANCEMENTS OR EXTENSIONS.

File Name:   	ClientPCInfoManager.h

Description:
    interface of the ClientPCInfoManager class


Environment (opt):
    OS: WindowsXP SP2
	SE: CodeBlock 8.02 + wxWidgets 2.8.7

Notes (opt):


  =====================================================================
  Revision   Revision History               Author     Date
  =====================================================================
  0.1        Create                         Guo xixiu     2008-09-01
  =====================================================================

****************************************************************************/
#ifndef MESHINFOMANAGER_H
#define MESHINFOMANAGER_H

#include "MeshServerEntity.h"
#include "InternetStateEntity.h"
#include "MeshUseOthersInternetDlg.h"

#include <vector>
#include <algorithm>
using namespace std;
typedef vector<InternetStateEntity> InternetStateList;
typedef vector<InternetStateEntity>::iterator  InternetStateListIter;
typedef vector<MeshServerEntity> MeshServerInfoList;
typedef vector<MeshServerEntity>::iterator  MeshServerListIter;

class MeshInfoManager
{
    public:
        // Return instance
        static MeshInfoManager* GetInstance();
		//
        virtual ~MeshInfoManager();
		//
        void Attach(MeshUseOthersInternetDlg* pMeshUseOthersInternetDlg);
		//
        void Detach();
		//
        void ModifyMeshServer(const MeshServerEntity&meshserverentity);
		//
        void RemoveMeshServer(const wxString& strServiceName);
		//
		bool GetMeshServerInfo(MeshServerEntity&meshserverentity);

		bool SetMeshServerInfo(MeshServerEntity&meshserverentity);

		void ChangeMeshMode(bool bIsMeshOn);

		bool GetMeshMode();

		void ChangeMeshServerMode(bool bIsMeshServer);

		const MeshServerInfoList& GetMeshServerInfoList();

		void GetInternetStateList(InternetStateList& internetStateList);

     private:
		 //
        MeshInfoManager();
		//
        void AddMeshServer(const MeshServerEntity&meshserverentity);
        //
        MeshServerListIter SearchMeshServerList(const MeshServerEntity& meshserverentity);
		//
        void Notify();
		//
//        MeshServerIter SearchMeshServer(const MeshServerEntity&meshserverentity);
		static MeshInfoManager* m_pMeshInfoManager;
        MeshServerInfoList    m_MeshServerInfoList;
        MeshServerEntity m_meshserverentity;
        MeshUseOthersInternetDlg* m_pMeshUseOthersInternetDlg;
        bool m_bIsMeshOn;
        bool m_bIsMeshServer;
        wxCriticalSection m_critsectMesh;
};

#endif // CLIENTPCINFOMANAGER_H
