/****************************************************************************

Copyright (c) Intel Corporation (2007).

DISCLAIMER OF WARRANTY
NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR
CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY
OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS
EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR
FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT
THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL
BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON
ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.
SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL
NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,
TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY
UPDATES, ENHANCEMENTS OR EXTENSIONS.

File Name:   	ClientPCInfoManager.cpp

Description:
	implementation file of the ClientPCInfoManager class


Environment (opt):
	OS: WindowsXP SP2
	SE: CodeBlock 8.02 + wxWidgets 2.8.7

Notes (opt):


  =====================================================================
  Revision   Revision History               Author     Date
  =====================================================================
  0.1        Create                         Guo xixiu     2008-09-01
  =====================================================================

****************************************************************************/
#include "MeshInfoManager.h"
#include "ENMUtil.h"
#include "DataCenterLinux.h"
#include <string.h>
#include <net/if.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

MeshInfoManager* MeshInfoManager::m_pMeshInfoManager = NULL;


/*=================================================================
 Function Name  : ClientPCInfoManager::GetInstance
 Description    : Return instance
 Date           : 2008-9-16 17:22:47
 Return Code    : ClientPCInfoManager*
 Author         : Guo xixiu
 =================================================================*/
MeshInfoManager* MeshInfoManager::GetInstance()
{
    if( NULL == m_pMeshInfoManager)
       m_pMeshInfoManager  = new MeshInfoManager();

    return m_pMeshInfoManager;
}

/*=================================================================
 Function Name  : ClientPCInfoManager::ClientPCInfoManager
 Description    :
 Date           : 2008-9-16 17:22:47
 Return Code    :
 Author         : Guo xixiu
 =================================================================*/
MeshInfoManager::MeshInfoManager()
{
    //ctor
    m_pMeshUseOthersInternetDlg = NULL;
    m_bIsMeshOn = false;
    m_bIsMeshServer = false;
}


/*=================================================================
 Function Name  : ClientPCInfoManager::~ClientPCInfoManager
 Description    :
 Date           : 2008-9-16 17:22:50
 Return Code    :
 Author         : Guo xixiu
 =================================================================*/
MeshInfoManager::~MeshInfoManager()
{
    //dtor
}


/*=================================================================
 Function Name  : ClientPCInfoManager::AddClientPC
 Description    :
 Date           : 2008-9-16 17:22:53
 Parameter      : const ClientPCInfo& newClientPCInfo
 Return Code    : void
 Author         : Guo xixiu
 =================================================================*/
void MeshInfoManager::AddMeshServer(const MeshServerEntity& meshserverentity)
{
    printf("AddMeshServer\n");
    m_MeshServerInfoList.push_back(meshserverentity);
}


/*=================================================================
 Function Name  : ClientPCInfoManager::Attach
 Description    :
 Date           : 2008-9-16 17:22:57
 Parameter      : DeploySettingDlg* deploysettingdlg
 Return Code    : void
 Author         : Guo xixiu
 =================================================================*/
void MeshInfoManager::Attach(MeshUseOthersInternetDlg* pMeshUseOthersInternetDlg)
{
    m_pMeshUseOthersInternetDlg = pMeshUseOthersInternetDlg;
}


/*=================================================================
 Function Name  : ClientPCInfoManager::Detach
 Description    :
 Date           : 2008-9-16 17:23:03
 Return Code    : void
 Author         : Guo xixiu
 =================================================================*/
void MeshInfoManager::Detach()
{
    m_pMeshUseOthersInternetDlg = NULL;
}


void MeshInfoManager::ModifyMeshServer(const MeshServerEntity&meshserverentity)
{
    m_critsectMesh.Enter();
    MeshServerListIter iterFind = SearchMeshServerList(meshserverentity);
    if( iterFind == m_MeshServerInfoList.end() )
    {
        AddMeshServer(meshserverentity);
        m_critsectMesh.Leave();
        Notify();
    }
    else
    {
        bool bChange = false;

        int iChannel = meshserverentity.GetChannel();
        int iOldChannel = iterFind->GetChannel();
        if ( iChannel != iOldChannel )
        {
            iterFind->SetChannel(iChannel);
            bChange = true;
        }

        int iSignalStrength = meshserverentity.GetSignalStrength();
        int iOldSignalStrength = iterFind->GetSignalStrength();
        if ( iSignalStrength != iOldSignalStrength )
        {
            iterFind->SetSignalStrength(iSignalStrength);
            bChange = true;
        }

        bool bStatus = meshserverentity.GetStatus();
        bool bOldStatus = meshserverentity.GetStatus();
        if ( bStatus != bOldStatus )
        {
            iterFind->SetStatus(bStatus);
            bChange = true;
        }
        m_critsectMesh.Leave();

        if (bChange)
        {
            Notify();
        }
    }
}

void MeshInfoManager::RemoveMeshServer(const wxString& strServiceName)
{
    m_critsectMesh.Enter();
    wxString findServiceName = strServiceName;
    wxString ServiceName;
    MeshServerListIter iter = m_MeshServerInfoList.begin();
    while ( iter!= m_MeshServerInfoList.end())
    {
        ServiceName = iter->GetServiceName();
        if(0 == ServiceName.Cmp(findServiceName))
        {
            break;
        }
        iter++;
    }

    if(iter != m_MeshServerInfoList.end())
    {
        m_MeshServerInfoList.erase(iter);
    }
    m_critsectMesh.Leave();
    Notify();
}


void MeshInfoManager::Notify()
{
    printf("Notify\n");
    if (m_pMeshUseOthersInternetDlg!=NULL)
    {
        printf("m_pMeshUseOthersInternetDlg!=NULL\n");
        m_pMeshUseOthersInternetDlg->RefreshList();
    }
    else{printf("m_pMeshUseOthersInternetDlg==NULL\n");}
}

//MeshServerIter MeshInfoManager::SearchMeshServer(const MeshServerEntity&meshserverentity);
//{
//}
bool MeshInfoManager::GetMeshServerInfo(MeshServerEntity&meshserverentity)
{
    if (m_bIsMeshServer)
    {
        printf("m_bIsMeshServer = true\n");
        meshserverentity.SetIPAddress(m_meshserverentity.GetMeshIPAddress());
        meshserverentity.SetHostName(m_meshserverentity.GetHostName());
        meshserverentity.SetDNS(m_meshserverentity.GetDNS());
        meshserverentity.SetDNS_back(m_meshserverentity.GetDNS_back());
        meshserverentity.SetChannel(m_meshserverentity.GetChannel());
    }
    else
    {
        printf("m_bIsMeshServer = false\n");
    }

    return m_bIsMeshServer;
}

bool MeshInfoManager::SetMeshServerInfo(MeshServerEntity&meshserverentity)
{
    m_meshserverentity.SetIPAddress(meshserverentity.GetMeshIPAddress());
    m_meshserverentity.SetHostName(meshserverentity.GetHostName());
    m_meshserverentity.SetDNS(meshserverentity.GetDNS());
    m_meshserverentity.SetDNS_back(meshserverentity.GetDNS_back());
    m_meshserverentity.SetChannel(meshserverentity.GetChannel());

    return true;
}

void MeshInfoManager::ChangeMeshMode(bool bIsMeshOn)
{
    m_bIsMeshOn = bIsMeshOn;
}

bool MeshInfoManager::GetMeshMode()
{
    return m_bIsMeshOn;
}

void MeshInfoManager::ChangeMeshServerMode(bool bIsMeshServer)
{
    m_bIsMeshServer = bIsMeshServer;
}

MeshServerListIter MeshInfoManager::SearchMeshServerList(const MeshServerEntity& meshserverentity)
{
    wxString findHostName = meshserverentity.GetHostName();
    wxString HostName;
    MeshServerListIter iter = m_MeshServerInfoList.begin();
    while ( iter!= m_MeshServerInfoList.end())
    {
        HostName = iter->GetHostName();
        if(0 == HostName.Cmp(findHostName))
        {
            break;
        }
        iter++;
    }
    return iter;
}

const MeshServerInfoList& MeshInfoManager::GetMeshServerInfoList()
{
    //m_critsectMesh.Enter();
    return m_MeshServerInfoList;
    //m_critsectMesh.Leave();
}

void MeshInfoManager::GetInternetStateList(InternetStateList& internetStateList)
{
    struct if_nameindex *ifnames, *ifnm;
    struct ifreq ifr;

    ifnames = if_nameindex();
    char ip[33] = {'\0'};
    int socket_id;
    int ret = 0;
    InternetStateEntity internetStateEntity;


    for (ifnm = ifnames; ifnm && ifnm->if_name && ifnm->if_name[0]; ifnm++)
    {

        if(strstr(ifnm->if_name, "eth") || strstr(ifnm->if_name, "ra"))
        {
            memset(ip, 0, 32);
            internetStateEntity.SetInterface(ENMUtil::StringToWxString(ifnm->if_name));
            DataCenterLinux::GetMeshIp(ifnm->if_name, ip);
            internetStateEntity.SetIPAddress(ENMUtil::StringToWxString(ip));
            socket_id = socket(AF_INET, SOCK_DGRAM, 0);
            if(socket_id < 0)
            {
                internetStateEntity.SetState(_("Disabled"));
            }
            else
            {
                strncpy (ifr.ifr_name, ifnm->if_name, IFNAMSIZ);
                ret=ioctl(socket_id, SIOCGIFFLAGS, (caddr_t)&ifr);
                if(ret == -1)
                {
                    close(socket_id);
                    internetStateEntity.SetState(_("Disabled"));
                    continue;
                }
                if ((ifr.ifr_flags)&IFF_UP)
                {
                    internetStateEntity.SetState(_("Enabled"));
                }
                else
                {
                    internetStateEntity.SetState(_("Disabled"));
                }
            }

            internetStateList.push_back(internetStateEntity);
        }

    }

}
