/****************************************************************************

Copyright (c) Intel Corporation (2007).

DISCLAIMER OF WARRANTY
NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR
CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY
OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS
EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR
FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT
THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL
BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON
ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.
SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL
NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,
TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY
UPDATES, ENHANCEMENTS OR EXTENSIONS.

File Name:   	MeshInfo.h

Description:
    interface of the ClientPCInfo class


Environment (opt):
    OS: WindowsXP SP2
	SE: CodeBlock 8.02 + wxWidgets 2.8.7

Notes (opt):


  =====================================================================
  Revision   Revision History               Author     Date
  =====================================================================
  0.1        Create                         Liu Jinjia     2008-09-01
  =====================================================================

****************************************************************************/
#ifndef MESHINFO_H
#define MESHINFO_H

#include <wx/string.h>

class MeshInfo
{
    public:
        // Constructor
        MeshInfo();

        // Constructor
        MeshInfo( wxString strMeshHostName,
                  wxString strMeshIP,
                  wxString strMainDNS,
                  wxString strSecondaryDNS);

        // Destructor
        virtual ~MeshInfo();

        // Return connect status
        wxString GetMeshHostName()const;

        // Return deploy status
        wxString GetMeshIP()const;

        // Return select status
        wxString GetMainDNS()const;

        // Return IP address
        wxString GetSecondaryDNS()const;

        // Set IP address
        void SetMeshHostName(const wxString& strMeshHostName);

        // Set MAC address
        void SetMeshIP(const wxString& strMeshIP);

        // Set profile version
        void SetMainDNS(const wxString& strMainDNS);

        // Set student name
        void SetSecondaryDNS(const wxString& strSecondaryDNS);


    protected:
    private:
        wxString m_strMeshHostName;
        wxString m_strMeshIP;
        wxString m_strMainDNS;
        wxString m_strSecondaryDNS;
};

#endif // CLIENTPCINFO_H
