/****************************************************************************

Copyright (c) Intel Corporation (2007).

DISCLAIMER OF WARRANTY
NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR
CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY
OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS
EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR
FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT
THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL
BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON
ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.
SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL
NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,
TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY
UPDATES, ENHANCEMENTS OR EXTENSIONS.

File Name:   	MeshInfo.cpp

Description:
	implementation file of the ClientPCInfo class


Environment (opt):
	OS: WindowsXP SP2
	SE: CodeBlock 8.02 + wxWidgets 2.8.7

Notes (opt):


  =====================================================================
  Revision   Revision History               Author     Date
  =====================================================================
  0.1        Create                         Liu Jinjia     2008-12-28
  =====================================================================

****************************************************************************/

#include "MeshInfo.h"


/*=================================================================
 Function Name  : MeshInfo::MeshInfo
 Description    : Constructor
 Date           : 2008-9-16 16:21:55
 Return Code    : none
 Author         : Guo xixiu
 =================================================================*/
MeshInfo::MeshInfo()
{
}


/*=================================================================
 Function Name  : MeshInfo::MeshInfo
 Description    : Constructor
 Date           : 2008-9-16 16:21:59
 Parameter      :  bool bCanConnect
 Parameter      : bool bHaveDeployed
 Parameter      : bool bSelected
 Parameter      : wxString strIPAddress
 Parameter      : wxString strMacAddress
 Parameter      : wxString strProfileVersion
 Parameter      : wxString strStudentName
 Return Code    : None
 Author         : Guo xixiu
 =================================================================*/
MeshInfo::MeshInfo( wxString strMeshHostName,
                    wxString strMeshIP,
                    wxString strMainDNS,
                    wxString strSecondaryDNS)

{
    m_strMeshHostName = strMeshHostName;
    m_strMeshIP = strMeshIP;
    m_strMainDNS = strMainDNS;
    m_strSecondaryDNS = strSecondaryDNS;
}


/*=================================================================
 Function Name  : ClientPCInfo::~ClientPCInfo
 Description    : Destructor
 Date           : 2008-9-16 16:22:04
 Return Code    : None
 Author         : Guo xixiu
 =================================================================*/
MeshInfo::~MeshInfo()
{
    //dtor
}


/*=================================================================
 Function Name  : ClientPCInfo::GetIPAddress
 Description    : Return IP address
 Date           : 2008-9-16 16:22:22
 Return Code    : wxString
 Author         : Guo xixiu
 =================================================================*/
wxString MeshInfo::GetMeshHostName()const
{
    return m_strMeshHostName;
}


/*=================================================================
 Function Name  : ClientPCInfo::GetMacAddress
 Description    : Return MAC address
 Date           : 2008-9-16 16:22:25
 Return Code    : wxString
 Author         : Guo xixiu
 =================================================================*/
wxString MeshInfo::GetMeshIP()const
{
    return m_strMeshIP;
}


/*=================================================================
 Function Name  : ClientPCInfo::GetProfileVersion
 Description    : Return profile version
 Date           : 2008-9-16 16:22:28
 Return Code    : wxString
 Author         : Guo xixiu
 =================================================================*/
wxString MeshInfo::GetMainDNS()const
{
    return m_strMainDNS;
}


/*=================================================================
 Function Name  : ClientPCInfo::GetStudentName
 Description    : Return student name
 Date           : 2008-9-16 16:22:31
 Return Code    : wxString
 Author         : Guo xixiu
 =================================================================*/
wxString MeshInfo::GetSecondaryDNS()const
{
    return m_strSecondaryDNS;
}



/*=================================================================
 Function Name  : ClientPCInfo::SetIPAddress
 Description    : Set IP address
 Date           : 2008-9-16 16:24:05
 Parameter      : const wxString &strIPAddress
 Return Code    : void
 Author         : Guo xixiu
 =================================================================*/
void MeshInfo::SetMeshHostName(const wxString &strMeshHostName)
{
    m_strMeshHostName = strMeshHostName;
}


/*=================================================================
 Function Name  : ClientPCInfo::SetMacAddress
 Description    : Set MAC address
 Date           : 2008-9-16 16:24:19
 Parameter      : const wxString &strMacAddress
 Return Code    : void
 Author         : Guo xixiu
 =================================================================*/
void MeshInfo::SetMeshIP(const wxString &strMeshIP)
{
    m_strMeshIP = strMeshIP;
}


/*=================================================================
 Function Name  : ClientPCInfo::SetProfileVersion
 Description    : Set profile version
 Date           : 2008-9-16 16:24:22
 Parameter      : const wxString &strProfileVersion
 Return Code    : void
 Author         : Guo xixiu
 =================================================================*/
void MeshInfo::SetMainDNS(const wxString &strMainDNS)
{
    m_strMainDNS = strMainDNS;
}


/*=================================================================
 Function Name  : ClientPCInfo::SetStudentName
 Description    : Set student name
 Date           : 2008-9-16 16:24:26
 Parameter      : const wxString &strStudentName
 Return Code    : void
 Author         : Guo xixiu
 =================================================================*/
void MeshInfo::SetSecondaryDNS(const wxString &strSecondaryDNS)
{
    m_strSecondaryDNS = strSecondaryDNS;
}


