#include "IPSettings.h"

#include <wx/intl.h>
#include <wx/string.h>
#include <wx/msgdlg.h>
#include "ENMApp.h"
#include "ENMUtil.h"

#include "ipv4.h"

const long IPSettings::ID_TCIP = wxNewId();
const long IPSettings::ID_TCSM = wxNewId();
const long IPSettings::ID_TCGA = wxNewId();
const long IPSettings::ID_BUTTONCANCEL = wxNewId();
const long IPSettings::ID_BUTTONOK = wxNewId();
const long IPSettings::ID_TCDNS = wxNewId();
const long IPSettings::ID_STIP = wxNewId();
const long IPSettings::ID_STSM = wxNewId();
const long IPSettings::ID_STGA = wxNewId();
const long IPSettings::ID_STDNS = wxNewId();
const long IPSettings::ID_PANEL1 = wxNewId();
const long IPSettings::ID_HELP = wxNewId();

BEGIN_EVENT_TABLE(IPSettings,wxDialog)
	EVT_BUTTON(ID_BUTTONCANCEL, IPSettings::Onm_BtnCancelClick)
	EVT_BUTTON(ID_BUTTONOK, IPSettings::Onm_BtnOKClick)
	EVT_INIT_DIALOG(IPSettings::OnInit)
END_EVENT_TABLE()

IPSettings::IPSettings(wxWindow* parent)
{
	Create(parent, wxID_ANY, _("IP Settings"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxSize(368, 248));
	Move(wxDefaultPosition);

	Panel1 = new wxPanel(this, ID_PANEL1, wxPoint(0,0), wxSize(369,249), wxTAB_TRAVERSAL, _T("ID_PANEL1"));
	m_StIP = new wxStaticText(Panel1, ID_STIP, _("IP:"), wxPoint(16,35), wxSize(145,30), 0, _T("ID_STIP"));
	m_StSm = new wxStaticText(Panel1, ID_STSM, _("Subnet Mask:"), wxPoint(16,75), wxSize(145,30), 0, _T("ID_STSM"));
	m_StGa = new wxStaticText(Panel1, ID_STGA, _("Gateway Address:"), wxPoint(16,115), wxSize(145,30), 0, _T("ID_STGA"));
	m_StDns = new wxStaticText(Panel1, ID_STDNS, _("DNS:"), wxPoint(16,155), wxSize(145,30), 0, _T("ID_STDNS"));
	m_TcIP = new wxTextCtrl(Panel1, ID_TCIP, wxEmptyString, wxPoint(176,32), wxSize(176,24), 0, wxDefaultValidator, _T("ID_TCIP"));
	m_TcSm = new wxTextCtrl(Panel1, ID_TCSM, wxEmptyString, wxPoint(176,72), wxSize(176,24), 0, wxDefaultValidator, _T("ID_TCSM"));
	m_TcGa = new wxTextCtrl(Panel1, ID_TCGA, wxEmptyString, wxPoint(176,112), wxSize(176,24), 0, wxDefaultValidator, _T("ID_TCGA"));
	m_TcDns = new wxTextCtrl(Panel1, ID_TCDNS, wxEmptyString, wxPoint(176,152), wxSize(176,24), 0, wxDefaultValidator, _T("ID_TCDNS"));

#if defined(__WXMSW__)
	m_BtnOK = new wxButton(Panel1, ID_BUTTONOK, _("OK"), wxPoint(175,208), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BUTTONOK"));
	m_BtnCancel = new wxButton(Panel1, ID_BUTTONCANCEL, _("Cancel"), wxPoint(273,208), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BUTTONCANCEL"));
#endif
#if defined(__UNIX__)
	m_BtnOK = new wxButton(Panel1, ID_BUTTONOK, _("OK"), wxPoint(165,198), wxSize(88,32), 0, wxDefaultValidator, _T("ID_BUTTONOK"));
	m_BtnCancel = new wxButton(Panel1, ID_BUTTONCANCEL, _("Cancel"), wxPoint(265,198), wxSize(88,32), 0, wxDefaultValidator, _T("ID_BUTTONCANCEL"));
#endif

    m_TcIP->SetMaxLength(15);
    m_TcSm->SetMaxLength(15);
    m_TcGa->SetMaxLength(15);
    m_TcDns->SetMaxLength(15);

	Connect(ID_HELP,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&IPSettings::OnF1Press);

    wxAcceleratorEntry entries[1];
    entries[0].Set( wxACCEL_NORMAL, WXK_F1, ID_HELP );
    wxAcceleratorTable accel(1, entries);
    SetAcceleratorTable(accel);
}

IPSettings::~IPSettings()
{
}

void IPSettings::OnInit(wxInitDialogEvent& event)
{
    Center();
    m_TcIP->SetFocus();
}

void IPSettings::Onm_BtnCancelClick(wxCommandEvent& event)
{
    Close();
}

void IPSettings::Onm_BtnOKClick(wxCommandEvent& event)
{
    if (m_TcIP->IsEmpty())
    {
        wxMessageDialog msg(this, _("IP address cannot be empty!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_TcIP->SetFocus();
        return;
    }
    if (m_TcSm->IsEmpty())
    {
        wxMessageDialog msg(this, _("Subnet mask cannot be empty!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_TcSm->SetFocus();
        return;
    }
    if (m_TcGa->IsEmpty())
    {
        wxMessageDialog msg(this, _("Gateway address cannot be empty!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_TcGa->SetFocus();
        return;
    }
    if (m_TcDns->IsEmpty())
    {
        wxMessageDialog msg(this, _("DNS cannot be empty!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_TcDns->SetFocus();
        return;
    }
    char pszIp[32] = { 0 };
    char pszMask[32] = { 0 };
    char pszGateway[32] = { 0 };
    strcpy(pszIp, m_TcIP->GetValue().mb_str());
    strcpy(pszMask, m_TcSm->GetValue().mb_str());
    strcpy(pszGateway, m_TcGa->GetValue().mb_str());
    wxString message = wxEmptyString;
    wxControl* pToFocus = NULL;
    switch ( IPv4AddressUtil::ValidateAdapterAddress(pszIp, pszMask, pszGateway) )
    {
    case INET_INVALID_ADDRESS:
        message = _("Invalid IP!");
        pToFocus = m_TcIP;
        break;
    case INET_BROADCAST_HOST_ADDRESS:
        message = _("IP address cannot be broadcast address!");
        pToFocus = m_TcIP;
        break;
    case INET_BROADCAST_GATEWAY_ADDRESS:
        message = _("Gateway cannot be broadcast address!");
        pToFocus = m_TcGa;
        break;
    case INET_MULTICAST_ADDRESS:
        message = _("IP address cannot be multicast address!");
        pToFocus = m_TcIP;
        break;
    case INET_RESERVED_ADDRESS:
        message = _("IP address cannot be reserved address!");
        pToFocus = m_TcIP;
        break;
    case INET_NETWORK_HOST_ADDRESS:
        message = _("IP address cannot be the same as the network address!");
        pToFocus = m_TcIP;
        break;
    case INET_NETWORK_GATEWAY_ADDRESS:
        message = _("Gateway address cannot be the same as the network address!");
        pToFocus = m_TcGa;
        break;
    case INET_INVALID_MASK:
        message = _("Invalid subnet mask!");
        pToFocus = m_TcSm;
        break;
    case INET_INVALID_GATEWAY:
        message = _("Invalid gateway address!");
        pToFocus = m_TcGa;
        break;
    case INET_ADDRESS_NOT_MATCH:
        message = _("IP address does not match the gateway!");
        pToFocus = m_TcIP;
        break;
    case INET_OK:
        switch ( IPv4AddressUtil::ValidateHostAddress(m_TcDns->GetValue().mbc_str()) )
        {
        case INET_MULTICAST_ADDRESS:
            message = _("DNS cannot be multicast address!");
            pToFocus = m_TcDns;
            break;
        case INET_RESERVED_ADDRESS:
            message = _("DNS cannot be reserved address!");
            pToFocus = m_TcDns;
            break;
        case INET_OK:
            break;
        default:
            message = _("Invalid DNS!");
            pToFocus = m_TcDns;
            break;
        };
        break;
    default:
        message = _("Invalid IP!");
        pToFocus = m_TcIP;
        break;
    };

    if ( message != wxEmptyString )
    {
        wxMessageDialog msg(this, message, _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        pToFocus->SetFocus();
    }
    else
    {
        EndModal(wxID_OK);
    }
}

void IPSettings::OnF1Press(wxCommandEvent& event)
{
#if defined(__UNIX__)
    if(wxFileExists(wxT("/usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf")))
    {
        wxString cmd = wxT("evince /usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf --page-label=30");
        //wxExecute(cmd);
    }
#endif
#if defined(__WXMSW__)
    ENMUtil::ShowContextHelp(this, _T("IPSetting"));
#endif
}
