#ifndef GAUGEDIALOG_H
#define GAUGEDIALOG_H

#include "BitmapDialog.h"
#include <wx/stattext.h>
#include <wx/gauge.h>
#include <wx/timer.h>

class GaugeDialog: public wxBitmapDialog
{
public:
    GaugeDialog(wxWindow* parent, wxWindowID id = wxID_ANY);
    virtual ~GaugeDialog();

    void SetProcessLabel(const wxString& label);
    virtual bool Show(bool show = true);

private:
    static wxBitmap m_bgBitmap;
    wxStaticText* m_stxLabel;
    wxGauge* m_gauge;
    wxTimer m_timer;

    static const long ID_GAUGE;
    static const long ID_STATICTEXT_LABEL;
    static const int ID_TIMER;

    void OnInit(wxInitDialogEvent& event);
    void OnTimer(wxTimerEvent& event);

    DECLARE_EVENT_TABLE()
};

#endif
