#ifndef ENMUTIL_H_INCLUDED
#define ENMUTIL_H_INCLUDED
#include "wx/string.h"
#include <string>
#include "PopupConfirmDialog.h"
using namespace std;

class ENMUtil
{
    public:
        static wxString m_appPath;
        static const int CHECK_OK = 0;
        static const int CHECK_ILLEGAL = 1;
        static const int CHECK_EMPTY = 2;
        static const int MAX_IP_ADDRESS = 15;
        static const int MAX_PART_IP = 3;

        static bool FilenameEquals(const wxString& name1, const wxString& name2);
        static void Log(const wxString& file, const wxString& log);
//        static int CheckParticular(wxString str);
        static string WxStringToString(wxString wxStringValue);
        static wxString StringToWxString(string stringValue);
        static bool IsHexNumber(wxString str);
        static int OnlyLetterAndNum(wxString str);
        static int CheckValide(wxString str);
        static bool IsAdministrator();
        static wxString GetCurrentUserAppDataFolder();
        static string& StringToLowerCase(string& str);
        static bool ChangeIPAddress(const wxString& ip, const wxString& mask, const wxString& gateway, const wxString& dns, int adapterType, const wxString& op);
        static bool GetIPAddress(wxString& ip, wxString& mask, wxString& gateway, wxString& dns, int adapterType);
        static bool DisableInternetSharing();
        static bool EnableInternetSharing();
        static bool AutoRunApp(string strAppPath);
        static bool OverwriteHomePage(string strHomePage);
        static bool OverwriteProxy(string strProxy, string strPort);
        static bool IsOnlyNumber(wxString str);
        static bool Enable8021xAuthentication(bool isEnable);
        static bool IsGuest();
        static void ShowSwitchWiredLANDlg();
        static void ShowSwitchWiredSuccDlg();
        static int ShowSwitchWirelessLANDlg();
        static void ShowSwitchWirelessSuccDlg();
        static void ShowNoWirelessAdapterDlg();
        static int ShowSwitchWirelessFailedDlg();
        static void ShowWirelessOnOffDlg(bool isEnable);
        static void ShowAutoConnectionFailedDlg();
        static bool ShowContextHelp(const wxWindow* pWnd, const wxString& section);
#if defined(__WXMSW__)
        static wxArrayString GetNetworkAdapterNames();
        static wxString GetAllUserAppDataFolder();
        static bool StartupWindowsFirewallService();
        static bool StartupWindowsFirewall();
        static bool StopWindowsFirewall();
        static bool EnableFileAndPrint();
        static bool DisableFileAndPrint();
#endif
#if defined(__UNIX__)
        static bool IsFirefoxRunning();
        static wxString GetFirefoxConfigFile();
        static int GetLocaleFileName(int langCode, wxString& fileName);
#endif

    private:
        static PopupConfirmDialog* switchWiredSuccDlg;
        static PopupConfirmDialog* switchWirelessSuccDlg;
        static PopupConfirmDialog* noWirelessAdapterDlg;
        static PopupConfirmDialog* wirelessOnOffDlg;
        static PopupConfirmDialog* autoConnectionFailedDlg;
};


#endif // ENMUTIL_H_INCLUDED
