#include "ENMUtil.h"
#include "ENMApp.h"

#include <string>
#include <vector>
#include <iostream>
#include <fstream>

#include <wx/msgdlg.h>
#include <wx/utils.h>

#if defined(__WXMSW__)
// for Windows
#include <ENM/ENMApi.h>
#include <windows.h>
#include <shlobj.h>
#include <wx/msw/registry.h>
#include "NetCon.h"
#include "DeviceController.h"

#else
// for Linux
#include <sdk/ENMApi.h>
#include <sys/types.h>
#include <errno.h>
#include <stdlib.h>

#endif

#include "DataCenter.h"
#include <wx/buffer.h>
#include <wx/file.h>
#include <fstream>

#include "PopupDialog.h"
#include "PopupConfirmDialog.h"

#if defined(__WXMSW__)
static wxString logFile(_T("C:\\ENMUtil.log"));
#else
static wxString logFile(_T("/tmp/ENMUtil.log"));
#endif

using namespace std;

const long START_FIREWALL = 1;
const long STOP_FIREWALL = 0;
const size_t REG801X_LENGTH = 104;
#if defined(__WXMSW__)
const unsigned char DISABLE_8021X[REG801X_LENGTH] = {0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x0d, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
const unsigned char ENABLE_8021X[REG801X_LENGTH] = {0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0D, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x33, 0x11, 0x22, 0x0d, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#endif

PopupConfirmDialog* ENMUtil::switchWiredSuccDlg = NULL;
PopupConfirmDialog* ENMUtil::switchWirelessSuccDlg = NULL;
PopupConfirmDialog* ENMUtil::noWirelessAdapterDlg = NULL;
PopupConfirmDialog* ENMUtil::wirelessOnOffDlg = NULL;
PopupConfirmDialog* ENMUtil::autoConnectionFailedDlg = NULL;
wxString ENMUtil::m_appPath = wxT("");

bool ENMUtil::FilenameEquals(const wxString& name1, const wxString& name2)
{
#if defined(__WXMSW__)
    return name1.CmpNoCase(name2) == 0;
#else
    return name1.Cmp(name2) == 0;
#endif
}

string ENMUtil::WxStringToString(wxString wxStringValue)
{
    string temp(wxStringValue.mb_str(wxConvUTF8));
    return temp;
}

wxString ENMUtil::StringToWxString(string stringValue)
{
    wxString temp(stringValue.c_str(), wxConvUTF8);
    return temp;
}

string& ENMUtil::StringToLowerCase(string& str)
{
    char d = 'a' - 'A';
    for ( string::size_type i = 0; i < str.size(); i++ )
    {
        if ( str[i] >= 'A' && str[i] <= 'Z' )
            str[i] += d;
    }
    return str;
}

bool ENMUtil::IsHexNumber(wxString str)
{
    bool result = true;
    for ( size_t i = 0; i < str.Length(); i++ )
    {
        result &= ( (str[i] >= '0' && str[i] <= '9') || (str[i] >= 'a' && str[i] <= 'f') || (str[i] >= 'A' && str[i] <= 'F') );
    }
    return result;
}

int ENMUtil::OnlyLetterAndNum(wxString str)
{
    string s = WxStringToString(str);
    for ( string::size_type i = 0; i < s.length(); i++)
    {
        if ((s[i] < 48 || s[i] > 57) && (s[i] < 97 || s[i] > 122))
        {
            return 1;
        }
    }
    return 0;
}

bool ENMUtil::IsOnlyNumber(wxString str)
{
    return str.IsNumber();
}

int ENMUtil::CheckValide(wxString str)
{
    str.Trim(true).Trim(false);
    if (str.Length() == 0)
    {
        return CHECK_EMPTY;
    }
    if (str.Find('<') >= 0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('>') >= 0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('"') >= 0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('\\') >= 0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('\'') >=0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('*') >=0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find(':') >=0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('?') >=0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('|') >=0)
    {
        return CHECK_ILLEGAL;
    }
    else if (str.Find('/') >=0)
    {
        return CHECK_ILLEGAL;
    }
//    else if (str.Find('%') >=0)
//    {
//        return CHECK_ILLEGAL;
//    }
    return CHECK_OK;
}

bool ENMUtil::IsAdministrator()
{
#if defined(__WXMSW__)
    return IsUserAnAdmin() ? true : false;
#endif
#if defined(__UNIX__)
    wxString wxs = ::wxGetUserId();
    string s(wxs.mb_str(wxConvUTF8));
    return s == "root";
#endif
}

wxString ENMUtil::GetCurrentUserAppDataFolder()
{
#if defined(__WXMSW__)
    wxString homeDir = ::wxGetHomeDir();
    wxString strAppDataFolder = homeDir + wxString(_T("\\Application Data"));
    return strAppDataFolder;
#endif
#if defined(__UNIX__)
     return ::wxGetHomeDir();;
#endif
}

bool ENMUtil::ChangeIPAddress(const wxString& ip, const wxString& mask, const wxString& gateway, const wxString& dns, int adapterType, const wxString& op)
{
//    ENMUtil::Log(logFile, wxString::Format(_T("Enter ENMUtil::ChangeIPAddress(\"%s\", \"%s\", \"%s\", \"%s\", %d, \"%s\")"), ip, mask, gateway, dns, adapterType, op));
    DataCenter* pDataCenter = DataCenter::GetInstance();
    if ( NULL == pDataCenter )
        return false;

    if ( adapterType == ADAPTER_NONE )
        return false;

    ENM_AddressInfo addrInfo;
    memset(&addrInfo, 0, sizeof(ENM_AddressInfo));
    string strIP = WxStringToString(ip);
    string strGateway = WxStringToString(gateway);
    string strMask = WxStringToString(mask);
    string strDns = WxStringToString(dns);
    strcpy((char*)addrInfo.ip.dcsString, (const char*)strIP.c_str());
    strcpy((char*)addrInfo.mask.dcsString, (const char*)strMask.c_str());
    strcpy((char*)addrInfo.gateway.dcsString, (const char*)strGateway.c_str());
    strcpy((char*)addrInfo.dns.dcsString, (const char*)strDns.c_str());

#if defined(__WXMSW__)
    wxArrayString adapterName = pDataCenter->GetNetworkAdapterName((ADAPTER_TYPE)adapterType);
    if ( adapterName.GetCount() == 0 )
        return false;

    wxArrayString strArrayAdapterName = GetNetworkAdapterNames();
    wxString strAdapterGuid;
    for ( size_t i = 0; i < strArrayAdapterName.Count(); i += 2 )
    {
        wxString name = strArrayAdapterName.Item(i);
        if ( adapterName.Item(0).Cmp(name) == 0 )
        {
            strAdapterGuid = strArrayAdapterName.Item(i + 1);
            break;
        }
    }
    ENMUtil::Log(logFile, _T("\t Get network adapter GUID: ") + strAdapterGuid);
    if ( strAdapterGuid.Length() == 0 )
        return false;

    wxRegKey key(_T("HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters\\Interfaces\\") + strAdapterGuid);
    long dhcpEnabled = 0;
    if ( key.Exists() )
    {
        key.QueryValue(_T("EnableDHCP"), &dhcpEnabled);
    }
    if ( dhcpEnabled == 1 && ip.IsEmpty() && op.Cmp(_T("ip")) == 0 )
        return true;

    strcpy((char*)addrInfo.adapterInfo.systemName.dcsString, strAdapterGuid.mbc_str());
    strcpy((char*)addrInfo.adapterInfo.userName.dcsString, op.mbc_str());
#endif

    bool result = (DCS_SetIPAddress(&addrInfo) == DCS_SUCCESS);
    ENMUtil::Log(logFile, wxString::Format(_T("Return ENMUtil::ChangeIPAddress: %d\n"), result));
    return result;
}

bool ENMUtil::GetIPAddress(wxString& ip, wxString& mask, wxString& gateway, wxString& dns, int adapterType)
{
#if defined(__WXMSW__)
    wxString strGuid;
    NetworkDeviceInfoArray devArray = Win32NetworkDeviceController::GetCurrentInstance()->EnumNetworkDevice();
    for ( size_t i = 0; i < devArray.GetCount(); i++ )
    {
        NetworkDeviceInfo info = devArray.Item(i);
        if ( adapterType == info.GetDeviceType() )
        {
            strGuid = info.GetGuid();
        }
    }
    if ( strGuid.IsEmpty() )
        return false;

    wxRegKey reg(_T("HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters\\Interfaces\\") + strGuid);
    if ( !reg.Exists() )
    {
        return false;
    }
    if ( !reg.Open(wxRegKey::Read) )
    {
        return false;
    }

    if ( !reg.HasValue(_T("EnableDHCP")) )
    {
        reg.Close();
        return false;
    }
    long dhcp;
    if ( !reg.QueryValue(_T("EnableDHCP"), &dhcp) )
    {
        reg.Close();
        return false;
    }

    bool result;
    if ( result = (dhcp == 0) )
    {
        result &= reg.QueryValue(_T("IPAddress"), ip);
        result &= reg.QueryValue(_T("SubnetMask"), mask);
        result &= reg.QueryValue(_T("DefaultGateway"), gateway);
        result &= reg.QueryValue(_T("NameServer"), dns);
    }
    reg.Close();
    return result;
#else
    return false;
#endif
}

#if defined(__WXMSW__)
wxString ENMUtil::GetAllUserAppDataFolder()
{
    wxString strAppDataFolder = _T("C:\\Documents and Settings\\Default User\\Application Data");
//    TCHAR szPath[MAX_PATH];
//    if(SUCCEEDED(SHGetFolderPath(NULL,
//                                 CSIDL_COMMON_APPDATA,
//                                 NULL,
//                                 0,
//                                 szPath)))
//    {
//        strAppDataFolder = szPath;
//    }

    return strAppDataFolder;
}
#endif


#if defined(__WXMSW__)
bool ENMUtil::StartupWindowsFirewallService()
{
    ShellExecute(NULL,_T("open"),_T("C:\\WINDOWS\\system32\\cmd.exe"),_T("/c   net start \"Windows Firewall/Internet Connection Sharing (ICS)\""),_T(""),SW_HIDE);
    return true;
}
#endif


#if defined(__WXMSW__)
bool ENMUtil::StartupWindowsFirewall()
{
    return DCS_EnableWindowsFirewall(true) == DCS_SUCCESS;
}
#endif

#if defined(__WXMSW__)
bool ENMUtil::StopWindowsFirewall()
{
    return DCS_EnableWindowsFirewall(false) == DCS_SUCCESS;
}
#endif


#if defined(__WXMSW__)
bool ENMUtil::DisableFileAndPrint()
{
    return DCS_EnableFileAndPrint(false) == DCS_SUCCESS;
}
#endif

#if defined(__WXMSW__)
bool ENMUtil::EnableFileAndPrint()
{
    return DCS_EnableFileAndPrint(true) == DCS_SUCCESS;
}
#endif

bool ENMUtil::DisableInternetSharing()
{
#if defined(__WXMSW__)
    INetSharingManager * pNetSharingManager = NULL;
    HRESULT hr = ::CoCreateInstance (__uuidof(NetSharingManager), NULL, CLSCTX_ALL, __uuidof(INetSharingManager), (void**)&pNetSharingManager);
    INetConnection * pNetConnection = NULL;
    INetSharingEveryConnectionCollection * pConCollection = NULL;
    hr = pNetSharingManager->get_EnumEveryConnection(&pConCollection);
    if ( pConCollection != NULL )
    {
        IEnumVARIANT * pEnumVariant = NULL;
        IUnknown * pUnk = NULL;
        hr = pConCollection->get__NewEnum (&pUnk);
        if (pUnk)
        {
            hr = pUnk->QueryInterface(__uuidof(IEnumVARIANT), (void**)&pEnumVariant);
            pUnk->Release();
        }
        if (pEnumVariant)
        {
            VARIANT v;
            VariantInit(&v);
            BOOL bFoundIt = FALSE;
            while ( S_OK == pEnumVariant->Next(1, &v, NULL) )
            {
                if ( V_VT(&v) == VT_UNKNOWN )
                {
                    V_UNKNOWN(&v)->QueryInterface(__uuidof(INetConnection), (void**)&pNetConnection);
                    if (pNetConnection)
                    {
                        INetConnectionProps * pProps = NULL;
                        pNetSharingManager->get_NetConnectionProps(pNetConnection, &pProps);
                        if ( pProps != NULL )
                        {
                            DWORD dwCharacteristics = 0;
                            pProps->get_Characteristics(&dwCharacteristics);
                            if ( dwCharacteristics & (NCCF_SHARED | NCCF_FIREWALLED) )
                            {
                                NETCON_MEDIATYPE MediaType = NCM_NONE;
                                pProps->get_MediaType (&MediaType);
                                BSTR pbstrName;
                                pProps->get_DeviceName(&pbstrName);
                                wxString strName(pbstrName);
                                if ( strName.Contains(_T("Wireless")) || strName.Contains(_T("wireless")) )
                                {
                                    bFoundIt = TRUE;
                                }
                            }
                            pProps->Release();
                        }
                        if ( bFoundIt == FALSE )
                        {
                            pNetConnection->Release();
                            pNetConnection = NULL;
                        }
                    }
                }
                VariantClear (&v);
                if ( bFoundIt == TRUE )
                {
                    break;
                }
            }
            pEnumVariant->Release();
        }
        pConCollection->Release();
    }
    if ( NULL == pNetConnection )
    {
//        wxMessageDialog msg(NULL, _("Failed to find a valid connection!"), _("Message"), wxOK | wxICON_INFORMATION);
//        msg.ShowModal();
        return false;
    }
    INetSharingConfiguration * pNSC = NULL;
    hr = pNetSharingManager->get_INetSharingConfigurationForINetConnection (pNetConnection, &pNSC);
    pNetConnection->Release(); // don\'t need this anymore
    if ( NULL == pNSC )
    {
//        wxMessageDialog msg(NULL, _("Cannot make INetSharingConfiguration object!"), _("Message"), wxOK | wxICON_INFORMATION);
//        msg.ShowModal();
        return false;
    }

    pNSC->DisableSharing();
    pNSC->Release();
    CoUninitialize();
    return true;
//    bool bRet = false;
//    DCS_Return_Code iRet = DCS_EnableInternetSharing(false);
//
//    if ( iRet == DCS_SUCCESS )
//    {
//        bRet = true;
//    }
//
//    return bRet;
#endif

#if defined(__UNIX__)
    return true;
#endif
}

#if defined(__WXMSW__)
wxArrayString ENMUtil::GetNetworkAdapterNames()
{
    wxArrayString result;
    static const wxString KEY = _T("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\NetworkCards\\");
    wxRegKey reg(KEY);
    if ( !reg.Exists() )
        return result;
    if ( !reg.Open(wxRegKey::Read) )
        return result;

    size_t nSubKeys, nValues;
    if ( !reg.GetKeyInfo(&nSubKeys, NULL, &nValues, NULL) )
        return result;

    long dummy = 1;
    wxString value;
    bool cont = reg.GetFirstKey(value, dummy);
    while ( cont )
    {
        wxRegKey key(KEY + value);
        if ( !key.Exists() )
            return result;
        if ( !key.HasValue(_T("ServiceName")) )
            return result;
        if ( !key.HasValue(_T("Description")) )
            return result;

        wxString keyServName;
        wxString keyDescription;
        key.QueryValue(_T("ServiceName"),keyServName);
        key.QueryValue(_T("Description"),keyDescription);
        wxString strAdapterName;
        wxRegKey keyConn(_T("HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Network\\{4D36E972-E325-11CE-BFC1-08002BE10318}\\") + keyServName + _T("\\Connection"));
        if ( !keyConn.Exists() )
            return result;
        if ( !keyConn.HasValue(_T("Name")) )
            return result;

        keyConn.QueryValue(_T("Name"),strAdapterName);
        result.Add(strAdapterName);
        result.Add(keyServName);
        cont = reg.GetNextKey(value, dummy);
    }
    return result;
}
#endif // __WXMSW__

bool ENMUtil::EnableInternetSharing()
{
#if defined(__WXMSW__)
    INetSharingManager * pNetSharingManager = NULL;
    HRESULT hr = ::CoCreateInstance(__uuidof(NetSharingManager), NULL, CLSCTX_ALL, __uuidof(INetSharingManager), (void**)&pNetSharingManager);
    INetConnection * pNetConnection = NULL;
    INetSharingEveryConnectionCollection * pConCollection = NULL;
    hr = pNetSharingManager->get_EnumEveryConnection(&pConCollection);
    if ( pConCollection != NULL )
    {
        IEnumVARIANT * pEnumVariant = NULL;
        IUnknown * pUnk = NULL;
        hr = pConCollection->get__NewEnum(&pUnk);
        if ( pUnk != NULL )
        {
            hr = pUnk->QueryInterface(__uuidof(IEnumVARIANT), (void**)&pEnumVariant);
            pUnk->Release();
        }
        if ( pEnumVariant != NULL )
        {
            VARIANT v;
            VariantInit(&v);
            BOOL bFoundIt = FALSE;
            while ( S_OK == pEnumVariant->Next(1, &v, NULL) )
            {
                if ( V_VT(&v) == VT_UNKNOWN )
                {
                    V_UNKNOWN(&v)->QueryInterface(__uuidof(INetConnection),(void**)&pNetConnection);
                    if ( pNetConnection != NULL )
                    {
                        INetConnectionProps * pProps = NULL;
                        pNetSharingManager->get_NetConnectionProps (pNetConnection, &pProps);
                        if ( pProps != NULL )
                        {
                            DWORD dwCharacteristics = 0;
                            pProps->get_Characteristics(&dwCharacteristics);
                            if ( dwCharacteristics & (NCCF_SHARED | NCCF_FIREWALLED) )
                            {
                                NETCON_MEDIATYPE MediaType = NCM_NONE;
                                pProps->get_MediaType(&MediaType);
                                BSTR pbstrName;
                                pProps->get_DeviceName(&pbstrName);
                                wxString strName(pbstrName);
                                if ( strName.Contains(_T("Wireless")) || strName.Contains(_T("wireless")) )
                                {
                                    bFoundIt = TRUE;
                                }
                            }
                            pProps->Release();
                        }
                        if ( bFoundIt == FALSE )
                        {
                            pNetConnection->Release();
                            pNetConnection = NULL;
                        }
                    }
                }
                VariantClear (&v);
                if ( bFoundIt == TRUE )
                {
                    break;
                }
            }
            pEnumVariant->Release();
        }
        pConCollection->Release();
    }
    if ( NULL == pNetConnection )
    {
//        wxMessageDialog msg(NULL, _("Failed to find a valid connection!"), _("Message"), wxOK | wxICON_INFORMATION);
//        msg.ShowModal();
        return false;
    }
    INetSharingConfiguration * pNSC = NULL;
    hr = pNetSharingManager->get_INetSharingConfigurationForINetConnection (pNetConnection, &pNSC);
    pNetConnection->Release(); // don\'t need this anymore
    if ( NULL == pNSC )
    {
//        wxMessageDialog msg(NULL, _("Cannot make INetSharingConfiguration object!"), _("Message"), wxOK | wxICON_INFORMATION);
//        msg.ShowModal();
        return false;
    }

    pNSC->EnableSharing(ICSSHARINGTYPE_PUBLIC);
    pNSC->Release();
    CoUninitialize ();
    return true;

//    bool bRet = false;
//    DCS_Return_Code iRet = DCS_EnableInternetSharing(true);
//
//    if ( iRet == DCS_SUCCESS )
//    {
//        bRet = true;
//    }
//
//    return bRet;
#endif

#if defined(__UNIX__)
    return true;
#endif
}

bool ENMUtil::AutoRunApp(string strAppPath)
{
#if defined(__WXMSW__)
    ShellExecute(NULL, _T("open"), wxString::FromUTF8(strAppPath.c_str()), _T(""), _T(""), SW_SHOWNORMAL);
#endif
#if defined(__UNIX__)
    string s = strAppPath + " &";
    system(s.c_str());
#endif
    return true;
}

bool ENMUtil::OverwriteHomePage(string strHomePage)
{
#if defined(__WXMSW__)
    static const wxString KEY = _T("HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\Main");
    wxRegKey reg(KEY);
    if ( !reg.Exists() )
        return false;
    if ( !reg.Open(wxRegKey::Read) )
        return false;
    reg.SetValue(_T("Start Page"), wxString::FromUTF8(strHomePage.c_str()));
    return true;
#endif

#if defined(__UNIX__)
    wxString wxstrHomePage = wxString::FromUTF8(strHomePage.c_str());
    int confirm = wxID_YES;
    while ( IsFirefoxRunning() && confirm == wxID_YES )
    {
        wxMessageDialog msg(NULL, _("Firefox is running. \nPlease shut down Firefox and press Yes."), _("Confirm"), wxYES_NO | wxICON_QUESTION);
        confirm = msg.ShowModal();
    }
    if ( confirm != wxID_YES )
        return false;

    wxString prefsFile = GetFirefoxConfigFile();
    if ( prefsFile.Length() == 0 || !wxFile::Exists(prefsFile) )
        return false;
    wxArrayString arrayString;
//    const char* fileName = WxStringToString(prefsFile).c_str();
    char fileName[256] = { 0 };
    bool homePageFound = false;
    strcpy(fileName, prefsFile.mb_str());
    ifstream fin(fileName);
    while ( !fin.eof() )
    {
        char buf[1024] = { 0 };
        fin.getline(buf, 1024);
        wxString s = wxString::FromUTF8(buf);
        if ( s.StartsWith(_T("user_pref(\"browser.startup.homepage\", \"")) )
        {
            homePageFound = true;
            s = _T("user_pref(\"browser.startup.homepage\", \"") + wxstrHomePage + _T("\");");
        }
        arrayString.Add(s);
    }
    fin.close();
    if ( !homePageFound )
    {
        wxString wxsHomePage = _T("user_pref(\"browser.startup.homepage\", \"") + wxstrHomePage + _T("\");");
        arrayString.Add(wxsHomePage);
    }
    ofstream fout(fileName);
    size_t i;
    for ( i = 0; i < arrayString.GetCount() - 1; i++ )
    {
        fout << WxStringToString(arrayString.Item(i)) << endl;
    }
    fout << WxStringToString(arrayString.Item(i)) << endl;
    fout.close();
    return true;
#endif
}

bool ENMUtil::OverwriteProxy(string strProxy, string strPort)
{
#if defined(__WXMSW__)
    static const wxString KEY = _T("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings");
    wxRegKey reg(KEY);
    if ( !reg.Exists() )
        return false;
    if ( !reg.Open(wxRegKey::Read) )
        return false;
    reg.SetValue(_T("ProxyServer"), wxString::FromUTF8(strProxy.c_str()) + _T(":") + wxString::FromUTF8(strPort.c_str()));
    return true;
#endif
#if defined(__UNIX__)
    wxString wxstrProxy = wxString::FromUTF8(strProxy.c_str());
    wxString wxstrPort = wxString::FromUTF8(strPort.c_str());
    int confirm = wxID_YES;
    while ( IsFirefoxRunning() && confirm == wxID_YES )
    {
        wxMessageDialog msg(NULL, _("Firefox is running. \nPlease shut down Firefox and press Yes."), _("Confirm"), wxYES_NO | wxICON_QUESTION);
        confirm = msg.ShowModal();
    }
    if ( confirm != wxID_YES )
        return false;

    wxString prefsFile = GetFirefoxConfigFile();
    if ( prefsFile.Length() == 0 || !wxFile::Exists(prefsFile) )
        return false;
    wxArrayString arrayString;
//    const char* fileName = WxStringToString(prefsFile).c_str();
    bool proxyFound = false;
    bool portFound = false;
    char fileName[256] = { 0 };
    strcpy(fileName, prefsFile.mb_str());
    ifstream fin(fileName);
    while ( !fin.eof() )
    {
        char buf[1024] = { 0 };
        fin.getline(buf, 1024);
        wxString s = wxString::FromUTF8(buf);
        if ( s.StartsWith(_T("user_pref(\"network.proxy.http\", \"")) )
        {
            proxyFound = true;
            s = _T("user_pref(\"network.proxy.http\", \"") + wxstrProxy + _T("\");");
        }
        else if ( s.StartsWith(_T("user_pref(\"network.proxy.http_port\", ")) )
        {
            portFound = true;
            s = _T("user_pref(\"network.proxy.http_port\", ") + wxstrPort + _T(");");
        }
        arrayString.Add(s);
    }
    fin.close();
    if ( !proxyFound )
    {
        wxString proxy = _T("user_pref(\"network.proxy.http\", \"") + wxstrProxy + _T("\");");
        arrayString.Add(proxy);
    }
    if ( !portFound )
    {
        wxString port = _T("user_pref(\"network.proxy.http_port\", ") + wxstrPort + _T(");");
        arrayString.Add(port);
    }
    ofstream fout(fileName);
    size_t i;
    for ( i = 0; i < arrayString.GetCount() - 1; i++ )
    {
        fout << WxStringToString(arrayString.Item(i)) << endl;
    }
    fout << WxStringToString(arrayString.Item(i)) << endl;
    fout.close();
    return true;
#endif
}


bool ENMUtil::Enable8021xAuthentication(bool isEnable)
{
    return DCS_Enable8021xAuthentication(isEnable) == DCS_SUCCESS;
}

#if defined(__UNIX__)
wxString ENMUtil::GetFirefoxConfigFile()
{
    wxString firefoxDir = ::wxGetHomeDir() + _T("/.mozilla/firefox");
    wxString profile = firefoxDir + _T("/profiles.ini");
    if ( !wxFile::Exists(profile) )
        return _T("");

    ifstream fin(WxStringToString(profile).c_str());
    wxArrayString arrayString;
    while ( !fin.eof() )
    {
        char buf[256] = { 0 };
    //    getline(fin, buf);
        fin.getline(buf, 256);
        arrayString.Add(wxString::FromUTF8(buf));
    }
    fin.close();
    wxString pref;
    for ( size_t i = 0; i < arrayString.Count(); i++ )
    {
        wxString s = arrayString.Item(i);
        if ( s.StartsWith(_T("Path=")) )
        {
            pref = s.Mid(s.Find('=', false) + 1);
        }
    }
    return ::wxGetHomeDir() + _T("/.mozilla/firefox/") + pref + _T("/prefs.js");
}

bool ENMUtil::IsFirefoxRunning()
{
    system("ps -A|grep \"firefox\" > /tmp/_firefox.tmp");
    wxString tmpFile = _T("/tmp/_firefox.tmp");
    if ( !wxFile::Exists(tmpFile) )
        return false;

    wxFile file(tmpFile);
    bool result = file.Length() > 0;
    file.Close();
    return result;
}

int ENMUtil::GetLocaleFileName(int langCode, wxString& fileName)
{
    string mapfile = "/usr/share/EasyNetwork/resource/langToFile";
    fileName = wxT("en");
    ifstream in(mapfile.c_str());

    if (!in)
    {
        return -1;
    }
    char langCodeStr[10] = {'\0'};
    snprintf(langCodeStr, 10, "%d", langCode);
    string line;
    while(getline(in, line))
    {
        string::size_type index = line.find(":");
        if (index == string::npos || index == 0)

        {
            continue;
        }
        if (0 == line.compare(0, index, langCodeStr))
        {
            fileName = ENMUtil::StringToWxString(line.substr(index + 1));
            in.close();
            return 1;
        }
    }

    in.close();
    return -1;
}
#endif


bool ENMUtil::IsGuest()
{
#if defined(__WXMSW__)
    bool bRet = false;
    wchar_t   wbuf[100];
	unsigned   long   dwlen=100;
	GetUserName(wbuf,&dwlen);
	wxString strUserName = wxString(wbuf, wxConvUTF8);
	if ( !strUserName.Cmp(_T("Guest")) )
	{
	    bRet = true;
	}

	return bRet;
#endif
#if defined(__UNIX__)
    return false;
#endif
}

void ENMUtil::Log(const wxString& file, const wxString& log)
{
#ifdef __USE_ENM_LOG__
    wxFile f(file, wxFile::write_append);
    f.Write(log + wxT("\n"));
    f.Close();
#endif
}

void ENMUtil::ShowSwitchWiredLANDlg()
{
    #if defined(__WXMSW__)
    PopupDialog Dlg(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\balloon_background.png"))));
    #endif

    #if defined(__UNIX__)
    PopupDialog Dlg(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/balloon_background.png"))));
    #endif
    #if defined(__WXMSW__)
    Dlg.SetTitle(_("Confirm"));
    Dlg.SetContentLine1(_("EN has found Wired LAN available,"));
    Dlg.SetContentLine2(_("would you like to switch from"));
    Dlg.SetContentLine3(_("Wireless to Wired LAN?"));
    #endif
    #if defined(__UNIX__)
    Dlg.SetTitle(_("Confirm"));
    Dlg.SetContentLine1(_("EN found Wired LAN is available,"));
    Dlg.SetContentLine2(_("would you like to switch"));
    Dlg.SetContentLine3(_("Wireless to Wired LAN?"));
    #endif
    if ( Dlg.ShowModal() == wxID_OK )
    {
        DataCenter::GetInstance()->SwitchAdapterParameter(ADAPTER_WIREDLESS,ADAPTER_WIRED,NULL);
        ShowSwitchWiredSuccDlg();
    }
    else
    {
        DataCenter::GetInstance()->SwitchAdapterParameter(ADAPTER_WIRED,(ADAPTER_TYPE)0,NULL);
    }
}


void ENMUtil::ShowSwitchWiredSuccDlg()
{
    if ( NULL == switchWiredSuccDlg )
    {
        #if defined(__WXMSW__)
        switchWiredSuccDlg = new PopupConfirmDialog(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\balloon_background.png"))));
        #endif

        #if defined(__UNIX__)
        switchWiredSuccDlg = new PopupConfirmDialog(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/balloon_background.png"))));
        #endif
    }
    #if defined(__WXMSW__)
    switchWiredSuccDlg->SetTitle(_("Confirm"));
    switchWiredSuccDlg->SetContentLine1(_("EN has successfully switched from"));
    switchWiredSuccDlg->SetContentLine2(_("Wireless LAN to Wired LAN."));
    #endif
    #if defined(__UNIX__)
    switchWiredSuccDlg->SetTitle(_("Confirm"));
    switchWiredSuccDlg->SetContentLine1(_("EN switched Wireless LAN to"));
    switchWiredSuccDlg->SetContentLine2(_("Wired LAN successfully!"));
    #endif
    switchWiredSuccDlg->CentreOnScreen();
    switchWiredSuccDlg->Show();
}

int ENMUtil::ShowSwitchWirelessLANDlg()
{
    #if defined(__WXMSW__)
    PopupDialog Dlg(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\balloon_background.png"))));
    #endif

    #if defined(__UNIX__)
    PopupDialog Dlg(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/balloon_background.png"))));
    #endif
    #if defined(__WXMSW__)
    Dlg.SetTitle(_("Confirm"));
    Dlg.SetContentLine1(_("Wired LAN is disconnected. Would you"));
    Dlg.SetContentLine2(_("like to switch to Wireless LAN?"));
    #endif
    #if defined(__UNIX__)
    Dlg.SetTitle(_("Confirm"));
    Dlg.SetContentLine1(_("Wired LAN is disconnected."));
    Dlg.SetContentLine2(_("Would you like to switch"));
    Dlg.SetContentLine3(_("to Wireless LAN?"));
    #endif
    return Dlg.ShowModal();
}

void ENMUtil::ShowSwitchWirelessSuccDlg()
{
    if ( NULL == switchWirelessSuccDlg )
    {
        #if defined(__WXMSW__)
        switchWirelessSuccDlg = new PopupConfirmDialog(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\balloon_background.png"))));
        #endif

        #if defined(__UNIX__)
        switchWirelessSuccDlg = new PopupConfirmDialog(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/balloon_background.png"))));
        #endif
    }

    switchWirelessSuccDlg->SetTitle(_("Confirm"));
    #if defined(__UNIX__)
    switchWirelessSuccDlg->SetContentLine1(_("EN has switched Wired LAN to"));
    switchWirelessSuccDlg->SetContentLine2(_("Wireless LAN successfully!"));
    #endif
    #if defined(__WXMSW__)
    switchWirelessSuccDlg->SetContentLine1(_("EN has successfully switched from"));
    switchWirelessSuccDlg->SetContentLine2(_("Wired LAN to Wireless LAN."));
    #endif
//    Dlg.ShowModal();
    switchWirelessSuccDlg->CentreOnScreen();
    switchWirelessSuccDlg->Show();
}

void ENMUtil::ShowNoWirelessAdapterDlg()
{
    if ( NULL == noWirelessAdapterDlg )
    {
        #if defined(__WXMSW__)
        noWirelessAdapterDlg = new PopupConfirmDialog(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\balloon_background.png"))));
        #endif

        #if defined(__UNIX__)
        noWirelessAdapterDlg = new PopupConfirmDialog(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/balloon_background.png"))));
        #endif
    }

    noWirelessAdapterDlg->SetTitle(_("Confirm"));
    noWirelessAdapterDlg->SetContentLine2(_("No Wireless Adapter was found!"));
//    Dlg.ShowModal();
    noWirelessAdapterDlg->CentreOnScreen();
    noWirelessAdapterDlg->Show();
}

int ENMUtil::ShowSwitchWirelessFailedDlg()
{
    #if defined(__WXMSW__)
    PopupDialog Dlg(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\balloon_background.png"))));
    #endif

    #if defined(__UNIX__)
    PopupDialog Dlg(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/balloon_background.png"))));
    #endif
    #if defined(__WXMSW__)
    Dlg.SetTitle(_("Confirm"));
    Dlg.SetContentLine1(_("None of pre-defined wireless profiles"));
    Dlg.SetContentLine2(_("successfully connected, would you like "));
    Dlg.SetContentLine3(_("to manually scan network?"));
    #endif
    #if defined(__UNIX__)
    Dlg.SetTitle(_("Confirm"));
    Dlg.SetContentLine1(_("None of pre-defined wireless "));
    Dlg.SetContentLine2(_("profiles connected, would you"));
    Dlg.SetContentLine3(_("like to manually scan network?"));
    #endif
    return Dlg.ShowModal();
}

void ENMUtil::ShowWirelessOnOffDlg(bool isEnable)
{
    if ( NULL == wirelessOnOffDlg )
    {
        #if defined(__WXMSW__)
        wirelessOnOffDlg = new PopupConfirmDialog(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\balloon_background.png"))));
        #endif

        #if defined(__UNIX__)
        wirelessOnOffDlg = new PopupConfirmDialog(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/balloon_background.png"))));
        #endif
    }

    wirelessOnOffDlg->SetTitle(_("Confirm"));
    if ( isEnable )
    {
        wirelessOnOffDlg->SetContentLine2(_("Turn on Wireless!"));
    }
    else
    {
        wirelessOnOffDlg->SetContentLine2(_("Turn off Wireless!"));
        wirelessOnOffDlg->SetContentLine3(_("Turn on Wired LAN!"));
    }

//    Dlg.ShowModal();
    wirelessOnOffDlg->CentreOnScreen();
    wirelessOnOffDlg->Show();
}


void ENMUtil::ShowAutoConnectionFailedDlg()
{
    if ( NULL == autoConnectionFailedDlg )
    {
#if defined(__WXMSW__)
        autoConnectionFailedDlg = new PopupConfirmDialog(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\balloon_background.png"))));
#endif
#if defined(__UNIX__)
        autoConnectionFailedDlg = new PopupConfirmDialog(NULL, wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/balloon_background.png"))));
#endif
    }
    autoConnectionFailedDlg->SetTitle(_("Confirm"));
    autoConnectionFailedDlg->SetContentLine1(_("None of pre-defined profiles"));
    autoConnectionFailedDlg->SetContentLine2(_("successfully connected!"));
    autoConnectionFailedDlg->CentreOnScreen();
    autoConnectionFailedDlg->Show();
}

bool ENMUtil::ShowContextHelp(const wxWindow* pWnd, const wxString& section)
{
#if defined(__WXMSW__)
    wxString strPdfFilePath(::wxGetApp().strAppPath + _T("Intel_CMPC2.0_Easy_Network_User_Manual.pdf"));
    if ( !wxFile::Exists(strPdfFilePath) )
        return false;
    HINSTANCE instance = ShellExecute(NULL, NULL, _T("\"") + strPdfFilePath + _T("\""), NULL, NULL, SW_SHOWNORMAL);
    return (int)instance > 32;
#endif
#if defined(__UNIX__)
    return false;
#endif
}
