
#include "ENMPopupMenu.h"
#include "NetworkManagerDlg.h"
#include "ScanNetworkDlg.h"
#include "ENMApp.h"
#include "DataCenter.h"
#include "ProfileManagementControl.h"
#include "ENMUtil.h"
#include "PolicyManager.h"
#include "MeshShareMyInternetDlg.h"
#include "MeshUseOthersInternetDlg.h"
#include "MeshInfoManager.h"
#include "IPDlg.h"
#include "Profile.h"

//#include <vector>
//#include <algorithm>
//using namespace std;
//typedef vector<MeshServerEntity> MeshServerInfoList;


#if defined(__WXMSW__)
static wxString logFile(_T("C:\\ENMPopupMenu.log"));
#else
static wxString logFile(_T("/tmp/ENMPopupMenu.log"));
#endif
static bool m_bTurnOnMesh = false;

const int ENMPopupMenu::ID_MENU_ITEM_HELP       = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_MANAGE     = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_SCAN       = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_PROFILE    = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_PROFILE_MIN = ENMPopupMenu::ID_MENU_ITEM_PROFILE + 1;
const int ENMPopupMenu::MENU_ITEM_PROFILE_MARGIN_WIDTH  = 24;
const int ENMPopupMenu::MENU_ITEM_MARGIN_WIDTH  = 32;
const int ENMPopupMenu::ID_MENU_ITEM_CONNCETTOMESH = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_SHARE_MY_INTERNET = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_USER_OTHERS_INTERNET = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_TURNON_MESH = ::wxNewId();
const int ENMPopupMenu::ID_MENU_ITEM_MESH = ::wxNewId();

ENMPopupMenu::ENMPopupMenu() : wxMenu(), id(::wxNewId())
{
#if defined(__UNIX__)
    m_pBmpCheck = new wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/tick.png"), wxBITMAP_TYPE_PNG, 4));
    m_pBmpEmpty = new wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/empty.png"), wxBITMAP_TYPE_PNG, 4));
#endif

#if defined(__WXMSW__)

    m_pBmpCheck = new wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\tick.png"), wxBITMAP_TYPE_PNG, 4));
    m_pBmpEmpty = new wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\empty.png"), wxBITMAP_TYPE_PNG, 4));
#endif

    InitMenu();
}

ENMPopupMenu::~ENMPopupMenu()
{
}

void ENMPopupMenu::InitMenu()
{
    LoadProfileMenuItems();

    this->AppendSeparator();
    LoadMeshMenuItems();

    m_pmiScan = new wxMenuItem(this, ID_MENU_ITEM_SCAN, _("Scan for Networks"));
#if defined(__UNIX__)
    m_pmiScan->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/icon_scan.png"))));
#endif
#if defined(__WXMSW__)
    m_pmiScan->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\icon_scan.png"))));
    m_pmiScan->SetMarginWidth(MENU_ITEM_MARGIN_WIDTH);
#endif
    Connect(ID_MENU_ITEM_SCAN, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemScanClicked);
    this->Append(m_pmiScan);
    NETWORK_MODE networkMode = DataCenter::GetInstance()->GetCurrentNetworkMode();
    m_pmiScan->Enable(networkMode == NETWORK_MODE_WIRELESS_LAN_CONNECT || networkMode == NETWORK_MODE_WIRELESS_LAN_DISCONNECT);

    m_pmiManage = new wxMenuItem(this, ID_MENU_ITEM_MANAGE, _("Manage Network"));
#if defined(__UNIX__)
    m_pmiManage->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/icon_manage.png"))));
#endif
#if defined(__WXMSW__)
     m_pmiManage->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\icon_manage.png"))));
    m_pmiManage->SetMarginWidth(MENU_ITEM_MARGIN_WIDTH);
#endif
    Connect(ID_MENU_ITEM_MANAGE, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemManageClicked);
    this->Append(m_pmiManage);

    this->AppendSeparator();

    m_pmiHelp = new wxMenuItem(this, ID_MENU_ITEM_HELP, _("Help..."));
#if defined(__UNIX__)
    m_pmiHelp->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/icon_help.png"))));
#endif
#if defined(__WXMSW__)
    m_pmiHelp->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\icon_help.png"))));
    m_pmiHelp->SetMarginWidth(MENU_ITEM_MARGIN_WIDTH);
#endif
    Connect(ID_MENU_ITEM_HELP, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemHelpClicked);
    this->Append(m_pmiHelp);
}

void ENMPopupMenu::LoadProfileMenuItems()
{
    ENMUtil::Log(logFile, _T("Enter ENMPopupMenu::LoadProfileMenuItems"));
    m_pmiProfile = new wxMenuItem(this, ID_MENU_ITEM_PROFILE, _("Connect to Profile"));
#if defined(__UNIX__)
    m_pmiProfile->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/icon_pro.png"))));
#endif
#if defined(__WXMSW__)
    m_pmiProfile->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\icon_pro.png"))));
    m_pmiProfile->SetMarginWidth(MENU_ITEM_MARGIN_WIDTH);
#endif
    ENMUtil::Log(logFile, _T("\t Menu \"Connect to Profile\" created successfully."));

    ProfileManagementControl* pController = DataCenter::GetInstance()->GetProfileController();
    ProfileList_t cp = pController->GetCurrentUsedProfile();
    wxString _cpName = wxString::FromUTF8(cp.sProfileName.c_str());
    ENMUtil::Log(logFile, _T("\t Get current profile: ") + _cpName);
    vector<ProfileList_t> profileVector;
    bool hasSubMenu = false;
    if ( pController->GetUserProfiles(profileVector, ENMUtil::IsAdministrator(), true) && profileVector.size() > 0 )
    {
//        wxString log = wxString::Format(wxT("ENMPopupMenu::LoadProfileMenuItems\n\tLoad %d profiles."), profileVector.size());
//        ENMUtil::Log(::wxGetHomeDir() + wxT("\\log.txt"), log);
        for ( vector<ProfileList_t>::size_type i = 0; i < profileVector.size(); i++ )
        {
            ProfileList_t profile = profileVector.at(i);
            if ( profile.sShow == "1" )
                hasSubMenu = true;
        }
    }
    if ( hasSubMenu )
    {
        wxMenu* profileSubMenu = new wxMenu();
        wxMenu* pEventSource = this;
#if defined(__UNIX__)
        pEventSource = profileSubMenu;
#endif
        ENMUtil::Log(logFile, wxString::Format(_T("\t Get %d profiles"), profileVector.size()));
        for ( vector<ProfileList_t>::size_type i = 0; i < profileVector.size(); i++ )
        {
            ProfileList_t profile = profileVector.at(i);
            if ( profile.sShow != "1" )
                continue;

            wxString profileName = wxString::FromUTF8(profile.sProfileName.c_str());
            int id = ID_MENU_ITEM_PROFILE_MIN + i;
            wxMenuItem* pItem = new wxMenuItem(profileSubMenu, id, profileName, _T(""), wxITEM_NORMAL, NULL);
#if defined(__WXMSW__)
            pItem->SetMarginWidth(MENU_ITEM_PROFILE_MARGIN_WIDTH);
#endif
            ENMUtil::Log(logFile, _T("\t Create menu item ") + profileName);
            if ( profile.sProfileName == cp.sProfileName && profile.sPermission == cp.sPermission )
                pItem->SetBitmap(*m_pBmpCheck);
            else
                pItem->SetBitmap(*m_pBmpEmpty);
            pEventSource->Connect(id, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemProfileClicked);
            profileSubMenu->Append(pItem);
            ENMUtil::Log(logFile, _T("\t Append menu item ") + profileName);
        }
        ENMUtil::Log(logFile, _T("\t Append menu item \"Connect to Profile\""));
        m_pmiProfile->SetSubMenu(profileSubMenu);
//        m_pmiProfile = this->AppendSubMenu(profileSubMenu, _("Connect to Profile"));
    }
    this->Append(m_pmiProfile);
    if ( !hasSubMenu )
    {
        ENMUtil::Log(logFile, _T("\t No profile"));
        m_pmiProfile->Enable(false);
    }
    ENMUtil::Log(logFile, _T("Return ENMPopupMenu::LoadProfileMenuItems\n"));
}


void ENMPopupMenu::LoadMeshMenuItems()
{
    m_pmiMesh = new wxMenuItem(this, ID_MENU_ITEM_MESH, _("Connect to Mesh Network"));
#if defined(__UNIX__)
    m_pmiMesh->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic/UseOtherInternet.ico")).Rescale(32, 32)));
#endif
#if defined(__WXMSW__)
    m_pmiMesh->SetBitmap(wxBitmap(wxImage(::wxGetApp().strAppPath + _T("pic\\UseOtherInternet.ico"))));
    m_pmiMesh->SetMarginWidth(MENU_ITEM_MARGIN_WIDTH);
#endif

    if(::wxGetApp().m_nMeshStatus != MESHSTATUS_MESHCLOSE)
	{
		wxMenu* pMeshSubMenu = new wxMenu();
		wxMenu* pEventSource = this;
#if defined(__UNIX__)
		pEventSource = pMeshSubMenu;
#endif

		wxMenuItem* pItem = new wxMenuItem(pMeshSubMenu, 0, _T("Share My Internet"), _T(""), wxITEM_NORMAL, NULL);
#if defined(__WXMSW__)
		pItem->SetMarginWidth(MENU_ITEM_MARGIN_WIDTH);
#endif

        if(::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHSERVER)
        {
            pItem->SetBitmap(*m_pBmpCheck);
        }
        else
        {
            pItem->SetBitmap(*m_pBmpEmpty);
        }

		pEventSource->Connect(0, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemShareMyInternetClicked);
		pMeshSubMenu->Append(pItem);

		wxMenuItem* pItem1 = new wxMenuItem(pMeshSubMenu, 1, _T("Use Other's Internet"), _T(""), wxITEM_NORMAL, NULL);
#if defined(__WXMSW__)
		pItem1->SetMarginWidth(MENU_ITEM_MARGIN_WIDTH);
#endif
		if(::wxGetApp().m_nMeshStatus == MESHSTATUS_MESHCLIENT)
        {
            pItem1->SetBitmap(*m_pBmpCheck);
        }
        else
        {
            pItem1->SetBitmap(*m_pBmpEmpty);
        }

		pEventSource->Connect(1, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemUseOthersInternetClicked);
		pMeshSubMenu->Append(pItem1);

		wxMenuItem* pItem2 = new wxMenuItem(pMeshSubMenu, 2, _T("Turn off Mesh"), _T(""), wxITEM_NORMAL, NULL);
#if defined(__WXMSW__)
		pItem2->SetMarginWidth(MENU_ITEM_MARGIN_WIDTH);
#endif
		pEventSource->Connect(2, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemTurnOffClicked);
		pMeshSubMenu->Append(pItem2);

		m_pmiMesh->SetSubMenu(pMeshSubMenu);
	}
	else
	{
	    wxMenu* pMeshSubMenu = new wxMenu();
		wxMenu* pEventSource = this;
#if defined(__UNIX__)
		pEventSource = pMeshSubMenu;
#endif

		wxMenuItem* pItem = new wxMenuItem(pMeshSubMenu, 0, _T("Turn on Mesh"), _T(""), wxITEM_NORMAL, NULL);
#if defined(__WXMSW__)
		pItem->SetMarginWidth(MENU_ITEM_MARGIN_WIDTH);
#endif
		//if ( profile.sProfileName == cp.sProfileName && profile.sPermission == cp.sPermission )
		//pItem->SetBitmap(*m_pBmpCheck);
		//else
		//pItem->SetBitmap(*m_pBmpEmpty);

		pEventSource->Connect(0, wxEVT_COMMAND_MENU_SELECTED, (wxObjectEventFunction)&ENMPopupMenu::OnMenuItemTurnOnClicked);
		pMeshSubMenu->Append(pItem);

		m_pmiMesh->SetSubMenu(pMeshSubMenu);
    }
    this->Append(m_pmiMesh);
}


void ENMPopupMenu::OnMenuItemHelpClicked(wxCommandEvent& event)
{
#if defined(__UNIX__)
    if(wxFileExists(wxT("/usr/share/doc/easy-network/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf.gz")))
    {
        wxString cmd = wxT("evince /usr/share/doc/easy-network/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf.gz --page-label=1");
        wxExecute(cmd);
    }
#endif
#if defined(__WXMSW__)
    ENMUtil::ShowContextHelp(NULL, _T("Main"));
#endif
}

void ENMPopupMenu::OnMenuItemManageClicked(wxCommandEvent& event)
{
    NetworkManagerDlg* networkManagerDlg = DataCenter::GetInstance()->GetNetworkManagerDlgHandle();
    if ( NULL == networkManagerDlg )
    {
        return;
    }
//    networkManagerDlg->SetNetworkProfile();
    networkManagerDlg->Iconize(false);
    networkManagerDlg->Show();
    networkManagerDlg->Raise();
}

void ENMPopupMenu::OnMenuItemScanClicked(wxCommandEvent& event)
{
    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsScanEnable() )
    {
        wxMessageDialog dlg(NULL, _("The current policy forbids scanning for wireless networks."), _("Message"), wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }

    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }

    if ( DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->IsApplyingProfile() )
    {
        return;
    }

    ScanNetworkDlg* scanNetworkDlg = DataCenter::GetInstance()->GetScanNetworkDlgHandle();
    if ( scanNetworkDlg->IsShown() )
    {
        scanNetworkDlg->CloseDialog(wxID_CANCEL);
    }
    scanNetworkDlg->SetDialogMode(true);
    scanNetworkDlg->Iconize(false);
    scanNetworkDlg->Show();
    scanNetworkDlg->Raise();
}

void ENMPopupMenu::OnMenuItemProfileClicked(wxCommandEvent& event)
{
    if ( ::wxGetApp().m_nMeshStatus != MESHSTATUS_MESHCLOSE &&
     ::wxGetApp().m_nMeshStatus != MESHSTATUS_MESHSERVER)
    {
        DCS_TurnOnMesh(FALSE);
        ::wxGetApp().m_nMeshStatus = MESHSTATUS_MESHCLOSE;
    }
    if ( !ENMTaskTray::GetInstance()->GetApplyWirelessFlag() )
    {
        return;
    }
    int id = event.GetId();
    wxMenu* pMenu = static_cast<wxMenu*>(event.GetEventObject());
    wxMenuItem* pItem = pMenu->FindItem(id);
    wxString profileName = pItem->GetItemLabel();
    ProfileList_t* pProfile;
    pProfile = DataCenter::GetInstance()->GetProfileController()->GetProfile(id - ID_MENU_ITEM_PROFILE_MIN);
    if ( NULL == pProfile )
        return;
    DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->ShowApplyingProcessDialog(profileName, true);
    DataCenter::GetInstance()->GetProfileController()->ApplyProfile(*pProfile);
}

void ENMPopupMenu::OnMenuItemTurnOnClicked(wxCommandEvent& event)
{
    printf("TurnOn m_nMeshStatus = %d\n",::wxGetApp().m_nMeshStatus);

    PolicyManager* p = DataCenter::GetInstance()->GetPolicyManager();
    if ( !p->IsMeshEnable() )
    {
        wxMessageDialog dlg(NULL, _("The current policy forbids using mesh."), _("Message"), wxOK | wxICON_INFORMATION);
        dlg.ShowModal();
        return;
    }

//    wxString ip = _T("192.168.5.100");
//
//    ENM_String* sCommand = new ENM_String();
//
//    // ifconfig eth0 ip
//    memset(sCommand, 0, sizeof(ENM_String));
//    strcpy((char*)sCommand->dcsString, ENMUtil::WxStringToString(_T("ifconfig eth0 down")).c_str());
//    printf("command %s\n", (char*)sCommand->dcsString);
//    DCS_ExecuteCommand(sCommand);
//
//    // ifconfig eth1 down
//    memset(sCommand, 0, sizeof(ENM_String));
//    strcpy((char*)sCommand->dcsString, ENMUtil::WxStringToString(_T("ifconfig eth1 down")+ip).c_str());
//    printf("command %s\n", (char*)sCommand->dcsString);
//    DCS_ExecuteCommand(sCommand);
//
//    // ifconfig ra0 down
//    memset(sCommand, 0, sizeof(ENM_String));
//    strcpy((char*)sCommand->dcsString, ENMUtil::WxStringToString(_T("ifconfig ra0 down")).c_str());
//    printf("command %s\n", (char*)sCommand->dcsString);
//    DCS_ExecuteCommand(sCommand);

    ::wxGetApp().m_BeforeMeshNetworkMode = DataCenter::GetInstance()->GetCurrentNetworkMode();
    printf("get network mod \n");
    ::wxGetApp().m_BeforeMeshAppliedProfile = DataCenter::GetInstance()->GetProfileController()->GetCurrentProfile();
    printf("get applied profile \n");
    DCS_TurnOnMesh(TRUE);
    ;
    MeshConfigurationEntity meshConfigurationEntity;
    bool bRead = xmlOperator.ReadMeshConfigurationXmlFile(meshConfigurationEntity);
    if (bRead )
    {

        ENM_String* sHostName = new ENM_String();
        memset(sHostName, 0, sizeof(ENM_String));
        wxString strHostName = meshConfigurationEntity.GetMeshLocalHostName();
        int nMeshChannel = meshConfigurationEntity.GetMeshChannel();
        strcpy((char*)sHostName->dcsString, ENMUtil::WxStringToString(strHostName).c_str());
        DCS_SetMeshHostName(sHostName);
        DCS_SetMeshChannel(nMeshChannel);
    }


    //DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->OnConnectProfile();
    ::wxGetApp().m_nMeshStatus = MESHSTATUS_MESHONLY;

    DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->m_menuMeshDC->Enable(true);
    MeshInfoManager::GetInstance()->ChangeMeshMode(true);
    wxGetApp().StartBrowseTimer();
}

void ENMPopupMenu::OnMenuItemTurnOffClicked(wxCommandEvent& event)
{
    printf("TurnOff m_nMeshStatus\n");
    DCS_TurnOnMesh(FALSE);
    ::wxGetApp().m_nMeshStatus = MESHSTATUS_MESHCLOSE;
    DataCenter::GetInstance()->GetNetworkManagerDlgHandle()->m_menuMeshDC->Enable(false);
    //stop browse
    //stop publish
    MeshInfoManager::GetInstance()->ChangeMeshMode(false);
    MeshInfoManager::GetInstance()->ChangeMeshServerMode(false);

    wxString strProfile = ::wxGetApp().m_BeforeMeshAppliedProfile;

    printf("get profile \n");
    bool bIsAdmin = ENMUtil::IsAdministrator();
    ProfileList_t* profilelist = DataCenter::GetInstance()->GetProfileController()->GetProfile(strProfile, bIsAdmin);

    if (strProfile.IsEmpty() || NULL == profilelist)
    {
        printf("if (strProfile.IsEmpty())\n");

        NETWORK_MODE NetworkMode = ::wxGetApp().m_BeforeMeshNetworkMode;
        if ( NETWORK_MODE_WIRED_LAN_CONNECT == NetworkMode ||
             NETWORK_MODE_WIRED_LAN_DISCONNECT == NetworkMode)
        {
            printf("ADAPTER_WIRED\n");
            DataCenter::GetInstance()->EnableNetworkAdapter(ADAPTER_WIRED, true);
            printf("ADAPTER_WIRED enabled \n");
        }
        else if ( NETWORK_MODE_WIRELESS_LAN_CONNECT == NetworkMode ||
                  NETWORK_MODE_WIRELESS_LAN_DISCONNECT == NetworkMode)
        {
            printf("ADAPTER_WIRELESS\n");
             DataCenter::GetInstance()->EnableNetworkAdapter(ADAPTER_WIREDLESS, true);
             printf("ADAPTER_WIRELESS enabled \n");
        }

    }
    else
    {
         printf("else (strProfile.IsEmpty())\n");
        bool bIsAdmin = ENMUtil::IsAdministrator();
        printf("Is admin \n");
        //ProfileList_t* profilelist = DataCenter::GetInstance()->GetProfileController()->GetProfile(strProfile, bIsAdmin);
        //printf("ProfileList_t*");
        if (NULL != profilelist)
        {
            DataCenter::GetInstance()->GetProfileController()->ApplyProfile(*profilelist);
        }

        printf("ApplyProfile enabled\n");
    }

    wxGetApp().StartBrowseTimer();
    printf("StartBrowseTimer \n");
    wxGetApp().StartPublishTimer();
    printf("StartPublishTimer \n");
}

void ENMPopupMenu::OnMenuItemShareMyInternetClicked(wxCommandEvent& event)
{
    //wxMessageBox(_T("Share My Internet clicked"));
    // ifconfig eth1 up
//    ENM_String* sCommand = new ENM_String();
//
//    memset(sCommand, 0, sizeof(ENM_String));
//    strcpy((char*)sCommand->dcsString, ENMUtil::WxStringToString(_T("ifconfig eth1 up")).c_str());
//    printf("command %s\n", (char*)sCommand->dcsString);
//    DCS_ExecuteCommand(sCommand);

    // Enable gate way
//    memset(sCommand, 0, sizeof(ENM_String));
//    strcpy((char*)sCommand->dcsString, ENMUtil::WxStringToString(_T("/usr/share/EasyNetwork/mesh-tools/enablegateway.sh eth1 mesh0")).c_str());
//    printf("command %s\n", (char*)sCommand->dcsString);
//    DCS_ExecuteCommand(sCommand);

    //DCS_EnableMeshServer();
    ::wxGetApp().m_nMeshStatus = MESHSTATUS_MESHSERVER;

    MeshShareMyInternetDlg dlg(0);
    //start publish
    dlg.ShowModal();

//    ENM_String* sIP = new ENM_String();
//    memset(sIP, 0, sizeof(ENM_String));
//    DCS_GetMeshDeviceName(sIP);
//    printf("sIP %s \n", (char*)sIP->dcsString);
//
//    string gwStr((char*)sIP->dcsString);
//    string::size_type first_pos = gwStr.find("#");
//    string::size_type last_pos = gwStr.rfind("#");
//
//    if (first_pos == string::npos || last_pos == string::npos || first_pos == last_pos)
//    {
//        return ;
//    }
//
//    string ip = gwStr.substr(0, first_pos);
//    string dns1 = gwStr.substr(first_pos + 1, last_pos - first_pos -1);
//    string dns2 = gwStr.substr(last_pos + 1);
//
//    ENM_String* sHostName = new ENM_String();
//    memset(sHostName, 0, sizeof(ENM_String));
//    DCS_GetMeshHostName(sHostName);
//
//    int channel = 1;
//    DCS_GetMeshChannel(&channel);

    MESH_GATEWAY_INFO meshGatewayInfo;
    memset(&meshGatewayInfo, 0, sizeof(MESH_GATEWAY_INFO));
    DCS_GetMeshGatewayInfo(&meshGatewayInfo);
    MeshServerEntity meshserverentity;
    meshserverentity.SetIPAddress(ENMUtil::StringToWxString((char *)meshGatewayInfo.IPAddr));
    meshserverentity.SetDNS(ENMUtil::StringToWxString((char *)meshGatewayInfo.DNS1));
    meshserverentity.SetDNS_back(ENMUtil::StringToWxString((char *)meshGatewayInfo.DNS2));
    meshserverentity.SetHostName(ENMUtil::StringToWxString((char *)meshGatewayInfo.HostName));
    meshserverentity.SetChannel(meshGatewayInfo.Channel);
    if ( meshserverentity.GetMeshIPAddress().Cmp(wxT("")) == 0 )
        meshserverentity.SetIPAddress(wxT(" "));
    if ( meshserverentity.GetHostName().Cmp(wxT("")) == 0 )
        meshserverentity.SetHostName(wxT(" "));
    if ( meshserverentity.GetDNS().Cmp(wxT("")) == 0 )
        meshserverentity.SetDNS(wxT(" "));
    if ( meshserverentity.GetDNS_back().Cmp(wxT("")) == 0 )
        meshserverentity.SetDNS_back(wxT(" "));
    printf("meshserverentity.SetIPAddress %s \n", meshGatewayInfo.IPAddr);
    printf("meshserverentity.SetDNS %s \n", meshGatewayInfo.DNS1);
    printf("meshserverentity.SetDNS_back %s \n", meshGatewayInfo.DNS2);
    printf("meshserverentity.SetHostName %s \n", meshGatewayInfo.HostName);
    printf("meshserverentity.SetChannel %d \n", meshGatewayInfo.Channel);

            //    wxString wxstr = meshserverentity.GetMeshIPAddress();
            //    printf("meshserverentity.SetIPAddress %s \n", ENMUtil::WxStringToString(wxstr));
            //    wxstr = meshserverentity.GetHostName();
            //    printf("meshserverentity.SetIPAddress %s \n", ENMUtil::WxStringToString(wxstr));
            //    wxstr = meshserverentity.GetDNS();
            //    printf("meshserverentity.SetIPAddress %s \n", ENMUtil::WxStringToString(wxstr));
            //    wxstr = meshserverentity.GetDNS_back();
            //    printf("meshserverentity.SetIPAddress %s \n", ENMUtil::WxStringToString(wxstr));

    MeshInfoManager::GetInstance()->SetMeshServerInfo(meshserverentity);
    MeshInfoManager::GetInstance()->ChangeMeshServerMode(true);
    wxGetApp().StartPublishTimer();

}

void ENMPopupMenu::OnMenuItemUseOthersInternetClicked(wxCommandEvent& event)
{
    //wxMessageBox(_T("Use Other's Internet clicked"));
    //stop publish
    MeshUseOthersInternetDlg* pMeshUseOthersInternetDlg = DataCenter::GetInstance()->GetMeshUseOthersInternetDlgHandle();
    MeshInfoManager::GetInstance()->Attach(pMeshUseOthersInternetDlg);
    MeshInfoManager::GetInstance()->ChangeMeshServerMode(false);
    wxGetApp().StartPublishTimer();

    pMeshUseOthersInternetDlg->Show(true);
}
